/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.common.gadgets.GStatusLineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Gadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class GHBox
extends CompositeGadget {
    private int[] fWidthHints;
    private boolean fEnabled;

    public GHBox(CompositeGadget parent) {
        super(parent);
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        Gadget[] gadgetArray = this.fChildren;
        int n = this.fChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Gadget child = gadgetArray[n2];
            GStatusLineItem item = (GStatusLineItem)child;
            item.setEnabled(enabled);
            ++n2;
        }
    }

    public void setWidthHints(int[] widthHints) {
        this.fWidthHints = widthHints;
    }

    public int computeMinimalWidth() {
        if (this.fWidthHints != null) {
            Assert.isTrue((this.fWidthHints.length == this.getGadgetCount() ? 1 : 0) != 0);
        }
        int spacing = this.getOutlineResources().getFontMetrics().getHeight();
        int result = 0;
        boolean needsSpacing = false;
        int i = 0;
        while (i < this.fChildren.length) {
            if (!this.fChildren[i].isExcluded()) {
                int wHint = this.getWidthHint(i);
                result = wHint == -1 ? (result += this.fChildren[i].computeMinimalWidth()) : (result += this.fWidthHints[i]);
                if (needsSpacing) {
                    result += spacing;
                }
                needsSpacing = true;
            }
            ++i;
        }
        return result;
    }

    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        if (this.fWidthHints != null) {
            Assert.isTrue((this.fWidthHints.length == this.getGadgetCount() ? 1 : 0) != 0);
        }
        int width = 0;
        int height = 0;
        int spacing = this.getOutlineResources().getFontMetrics().getHeight();
        boolean needsSpacing = false;
        int i = 0;
        while (i < this.fChildren.length) {
            if (!this.fChildren[i].isExcluded()) {
                if (needsSpacing) {
                    x += spacing;
                    width += spacing;
                }
                int hint = this.getWidthHint(i);
                this.fChildren[i].layout(x, y, hint > 0 ? hint : -1, hHint);
                int toAdd = hint != -1 ? hint : this.fChildren[i].getWidth();
                x += toAdd;
                width += toAdd;
                height = this.max(height, this.fChildren[i].getHeight());
                needsSpacing = true;
            }
            ++i;
        }
        i = 0;
        while (i < this.fChildren.length) {
            if (!this.fChildren[i].isExcluded()) {
                this.fChildren[i].move(0, height - this.fChildren[i].getHeight());
            }
            ++i;
        }
        return new Point(width, height);
    }

    public void paint(GC gc, OutlineResources resources) {
        if (resources.debugLayout) {
            Rectangle view = this.getTransformation().toViewPort(this.getBounds());
            Rectangles.resize(view, -1, -1);
            gc.drawRectangle(view);
        }
        super.paint(gc, resources);
    }

    private int getWidthHint(int index) {
        return this.fWidthHints != null && this.fWidthHints.length > index ? this.fWidthHints[index] : -1;
    }
}

