/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGadgetEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.SimpleGadget;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

public class GButton
extends SimpleGadget {
    private Image fImage;
    private boolean fDrawRollover;
    private IAction fAction;
    private boolean fEnabled;
    private int fStyle;

    public GButton(CompositeGadget parent, Image image, int style) {
        super(parent);
        this.fImage = image;
        this.fStyle = style;
        this.fEnabled = true;
    }

    public void dispose() {
        if (this.fAction != null && this.fAction.getMenuCreator() != null) {
            this.fAction.getMenuCreator().dispose();
        }
        super.dispose();
    }

    public Image getImage() {
        return this.fImage;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public void setAction(IAction action) {
        this.fAction = action;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
    }

    public int computeMinimalWidth() {
        if (this.fImage == null) {
            return 0;
        }
        return this.fImage.getBounds().width;
    }

    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        if (this.fImage == null) {
            return this.hasDropdown() ? new Point(5, 3) : new Point(2, 3);
        }
        Rectangle bounds = this.fImage.getBounds();
        if (hHint != -1) {
            bounds.height = hHint;
            bounds.width = hHint;
        }
        return new Point(bounds.width, this.max(bounds.height, 3));
    }

    public void paint(GC gc, OutlineResources resources) {
        if (this.fImage == null) {
            return;
        }
        Rectangle view = this.getTransformation().toViewPort(this.fBounds);
        if (this.fEnabled && this.fDrawRollover) {
            Color color = gc.getBackground();
            int antialias = gc.getAntialias();
            gc.setAntialias(1);
            gc.setBackground(this.getOutlineResources().getHoverHightlightColor());
            gc.fillRoundRectangle(view.x, view.y, view.width, view.height, 5, 5);
            gc.setBackground(color);
            gc.setAntialias(antialias);
        }
        Rectangle imageBounds = this.fImage.getBounds();
        gc.drawImage(this.getImage(), 0, 0, imageBounds.width, imageBounds.height, view.x, view.y, view.height, view.height);
        if (this.hasDropdown() && this.isEnabled() && (this.fDrawRollover || !GButton.hasStyle(this.fStyle, 1024) || GButton.hasStyle(this.getShell().getSelectionMode(), 1))) {
            GCState state = GCState.save(gc, 8);
            try {
                int startX = view.x + view.width - 7;
                int startY = view.y + 6;
                int width = 7;
                int centerX = 4;
                int height = 5;
                gc.setBackground(gc.getDevice().getSystemColor(1));
                gc.fillPolygon(new int[]{startX, startY, startX + width, startY, startX + width, startY + 1, startX + centerX, startY + height, startX, startY + 1});
                gc.setBackground(resources.getDropDownTriangleColor());
                gc.fillPolygon(new int[]{startX + 1, startY + 1, startX + width - 1, startY + 1, startX + centerX, startY + height - 1});
            }
            finally {
                state.restore();
            }
            if (resources.debugLayout) {
                gc.drawRectangle(view.x, view.y, view.width - 1, view.height - 1);
            }
        }
    }

    public void handleMouseEnter(MouseEvent e) {
        if (!this.fEnabled) {
            return;
        }
        this.fDrawRollover = true;
        this.redraw(false);
    }

    public void handleMouseExit(MouseEvent e) {
        if (!this.fEnabled) {
            return;
        }
        this.fDrawRollover = false;
        this.redraw(false);
    }

    public IGadgetEditor handleMouseDown(MouseEvent e) {
        if (!this.fEnabled || this.fAction == null || e.button != 1) {
            return null;
        }
        Outline outline = this.getOutline();
        outline.setSelection(this.getOutlineItem());
        if (this.hasDropdown()) {
            Menu menu = this.fAction.getMenuCreator().getMenu((Control)outline);
            Rectangle viewBounds = this.getTransformation().toViewPort(this.getBounds());
            Point p = outline.toDisplay(new Point(viewBounds.x, viewBounds.y + viewBounds.height));
            menu.setLocation(p.x, p.y);
            menu.setVisible(true);
            Display display = outline.getDisplay();
            while (!menu.isDisposed() && menu.isVisible()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            if (!menu.isDisposed()) {
                menu.dispose();
            }
        } else {
            this.fAction.run();
        }
        return null;
    }

    public void stop() {
        super.stop();
        if (this.fDrawRollover) {
            this.fDrawRollover = false;
            this.redraw(false);
        }
    }

    private boolean hasDropdown() {
        return this.fAction != null && this.fAction.getStyle() == 4;
    }
}

