/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Gadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IEventHandler;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGObject;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class CompositeGadget
extends Gadget {
    protected static final Gadget[] NO_GADGETS = new Gadget[0];
    protected Gadget[] fChildren = NO_GADGETS;

    protected CompositeGadget(CompositeGadget parent) {
        super(parent);
    }

    CompositeGadget(OutlineItem item) {
        super(item);
    }

    public void dispose() {
        int i = 0;
        while (i < this.fChildren.length) {
            this.fChildren[i].dispose();
            ++i;
        }
        super.dispose();
    }

    public int getGadgetCount() {
        return this.fChildren.length;
    }

    public void move(int deltaX, int deltaY) {
        super.move(deltaX, deltaY);
        int i = 0;
        while (i < this.fChildren.length) {
            if (!this.fChildren[i].isExcluded()) {
                this.fChildren[i].move(deltaX, deltaY);
            }
            ++i;
        }
    }

    public void addGadget(Gadget item) {
        Gadget[] newGadgets = new Gadget[this.fChildren.length + 1];
        System.arraycopy(this.fChildren, 0, newGadgets, 0, this.fChildren.length);
        newGadgets[this.fChildren.length] = item;
        this.fChildren = newGadgets;
    }

    protected void resized(Gadget resizedChild, int deltaWidth, int deltaHeight, Gadget origin) {
        this.checkBounds();
        Point newSize = this.relayout(this.fBounds.x, this.fBounds.y, deltaWidth, deltaHeight, resizedChild);
        deltaWidth = newSize.x - this.fBounds.width;
        deltaHeight = newSize.y - this.fBounds.height;
        if (deltaWidth != 0 || deltaHeight != 0) {
            Rectangles.resize(this.getBounds(), deltaWidth, deltaHeight);
            if (this.fParent != null) {
                this.fParent.resized(this, deltaWidth, deltaHeight, origin);
            }
        } else {
            this.redraw(true);
        }
    }

    public void paint(GC gc, OutlineResources resources) {
        Rectangle clipping = gc.getClipping();
        int i = 0;
        while (i < this.fChildren.length) {
            Gadget child = this.fChildren[i];
            if (!child.isExcluded()) {
                Rectangle bounds = child.getBounds();
                if (!resources.getPaintPaneBounds().intersects(bounds)) {
                    // empty if block
                }
                gc.setClipping(this.getTransformation().toViewPort(bounds));
                child.paint(gc, resources);
            }
            ++i;
        }
        gc.setClipping(clipping);
        if (this.getOutlineResources().debugLayout) {
            Rectangle bounds = this.getTransformation().toViewPort(this.fBounds);
            gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        }
    }

    public IEventHandler findEventHandlerUnder(Point panePoint, int mode) {
        if (!this.getBounds().contains(panePoint)) {
            return null;
        }
        IEventHandler result = null;
        int i = 0;
        while (i < this.fChildren.length) {
            if (!this.fChildren[i].isExcluded() && (result = this.fChildren[i].findEventHandlerUnder(panePoint, mode)) != null) {
                return result;
            }
            ++i;
        }
        if (mode == 1 || this.getContentBounds().contains(panePoint)) {
            return this;
        }
        return null;
    }

    public IGObject findGObjectUnder(Point panePoint) {
        if (!this.getBounds().contains(panePoint)) {
            return null;
        }
        IGObject result = null;
        int i = 0;
        while (i < this.fChildren.length) {
            if (!this.fChildren[i].isExcluded() && (result = this.fChildren[i].findGObjectUnder(panePoint)) != null) {
                return result;
            }
            ++i;
        }
        return this;
    }

    void clearBounds() {
        super.clearBounds();
        int i = 0;
        while (i < this.fChildren.length) {
            this.fChildren[i].clearBounds();
            ++i;
        }
    }
}

