/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.widgets.outliner;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.FormColors;

public class BarResources {
    private final ResourceManager fResources;
    private final Color fRed;
    private final Color fGreen;
    private final Color fBrightGreen;
    private final Color fWhite;
    private final Color fBlack;
    private final Color fGradientStart;
    private final Color fGradientEnd;
    private final Color fTwistie;
    private final Color fOutline;
    private final Font fFont;
    private final FontMetrics fFontMetrics;

    public BarResources(Control control) {
        this((ResourceManager)new LocalResourceManager(JFaceResources.getResources(), control), BarResources.modify(control.getFont()));
    }

    private BarResources(ResourceManager manager, FontData[] font) {
        this(manager, manager.createFont(FontDescriptor.createFrom((FontData[])font)));
    }

    public BarResources(ResourceManager manager, Font font) {
        this.fResources = manager;
        this.fFont = font;
        GC gc = null;
        try {
            gc = new GC((Drawable)font.getDevice());
            gc.setFont(font);
            this.fFontMetrics = gc.getFontMetrics();
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        this.fRed = this.fResources.getDevice().getSystemColor(3);
        this.fGreen = this.fResources.getDevice().getSystemColor(6);
        this.fBrightGreen = this.fResources.getDevice().getSystemColor(5);
        this.fWhite = this.fResources.getDevice().getSystemColor(1);
        this.fBlack = this.fResources.getDevice().getSystemColor(2);
        this.fTwistie = this.fResources.getDevice().getSystemColor(17);
        this.fOutline = this.fResources.getDevice().getSystemColor(18);
        this.fGradientStart = this.blend(21, 25, 10);
        this.fGradientEnd = this.blend(21, 25, 20);
    }

    private static FontData[] modify(Font font) {
        FontData[] data = font.getFontData();
        int i = 0;
        while (i < data.length) {
            data[i].setHeight(data[i].getHeight() - 1);
            ++i;
        }
        return data;
    }

    private Color blend(int c1, int c2, int ratio) {
        Device device = this.fResources.getDevice();
        RGB blend = FormColors.blend((RGB)device.getSystemColor(c1).getRGB(), (RGB)device.getSystemColor(c2).getRGB(), (int)ratio);
        return this.fResources.createColor(blend);
    }

    public int getAlpha(int alpha) {
        return (int)((float)alpha * 0.33f);
    }

    public Font getMessageFont() {
        return this.fFont;
    }

    public FontMetrics getMessageFontMetrics() {
        return this.fFontMetrics;
    }

    public Color getBlack() {
        return this.fBlack;
    }

    public Color getWhite() {
        return this.fWhite;
    }

    public Color getRed() {
        return this.fRed;
    }

    public Color getGreen() {
        return this.fGreen;
    }

    public Color getGradientStart() {
        return this.fGradientStart;
    }

    public Color getGradientEnd() {
        return this.fGradientEnd;
    }

    public Color getTwistie() {
        return this.fTwistie;
    }

    public Color getOutline() {
        return this.fOutline;
    }

    public Color getBrightGreen() {
        return this.fBrightGreen;
    }
}

