/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.Iterations;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.ValueSetDropDownAction;
import com.ibm.team.apt.internal.ide.ui.util.IterationPlanDisplayObject;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationPlansDropDownAction
extends ValueSetDropDownAction<IterationPlanDisplayObject> {
    private LinkedHashMap<IIterationPlanRecordHandle, IterationPlanDisplayObject> fCache = new LinkedHashMap<IIterationPlanRecordHandle, IterationPlanDisplayObject>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<IIterationPlanRecordHandle, IterationPlanDisplayObject> eldest) {
            return this.size() > 50;
        }
    };
    private ItemList<IIterationPlanRecordHandle> fPlanHandles;
    private final IWorkbenchPage fPage;
    private ResourceManager fResources;

    public IterationPlansDropDownAction(IWorkbenchPage page, List<? extends IIterationPlanRecordHandle> planHandles) {
        Assert.isNotNull((Object)page);
        Assert.isNotNull(planHandles);
        this.fPage = page;
        this.fPlanHandles = new ItemArrayList(planHandles, CMode.CURRENT);
    }

    @Override
    protected void menuDisposed() {
        if (this.fResources != null) {
            this.fResources.dispose();
            this.fResources = null;
        }
    }

    @Override
    protected MenuItem createMenuItem(Menu menu, IterationPlanDisplayObject object) {
        if (this.fResources == null) {
            this.fResources = new LocalResourceManager(JFaceResources.getResources((Display)menu.getDisplay()));
        }
        StringBuilder text = new StringBuilder();
        text.append(object.getPlanName().replaceAll("&", "&&"));
        text.append(' ');
        text.append('[');
        text.append(object.getIterationLabel().replaceAll("&", "&&"));
        text.append(']');
        MenuItem item = new MenuItem(menu, 8);
        item.setText(text.toString());
        item.setImage(this.fResources.createImage(ImagePool.ITERATION_PLAN_OBJ));
        return item;
    }

    @Override
    protected void setValue(IterationPlanDisplayObject data) {
        PlanningUIPlugin.openIterationPlanEditor(data.getPlanHandle(), this.fPage);
    }

    @Override
    protected List<IterationPlanDisplayObject> fastResolveValues() {
        ItemArrayList list = new ItemArrayList((Collection)this.fCache.keySet(), CMode.CURRENT);
        if (list.containsAll(this.fPlanHandles)) {
            return new ArrayList<IterationPlanDisplayObject>(this.fCache.values());
        }
        return null;
    }

    @Override
    protected List<IterationPlanDisplayObject> slowResolveValues(IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IterationPlanDisplayObject> result = new ArrayList<IterationPlanDisplayObject>(this.fPlanHandles.size());
        for (IIterationPlanRecordHandle planHandle : this.fPlanHandles) {
            IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)planHandle).itemManager();
            IIterationPlanRecord plan = (IIterationPlanRecord)manager.fetchPartialItem((IItemHandle)planHandle, 0, (Collection)Arrays.asList(IIterationPlanRecord.NAME_PROPERTY, IIterationPlanRecord.ITERATION_PROPERTY), monitor);
            IIteration iteration = (IIteration)manager.fetchPartialItem((IItemHandle)plan.getIteration(), 0, Iterations.UI_PROFILE.getProperties(), monitor);
            IterationPlanDisplayObject object = new IterationPlanDisplayObject(planHandle, plan.getName(), iteration.getLabel());
            this.fCache.put(planHandle, object);
            result.add(object);
        }
        Collections.sort(result, new Comparator<IterationPlanDisplayObject>(){

            @Override
            public int compare(IterationPlanDisplayObject o1, IterationPlanDisplayObject o2) {
                return Collator.getInstance().compare(o1.getPlanName(), o2.getPlanName());
            }
        });
        return result;
    }
}

