/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Html {
    HTML("<html>", "</html>"),
    HEAD("<head>", "</head>"),
    TITLE("<title>", "</title>"),
    SCRIPT("<script>", "</script>"),
    META("<meta>", "</meta>"),
    STYLE("<style>", "</style>"),
    BODY("<body>", "</body>"),
    BOLD("<b>", "</b>"),
    ITALIC("<i>", "</i>"),
    BR("<br/>", null),
    HR("<hr/>", null),
    DIV("<div>", "</div>"),
    SPAN("<span>", "</span>"),
    H5("<h5>", "</h5>"),
    ANCHOR("<a>", "</a>"),
    IMG("<img/>", null),
    LI("<li>", "</li>"),
    OL("<ol>", "</ol>"),
    UL("<ul>", "</ul>"),
    TABLE("<table>", "</table>"),
    THEAD("<thead>", "</thead>"),
    TR("<tr>", "</tr>"),
    TD("<td>", "</td>");

    public final String open;
    public final String close;

    private Html(String open, String close) {
        this.open = open;
        this.close = close;
    }

    public <T extends CharSequence & Appendable> void open(T body, Attribute ... attributes) {
        if (this.open != null) {
            try {
                if (attributes.length == 0) {
                    ((Appendable)body).append(this.open);
                } else {
                    int indexOf = this.open.lastIndexOf(47);
                    if (indexOf == -1) {
                        indexOf = this.open.lastIndexOf(62);
                    }
                    ((Appendable)body).append(this.open.substring(0, indexOf));
                    Attribute[] attributeArray = attributes;
                    int n = attributes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Attribute attribute = attributeArray[n2];
                        ((Appendable)body).append(' ');
                        ((Appendable)body).append(attribute.getKey());
                        ((Appendable)body).append('=');
                        ((Appendable)body).append('\"');
                        ((Appendable)body).append(attribute.getValue());
                        ((Appendable)body).append('\"');
                        ++n2;
                    }
                    ((Appendable)body).append(this.open.subSequence(indexOf, this.open.length()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public <T extends CharSequence & Appendable> void close(T body) {
        if (this.close != null) {
            try {
                ((Appendable)body).append(this.close);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <T extends CharSequence & Appendable> T append(T body, CharSequence content) {
        try {
            ((Appendable)body).append(content);
            return body;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Attribute {
        private final String fKey;
        private final String fValue;

        public Attribute(String key, String value) {
            this.fKey = key;
            this.fValue = value;
        }

        public String getKey() {
            return this.fKey;
        }

        public String getValue() {
            return this.fValue;
        }
    }
}

