/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import com.ibm.team.apt.internal.ide.ui.util.Result;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DisplayCallable<T>
implements Runnable {
    private Display fDisplay;
    private Control fControl;
    private volatile Result<T> fResult;

    public DisplayCallable(Display display) {
        Assert.isNotNull((Object)display);
        this.fDisplay = display;
    }

    public DisplayCallable(Control control) {
        Assert.isNotNull((Object)control);
        this.fControl = control;
    }

    public Result<T> result() {
        return this.fResult;
    }

    public Result<T> syncExec() {
        return this.exec(true);
    }

    public void asyncExec() {
        this.exec(false);
    }

    protected Result<T> exec(boolean sync) {
        Display display = this.fDisplay;
        if (this.fControl != null) {
            display = this.fControl.getDisplay();
        }
        if (sync) {
            display.syncExec((Runnable)this);
        } else {
            display.asyncExec((Runnable)this);
        }
        return this.fResult;
    }

    @Override
    public final void run() {
        if (this.fControl != null && this.fControl.isDisposed()) {
            this.fResult = new Result<Object>(null, Status.CANCEL_STATUS);
            return;
        }
        this.fResult = new Result<T>(this.execute(), Status.OK_STATUS);
    }

    protected abstract T execute();
}

