/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.util;

import com.ibm.team.apt.internal.common.util.SortMode;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.repository.common.IItemHandle;
import java.text.Collator;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevelopmentLineUIComparator
implements Comparator<IDevelopmentLine> {
    private final SortMode fMode;
    private final IDevelopmentLine fDefaultDevelopmentLine;

    public DevelopmentLineUIComparator(SortMode mode, IDevelopmentLine defaultDevelopmentLine) {
        this.fMode = mode;
        this.fDefaultDevelopmentLine = defaultDevelopmentLine;
    }

    @Override
    public int compare(IDevelopmentLine o1, IDevelopmentLine o2) {
        if (o1 == o2) {
            return 0;
        }
        boolean isAscending = this.fMode == SortMode.ASC;
        boolean d1 = this.isDefaultDevelopmentLine(o1);
        boolean d2 = this.isDefaultDevelopmentLine(o2);
        if (d1 && !d2) {
            return isAscending ? -1 : 1;
        }
        if (!d1 && d2) {
            return isAscending ? 1 : -1;
        }
        String l1 = this.getLabel(o1);
        String l2 = this.getLabel(o2);
        return isAscending ? Collator.getInstance().compare(l1, l2) : Collator.getInstance().compare(l1, l2) * -1;
    }

    private boolean isDefaultDevelopmentLine(IDevelopmentLine line) {
        if (this.fDefaultDevelopmentLine == null) {
            return false;
        }
        return this.fDefaultDevelopmentLine.sameItemId((IItemHandle)line);
    }

    private String getLabel(IDevelopmentLine line) {
        return line.getName() != null && !"".equals(line.getName()) ? line.getName() : line.getId();
    }
}

