/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.teamload;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.teamload.ITeamLoadClient;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.client.teamload.TeamLoadInformation;
import com.ibm.team.apt.internal.client.util.AssignmentAwareTeamAreaComparator;
import com.ibm.team.apt.internal.client.util.IterationClient;
import com.ibm.team.apt.internal.common.nucleus.IterationPlanRecord;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.actions.OpenUserAction;
import com.ibm.team.apt.internal.ide.ui.teamload.Messages;
import com.ibm.team.apt.internal.ide.ui.teamload.TeamLoadConfiguration;
import com.ibm.team.apt.internal.ide.ui.teamload.TeamLoadContentProvider;
import com.ibm.team.apt.internal.ide.ui.teamload.TeamLoadDialog;
import com.ibm.team.apt.internal.ide.ui.teamload.TeamLoadLabelProvider;
import com.ibm.team.apt.internal.ide.ui.teamload.TeamLoadToolTip;
import com.ibm.team.apt.internal.ide.ui.util.QueryHelper;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.session.CollaborationPresenceEvent;
import com.ibm.team.collaboration.core.session.CollaborationSessionEvent;
import com.ibm.team.collaboration.core.session.ICollaborationPresenceListener;
import com.ibm.team.collaboration.core.session.ICollaborationSessionListener;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.client.util.FoundationJobContext;
import com.ibm.team.foundation.common.internal.util.ExceptionDescription;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.dnd.DragSupport;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.dashboard.ISectionListener;
import com.ibm.team.jface.dashboard.ISectionSite;
import com.ibm.team.jface.dashboard.Section;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.jface.viewerutilities.SelectionProvider;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.ide.ui.wizards.ProjectAreaConnectionWizard;
import com.ibm.team.process.rcp.ui.ContextMenuHelper2;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.SelectClause;
import com.ibm.team.workitem.common.expression.SortCriteria;
import com.ibm.team.workitem.common.expression.Statement;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;

public class TeamLoadSection
extends Section {
    private static final int NO_CURRENT_ITERATION = 10;
    final FoundationJobContext TEAMLOAD_CONTEXT = new FoundationJobContext(){

        public boolean isExpectedStatus(Job job, IStatus status) {
            if (status.getCode() == 10) {
                return true;
            }
            return super.isExpectedStatus(job, status);
        }

        public void handleStatus(Job job, IStatus status) {
            SectionJob sectionJob = (SectionJob)job;
            State nextState = null;
            String summary = null;
            switch (status.getSeverity()) {
                case 4: {
                    Throwable exception = status.getException();
                    if (status.getMessage() != null) {
                        summary = status.getMessage();
                    } else {
                        ExceptionDescription description = ExceptionDescription.findDescription((String)job.getName(), (Throwable)status.getException());
                        summary = description.getSummary();
                    }
                    nextState = exception instanceof NotLoggedInException || exception instanceof ConnectionException ? State.NOT_CONNECTED : sectionJob.fEndFailure;
                    break;
                }
                case 8: {
                    nextState = sectionJob.getStartedIn();
                    summary = status.getMessage();
                    break;
                }
                default: {
                    summary = status.getMessage();
                    nextState = sectionJob.fEndSucesses;
                }
            }
            final State[] nextStateFinal = new State[]{nextState};
            final String[] summaryFinal = new String[]{summary};
            sectionJob.postToUI(new Runnable(){

                public void run() {
                    TeamLoadSection.this.update(nextStateFinal[0], summaryFinal[0]);
                }
            });
        }
    };
    private Job fJumpStartJob = new SectionJob(Messages.TeamLoadSection_JOB_COMPUTE_CONFIGURATION, State.POPULATED, State.NOT_CONFIGURED, new State[]{State.NOT_CONFIGURED}){
        {
            this.setUser(false);
        }

        @Override
        protected IStatus runInSection(IProgressMonitor monitor) throws Exception {
            this.postToUI(new Runnable(){

                public void run() {
                    TeamLoadSection.this.update(State.LOADING, null);
                }
            });
            IProjectAreaHandle projectAreaHandle = TeamLoadSection.this.getProjectArea();
            if (projectAreaHandle == null) {
                return this.returnCancel();
            }
            final ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)projectAreaHandle);
            IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)projectAreaHandle);
            IContributor contributor = repository.loggedInContributor();
            IItemManager itemManager = repository.itemManager();
            IProjectArea projectArea = (IProjectArea)itemManager.fetchCompleteItem((IItemHandle)projectAreaHandle, 0, monitor);
            ITeamArea[] associatedTeamAreas = client.getAssociatedTeamAreas(contributor, projectArea, monitor);
            final ItemList<ITeamArea> teamAreas = this.filterArchivedEmptyNoCategory(Arrays.asList(associatedTeamAreas), monitor);
            if (monitor.isCanceled()) {
                return Status.OK_STATUS;
            }
            if (!teamAreas.isEmpty()) {
                ItemCollections.sort(teamAreas, (Comparator)new AssignmentAwareTeamAreaComparator().init((IContributorHandle)contributor, (IProjectAreaHandle)projectArea, false, monitor));
                this.postToUI(new Runnable(){

                    public void run() {
                        TeamLoadSection.this.load(repository, (IItemHandle)teamAreas.iterator().next(), null);
                    }
                });
                return Status.OK_STATUS;
            }
            return this.returnCancel();
        }

        private ItemList<ITeamArea> filterArchivedEmptyNoCategory(List<ITeamArea> teamAreas, IProgressMonitor monitor) throws TeamRepositoryException {
            if (teamAreas.isEmpty()) {
                return ItemCollections.emptyList();
            }
            ItemArrayList result = new ItemArrayList(teamAreas);
            IWorkItemClient client = PlanningClientPlugin.getWorkItemClient((IItemHandle)((IItemHandle)teamAreas.get(0)));
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                boolean remove;
                ITeamArea teamArea = (ITeamArea)iter.next();
                boolean bl = remove = teamArea.isArchived() || teamArea.getMembers().length == 0 || client.findCategoriesOfTeamArea2((ITeamAreaHandle)teamArea, ICategory.SMALL_PROFILE, monitor).isEmpty();
                if (!remove) continue;
                iter.remove();
            }
            return result;
        }

        private IStatus returnCancel() {
            this.postToUI(new Runnable(){

                public void run() {
                    TeamLoadSection.this.update(State.NOT_CONFIGURED, null);
                }
            });
            return new Status(8, PlanningUI.getPluginId(), JUMP_START);
        }
    };
    private Job fRefreshJob = new SectionJob(Messages.TeamLoadSection_JOB_UPDATE_TEAM_LOAD, State.POPULATED, State.ERROR, new State[]{State.POPULATED}){
        {
            this.setSystem(true);
        }

        protected IStatus runInSection(IProgressMonitor monitor) throws Exception {
            try {
                boolean iterationUpdated;
                TeamLoadSection.this.getSectionSite().setBusy(true);
                monitor.beginTask(Messages.TeamLoadSection_MONITOR_UPDATE_TEAM_LOAD, 2);
                TeamLoadInformation input = TeamLoadSection.this.getInput();
                ITeamLoadClient client = PlanningClientPlugin.getTeamLoadClient((ITeamRepository)PlanningClientPlugin.getTeamRepository((IItemHandle)input.getTeamArea()));
                IIteration newIteration = TeamLoadSection.this.updateIteration(input.getIteration(), monitor);
                boolean bl = iterationUpdated = !newIteration.sameItemId((IItemHandle)input.getIteration());
                if (!iterationUpdated) {
                    final TeamLoadInformation newInput = client.refreshTeamLoadInformation(input, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    String msg = TeamLoadSection.this.fConfiguration.useCurrentIteration() ? NLS.bind((String)Messages.TeamLoadSection_TEASER_CURRENT_ITERATION, (Object[])new Object[]{newInput.getTeamArea().getName(), newInput.getIteration().getLabel()}) : NLS.bind((String)Messages.TeamLoadSection_TEASER_ITERATION, (Object[])new Object[]{newInput.getTeamArea().getName(), newInput.getIteration().getLabel()});
                    this.postToUI(TeamLoadSection.this.teaserUpdater(null, msg, null, 0));
                    this.postToUI(new Runnable(){

                        public void run() {
                            TeamLoadSection.this.fViewer.setInput((Object)newInput);
                        }
                    });
                } else {
                    final ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)input.getTeamArea());
                    final ITeamArea teamArea = input.getTeamArea();
                    final IIteration iteration = input.getIteration();
                    this.postToUI(new Runnable(){

                        public void run() {
                            TeamLoadSection.this.load(repository, (IItemHandle)teamArea, (IItemHandle)(TeamLoadSection.this.fConfiguration.useCurrentIteration() ? null : iteration));
                        }
                    });
                }
                if (TeamLoadSection.this.fConfiguration.getRefreshInterval() != Intervals.DISABLE) {
                    TeamLoadSection.this.scheduleSectionJob((Job)this, ((TeamLoadSection)TeamLoadSection.this).fConfiguration.getRefreshInterval().millis);
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                TeamLoadSection.this.getSectionSite().setBusy(false);
                monitor.done();
            }
        }
    };
    private Action fConfigureAction = new SectionAction(Messages.TeamLoadSection_CONFIGURE_ACTION_LABEL, 1, State.values()){
        private ITeamArea fLastTeamArea;
        private IIteration fLastIteration;

        public void run() {
            TeamLoadDialog dialog;
            TeamLoadSection.this.fJumpStartJob.cancel();
            if (TeamLoadSection.this.getProjectArea() == null) {
                Shell shell = TeamLoadSection.this.getSectionSite().getViewSite().getShell();
                boolean connect = MessageDialog.openQuestion((Shell)shell, (String)Messages.TeamLoadSection_CONFIGURE_ACTION_NO_PROJECT_AREA, (String)Messages.TeamLoadSection_CONFIGURE_ACTION_NO_PROJECT_AREA_DETAIL);
                if (connect) {
                    WizardDialog dialog2 = new WizardDialog(shell, (IWizard)new ProjectAreaConnectionWizard());
                    dialog2.open();
                }
                return;
            }
            ITeamArea preselectedTeamArea = this.fLastTeamArea;
            IIteration preseletedIteration = this.fLastIteration;
            TeamLoadInformation input = ((TeamLoadContentProvider)TeamLoadSection.this.fViewer.getContentProvider()).getInput();
            if (input != null) {
                preselectedTeamArea = input.getTeamArea();
            }
            if (input != null && !TeamLoadSection.this.fConfiguration.useCurrentIteration()) {
                preseletedIteration = input.getIteration();
            }
            if ((dialog = new TeamLoadDialog(TeamLoadSection.this.getSectionSite().getViewSite().getShell(), TeamLoadSection.this.getProjectArea(), preselectedTeamArea, preseletedIteration)).open() == 0) {
                final ITeamArea teamArea = dialog.getTeamArea();
                IIteration iteration = dialog.getIteration();
                if (iteration != null && (iteration.getEndDate() == null || iteration.getStartDate() == null)) {
                    TeamLoadSection.this.fJumpStartLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            TeamLoadSection.this.fJumpStartLink.removeSelectionListener((SelectionListener)this);
                            if (TeamLoadSection.LINK_PROJECT_AREA.equals(e.text)) {
                                IProjectAreaHandle area = teamArea.getProjectArea();
                                Location location = Location.itemLocation((IItemHandle)area, (String)PlanningClientPlugin.getTeamRepository((IItemHandle)area).getRepositoryURI());
                                Hyperlinks.open((URI)location.toAbsoluteUri(), null);
                            }
                        }
                    });
                    TeamLoadSection.this.fViewer.setInput(null);
                    TeamLoadSection.this.teaserUpdater(null, "", "", 0).run();
                    TeamLoadSection.this.update(State.NOT_CONFIGURED, JUMP_START_ITERATION);
                } else {
                    TeamLoadSection.this.fRefreshJob.cancel();
                    TeamLoadSection.this.load(PlanningClientPlugin.getTeamRepository((IItemHandle)teamArea), (IItemHandle)teamArea, (IItemHandle)iteration);
                }
                this.fLastTeamArea = teamArea;
                this.fLastIteration = iteration;
            }
        }
    };
    private ISectionListener fSectionListener = new ISectionListener(){

        public void sectionOpened() {
            TeamLoadInformation input = TeamLoadSection.this.getInput();
            if (input == null) {
                return;
            }
            PlanningUIPlugin.openIterationPlanEditor((ITeamAreaHandle)input.getTeamArea(), (IIterationHandle)input.getIteration(), TeamLoadSection.this.getSectionSite().getViewSite().getPage());
        }

        public void sectionCollapsed() {
        }

        public void sectionExpanded() {
        }

        public void sectionMaximized(boolean isContentClipped) {
        }

        public void sectionResized() {
        }
    };
    private ICollaborationPresenceListener fPresenceListener = new ICollaborationPresenceListener(){

        public void presenceNotification(final CollaborationPresenceEvent event) {
            Shell shell = TeamLoadSection.this.getSectionSite().getViewSite().getShell();
            if (shell != null && !shell.isDisposed()) {
                shell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        Object input;
                        Control control = TeamLoadSection.this.fViewer.getControl();
                        if (control != null && !control.isDisposed() && (input = TeamLoadSection.this.fViewer.getInput()) instanceof TeamLoadInformation) {
                            LoadItem item;
                            TeamLoadInformation info = (TeamLoadInformation)input;
                            IContributorHandle handle = event.getUser().getContributor();
                            if (handle != null && (item = info.getLoadItem(handle)) != null) {
                                TeamLoadSection.this.fViewer.update((Object)item, null);
                            }
                        }
                    }
                });
            }
        }
    };
    private ICollaborationSessionListener fSessionListener = new ICollaborationSessionListener(){

        public void sessionNotification(CollaborationSessionEvent event) {
            Shell shell;
            int type = event.getType();
            if (!(type != 0 && type != 1 || (shell = TeamLoadSection.this.getSectionSite().getViewSite().getShell()) == null || shell.isDisposed())) {
                shell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        Control control = TeamLoadSection.this.fViewer.getControl();
                        if (control != null && !control.isDisposed()) {
                            control.redraw();
                        }
                    }
                });
            }
        }
    };
    private IConnectedProjectAreaRegistryListener fProjectAreaStateListener = new IConnectedProjectAreaRegistryListener(){

        public void connectedProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent event) {
            Assert.isNotNull((Object)TeamLoadSection.this.fViewer);
            Display display = TeamLoadSection.this.fViewer.getControl().getDisplay();
            if (2 == event.getType()) {
                if (TeamLoadSection.this.getInput() != null && TeamLoadSection.this.getInput().getProjectArea().sameItemId((IItemHandle)event.getProjectAreaHandle())) {
                    TeamLoadSection.this.update(State.NOT_CONNECTED, null);
                }
            } else if (event.getType() == 0) {
                if (!event.getTeamRepository().loggedIn()) {
                    return;
                }
                switch (TeamLoadSection.this.fSectionState) {
                    case NOT_CONFIGURED: 
                    case NOT_CONNECTED: 
                    case ERROR: {
                        UI.asyncExec(display, new Runnable(){

                            public void run() {
                                TeamLoadSection.this.populateSection();
                            }
                        });
                    }
                }
            }
        }
    };
    private ITeamRepository.ILoginParticipant fLogoutHandler = new ITeamRepository.ILoginParticipant(){

        public void handleLogin(ITeamRepository repository) {
        }

        public void handleLogout(ITeamRepository repository) {
            String uri;
            Assert.isNotNull((Object)repository);
            Assert.isNotNull((Object)TeamLoadSection.this.fViewer);
            Display display = TeamLoadSection.this.fViewer.getControl().getDisplay();
            TeamLoadInformation input = (TeamLoadInformation)TeamLoadSection.this.fViewer.getInput();
            if (input != null && (uri = PlanningClientPlugin.getTeamRepository((IItemHandle)input.getTeamArea()).getRepositoryURI()).equals(repository.getRepositoryURI())) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        TeamLoadSection.this.update(State.NOT_CONNECTED, null);
                    }
                });
            }
            repository.removeLoginParticipant((ITeamRepository.ILoginParticipant)this);
        }
    };
    private static final String LINK_CONFIGURE = "Configure";
    private static final String LINK_PROJECT_AREA = "ProjectAreaEditor";
    private static final String JUMP_START = NLS.bind((String)Messages.TeamLoadSection_HINT_CONFIGURATION, (Object[])new Object[]{"Configure"});
    private static final String JUMP_START_ITERATION = NLS.bind((String)Messages.TeamLoadSection_HINT_INVALD_ITERATION, (Object[])new Object[]{"ProjectAreaEditor"});
    private static final Object LOAD_JOB_FAMILY = new Object();
    private StackLayout fStackLayout;
    private CLabel fTeaserTitle;
    private Image fTeaserWarning;
    private Link fJumpStartLink;
    private TableViewer fViewer;
    private Label fStatusLabel;
    private Composite fJumpStartPart;
    private TeamLoadConfiguration fConfiguration;
    private State fSectionState = State.NOT_CONNECTED;
    private LocalResourceManager fResources;

    public void init(ISectionSite sectionSite, IMemento memento) {
        super.init(sectionSite, memento);
        this.fConfiguration = new TeamLoadConfiguration();
        this.fConfiguration.loadState(memento);
        sectionSite.addSectionListener(this.fSectionListener);
    }

    public void createTeaser(Composite parent) {
        this.fTeaserTitle = new CLabel(parent, 131073);
        FontData[] defFont = UI.modifyFont(this.fTeaserTitle.getFont().getFontData(), -1, 0);
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fTeaserTitle);
        this.fTeaserTitle.setFont(this.fResources.createFont(FontDescriptor.createFrom((FontData[])defFont)));
        this.fTeaserTitle.setLayoutData((Object)new GridData(3, 2, true, true));
        this.fTeaserTitle.setBackground(null);
        this.fTeaserTitle.setForeground(JazzResources.getColor((ResourceManager)this.fResources, (RGB)new RGB(80, 80, 80)));
        this.fTeaserWarning = this.fResources.createImage(ImagePool.WARNING_OVR);
        UI.hookHelpListener((Control)parent.getParent(), "com.ibm.team.apt.ide.ui.section_teamLoad");
    }

    public void refreshContent() {
        this.fRefreshJob.cancel();
        this.scheduleSectionJob(this.fRefreshJob);
    }

    protected Runnable teaserUpdater(final Image image, final String message, final String tooltip, final int style) {
        return new Runnable(){

            public void run() {
                if (TeamLoadSection.this.fTeaserTitle.isDisposed()) {
                    return;
                }
                FontData[] fontDef = UI.modifyFont(TeamLoadSection.this.fTeaserTitle.getFont().getFontData(), 0, style);
                TeamLoadSection.this.fTeaserTitle.setFont(TeamLoadSection.this.fResources.createFont(FontDescriptor.createFrom((FontData[])fontDef)));
                TeamLoadSection.this.fTeaserTitle.setImage(image);
                TeamLoadSection.this.fTeaserTitle.setText(message);
                TeamLoadSection.this.fTeaserTitle.setToolTipText(tooltip != null ? tooltip : message);
                TeamLoadSection.this.getSectionSite().layoutTeaser();
            }
        };
    }

    public void createContent(Composite parent) {
        this.fStackLayout = new StackLayout();
        parent.setLayout((Layout)this.fStackLayout);
        this.setupTableViewer(parent);
        this.setupJumpStartPart(parent);
        this.setupStatusPart(parent);
        this.createSectionMenu();
        this.createContextMenu();
        new TeamLoadToolTip(this.fViewer.getControl());
        this.addDragSupport();
        this.addDropSupport();
        this.populateSection();
        ConnectedProjectAreaRegistry.getDefault().addListener(this.fProjectAreaStateListener);
        CollaborationCore.getCollaborationService().addPresenceListener(this.fPresenceListener);
        CollaborationCore.getCollaborationService().addSessionListener(this.fSessionListener);
    }

    private void setupTableViewer(Composite parent) {
        this.fViewer = new TableViewer(new Table(parent, 98820));
        this.fViewer.getTable().setBackground(parent.getBackground());
        this.fViewer.getTable().setHeaderVisible(false);
        this.fViewer.getTable().setLinesVisible(false);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new TeamLoadLabelProvider(this.fConfiguration, this.fViewer));
        this.fViewer.setContentProvider((IContentProvider)new TeamLoadContentProvider());
        this.fViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                LoadItem item1 = (LoadItem)e1;
                LoadItem item2 = (LoadItem)e2;
                return Collator.getInstance().compare(item1.getContributor().getName(), item2.getContributor().getName());
            }
        });
        final TableColumn column = new TableColumn(this.fViewer.getTable(), 0);
        column.setWidth(this.fViewer.getTable().getClientArea().width);
        this.fViewer.getTable().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Assert.isTrue(((event.type & 0xB) != 0 ? 1 : 0) != 0);
                if (((TeamLoadSection)TeamLoadSection.this).fStackLayout.topControl == TeamLoadSection.this.fViewer.getTable()) {
                    column.setWidth(((TeamLoadSection)TeamLoadSection.this).fViewer.getTable().getClientArea().width);
                }
            }
        });
        this.getSectionSite().addSelectionProvider((ISelectionProvider)this.fViewer);
        UI.hookHelpListener(this.fViewer.getControl(), "com.ibm.team.apt.ide.ui.section_teamLoad");
    }

    private void setupJumpStartPart(Composite parent) {
        this.fJumpStartPart = new Composite(parent, 0);
        this.fJumpStartPart.setBackground(parent.getBackground());
        this.fJumpStartLink = new Link(this.fJumpStartPart, 16384);
        this.fJumpStartLink.setBackground(parent.getBackground());
        this.fJumpStartLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TeamLoadSection.LINK_CONFIGURE.equals(e.text)) {
                    TeamLoadSection.this.fConfigureAction.run();
                }
            }
        });
        GridLayoutFactory.swtDefaults().applyTo(this.fJumpStartPart);
        GridDataFactory.fillDefaults().grab(true, true).align(1, 1).applyTo((Control)this.fJumpStartLink);
        UI.hookHelpListener((Control)this.fJumpStartPart, "com.ibm.team.apt.ide.ui.section_teamLoad");
    }

    private void setupStatusPart(Composite parent) {
        Composite part = new Composite(parent, 0);
        part.setBackground(parent.getBackground());
        this.fStatusLabel = new Label(part, 0x1000000);
        this.fStatusLabel.setBackground(part.getBackground());
        this.fStatusLabel.setFont(JFaceResources.getBannerFont());
        this.fStatusLabel.setForeground(part.getDisplay().getSystemColor(15));
        GridLayoutFactory.fillDefaults().applyTo(part);
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).applyTo((Control)this.fStatusLabel);
        UI.hookHelpListener((Control)part, "com.ibm.team.apt.ide.ui.section_teamLoad");
    }

    private void addDragSupport() {
        new DragSupport(this.fViewer.getControl()){

            public ISelection getSelection() {
                if (TeamLoadSection.this.fViewer == null) {
                    return StructuredSelection.EMPTY;
                }
                IStructuredSelection selection = (IStructuredSelection)TeamLoadSection.this.fViewer.getSelection();
                ArrayList<IContributor> elements = new ArrayList<IContributor>(selection.size());
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    elements.add(((LoadItem)iter.next()).getContributor());
                }
                return new StructuredSelection(elements);
            }
        };
    }

    private void addDropSupport() {
        DropTarget target = new DropTarget((Control)this.fViewer.getControl().getParent(), 22);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                if (selection.size() == 1 && (selection.getFirstElement() instanceof IterationPlanRecord || selection.getFirstElement() instanceof ITeamArea)) {
                    event.detail = 4;
                    event.feedback = 0;
                } else {
                    event.detail = 0;
                }
            }

            public void drop(DropTargetEvent event) {
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                if (selection.getFirstElement() instanceof IterationPlanRecord) {
                    IterationPlanRecord plan = (IterationPlanRecord)selection.getFirstElement();
                    TeamLoadSection.this.load(PlanningClientPlugin.getTeamRepository((IItemHandle)plan.getTeamArea()), (IItemHandle)plan.getTeamArea(), (IItemHandle)plan.getIteration());
                } else if (selection.getFirstElement() instanceof ITeamArea) {
                    ITeamArea teamArea = (ITeamArea)selection.getFirstElement();
                    TeamLoadSection.this.load(PlanningClientPlugin.getTeamRepository((IItemHandle)teamArea), (IItemHandle)teamArea, null);
                }
            }
        });
        ViewerDropAdapter dropAdapter = new ViewerDropAdapter((Viewer)this.fViewer){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = 4;
                }
                super.dragEnter(event);
            }

            public boolean performDrop(Object data) {
                if (!(data instanceof IStructuredSelection)) {
                    return false;
                }
                IStructuredSelection selection = (IStructuredSelection)data;
                if (selection.getFirstElement() instanceof ITeamArea) {
                    ITeamArea teamArea = (ITeamArea)selection.getFirstElement();
                    ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)teamArea);
                    TeamLoadSection.this.load(repository, (IItemHandle)teamArea, null);
                    return true;
                }
                if (selection.getFirstElement() instanceof IIterationPlanRecord) {
                    IIterationPlanRecord plan = (IIterationPlanRecord)selection.getFirstElement();
                    ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)plan.getTeamArea());
                    TeamLoadSection.this.load(repository, (IItemHandle)plan.getTeamArea(), (IItemHandle)plan.getIteration());
                    return true;
                }
                int adoptCount = 0;
                Iterator iter = selection.iterator();
                LoadItem target = (LoadItem)this.getCurrentTarget();
                while (iter.hasNext()) {
                    IWorkItemHandle item = (IWorkItemHandle)iter.next();
                    TeamLoadSection.this.adoptWorkItem(item, target);
                    ++adoptCount;
                }
                return adoptCount > 0;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (target == null) {
                    return false;
                }
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                if (selection.size() == 1 && (selection.getFirstElement() instanceof IterationPlanRecord || selection.getFirstElement() instanceof ITeamArea)) {
                    return true;
                }
                LoadItem item = (LoadItem)target;
                for (Object next : selection) {
                    if (!(next instanceof IWorkItemHandle)) continue;
                    IWorkItem workItem = null;
                    workItem = next instanceof IWorkItem ? (IWorkItem)next : (IWorkItem)PlanningClientPlugin.getTeamRepository((IItemHandle)((IItemHandle)next)).itemManager().getSharedItemIfKnown((IItemHandle)next);
                    if (workItem == null) {
                        return true;
                    }
                    if (!(workItem.isPropertySet(IWorkItem.OWNER_PROPERTY) && workItem.isPropertySet(IWorkItem.TARGET_PROPERTY) && workItem.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY))) {
                        return true;
                    }
                    return TeamLoadSection.this.canAdoptWorkItem(workItem, item);
                }
                return false;
            }
        };
        dropAdapter.setFeedbackEnabled(true);
        dropAdapter.setScrollExpandEnabled(true);
        dropAdapter.setSelectionFeedbackEnabled(true);
        this.fViewer.addDropSupport(31, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)dropAdapter);
    }

    private void createSectionMenu() {
        Menu menu = this.getSectionSite().getSectionMenu();
        final MenuItem showImagesItem = new MenuItem(menu, 32);
        showImagesItem.setText(Messages.TeamLoadSection_SHOW_IMAGES_LABEL);
        showImagesItem.setSelection(this.fConfiguration.isShowImages());
        showImagesItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamLoadSection.this.fConfiguration.setShowImages(showImagesItem.getSelection());
                TeamLoadSection.this.fViewer.getControl().redraw();
            }
        });
        final MenuManager refreshMenu = new MenuManager(Messages.TeamLoadSection_UPDATE_MENU);
        refreshMenu.add((IContributionItem)new Separator("group.now"));
        refreshMenu.appendToGroup("group.now", (IAction)new RefreshAction(Intervals.NOW));
        refreshMenu.add((IContributionItem)new Separator("group.intervals"));
        refreshMenu.appendToGroup("group.intervals", (IAction)new RefreshAction(Intervals.DISABLE));
        refreshMenu.appendToGroup("group.intervals", (IAction)new RefreshAction(Intervals.MIN_3));
        refreshMenu.appendToGroup("group.intervals", (IAction)new RefreshAction(Intervals.MIN_5));
        refreshMenu.appendToGroup("group.intervals", (IAction)new RefreshAction(Intervals.MIN_10));
        refreshMenu.appendToGroup("group.intervals", (IAction)new RefreshAction(Intervals.MIN_15));
        refreshMenu.appendToGroup("group.intervals", (IAction)new RefreshAction(Intervals.MIN_30));
        refreshMenu.appendToGroup("group.intervals", (IAction)new RefreshAction(Intervals.MIN_60));
        refreshMenu.fill(menu, -1);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                boolean enabled = TeamLoadSection.this.fSectionState == State.POPULATED;
                refreshMenu.getMenu().setEnabled(enabled);
                MenuItem[] menuItemArray = refreshMenu.getMenu().getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.setEnabled(enabled);
                    ++n2;
                }
            }
        });
        new MenuItem(menu, 2);
        new ActionContributionItem((IAction)this.fConfigureAction).fill(menu, -1);
    }

    private void createContextMenu() {
        SelectionProvider provider = new SelectionProvider(){

            public ISelection getSelection() {
                Object firstElement = ((IStructuredSelection)TeamLoadSection.this.fViewer.getSelection()).getFirstElement();
                if (firstElement == null) {
                    return StructuredSelection.EMPTY;
                }
                return new StructuredSelection(new Object[]{((LoadItem)firstElement).getContributor()});
            }
        };
        MenuManager menu = new MenuManager();
        menu.setRemoveAllWhenShown(true);
        menu.addMenuListener(new IMenuListener((ISelectionProvider)provider){
            private final /* synthetic */ ISelectionProvider val$provider;
            {
                this.val$provider = iSelectionProvider;
            }

            public void menuAboutToShow(IMenuManager manager) {
                final LoadItem item = (LoadItem)((IStructuredSelection)TeamLoadSection.this.fViewer.getSelection()).getFirstElement();
                if (item == null) {
                    return;
                }
                ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)manager);
                ContextMenuHelper2.addStandardActions((IMenuManager)manager, (ISelectionProvider)this.val$provider, (IWorkbenchSite)TeamLoadSection.this.getSectionSite().getViewSite(), (String[])IMenuOperationTarget.ALL_TYPES);
                manager.appendToGroup("additions", (IAction)new SectionAction(TeamLoadSection.this, Messages.TeamLoadSection_SHOW_WORK_ITEMS_ACTION_LABEL, 1, new State[]{State.POPULATED}){

                    public void run() {
                        SectionJob job = new SectionJob(TeamLoadSection.this, Messages.TeamLoadSection_JOB_RUNNING_QUERY, State.POPULATED, State.POPULATED, new State[]{State.POPULATED}){

                            protected IStatus runInSection(IProgressMonitor monitor) throws Exception {
                                IProjectAreaHandle projectArea = item.getLoadInformation().getProjectArea();
                                SortCriteria[] sortCriteria = QueryHelper.createSortCriteria(projectArea, Arrays.asList(IWorkItem.PRIORITY_PROPERTY), monitor);
                                SelectClause select = QueryHelper.createSelectClause(projectArea, Arrays.asList(IWorkItem.TYPE_PROPERTY, IWorkItem.PRIORITY_PROPERTY, IWorkItem.STATE_PROPERTY, IWorkItem.SUMMARY_PROPERTY, IWorkItem.DURATION_PROPERTY, IWorkItem.TARGET_PROPERTY), monitor);
                                Expression expression = QueryHelper.createTeamLoadQuery(item, false, monitor);
                                Statement stmt = new Statement(select, expression, sortCriteria);
                                IWorkbenchWindow workbenchWindow = TeamLoadSection.this.getSectionSite().getViewSite().getWorkbenchWindow();
                                ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)item.getContributor());
                                QueriesUI.showQueryResults((IWorkbenchWindow)workbenchWindow, (ITeamRepository)repository, (String)NLS.bind((String)Messages.TeamLoadSection_QUERY_TITLE, (Object[])new Object[]{item.getContributor().getName()}), (Expression)stmt);
                                return Status.OK_STATUS;
                            }
                        };
                        job.setUser(true);
                        TeamLoadSection.this.getSectionSite().getProgressService().schedule((Job)job);
                    }
                });
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getSectionSite().getViewSite().registerContextMenu(menu, (ISelectionProvider)provider);
        menu.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu.getMenu());
        menu.getMenu().addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu widget = (Menu)e.widget;
                MenuItem[] menuItemArray = widget.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ActionContributionItem ci;
                    MenuItem item = menuItemArray[n2];
                    if (item.getData() instanceof ActionContributionItem && "jazz.open".equals((ci = (ActionContributionItem)item.getData()).getId())) {
                        widget.setDefaultItem(item);
                        break;
                    }
                    ++n2;
                }
            }
        });
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element instanceof LoadItem) {
                    IContributor contributor = ((LoadItem)element).getContributor();
                    new OpenUserAction(TeamLoadSection.this.getSectionSite().getViewSite().getPage(), contributor, null).run();
                }
            }
        });
    }

    private void populateSection() {
        if (this.fSectionState == State.NOT_CONNECTED && this.getProjectArea() != null) {
            if (!this.fConfiguration.isConfigured()) {
                this.fSectionState = State.NOT_CONFIGURED;
            } else if (this.fSectionState != State.POPULATED) {
                this.fSectionState = State.CONFIGURED;
            }
        }
        switch (this.fSectionState) {
            case CONFIGURED: {
                this.initFromMemento();
                break;
            }
            case POPULATED: {
                if (this.fViewer.getInput() == null) break;
                TeamLoadInformation input = (TeamLoadInformation)this.fViewer.getInput();
                this.load(PlanningClientPlugin.getTeamRepository((IItemHandle)input.getTeamArea()), (IItemHandle)input.getTeamArea(), (IItemHandle)input.getIteration());
                break;
            }
            case NOT_CONFIGURED: {
                this.scheduleSectionJob(this.fJumpStartJob);
                break;
            }
            default: {
                this.update(this.fSectionState, null);
            }
        }
    }

    private void initFromMemento() {
        IItemHandle iterationHandle;
        ITeamRepository repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(this.fConfiguration.getRepositoryUrl());
        final IItemHandle teamAreaHandle = ITeamArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.fConfiguration.getTeamAreaId()), null);
        IItemHandle iItemHandle = iterationHandle = this.fConfiguration.getIterationId().equals("CURRENT") ? null : IIteration.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.fConfiguration.getIterationId()), null);
        if (repository.loggedIn()) {
            this.load(repository, teamAreaHandle, iterationHandle);
        } else {
            repository.addLoginParticipant(new ITeamRepository.ILoginParticipant(){

                public void handleLogin(ITeamRepository repository) {
                    TeamLoadSection.this.load(repository, teamAreaHandle, iterationHandle);
                    repository.removeLoginParticipant((ITeamRepository.ILoginParticipant)this);
                }

                public void handleLogout(ITeamRepository repository) {
                }
            });
            this.update(State.NOT_CONNECTED, null);
        }
    }

    private IProjectAreaHandle getProjectArea() {
        List list = ProjectAreaPicker.getAllConnectedProjectAreas((boolean)false);
        if (list.isEmpty()) {
            return null;
        }
        TeamLoadInformation input = this.getInput();
        if (input != null) {
            return input.getTeamArea().getProjectArea();
        }
        return (IProjectAreaHandle)list.get(0);
    }

    public TeamLoadInformation getInput() {
        Object input = this.fViewer.getInput();
        if (input != null) {
            return (TeamLoadInformation)input;
        }
        return null;
    }

    public void saveState(IMemento memento) {
        this.fConfiguration.saveState(memento);
    }

    protected void update(State state, String summary) {
        Assert.isNotNull((Object)((Object)state));
        State previousState = this.fSectionState;
        this.fSectionState = state;
        block0 : switch (state) {
            case CONFIGURED: {
                this.reveal(this.fViewer.getControl());
                break;
            }
            case NOT_CONFIGURED: {
                if (summary != null) {
                    this.fJumpStartLink.setText(summary);
                }
                this.reveal((Control)this.fJumpStartPart);
                break;
            }
            case NOT_CONNECTED: {
                switch (previousState) {
                    case POPULATED: {
                        this.teaserUpdater(this.fTeaserWarning, this.fTeaserTitle.getText(), Messages.TeamLoadSection_TEASER_NOT_CONNECTED, 0).run();
                        break block0;
                    }
                }
                this.teaserUpdater(null, "", null, 0);
                this.fStatusLabel.setText(Messages.TeamLoadSection_MSG_NOT_CONNECTED);
                this.reveal((Control)this.fStatusLabel.getParent());
                break;
            }
            case LOADING: {
                this.fStatusLabel.setText(Messages.TeamLoadSection_MSG_LOADING);
                this.reveal((Control)this.fStatusLabel.getParent());
                break;
            }
            case POPULATED: {
                this.reveal(this.fViewer.getControl());
                break;
            }
            case ERROR: {
                this.fTeaserTitle.setText("");
                if (summary != null) {
                    this.fStatusLabel.setText(summary);
                } else {
                    this.fStatusLabel.setText(Messages.TeamLoadSection_UNKNOWN_ERROR);
                }
                this.reveal((Control)this.fStatusLabel.getParent());
            }
        }
    }

    protected void reveal(Control c) {
        Assert.isTrue((c.getParent().getLayout() == this.fStackLayout ? 1 : 0) != 0);
        this.fStackLayout.topControl = c;
        if (c == this.fViewer.getControl()) {
            this.fViewer.getTable().getColumn(0).setWidth(this.fViewer.getTable().getClientArea().width);
        }
        c.getParent().layout(true, true);
        c.getParent().update();
    }

    public void setFocus() {
        if (this.fViewer != null) {
            this.fViewer.getControl().setFocus();
        }
    }

    public void dispose() {
        TeamLoadInformation input;
        super.dispose();
        this.fRefreshJob.cancel();
        Job.getJobManager().cancel(LOAD_JOB_FAMILY);
        if (this.fViewer != null && (input = (TeamLoadInformation)this.fViewer.getInput()) != null) {
            PlanningClientPlugin.getTeamRepository((IItemHandle)input.getTeamArea()).removeLoginParticipant(this.fLogoutHandler);
            input.dispose();
        }
        ConnectedProjectAreaRegistry.getDefault().removeListener(this.fProjectAreaStateListener);
        CollaborationCore.getCollaborationService().removePresenceListener(this.fPresenceListener);
        CollaborationCore.getCollaborationService().removeSessionListener(this.fSessionListener);
    }

    public void scheduleSectionJob(Job job) {
        this.scheduleSectionJob(job, 0L);
    }

    public void scheduleSectionJob(Job job, long delay) {
        if (!this.progressServiceInitialized()) {
            throw new IllegalStateException();
        }
        this.getSectionSite().getProgressService().schedule(job, delay, true);
    }

    private boolean progressServiceInitialized() {
        return this.getSectionSite() != null && this.getSectionSite().getProgressService() != null;
    }

    private void load(final ITeamRepository repository, final IItemHandle teamAreaHandle, final IItemHandle iterationHandle) {
        this.fJumpStartJob.cancel();
        Job.getJobManager().cancel(LOAD_JOB_FAMILY);
        Assert.isNotNull((Object)repository);
        Assert.isNotNull((Object)teamAreaHandle);
        this.scheduleSectionJob((Job)new SectionJob(Messages.TeamLoadSection_JOB_LOADING_TEAM_LOAD, State.POPULATED, State.ERROR, State.values()){

            public boolean belongsTo(Object family) {
                return LOAD_JOB_FAMILY == family;
            }

            @Override
            protected IStatus runInSection(IProgressMonitor monitor) throws Exception {
                this.postToUI(new Runnable(){

                    public void run() {
                        TeamLoadSection.this.update(State.LOADING, null);
                    }
                });
                boolean autoIteration = iterationHandle == null;
                ITeamArea teamArea = (ITeamArea)this.resolve(repository, teamAreaHandle, monitor);
                IIteration iteration = iterationHandle == null ? this.defaultIteration(repository, teamArea, monitor) : (IIteration)this.resolve(repository, iterationHandle, monitor);
                if (autoIteration && iteration != null) {
                    IIteration newIteration;
                    iteration = newIteration = TeamLoadSection.this.updateIteration(iteration, monitor);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (iteration == null) {
                    return new Status(4, PlanningUI.getPluginId(), 10, Messages.TeamLoadSection_NO_CURRENT_ITERATION, null);
                }
                String label = autoIteration ? NLS.bind((String)Messages.TeamLoadSection_TEASER_CURRENT_ITERATION, (Object[])new Object[]{teamArea.getName(), iteration.getLabel()}) : NLS.bind((String)Messages.TeamLoadSection_TEASER_ITERATION, (Object[])new Object[]{teamArea.getName(), iteration.getLabel()});
                this.postToUI(TeamLoadSection.this.teaserUpdater(null, label, null, 0));
                Assert.isNotNull((Object)teamArea);
                Assert.isNotNull((Object)iteration);
                ITeamLoadClient client = PlanningClientPlugin.getTeamLoadClient((ITeamRepository)repository);
                final TeamLoadInformation input = client.fetchTeamLoadInformation((ITeamAreaHandle)teamArea, (IIterationHandle)iteration, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                TeamLoadSection.this.fConfiguration.setRepositoryUrl(repository.getRepositoryURI());
                TeamLoadSection.this.fConfiguration.setTeamAreaId(input.getTeamArea().getItemId().getUuidValue());
                TeamLoadSection.this.fConfiguration.setIterationId(autoIteration ? "CURRENT" : input.getIteration().getItemId().getUuidValue());
                this.postToUI(new Runnable(){

                    public void run() {
                        TeamLoadSection.this.fViewer.setInput((Object)input);
                    }
                });
                repository.addLoginParticipant(TeamLoadSection.this.fLogoutHandler);
                TeamLoadSection.this.scheduleSectionJob(TeamLoadSection.this.fRefreshJob, ((TeamLoadSection)TeamLoadSection.this).fConfiguration.getRefreshInterval().millis);
                return Status.OK_STATUS;
            }

            private IIteration defaultIteration(ITeamRepository repository2, ITeamArea teamArea, IProgressMonitor monitor) throws TeamRepositoryException {
                IProjectArea projectArea = (IProjectArea)this.resolve(repository2, (IItemHandle)teamArea.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                IDevelopmentLineHandle devLineHandle = projectArea.getTeamAreaHierarchy().getDevelopmentLine((ITeamAreaHandle)teamArea);
                IDevelopmentLine devLine = (IDevelopmentLine)this.resolve(repository2, (IItemHandle)devLineHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                return IterationClient.getCurrentPlanLeafIteration((IDevelopmentLineHandle)devLine, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }

            private <T extends IItem> T resolve(ITeamRepository repository2, IItemHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
                return (T)repository2.itemManager().fetchCompleteItem(handle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        });
    }

    private IIteration updateIteration(IIteration iteration, IProgressMonitor monitor) throws TeamRepositoryException {
        IDevelopmentLineHandle devLineHandle = iteration.getDevelopmentLine();
        IIteration result = IterationClient.getCurrentPlanLeafIteration((IDevelopmentLineHandle)devLineHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (result != null) {
            return result;
        }
        return iteration;
    }

    private boolean canAdoptWorkItem(IWorkItem workItem, LoadItem item) {
        if (workItem.getProjectArea() != null && !workItem.getProjectArea().sameItemId((IItemHandle)item.getLoadInformation().getProjectArea())) {
            return false;
        }
        if (workItem.getOwner() != null) {
            if (!workItem.getOwner().sameItemId((IItemHandle)item.getContributor())) {
                return true;
            }
            if (workItem.getTarget() != null && !workItem.getTarget().sameItemId((IItemHandle)item.getLoadInformation().getIterations().iterator().next())) {
                return true;
            }
        }
        return false;
    }

    private void adoptWorkItem(final IWorkItemHandle workItem, final LoadItem loadItem) {
        this.scheduleSectionJob((Job)new SectionJob(Messages.TeamLoadSection_JOB_ADOPTING_WORK_ITEM, State.POPULATED, State.POPULATED, new State[]{State.POPULATED}){

            protected IStatus runInSection(IProgressMonitor monitor) throws Exception {
                IWorkItemClient client = PlanningClientPlugin.getWorkItemClient((IItemHandle)workItem);
                IWorkItemWorkingCopyManager workItemManager = client.getWorkItemWorkingCopyManager();
                ItemProfile profile = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, (Collection)loadItem.getLoadInformation().getRequiredProperties());
                workItemManager.connect(workItem, profile, monitor);
                try {
                    WorkItemWorkingCopy workingCopy = workItemManager.getWorkingCopy(workItem);
                    boolean retrievedDirty = workingCopy.isDirty();
                    if (!TeamLoadSection.this.canAdoptWorkItem(workingCopy.getWorkItem(), loadItem)) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    workItemManager.beginCompoundWorkItemChange((IWorkItemHandle)workingCopy.getWorkItem());
                    try {
                        ItemArrayList categories = new ItemArrayList((Collection)client.findCategoriesOfTeamArea2((ITeamAreaHandle)((TeamLoadInformation)loadItem.getLoadInformation()).getTeamArea(), ICategory.DEFAULT_PROFILE, monitor));
                        ICategoryHandle category = workingCopy.getWorkItem().getCategory();
                        if (categories.isEmpty()) {
                            category = client.findUnassignedCategory(loadItem.getLoadInformation().getProjectArea(), ICategory.DEFAULT_PROFILE, monitor);
                            workingCopy.getWorkItem().setCategory(category);
                        } else if (category == null || !categories.contains((Object)category)) {
                            workingCopy.getWorkItem().setCategory((ICategoryHandle)categories.get(0));
                        }
                        workingCopy.getWorkItem().setOwner((IContributorHandle)loadItem.getContributor());
                        workingCopy.getWorkItem().setTarget((IIterationHandle)((TeamLoadContentProvider)TeamLoadSection.this.fViewer.getContentProvider()).getInput().getIteration());
                    }
                    finally {
                        workItemManager.endCompoundWorkItemChange((IWorkItemHandle)workingCopy.getWorkItem());
                    }
                    if (!retrievedDirty) {
                        workItemManager.save(new WorkItemWorkingCopy[]{workingCopy}, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                }
                finally {
                    workItemManager.disconnect(workItem);
                }
                return Status.OK_STATUS;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Intervals {
        DISABLE(-1),
        NOW(0),
        MIN_3(180000),
        MIN_5(300000),
        MIN_10(600000),
        MIN_15(900000),
        MIN_30(1800000),
        MIN_60(3600000);

        public final int millis;

        private Intervals(int v) {
            this.millis = v;
        }
    }

    public class RefreshAction
    extends SectionAction {
        private Intervals fInterval;

        public RefreshAction(Intervals interval) {
            super(null, interval == Intervals.NOW ? 1 : 8, State.POPULATED);
            switch (interval) {
                case NOW: {
                    this.setText(Messages.TeamLoadSection_UPDATE_INTERVAL_NOW);
                    break;
                }
                case DISABLE: {
                    this.setText(Messages.TeamLoadSection_UPDATE_INTERVAL_DISABLE);
                    break;
                }
                default: {
                    this.setText(NLS.bind((String)Messages.TeamLoadSection_UPDATE_INTERVAL_FREQUENT, (Object[])new Object[]{interval.millis / 60000}));
                }
            }
            if (interval == TeamLoadSection.this.fConfiguration.getRefreshInterval()) {
                this.setChecked(true);
            }
            this.fInterval = interval;
        }

        public void run() {
            TeamLoadSection.this.fRefreshJob.cancel();
            if (this.fInterval != Intervals.NOW && this.fInterval != Intervals.DISABLE) {
                TeamLoadSection.this.fConfiguration.setRefreshInterval(this.fInterval);
                TeamLoadSection.this.scheduleSectionJob(TeamLoadSection.this.fRefreshJob, this.fInterval.millis);
            }
            if (this.fInterval == Intervals.NOW) {
                TeamLoadSection.this.scheduleSectionJob(TeamLoadSection.this.fRefreshJob);
            }
        }
    }

    abstract class SectionAction
    extends Action {
        private Collection<State> fValidStates;

        public SectionAction(String name, int style, State ... validStates) {
            super(name, style);
            this.fValidStates = Collections.unmodifiableCollection((Collection)Arrays.asList(validStates));
        }

        public boolean isEnabled() {
            return this.fValidStates.contains((Object)TeamLoadSection.this.fSectionState);
        }
    }

    abstract class SectionJob
    extends FoundationJob {
        final Collection<State> fValidStates;
        final State fEndSucesses;
        final State fEndFailure;
        private State fStartedIn;

        public SectionJob(String name, State endSuccess, State endFailure, State ... startStates) {
            super(name, TeamLoadSection.this.TEAMLOAD_CONTEXT);
            this.fValidStates = Collections.unmodifiableCollection((Collection)Arrays.asList(startStates));
            this.fEndSucesses = endSuccess;
            this.fEndFailure = endFailure;
        }

        public State getStartedIn() {
            return this.fStartedIn;
        }

        public boolean shouldSchedule() {
            return TeamLoadSection.this.progressServiceInitialized() && this.fValidStates.contains((Object)TeamLoadSection.this.fSectionState);
        }

        public boolean shouldRun() {
            return this.shouldSchedule();
        }

        protected final IStatus runProtected(IProgressMonitor monitor) throws Exception {
            this.fStartedIn = TeamLoadSection.this.fSectionState;
            return this.runInSection(monitor);
        }

        protected abstract IStatus runInSection(IProgressMonitor var1) throws Exception;

        public void postToUI(Runnable runnable) {
            UI.syncExec(TeamLoadSection.this.getSectionSite().getViewSite().getShell().getDisplay(), runnable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        NOT_CONFIGURED,
        CONFIGURED,
        NOT_CONNECTED,
        LOADING,
        POPULATED,
        ERROR;

    }
}

