/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.teamload;

import com.ibm.team.apt.internal.ide.ui.teamload.TeamLoadSection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.IMemento;

public class TeamLoadConfiguration {
    private static final String REFRESH_INTERVAL = "REFRESH_INTERVAL";
    private static final String SHOW_IMAGES = "SHOW_IMAGES";
    private static final String REPO_URL = "REPO_URL";
    private static final String TEAM_AREA_UUID = "TEAM_AREA_UUID";
    private static final String ITERATION_UUID = "ITERATION_UUID";
    public static final String CURRENT = "CURRENT";
    private TeamLoadSection.Intervals fRefreshInterval;
    private boolean fShowImages;
    private String fRepositoryUrl;
    private String fTeamAreaId;
    private String fIterationId;

    public TeamLoadConfiguration() {
        this.initDefaults();
    }

    public void initDefaults() {
        this.fShowImages = true;
        this.fIterationId = CURRENT;
        this.fRefreshInterval = TeamLoadSection.Intervals.MIN_5;
    }

    public void loadState(IMemento memento) {
        String str;
        if (memento == null) {
            return;
        }
        Integer value = memento.getInteger(SHOW_IMAGES);
        if (value != null) {
            boolean bl = this.fShowImages = value == 1;
        }
        if ((value = memento.getInteger(REFRESH_INTERVAL)) != null && value >= 0 && value < TeamLoadSection.Intervals.values().length) {
            this.fRefreshInterval = TeamLoadSection.Intervals.values()[value];
        }
        if ((str = memento.getString(REPO_URL)) != null) {
            this.fRepositoryUrl = str;
        }
        if ((str = memento.getString(TEAM_AREA_UUID)) != null) {
            this.fTeamAreaId = str;
        }
        if ((str = memento.getString(ITERATION_UUID)) != null) {
            this.fIterationId = str;
        }
    }

    public void saveState(IMemento memento) {
        Assert.isNotNull((Object)memento);
        memento.putInteger(SHOW_IMAGES, this.fShowImages ? 1 : 0);
        memento.putInteger(REFRESH_INTERVAL, this.fRefreshInterval.ordinal());
        memento.putString(REPO_URL, this.fRepositoryUrl);
        memento.putString(TEAM_AREA_UUID, this.fTeamAreaId);
        memento.putString(ITERATION_UUID, this.fIterationId);
    }

    public boolean isConfigured() {
        return this.fRepositoryUrl != null && this.fTeamAreaId != null && this.fIterationId != null;
    }

    public String getRepositoryUrl() {
        return this.fRepositoryUrl;
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.fRepositoryUrl = repositoryUrl;
    }

    public String getTeamAreaId() {
        return this.fTeamAreaId;
    }

    public void setTeamAreaId(String teamAreaId) {
        this.fTeamAreaId = teamAreaId;
    }

    public boolean useCurrentIteration() {
        return this.fIterationId.equals(CURRENT);
    }

    public String getIterationId() {
        return this.fIterationId;
    }

    public void setIterationId(String iterationId) {
        this.fIterationId = iterationId;
    }

    public TeamLoadSection.Intervals getRefreshInterval() {
        return this.fRefreshInterval;
    }

    public void setRefreshInterval(TeamLoadSection.Intervals refreshInterval) {
        this.fRefreshInterval = refreshInterval;
    }

    public boolean isShowImages() {
        return this.fShowImages;
    }

    public void setShowImages(boolean showImages) {
        this.fShowImages = showImages;
    }
}

