/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.widgets;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.team.apt.common.resource.IWorkDayDefinition;
import com.ibm.team.apt.internal.ide.ui.resource.widgets.DurationPickerWidget;
import com.ibm.team.apt.internal.ide.ui.resource.widgets.Messages;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkDayDefinitionDialog
extends StatusDialog {
    private long fEndTime = 61200000L;
    private final Locale fLocale;
    private final DateFormat fWeekDayFormat;
    private boolean fWorkDay;
    private final Collection<IWorkDayDefinition> fWorkDayDefinitions;
    private long fWorkingTime = 28800000L;

    public WorkDayDefinitionDialog(Shell parent, String title, Collection<IWorkDayDefinition> definitions, Locale locale) {
        super(parent);
        Assert.isNotNull(definitions);
        Assert.isNotNull((Object)locale);
        this.setTitle(title);
        this.fWorkDayDefinitions = definitions;
        long workingTime = Long.MIN_VALUE;
        long endTime = Long.MIN_VALUE;
        for (IWorkDayDefinition definition : definitions) {
            if (endTime == Long.MIN_VALUE) {
                endTime = definition.getEndTime();
                continue;
            }
            if (endTime == definition.getEndTime()) continue;
            endTime = Long.MIN_VALUE;
            break;
        }
        for (IWorkDayDefinition definition : definitions) {
            if (workingTime == Long.MIN_VALUE) {
                workingTime = definition.getWorkingTime();
                continue;
            }
            if (workingTime == definition.getWorkingTime()) continue;
            workingTime = Long.MIN_VALUE;
            break;
        }
        if (workingTime != Long.MIN_VALUE) {
            this.fWorkingTime = workingTime;
        }
        if (endTime != Long.MIN_VALUE) {
            this.fEndTime = endTime;
        }
        this.fWorkDay = this.fWorkingTime != 0L && this.fEndTime != 0L;
        this.fLocale = locale;
        this.fWeekDayFormat = new SimpleDateFormat("EEEE", locale);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "com.ibm.team.apt.work.day.definition.dialog");
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 7;
        layout.marginHeight = 7;
        composite.setLayout((Layout)layout);
        this.createWorkTimeControls(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createWorkTimeControls(Composite parent) {
        Assert.isNotNull((Object)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        final Calendar calendar = Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)"GMT"), (Locale)this.fLocale);
        calendar.setTimeInMillis(System.currentTimeMillis());
        boolean single = false;
        if (this.fWorkDayDefinitions.size() == 1) {
            single = true;
            calendar.set(7, this.fWorkDayDefinitions.iterator().next().getDay().getValue());
        }
        final Button button = new Button(composite, 32);
        if (single) {
            button.setText(MessageFormat.format((String)Messages.WorkDayDefinitionDialog_SCHEDULE_PATTERN, (Object[])new String[]{this.fWeekDayFormat.format(calendar.getTime())}));
        } else {
            button.setText(Messages.WorkDayDefinitionDialog_SCHEDULE_LABEL);
        }
        GridData data = new GridData();
        data.verticalIndent = 8;
        data.horizontalSpan = 2;
        button.setLayoutData((Object)data);
        final Label workingLabel = new Label(composite, 64);
        workingLabel.setText(Messages.WorkDayDefinitionDialog_WORKING_TIME_LABEL);
        data = new GridData();
        data.verticalIndent = 8;
        workingLabel.setLayoutData((Object)data);
        if (this.fWorkingTime != 0L) {
            calendar.setTimeInMillis(this.fWorkingTime);
        } else {
            calendar.setTimeInMillis(28800000L);
        }
        final DurationPickerWidget workingTime = new DurationPickerWidget(composite);
        data = new GridData(16384, 4, false, false);
        data.verticalIndent = 8;
        workingTime.setLayoutData(data);
        workingTime.setHours(calendar.get(11));
        workingTime.setMinutes(calendar.get(12));
        workingTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                calendar.setTimeInMillis(0L);
                calendar.set(11, workingTime.getHours());
                calendar.set(12, workingTime.getMinutes());
                WorkDayDefinitionDialog.this.fWorkingTime = calendar.getTimeInMillis();
                WorkDayDefinitionDialog.this.getButton(0).setEnabled(true);
            }
        });
        workingTime.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                calendar.setTimeInMillis(0L);
                calendar.set(11, workingTime.getHours());
                calendar.set(12, workingTime.getMinutes());
                WorkDayDefinitionDialog.this.fWorkingTime = calendar.getTimeInMillis();
                WorkDayDefinitionDialog.this.getButton(0).setEnabled(true);
            }
        });
        final Label endLabel = new Label(composite, 64);
        endLabel.setText(Messages.WorkDayDefinitionDialog_END_TIME_LABEL);
        if (this.fEndTime != 0L) {
            calendar.setTimeInMillis(this.fEndTime);
        } else {
            calendar.setTimeInMillis(61200000L);
        }
        endLabel.setLayoutData((Object)new GridData());
        final DateTime endTime = new DateTime(composite, 34944);
        endTime.setHours(calendar.get(11));
        endTime.setMinutes(calendar.get(12));
        endTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                calendar.setTimeInMillis(0L);
                calendar.set(11, endTime.getHours());
                calendar.set(12, endTime.getMinutes());
                WorkDayDefinitionDialog.this.fEndTime = calendar.getTimeInMillis();
                WorkDayDefinitionDialog.this.getButton(0).setEnabled(true);
            }
        });
        data = new GridData(16384, 4, false, false);
        endTime.setLayoutData((Object)data);
        button.setSelection(this.fWorkDay);
        workingLabel.setEnabled(this.fWorkDay);
        workingTime.setEnabled(this.fWorkDay);
        endLabel.setEnabled(this.fWorkDay);
        endTime.setEnabled(this.fWorkDay);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean selection = button.getSelection();
                workingLabel.setEnabled(selection);
                workingTime.setEnabled(selection);
                endLabel.setEnabled(selection);
                endTime.setEnabled(selection);
                WorkDayDefinitionDialog.this.fWorkDay = selection;
                if (WorkDayDefinitionDialog.this.fWorkDay) {
                    if (WorkDayDefinitionDialog.this.fWorkingTime == 0L) {
                        WorkDayDefinitionDialog.this.fWorkingTime = 28800000L;
                        calendar.setTimeInMillis(WorkDayDefinitionDialog.this.fWorkingTime);
                        workingTime.setHours(calendar.get(11));
                        workingTime.setMinutes(calendar.get(12));
                    }
                    if (WorkDayDefinitionDialog.this.fEndTime == 0L) {
                        WorkDayDefinitionDialog.this.fEndTime = 61200000L;
                        calendar.setTimeInMillis(WorkDayDefinitionDialog.this.fEndTime);
                        endTime.setHours(calendar.get(11));
                        endTime.setMinutes(calendar.get(12));
                    }
                }
                WorkDayDefinitionDialog.this.getButton(0).setEnabled(true);
            }
        });
    }

    public long getEndTime() {
        return this.fEndTime;
    }

    public long getWorkingTime() {
        return this.fWorkingTime;
    }

    public boolean isWorkDay() {
        return this.fWorkDay;
    }
}

