/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.widgets;

import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.resource.widgets.Messages;
import com.ibm.team.apt.internal.ide.ui.util.PixelConverter;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.calendar.DatePicker;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class DatePickerWidget
extends Composite {
    private ControlDecoration fDecoration;
    private Text fTextField;

    public DatePickerWidget(Composite parent, final DateFormat format, ResourceManager manager, FormToolkit toolkit) {
        super(parent, 0);
        Assert.isNotNull((Object)format);
        Assert.isNotNull((Object)manager);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(768));
        this.fTextField = toolkit != null ? toolkit.createText((Composite)this, "", 2052) : new Text((Composite)this, 2052);
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        this.fDecoration = new ControlDecoration((Control)this.fTextField, 16512);
        this.fDecoration.setImage(registry.getFieldDecoration("DEC_ERROR").getImage());
        this.fDecoration.setDescriptionText(Messages.DatePickerWidget_ENTER_VALID_DATE);
        this.fDecoration.hide();
        GridData data = new GridData(768);
        data.widthHint = new PixelConverter((Control)parent).convertWidthInCharsToPixels(18);
        this.fTextField.setLayoutData((Object)data);
        final ToolBar toolbar = new ToolBar((Composite)this, 0x800000);
        if (toolkit != null) {
            toolkit.adapt((Control)toolbar, true, true);
        }
        toolbar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        final ToolItem item = new ToolItem(toolbar, 8);
        item.setToolTipText(Messages.DatePickerWidget_PICK_DATE);
        item.setImage(JazzResources.getImageWithDefault((ResourceManager)manager, (ImageDescriptor)ImagePool.DATE));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                item.setEnabled(false);
                try {
                    Rectangle bounds = item.getBounds();
                    Point point = new Point(bounds.x, bounds.y + bounds.height);
                    point = toolbar.toDisplay(point);
                    DatePicker picker = new DatePicker(DatePickerWidget.this.getShell());
                    picker.setLocation(point.x, point.y);
                    try {
                        picker.setDate(format.parse(DatePickerWidget.this.fTextField.getText()));
                    }
                    catch (ParseException parseException) {}
                    picker.open();
                    Date date = picker.getDateObject();
                    if (date != null) {
                        DatePickerWidget.this.fTextField.setText(format.format(date));
                        DatePickerWidget.this.fTextField.setFocus();
                    }
                }
                finally {
                    if (!item.isDisposed()) {
                        item.setEnabled(true);
                    }
                }
            }
        });
    }

    public ControlDecoration getDecoration() {
        return this.fDecoration;
    }

    public Text getText() {
        return this.fTextField;
    }
}

