/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.parts;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.team.apt.common.resource.IWorkResourceDetails;
import com.ibm.team.apt.common.resource.IWorkResourceDetailsHandle;
import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.client.resource.OperationStatus;
import com.ibm.team.apt.internal.common.resource.model.WorkResourceDetails;
import com.ibm.team.apt.internal.common.util.ItemAwareMap;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemHashSet;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.jface.StructuredContentProvider;
import com.ibm.team.apt.internal.ide.ui.resource.AbstractContributorResourceFormPage;
import com.ibm.team.apt.internal.ide.ui.resource.AbstractContributorResourceInput;
import com.ibm.team.apt.internal.ide.ui.resource.parts.AbstractContributorResourceFormPart;
import com.ibm.team.apt.internal.ide.ui.resource.parts.Messages;
import com.ibm.team.apt.internal.ide.ui.resource.widgets.WorkResourceDetailsDialog;
import com.ibm.team.apt.internal.ide.ui.util.PixelConverter;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.ide.ui.EditorUtilities;
import com.ibm.team.process.internal.ide.ui.editors.contributor.ContributorEditor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkResourceDetailsPart
extends AbstractContributorResourceFormPart {
    private static final AbstractResourceDetailsNode[] NO_CHILDREN = new AbstractResourceDetailsNode[0];
    public static final String PART_ID = "com.ibm.team.apt.resource.work.resource.details.part.name";
    private Button fArchivedButton;
    private Button fEditButton;
    private IProgressMonitor fMonitor = null;
    private TreeColumn fPercentageColumn;
    private TreeColumn fResourceColumn;
    private boolean fShowArchived = false;
    private final StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
    private Label fWorkDetailsSummary;
    private TreeViewer fWorkDetailsViewer;

    private static boolean isDynamicAssignmentAllowed(AbstractResourceDetailsNode[] nodes, DevelopmentLineDetailsNode node) {
        boolean nodeFound = false;
        AbstractResourceDetailsNode candidate = null;
        AbstractResourceDetailsNode[] abstractResourceDetailsNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            int assignment;
            AbstractResourceDetailsNode current = abstractResourceDetailsNodeArray[n2];
            if (!WorkResourceDetailsPart.isDynamicAssignmentAllowed(current.getChildren(), node)) {
                return false;
            }
            if (current.equals(node)) {
                nodeFound = true;
            }
            if ((assignment = current.getAssignment()) < 0) {
                candidate = current;
            }
            if (nodeFound && candidate != null && !node.equals(candidate)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static void openProcessArea(IWorkbenchPage page, IProcessAreaHandle area) {
        if (area instanceof IProjectAreaHandle) {
            EditorUtilities.openProjectAreaEditor((IWorkbenchPage)page, (IProjectAreaHandle)((IProjectAreaHandle)area), (String)"com.ibm.team.process.ProjectAreaEditor");
        } else if (area instanceof ITeamAreaHandle) {
            EditorUtilities.openTeamAreaEditor((IWorkbenchPage)page, (ITeamAreaHandle)((ITeamAreaHandle)area), (String)"com.ibm.team.process.TeamAreaEditor");
        }
    }

    private static void setButtonWidth(Button button) {
        Assert.isNotNull((Object)button);
        Object data = button.getLayoutData();
        if (data instanceof GridData) {
            GridData extended = (GridData)data;
            extended.widthHint = Math.max(new PixelConverter((Control)button).convertHorizontalDLUsToPixels(61), button.computeSize((int)-1, (int)-1, (boolean)true).x);
            extended.horizontalAlignment = 4;
        }
    }

    public WorkResourceDetailsPart(AbstractContributorResourceFormPage page) {
        super(page);
        this.setId(PART_ID);
    }

    private void createArchivedCheckbox(Composite parent) {
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = this.getToolkit();
        this.fArchivedButton = toolkit.createButton(parent, Messages.WorkResourceDetailsPart_SHOW_ARCHIVED_CHECKBOX, 32);
        this.fArchivedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkResourceDetailsPart.this.fShowArchived = WorkResourceDetailsPart.this.fArchivedButton.getSelection();
                WorkResourceDetailsPart.this.fWorkDetailsViewer.refresh();
            }
        });
    }

    private Button createButton(Composite parent, String label) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)label);
        FormToolkit toolkit = this.getToolkit();
        Button button = toolkit.createButton(parent, label, 8);
        button.setLayoutData((Object)new GridData(258));
        WorkResourceDetailsPart.setButtonWidth(button);
        return button;
    }

    private void createButtons(Composite parent) {
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = this.getToolkit();
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(144));
        this.fEditButton = this.createButton(composite, Messages.WorkResourceDetailsPart_CHANGE_BUTTON_LABEL);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)WorkResourceDetailsPart.this.fWorkDetailsViewer.getSelection();
                if (selection.size() == 1) {
                    WorkResourceDetailsPart.this.editSelection(selection);
                }
            }
        });
        this.fEditButton.setEnabled(false);
    }

    public void createContent(Composite parent) {
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = this.getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        parent.addDisposeListener(new DisposeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetDisposed(DisposeEvent event) {
                3 var2_2 = this;
                synchronized (var2_2) {
                    if (WorkResourceDetailsPart.this.fMonitor != null && !WorkResourceDetailsPart.this.fMonitor.isCanceled()) {
                        WorkResourceDetailsPart.this.fMonitor.setCanceled(true);
                    }
                }
            }
        });
        this.createDescription(parent);
        Composite composite = toolkit.createComposite(parent);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createWorkDetailsViewer(composite);
        this.createButtons(composite);
        this.createArchivedCheckbox(composite);
    }

    private void createDescription(Composite parent) {
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = this.getToolkit();
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(16384, 1, false, false));
        Label prefix = toolkit.createLabel(composite, Messages.WorkResourceDetailsPart_WORK_ASSIGNMENTS_LABEL);
        prefix.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fWorkDetailsSummary = toolkit.createLabel(composite, Messages.WorkResourceDetailsPart_UNKNOWN_LOAD_LABEL, 131072);
        this.fWorkDetailsSummary.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
    }

    private AbstractResourceDetailsNode[] createWorkDetailsInput(ITeamRepository repository, IWorkResourceDetails[] details, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)repository);
        Assert.isNotNull((Object)details);
        HashMap<UUID, IAuditableHandle> handles = new HashMap<UUID, IAuditableHandle>(details.length);
        ItemHashMap owners = new ItemHashMap(details.length);
        IWorkResourceDetails[] iWorkResourceDetailsArray = details;
        int n = details.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkResourceDetails detail = iWorkResourceDetailsArray[n2];
            IAuditableHandle handle = detail.getOwner();
            if (!handles.containsKey(handle.getItemId())) {
                handles.put(handle.getItemId(), handle);
            }
            owners.put((IItemHandle)detail, (Object)handle);
            ++n2;
        }
        List auditables = repository.itemManager().fetchCompleteItems(new ArrayList(handles.values()), 0, monitor);
        ArrayList<AbstractResourceDetailsNode> nodes = new ArrayList<AbstractResourceDetailsNode>(auditables.size());
        HashMap<String, ProcessAreaContainerDetailsNode> containers = new HashMap<String, ProcessAreaContainerDetailsNode>(details.length);
        for (IAuditable auditable : auditables) {
            if (!(auditable instanceof IProcessArea)) continue;
            IProcessArea area = (IProcessArea)auditable;
            ProcessAreaContainerDetailsNode node = (ProcessAreaContainerDetailsNode)containers.get(area.getName());
            if (node == null) {
                node = new ProcessAreaContainerDetailsNode(area);
                nodes.add(node);
                containers.put(area.getName(), node);
            }
            IWorkResourceDetails[] iWorkResourceDetailsArray2 = details;
            int n3 = details.length;
            int n4 = 0;
            while (n4 < n3) {
                IDevelopmentLineHandle handle;
                IWorkResourceDetails detail = iWorkResourceDetailsArray2[n4];
                IAuditableHandle owner = (IAuditableHandle)owners.get((IItemHandle)detail);
                if (area.sameItemId((IItemHandle)owner) && (handle = detail.getDevelopmentLine()) != null) {
                    IDevelopmentLine line = (IDevelopmentLine)repository.itemManager().fetchCompleteItem((IItemHandle)handle, 0, monitor);
                    node.addChild(new DevelopmentLineDetailsNode(node, line, detail));
                }
                ++n4;
            }
        }
        int size = nodes.size();
        int index = size - 1;
        while (index >= 0) {
            AbstractResourceDetailsNode node = (AbstractResourceDetailsNode)nodes.get(index);
            if (node instanceof ProcessAreaContainerDetailsNode && node.hasSingleChild()) {
                ProcessAreaContainerDetailsNode container = (ProcessAreaContainerDetailsNode)node;
                AbstractResourceDetailsNode child = node.getChildren()[0];
                if (child instanceof DevelopmentLineDetailsNode) {
                    DevelopmentLineDetailsNode extended = (DevelopmentLineDetailsNode)child;
                    nodes.set(index, new ProcessAreaDetailsNode(container.getProcessArea(), extended.getDevelopmentLine(), extended.getWorkResourceDetails()));
                }
            }
            --index;
        }
        return nodes.toArray(new AbstractResourceDetailsNode[size]);
    }

    private void createWorkDetailsViewer(Composite parent) {
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = this.getToolkit();
        final Tree tree = toolkit.createTree(parent, 0x10010B00);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = new PixelConverter((Control)parent).convertHeightInCharsToPixels(9);
        tree.setLayoutData((Object)data);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.fResourceColumn = new TreeColumn(tree, 16384, 0);
        this.fResourceColumn.setWidth(320);
        this.fResourceColumn.setResizable(true);
        this.fResourceColumn.setText(Messages.WorkResourceDetailsPart_TEAM_COLUMN);
        this.fResourceColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeColumn column = tree.getSortColumn();
                if (column != WorkResourceDetailsPart.this.fResourceColumn) {
                    tree.setSortColumn(WorkResourceDetailsPart.this.fResourceColumn);
                } else {
                    int direction = tree.getSortDirection();
                    if (direction == 128) {
                        tree.setSortDirection(1024);
                    } else if (direction == 1024) {
                        tree.setSortDirection(128);
                    }
                }
                WorkResourceDetailsPart.this.fWorkDetailsViewer.refresh(false);
            }
        });
        this.fPercentageColumn = new TreeColumn(tree, 16384, 1);
        this.fPercentageColumn.setWidth(100);
        this.fPercentageColumn.setResizable(true);
        this.fPercentageColumn.setText(Messages.WorkResourceDetailsPart_PERCENTAGE_COLUMN);
        this.fPercentageColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeColumn column = tree.getSortColumn();
                if (column != WorkResourceDetailsPart.this.fPercentageColumn) {
                    tree.setSortColumn(WorkResourceDetailsPart.this.fPercentageColumn);
                } else {
                    int direction = tree.getSortDirection();
                    if (direction == 128) {
                        tree.setSortDirection(1024);
                    } else if (direction == 1024) {
                        tree.setSortDirection(128);
                    }
                }
                WorkResourceDetailsPart.this.fWorkDetailsViewer.refresh(false);
            }
        });
        tree.setSortColumn(this.fResourceColumn);
        tree.setSortDirection(128);
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                Object area;
                boolean changeable = false;
                final IStructuredSelection selection = (IStructuredSelection)WorkResourceDetailsPart.this.fWorkDetailsViewer.getSelection();
                if (selection.size() == 1) {
                    AbstractResourceDetailsNode node = (AbstractResourceDetailsNode)selection.getFirstElement();
                    changeable = node instanceof DevelopmentLineDetailsNode;
                    area = node instanceof ProcessAreaContainerDetailsNode ? ((ProcessAreaContainerDetailsNode)node).getProcessArea() : (node instanceof ProcessAreaDetailsNode ? ((ProcessAreaDetailsNode)node).getProcessArea() : null);
                } else {
                    area = null;
                }
                if (area != null) {
                    menu.add((IAction)new Action(Messages.WorkResourceDetailsPart_OPEN_CONTEXT_ACTION, (IProcessArea)area){
                        private final /* synthetic */ IProcessArea val$area;
                        {
                            this.val$area = iProcessArea;
                            super($anonymous0);
                        }

                        public void run() {
                            WorkResourceDetailsPart.openProcessArea(WorkResourceDetailsPart.this.getSite().getWorkbenchPage(), (IProcessAreaHandle)this.val$area);
                        }
                    });
                }
                if (changeable) {
                    if (area != null) {
                        menu.add((IContributionItem)new Separator());
                    }
                    menu.add((IAction)new Action(Messages.WorkResourceDetailsPart_CHANGE_CONTEXT_ACTION){

                        public void run() {
                            WorkResourceDetailsPart.this.editSelection(selection);
                        }
                    });
                }
            }
        });
        Menu menu = manager.createContextMenu((Control)tree);
        tree.setMenu(menu);
        this.fWorkDetailsViewer = new TreeViewer(tree);
        this.fWorkDetailsViewer.setUseHashlookup(true);
        this.fWorkDetailsViewer.setLabelProvider((IBaseLabelProvider)new WorkDetailsLabelProvider());
        this.fWorkDetailsViewer.setContentProvider((IContentProvider)new WorkDetailsViewerContentProvider());
        this.fWorkDetailsViewer.setComparator((ViewerComparator)new WorkDetailsViewerComparator());
        this.fWorkDetailsViewer.setColumnProperties(new String[]{Messages.WorkResourceDetailsPart_TEAM_PROPERTY, Messages.WorkResourceDetailsPart_PERCENTAGE_PROPERTY});
        this.fWorkDetailsViewer.setAutoExpandLevel(-1);
        this.fWorkDetailsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Assert.isNotNull((Object)event);
                boolean enabled = false;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1) {
                    AbstractResourceDetailsNode node = (AbstractResourceDetailsNode)selection.getFirstElement();
                    enabled = node.getAuditable() instanceof IWorkResourceDetails;
                }
                WorkResourceDetailsPart.this.fEditButton.setEnabled(enabled);
            }
        });
        this.fWorkDetailsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)WorkResourceDetailsPart.this.fWorkDetailsViewer.getSelection();
                if (selection.size() == 1) {
                    AbstractResourceDetailsNode node = (AbstractResourceDetailsNode)selection.getFirstElement();
                    if (node instanceof DevelopmentLineDetailsNode) {
                        WorkResourceDetailsPart.this.editSelection(selection);
                    } else if (node instanceof ProcessAreaContainerDetailsNode) {
                        ProcessAreaContainerDetailsNode extended = (ProcessAreaContainerDetailsNode)node;
                        WorkResourceDetailsPart.openProcessArea(WorkResourceDetailsPart.this.getSite().getWorkbenchPage(), (IProcessAreaHandle)extended.getProcessArea());
                    }
                }
            }
        });
        this.fWorkDetailsViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (WorkResourceDetailsPart.this.fShowArchived) {
                    return true;
                }
                if (element instanceof AbstractResourceDetailsNode) {
                    AbstractResourceDetailsNode node = (AbstractResourceDetailsNode)element;
                    AbstractResourceDetailsNode[] children = node.getChildren();
                    if (children.length > 0) {
                        boolean onlyArchived = true;
                        AbstractResourceDetailsNode[] abstractResourceDetailsNodeArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AbstractResourceDetailsNode child = abstractResourceDetailsNodeArray[n2];
                            if (!child.isArchived()) {
                                onlyArchived = false;
                                break;
                            }
                            ++n2;
                        }
                        if (onlyArchived) {
                            return false;
                        }
                    }
                    return !node.isArchived();
                }
                return true;
            }
        });
        new TooltipSupport((Control)tree, true, true){

            protected String getMarkup(Object element, boolean isFocus) {
                if (element instanceof AbstractResourceDetailsNode) {
                    AbstractResourceDetailsNode node = (AbstractResourceDetailsNode)element;
                    if (node instanceof ProcessAreaContainerDetailsNode || node instanceof ProcessAreaDetailsNode) {
                        return MessageFormat.format((String)Messages.WorkResourceDetailsPart_TEAM_AREA_HOVER, (Object[])new String[]{node.getName()});
                    }
                    if (node instanceof DevelopmentLineDetailsNode) {
                        return MessageFormat.format((String)Messages.WorkResourceDetailsPart_DEV_LINE_HOVER, (Object[])new String[]{node.getName()});
                    }
                }
                return super.getMarkup(element, isFocus);
            }

            protected void openRequested(Object element) {
                if (element != null) {
                    WorkResourceDetailsPart.this.editSelection((IStructuredSelection)new StructuredSelection(element));
                }
            }
        };
        this.getSite().registerSelectionProvider((ISelectionProvider)this.fWorkDetailsViewer, this.fWorkDetailsViewer.getControl());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fStandardLabelProvider.dispose();
    }

    private void editSelection(IStructuredSelection selection) {
        AbstractResourceDetailsNode node;
        if (!selection.isEmpty() && (node = (AbstractResourceDetailsNode)selection.getFirstElement()) instanceof DevelopmentLineDetailsNode) {
            DevelopmentLineDetailsNode extended = (DevelopmentLineDetailsNode)node;
            IWorkResourceDetails details = extended.getWorkResourceDetails();
            AbstractResourceDetailsNode[] nodes = (AbstractResourceDetailsNode[])this.fWorkDetailsViewer.getInput();
            WorkResourceDetailsDialog dialog = new WorkResourceDetailsDialog(this.getShell(), Messages.WorkResourceDetailsPart_WORK_DETAILS_DIALOG_CAPTION, extended.getAssignment(), WorkResourceDetailsPart.isDynamicAssignmentAllowed(nodes, extended));
            if (dialog.open() == 0) {
                WorkResourceDetails workingCopy = (WorkResourceDetails)(details.isNewItem() || details.isWorkingCopy() ? details : details.getWorkingCopy());
                workingCopy.setAssignment(dialog.getAssignment());
                workingCopy.setCustomized(true);
                extended.setWorkResourceDetails((IWorkResourceDetails)workingCopy);
                this.updateWorkDetailsSummary(nodes);
                this.fWorkDetailsViewer.refresh(true);
                this.getFormPage().setDirty(true);
            }
        }
    }

    private ItemAwareMap<IWorkResourceDetails, AbstractResourceDetailsNode> getWorkDetailsInput(AbstractResourceDetailsNode[] nodes) {
        if (nodes != null && nodes.length > 0) {
            ItemHashMap map = new ItemHashMap(nodes.length * 2);
            AbstractResourceDetailsNode[] abstractResourceDetailsNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractResourceDetailsNode node = abstractResourceDetailsNodeArray[n2];
                IAuditable auditable = node.getAuditable();
                if (auditable instanceof IProcessArea) {
                    AbstractResourceDetailsNode[] children;
                    AbstractResourceDetailsNode[] abstractResourceDetailsNodeArray2 = children = node.getChildren();
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        AbstractResourceDetailsNode child = abstractResourceDetailsNodeArray2[n4];
                        IWorkResourceDetails detail = (IWorkResourceDetails)child.getAuditable();
                        map.put((IItemHandle)detail, (Object)child);
                        ++n4;
                    }
                } else if (auditable instanceof IWorkResourceDetails) {
                    IWorkResourceDetails detail = (IWorkResourceDetails)auditable;
                    map.put((IItemHandle)detail, (Object)node);
                }
                ++n2;
            }
            return map;
        }
        return new ItemHashMap();
    }

    boolean hasDefaultWorkDetails(AbstractResourceDetailsNode[] nodes) {
        AbstractResourceDetailsNode[] abstractResourceDetailsNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkResourceDetails details;
            AbstractResourceDetailsNode node = abstractResourceDetailsNodeArray[n2];
            if (this.hasDefaultWorkDetails(node.getChildren())) {
                return true;
            }
            IAuditable auditable = node.getAuditable();
            if (auditable instanceof IWorkResourceDetails && !(details = (IWorkResourceDetails)auditable).isCustomized()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public synchronized boolean save(IProgressMonitor monitor) {
        AbstractContributorResourceFormPage page;
        FormEditor editor;
        AbstractContributorResourceInput input = this.getInput();
        if (input != null && (editor = (page = this.getFormPage()).getEditor()) instanceof ContributorEditor) {
            IStatus validationStatus;
            ArrayList<Object> collection;
            ItemAwareMap<IWorkResourceDetails, AbstractResourceDetailsNode> workingCopies;
            ItemHashSet predecessors;
            ContributorEditor extended;
            block15: {
                extended = (ContributorEditor)editor;
                IWorkResourceDetails[] details = (IWorkResourceDetails[])input.getWorkDetails(monitor).getElements();
                predecessors = new ItemHashSet((Collection)Arrays.asList(details));
                AbstractResourceDetailsNode[] nodes = (AbstractResourceDetailsNode[])this.fWorkDetailsViewer.getInput();
                workingCopies = this.getWorkDetailsInput(nodes);
                collection = new ArrayList<Object>(workingCopies.size());
                validationStatus = this.validateWorkDetails(nodes);
                if (!validationStatus.matches(4)) break block15;
                final Control control = this.fWorkDetailsViewer.getControl();
                control.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!control.isDisposed()) {
                            extended.setStatus(Messages.WorkResourceDetailsPart_SAVE_PROBLEM, validationStatus);
                        }
                    }
                });
                return false;
            }
            try {
                MultiStatus status;
                collection.add(validationStatus);
                ItemHashSet successors = new ItemHashSet(workingCopies.size());
                ItemHashSet toSave = new ItemHashSet(workingCopies.size());
                for (IWorkResourceDetails workingCopy : workingCopies.keySet()) {
                    if (workingCopy.isNewItem() || workingCopy.isWorkingCopy()) {
                        toSave.add((Object)workingCopy);
                    } else {
                        successors.add((Object)workingCopy);
                    }
                    predecessors.remove((Object)workingCopy);
                }
                try {
                    status = input.saveWorkDetails((IWorkResourceDetails[])toSave.toArray((Object[])new IWorkResourceDetails[toSave.size()]), monitor);
                    if (!status.isOK()) {
                        collection.add(status);
                    } else {
                        successors.addAll((Collection)Arrays.asList((IWorkResourceDetails[])status.getElements()));
                    }
                }
                catch (TeamRepositoryException exception) {
                    collection.add(new Status(4, PlanningUIPlugin.getPluginId(), Messages.WorkResourceDetailsPart_EXCEPTION_SAVING_WORK_DETAILS, (Throwable)exception));
                }
                for (IWorkResourceDetails successor : successors) {
                    AbstractResourceDetailsNode node = (AbstractResourceDetailsNode)workingCopies.get((IItemHandle)successor);
                    if (!(node instanceof DevelopmentLineDetailsNode)) continue;
                    DevelopmentLineDetailsNode detailsNode = (DevelopmentLineDetailsNode)node;
                    detailsNode.setWorkResourceDetails(successor);
                }
                try {
                    status = input.deleteWorkDetails((IWorkResourceDetailsHandle[])predecessors.toArray((Object[])new IWorkResourceDetails[predecessors.size()]), monitor);
                    if (!status.isOK()) {
                        collection.add(status);
                    }
                }
                catch (TeamRepositoryException exception) {
                    collection.add(new Status(4, PlanningUIPlugin.getPluginId(), Messages.WorkResourceDetailsPart_EXCEPTION_DELETING_WORK_DETAILS, (Throwable)exception));
                }
                status = new MultiStatus(PlanningUIPlugin.getPluginId(), 0, collection.toArray(new IStatus[collection.size()]), Messages.WorkResourceDetailsPart_CANNOT_SAVE_WORK_DETAILS, null);
                final Control control = this.fWorkDetailsViewer.getControl();
                control.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!control.isDisposed()) {
                            if (!status.isOK()) {
                                extended.setStatus(Messages.WorkResourceDetailsPart_SAVE_PROBLEM, (IStatus)status);
                            } else {
                                try {
                                    extended.setStatus(null, null);
                                    page.setValidationMessage(null, 0);
                                    control.setRedraw(false);
                                    WorkResourceDetailsPart.this.fWorkDetailsViewer.refresh(true);
                                }
                                finally {
                                    control.setRedraw(true);
                                }
                            }
                        }
                    }
                });
                return !status.matches(4);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                extended.setStatus(Messages.WorkResourceDetailsPart_SAVE_PROBLEM, (IStatus)new Status(4, PlanningUIPlugin.getPluginId(), Messages.WorkResourceDetailsPart_EXCEPTION_FETCHING_WORK_DETAILS));
            }
        }
        return false;
    }

    @Override
    public synchronized void setInput(Object object) {
        AbstractContributorResourceInput predecessor = this.getInput();
        if (predecessor == object) {
            return;
        }
        super.setInput(object);
        final AbstractContributorResourceInput input = this.getInput();
        final Control control = this.fWorkDetailsViewer.getControl();
        final Display display = control.getDisplay();
        FoundationJob job = new FoundationJob(Messages.WorkResourceDetailsPart_FETCHING_WORK_DETAILS_JOB_NAME){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus runProtected(IProgressMonitor monitor) {
                13 var2_2;
                block12: {
                    Assert.isNotNull((Object)monitor);
                    var2_2 = this;
                    synchronized (var2_2) {
                        WorkResourceDetailsPart.this.fMonitor = monitor;
                    }
                    try {
                        OperationStatus<IWorkResourceDetails> status;
                        13 var3_4 = this;
                        synchronized (var3_4) {
                            status = input != null ? input.getWorkDetails(monitor) : null;
                        }
                        final AbstractResourceDetailsNode[] nodes = status != null ? WorkResourceDetailsPart.this.createWorkDetailsInput(input.getTeamRepository(), (IWorkResourceDetails[])status.getElements(), monitor) : (AbstractResourceDetailsNode[])null;
                        if (!display.isDisposed()) {
                            display.asyncExec(new Runnable(){

                                public void run() {
                                    if (!control.isDisposed()) {
                                        AbstractContributorResourceFormPage page = WorkResourceDetailsPart.this.getFormPage();
                                        if (nodes != null) {
                                            WorkResourceDetailsPart.this.fWorkDetailsViewer.setInput((Object)nodes);
                                            WorkResourceDetailsPart.this.updateWorkDetailsSummary(nodes);
                                        }
                                        WorkResourceDetailsPart.this.fEditButton.setEnabled(false);
                                        page.getManagedForm().getForm().layout(true, true);
                                    }
                                }
                            });
                        }
                    }
                    catch (TeamRepositoryException exception) {
                        if (display.isDisposed()) break block12;
                        display.asyncExec(new Runnable(){

                            public void run() {
                                FormEditor editor;
                                AbstractContributorResourceFormPage page;
                                if (!control.isDisposed() && (page = WorkResourceDetailsPart.this.getFormPage()) != null && (editor = page.getEditor()) instanceof ContributorEditor) {
                                    ContributorEditor extended = (ContributorEditor)editor;
                                    extended.setStatus(Messages.WorkResourceDetailsPart_LOAD_PROBLEM, (IStatus)new Status(4, PlanningUIPlugin.getPluginId(), exception.getLocalizedMessage()));
                                }
                            }
                        });
                    }
                }
                var2_2 = this;
                synchronized (var2_2) {
                    WorkResourceDetailsPart.this.fMonitor = null;
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setSystem(true);
        job.schedule();
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    private void updateWorkDetailsSummary(AbstractResourceDetailsNode[] nodes) {
        Assert.isNotNull((Object)nodes);
        int total = 0;
        AbstractResourceDetailsNode[] abstractResourceDetailsNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractResourceDetailsNode node = abstractResourceDetailsNodeArray[n2];
            int assignment = node.getAssignment();
            if (assignment >= 0) {
                total += assignment;
            } else {
                total = 100;
                break;
            }
            ++n2;
        }
        String number = NumberFormat.getPercentInstance().format((double)total / 100.0);
        this.fWorkDetailsSummary.setText(MessageFormat.format((String)Messages.WorkResourceDetailsPart_TOTAL_LOAD_PATTERN, (Object[])new Object[]{number}));
        this.fWorkDetailsSummary.getParent().layout(true, true);
        AbstractContributorResourceFormPage page = this.getFormPage();
        if (total > 100) {
            number = NumberFormat.getPercentInstance().format((double)(total - 100) / 100.0);
            page.setValidationMessage(MessageFormat.format((String)Messages.WorkResourceDetailsPart_OVER_BOOKED_HINT, (Object[])new Object[]{number}), 3);
        } else if (this.hasDefaultWorkDetails(nodes)) {
            page.setValidationMessage(Messages.WorkResourceDetailsPart_AUTOMATIC_ASSIGNMENT_HINT, 1);
        } else {
            page.setValidationMessage(null, 0);
        }
    }

    private IStatus validateDynamicConstraints(AbstractResourceDetailsNode[] nodes) {
        Assert.isNotNull((Object)nodes);
        ArrayList<Status> result = new ArrayList<Status>(nodes.length);
        AbstractResourceDetailsNode candidate = null;
        boolean foundFixed = false;
        AbstractResourceDetailsNode[] abstractResourceDetailsNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractResourceDetailsNode child = abstractResourceDetailsNodeArray[n2];
            int assignment = child.getAssignment();
            if (assignment < 0) {
                if (candidate != null) {
                    result.add(new Status(4, PlanningUIPlugin.getPluginId(), MessageFormat.format((String)Messages.WorkResourceDetailsPart_CANNOT_DYNAMIC_ASSIGNMENT, (Object[])new Object[]{child.getName()})));
                }
                candidate = child;
            } else if (assignment > 0) {
                foundFixed = true;
            }
            ++n2;
        }
        if (candidate != null && !foundFixed) {
            result.add(new Status(2, PlanningUI.getPluginId(), MessageFormat.format((String)Messages.WorkResourceDetailsPart_DYNAMIC_ASSIGNMENT_GRAB_HINT, (Object[])new Object[]{candidate.getName()})));
        }
        if (result.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (result.size() == 1) {
            return (IStatus)result.iterator().next();
        }
        return new MultiStatus(PlanningUIPlugin.getPluginId(), 0, result.toArray(new IStatus[result.size()]), Messages.WorkResourceDetailsPart_CANNOT_DYNAMIC_ASSIGNMENT_TEAMS_DEV_LINES, null);
    }

    private IStatus validateWorkDetails(AbstractResourceDetailsNode[] nodes) {
        Assert.isNotNull((Object)nodes);
        int total = 0;
        ArrayList<Object> result = new ArrayList<Object>(nodes.length);
        AbstractResourceDetailsNode[] abstractResourceDetailsNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            int assignment;
            AbstractResourceDetailsNode node = abstractResourceDetailsNodeArray[n2];
            IStatus status = this.validateDynamicConstraints(node.getChildren());
            if (!status.isOK()) {
                result.add(status);
            }
            if ((assignment = node.getAssignment()) > 0) {
                total += assignment;
            }
            ++n2;
        }
        IStatus status = this.validateDynamicConstraints(nodes);
        if (!status.isOK()) {
            result.add(status);
        }
        if (total > 100) {
            String number = NumberFormat.getPercentInstance().format((double)(total - 100) / 100.0);
            result.add(new Status(4, PlanningUIPlugin.getPluginId(), MessageFormat.format((String)Messages.WorkResourceDetailsPart_OVER_BOOKED_PATTERN, (Object[])new Object[]{number})));
        }
        if (result.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (result.size() == 1) {
            return (IStatus)result.iterator().next();
        }
        return new MultiStatus(PlanningUIPlugin.getPluginId(), 0, result.toArray(new IStatus[result.size()]), Messages.WorkResourceDetailsPart_PROBLEM_WORK_ASSIGNMENT, null);
    }

    private static abstract class AbstractResourceDetailsNode {
        private AbstractResourceDetailsNode() {
        }

        public boolean equals(Object object) {
            if (object instanceof AbstractResourceDetailsNode) {
                AbstractResourceDetailsNode node = (AbstractResourceDetailsNode)object;
                return node.getAuditable().sameItemId((IItemHandle)this.getAuditable());
            }
            return false;
        }

        public abstract int getAssignment();

        public abstract IAuditable getAuditable();

        public AbstractResourceDetailsNode[] getChildren() {
            return NO_CHILDREN;
        }

        public abstract String getName();

        public AbstractResourceDetailsNode getParent() {
            return null;
        }

        public boolean hasChildren() {
            return false;
        }

        public int hashCode() {
            return this.getAuditable().getItemId().hashCode();
        }

        public boolean hasSingleChild() {
            return false;
        }

        public abstract boolean isArchived();

        public abstract boolean isCustomized();
    }

    private static class DevelopmentLineDetailsNode
    extends AbstractResourceDetailsNode {
        private boolean fCustomized = false;
        private IWorkResourceDetails fDetails;
        private final IDevelopmentLine fLine;
        private final AbstractResourceDetailsNode fParent;

        DevelopmentLineDetailsNode(AbstractResourceDetailsNode parent, IDevelopmentLine line, IWorkResourceDetails details) {
            Assert.isNotNull((Object)details);
            Assert.isNotNull((Object)line);
            this.fParent = parent;
            this.fDetails = details;
            this.fLine = line;
        }

        public int getAssignment() {
            return this.fDetails.getAssignment();
        }

        public IAuditable getAuditable() {
            return this.fDetails;
        }

        public IDevelopmentLine getDevelopmentLine() {
            return this.fLine;
        }

        public String getName() {
            return this.fLine.getLabel();
        }

        public AbstractResourceDetailsNode getParent() {
            return this.fParent;
        }

        public IWorkResourceDetails getWorkResourceDetails() {
            return this.fDetails;
        }

        public boolean isArchived() {
            return this.fLine.isArchived();
        }

        public boolean isCustomized() {
            if (this.fCustomized) {
                return true;
            }
            return this.fDetails.isCustomized();
        }

        public void setWorkResourceDetails(IWorkResourceDetails details) {
            Assert.isNotNull((Object)details);
            this.fDetails = details;
            this.fCustomized = true;
        }
    }

    private static final class ProcessAreaContainerDetailsNode
    extends AbstractResourceDetailsNode {
        private final IProcessArea fArea;
        private final Collection<AbstractResourceDetailsNode> fChildren = new HashSet<AbstractResourceDetailsNode>(4);

        ProcessAreaContainerDetailsNode(IProcessArea area) {
            Assert.isNotNull((Object)area);
            this.fArea = area;
        }

        public void addChild(AbstractResourceDetailsNode node) {
            Assert.isNotNull((Object)node);
            this.fChildren.add(node);
        }

        public int getAssignment() {
            int total = 0;
            for (AbstractResourceDetailsNode child : this.fChildren) {
                int assignment = child.getAssignment();
                if (assignment <= 0) continue;
                total += assignment;
            }
            return total;
        }

        public IAuditable getAuditable() {
            return this.fArea;
        }

        public AbstractResourceDetailsNode[] getChildren() {
            return this.fChildren.toArray(new AbstractResourceDetailsNode[this.fChildren.size()]);
        }

        public String getName() {
            return this.fArea.getName();
        }

        public IProcessArea getProcessArea() {
            return this.fArea;
        }

        public boolean hasChildren() {
            return !this.fChildren.isEmpty();
        }

        public boolean hasSingleChild() {
            return this.fChildren.size() == 1;
        }

        public boolean isArchived() {
            return this.fArea.isArchived();
        }

        public boolean isCustomized() {
            for (AbstractResourceDetailsNode child : this.fChildren) {
                if (child.isCustomized()) continue;
                return false;
            }
            return true;
        }

        public void removeChild(AbstractResourceDetailsNode node) {
            Assert.isNotNull((Object)node);
            this.fChildren.remove(node);
        }
    }

    private static class ProcessAreaDetailsNode
    extends DevelopmentLineDetailsNode {
        private final IProcessArea fArea;

        ProcessAreaDetailsNode(IProcessArea area, IDevelopmentLine line, IWorkResourceDetails details) {
            super(null, line, details);
            Assert.isNotNull((Object)area);
            this.fArea = area;
        }

        public String getName() {
            return this.fArea.getName();
        }

        public IProcessArea getProcessArea() {
            return this.fArea;
        }

        public boolean isArchived() {
            if (this.fArea.isArchived()) {
                return true;
            }
            return super.isArchived();
        }
    }

    private final class WorkDetailsLabelProvider
    extends CellLabelProvider {
        private Font fBoldFont = null;
        private Font fNormalFont = null;
        private final NumberFormat fNumberFormat = NumberFormat.getPercentInstance();
        private final ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

        private WorkDetailsLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
            super.addListener(listener);
            WorkResourceDetailsPart.this.fStandardLabelProvider.addListener(listener);
        }

        public void dispose() {
            this.fResourceManager.dispose();
            super.dispose();
        }

        private Font getBoldFont() {
            if (this.fBoldFont == null) {
                this.fBoldFont = (Font)this.fResourceManager.get((DeviceResourceDescriptor)this.getNormalFontDescriptor().withStyle(1));
            }
            return this.fBoldFont;
        }

        private Font getNormalFont() {
            if (this.fNormalFont == null) {
                this.fNormalFont = (Font)this.fResourceManager.get((DeviceResourceDescriptor)this.getNormalFontDescriptor());
            }
            return this.fNormalFont;
        }

        private FontDescriptor getNormalFontDescriptor() {
            return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().getDescriptor("org.eclipse.jface.defaultfont");
        }

        public void removeListener(ILabelProviderListener listener) {
            super.removeListener(listener);
            WorkResourceDetailsPart.this.fStandardLabelProvider.removeListener(listener);
        }

        public void update(ViewerCell cell) {
            Assert.isNotNull((Object)cell);
            AbstractResourceDetailsNode node = (AbstractResourceDetailsNode)cell.getElement();
            int index = cell.getColumnIndex();
            if (index == 0) {
                if (node instanceof ProcessAreaDetailsNode) {
                    ProcessAreaDetailsNode extended = (ProcessAreaDetailsNode)node;
                    IProcessArea area = extended.getProcessArea();
                    cell.setImage(WorkResourceDetailsPart.this.fStandardLabelProvider.getImage((Object)area));
                    cell.setText(MessageFormat.format((String)Messages.WorkResourceDetailsPart_TEAM_AREA_DEV_LINE_PATTERN, (Object[])new Object[]{WorkResourceDetailsPart.this.fStandardLabelProvider.getText((Object)area), WorkResourceDetailsPart.this.fStandardLabelProvider.getText((Object)extended.getDevelopmentLine())}));
                } else if (node instanceof ProcessAreaContainerDetailsNode) {
                    ProcessAreaContainerDetailsNode extended = (ProcessAreaContainerDetailsNode)node;
                    IProcessArea area = extended.getProcessArea();
                    cell.setImage(WorkResourceDetailsPart.this.fStandardLabelProvider.getImage((Object)area));
                    cell.setText(WorkResourceDetailsPart.this.fStandardLabelProvider.getText((Object)area));
                } else if (node instanceof DevelopmentLineDetailsNode) {
                    DevelopmentLineDetailsNode extended = (DevelopmentLineDetailsNode)node;
                    IDevelopmentLine line = extended.getDevelopmentLine();
                    cell.setImage(WorkResourceDetailsPart.this.fStandardLabelProvider.getImage((Object)line));
                    cell.setText(WorkResourceDetailsPart.this.fStandardLabelProvider.getText((Object)line));
                }
            } else if (index == 1) {
                int assignment = node.getAssignment();
                if (!node.isCustomized()) {
                    cell.setFont(this.getBoldFont());
                } else {
                    cell.setFont(this.getNormalFont());
                }
                if (assignment > 0) {
                    cell.setText(this.fNumberFormat.format((double)assignment / 100.0));
                } else if (assignment == 0) {
                    cell.setText(Messages.WorkResourceDetailsPart_NONE_LABEL);
                } else {
                    cell.setText(MessageFormat.format((String)Messages.WorkResourceDetailsPart_PRIORITY_PATTERN, (Object[])new Object[]{-assignment}));
                }
            }
        }
    }

    private final class WorkDetailsViewerComparator
    extends ViewerComparator {
        private WorkDetailsViewerComparator() {
        }

        public int category(Object element) {
            if (element instanceof AbstractResourceDetailsNode) {
                AbstractResourceDetailsNode node = (AbstractResourceDetailsNode)element;
                IAuditable auditable = node.getAuditable();
                if (auditable instanceof IProcessArea) {
                    return 1;
                }
                if (auditable instanceof IWorkResourceDetails) {
                    return 2;
                }
            }
            return super.category(element);
        }

        public int compare(Viewer viewer, Object first, Object second) {
            boolean up;
            int result = 0;
            TreeViewer extended = (TreeViewer)viewer;
            AbstractResourceDetailsNode firstNode = (AbstractResourceDetailsNode)first;
            AbstractResourceDetailsNode secondNode = (AbstractResourceDetailsNode)second;
            Tree tree = extended.getTree();
            TreeColumn column = tree.getSortColumn();
            boolean bl = up = tree.getSortDirection() == 128;
            if (column == WorkResourceDetailsPart.this.fResourceColumn) {
                result = Collator.getInstance().compare(firstNode.getName(), secondNode.getName());
            } else if (column == WorkResourceDetailsPart.this.fPercentageColumn) {
                int firstPercentage = firstNode.getAssignment();
                int secondPercentage = secondNode.getAssignment();
                result = firstPercentage - secondPercentage;
            }
            if (result != 0) {
                return up ? result : -1 * result;
            }
            return result;
        }
    }

    private final class WorkDetailsViewerContentProvider
    extends StructuredContentProvider
    implements ITreeContentProvider {
        private WorkDetailsViewerContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof AbstractResourceDetailsNode) {
                AbstractResourceDetailsNode node = (AbstractResourceDetailsNode)element;
                return node.getChildren();
            }
            return NO_CHILDREN;
        }

        public Object[] getElements(Object element) {
            if (element instanceof AbstractResourceDetailsNode[]) {
                return (Object[])element;
            }
            return NO_CHILDREN;
        }

        public Object getParent(Object element) {
            if (element instanceof AbstractResourceDetailsNode) {
                AbstractResourceDetailsNode node = (AbstractResourceDetailsNode)element;
                return node.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof AbstractResourceDetailsNode) {
                AbstractResourceDetailsNode node = (AbstractResourceDetailsNode)element;
                return node.hasChildren();
            }
            return false;
        }
    }
}

