/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.parts;

import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.ProgressInformation;
import com.ibm.team.apt.internal.common.duration.Progress;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_WorkItemProgress;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.resource.parts.Messages;
import com.ibm.team.apt.internal.ide.ui.resource.parts.WorkItemProgressBar;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ReferencesChangeDetails;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class WorkItemProgressPresentationPart
extends PresentationPart {
    private final WorkItemWorkingCopyListener fListener = new WorkItemWorkingCopyListener();
    private WorkItemProgressBar fProgressBar;
    private Composite fProgressComposite;
    private volatile DTO_WorkItemProgress fProgressData;
    private WorkItemWorkingCopy fWorkingCopy;

    private void addListeners() {
        if (this.fWorkingCopy != null) {
            IWorkItemClient client = PlanningClientPlugin.getWorkItemClient((ITeamRepository)this.fWorkingCopy.getTeamRepository());
            IWorkItemWorkingCopyManager manager = client.getWorkItemWorkingCopyManager();
            manager.addWorkItemListener((IWorkItemListener)this.fListener);
            manager.addWorkingCopyListener((IWorkingCopyListener)this.fListener);
        }
    }

    public void createContent(ITeamFormLayout formLayout) {
        Assert.isNotNull((Object)formLayout);
        FormToolkit toolkit = this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        Label label = toolkit.createLabel(parent, Messages.WorkItemProgressPresentationPart_DISPLAY_NAME);
        formLayout.add((Control)label, "label");
        this.fProgressComposite = toolkit.createComposite(parent);
        TeamFormLayouts.setLayoutData((Control)this.fProgressComposite, (ITeamFormData)ITeamFormData.SINGLE_LINE_GROW.addOffset(4, 0));
        formLayout.add((Control)this.fProgressComposite, "content");
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fProgressComposite.setLayout((Layout)layout);
        this.fProgressBar = new WorkItemProgressBar(this.fProgressComposite);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = data.minimumHeight = this.fProgressBar.getMinimalHeight();
        data.widthHint = data.minimumWidth = this.fProgressBar.getMinimalWidth();
        this.fProgressBar.setLayoutData(data);
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    private void refreshProgress() {
        Display display;
        IWorkItem handle = this.fWorkingCopy.getWorkItem();
        if (!this.fProgressBar.isDisposed() && !(display = this.fProgressBar.getDisplay()).isDisposed()) {
            display.syncExec(new Runnable(){

                public void run() {
                    WorkItemProgressPresentationPart.this.fProgressBar.setProgress(new ProgressInformation(), true);
                }
            });
        }
        final IterationPlanClient client = (IterationPlanClient)this.fWorkingCopy.getTeamRepository().getClientLibrary(IIterationPlanClient.class);
        UIUpdaterJob job = new UIUpdaterJob(Messages.WorkItemProgressPresentationPart_COMPUTING_WORK_PROGRESS_JOB_NAME, (IWorkItemHandle)handle){
            private final /* synthetic */ IWorkItemHandle val$handle;
            {
                this.val$handle = iWorkItemHandle;
                super($anonymous0);
            }

            public IStatus runInBackground(IProgressMonitor monitor) {
                try {
                    WorkItemProgressPresentationPart.this.fProgressData = client.fetchWorkItemProgress(this.val$handle, monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (ItemNotFoundException itemNotFoundException) {
                }
                catch (TeamRepositoryException exception) {
                    PlanningUIPlugin.log(exception);
                }
                return Status.OK_STATUS;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                WorkItemProgressPresentationPart.this.setProgress(WorkItemProgressPresentationPart.this.fProgressData);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void removeListeners() {
        if (this.fWorkingCopy != null) {
            IWorkItemClient client = PlanningClientPlugin.getWorkItemClient((ITeamRepository)this.fWorkingCopy.getTeamRepository());
            IWorkItemWorkingCopyManager manager = client.getWorkItemWorkingCopyManager();
            manager.removeWorkItemListener((IWorkItemListener)this.fListener);
            manager.removeWorkingCopyListener((IWorkingCopyListener)this.fListener);
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            WorkItemEditorInput extended = (WorkItemEditorInput)input;
            this.fWorkingCopy = extended.getWorkingCopy();
            this.addListeners();
            if (this.fWorkingCopy.getWorkItem().isNewItem()) {
                this.setProgress(null);
            } else {
                this.refreshProgress();
            }
        } else {
            this.fWorkingCopy = null;
            this.setProgress(null);
        }
    }

    private void setProgress(DTO_WorkItemProgress progress) {
        if (this.fProgressBar == null || this.fProgressBar.isDisposed()) {
            return;
        }
        if (progress != null) {
            this.fProgressBar.setProgress(Progress.create((DTO_WorkItemProgress)progress), false);
        } else {
            this.fProgressBar.setProgress(new ProgressInformation(), false);
        }
    }

    private final class WorkItemWorkingCopyListener
    implements IWorkingCopyListener,
    IWorkItemListener {
        private WorkItemWorkingCopyListener() {
        }

        public void workingCopyEvent(WorkingCopyEvent event) {
            Assert.isNotNull((Object)event);
            if (WorkItemProgressPresentationPart.this.fWorkingCopy != null && event.getSource().equals(WorkItemProgressPresentationPart.this.fWorkingCopy) && WorkItemProgressPresentationPart.this.fProgressBar != null && !WorkItemProgressPresentationPart.this.fProgressBar.isDisposed() && "reverted".equals(event.getType())) {
                WorkItemProgressPresentationPart.this.refreshProgress();
            }
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            ReferencesChangeDetails details;
            IAdaptable adaptable;
            Assert.isNotNull((Object)event);
            if (WorkItemProgressPresentationPart.this.fWorkingCopy != null && event.getWorkItem().sameItemId((IItemHandle)WorkItemProgressPresentationPart.this.fWorkingCopy.getWorkItem()) && event.affects("references") && WorkItemProgressPresentationPart.this.fProgressBar != null && !WorkItemProgressPresentationPart.this.fProgressBar.isDisposed() && (adaptable = event.getAttributeChangeDetails("references")) != null && (details = (ReferencesChangeDetails)adaptable.getAdapter(ReferencesChangeDetails.class)) != null) {
                boolean refresh = false;
                HashSet references = new HashSet(16);
                references.addAll(details.getAdded());
                references.addAll(details.getRemoved());
                for (IReference reference : references) {
                    IEndPointDescriptor descriptor = WorkItemLinkTypes.getEndPointDescriptor((IReference)reference);
                    if (!WorkItemEndPoints.PARENT_WORK_ITEM.equals(descriptor) && !WorkItemEndPoints.CHILD_WORK_ITEMS.equals(descriptor)) continue;
                    refresh = true;
                    break;
                }
                if (refresh) {
                    WorkItemProgressPresentationPart.this.refreshProgress();
                }
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }
}

