/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.parts;

import com.ibm.icu.text.MessageFormat;
import com.ibm.team.apt.internal.common.ProgressInformation;
import com.ibm.team.apt.internal.common.ProgressItem;
import com.ibm.team.apt.internal.common.duration.TimeUnit;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ProgressBarPainter;
import com.ibm.team.jface.DoubleBufferPainter;
import com.ibm.team.jface.tooltip.TooltipSupport;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class WorkItemProgressBar
extends Composite {
    private final Canvas fCanvas;
    private boolean fComputing = true;
    private final Label fEstimated;
    private final Label fHours;
    private int fMinHeight;
    private int fMinWidth;
    private final ProgressBarPainter fPainter;
    private ProgressInformation fProgress = new ProgressInformation();
    private final BarResources fResources = new BarResources((Control)this);

    public WorkItemProgressBar(Composite parent) {
        super(parent, 0);
        Color color = parent.getDisplay().getSystemColor(17);
        Font font = this.fResources.getMessageFont();
        this.fPainter = new ProgressBarPainter(this.fResources);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.fCanvas = new Canvas((Composite)this, 262144);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        data.heightHint = data.minimumHeight = this.fPainter.computeMinimalHeight();
        this.fCanvas.setLayoutData((Object)data);
        new DoubleBufferPainter(this.fCanvas){

            public void doPaint(PaintEvent event) {
                WorkItemProgressBar.this.fPainter.paint(event.gc, WorkItemProgressBar.this.fCanvas.getBounds(), ProgressItem.create((ProgressInformation)WorkItemProgressBar.this.fProgress, (boolean)WorkItemProgressBar.this.fComputing));
            }
        };
        this.fHours = new Label((Composite)this, 16384);
        this.fHours.setForeground(color);
        this.fHours.setFont(font);
        data = new GridData(128, 16384, true, true);
        data.horizontalSpan = 1;
        this.fHours.setLayoutData((Object)data);
        this.fEstimated = new Label((Composite)this, 131072);
        this.fEstimated.setForeground(color);
        this.fEstimated.setFont(font);
        data = new GridData(128, 131072, false, true);
        data.horizontalSpan = 1;
        this.fEstimated.setLayoutData((Object)data);
        new TooltipSupport((Control)this.fCanvas, true, false){

            public Object getElement(Control control, int x, int y) {
                return WorkItemProgressBar.this.fProgress;
            }
        };
        new TooltipSupport((Control)this.fHours, true, false){

            public Object getElement(Control control, int x, int y) {
                return WorkItemProgressBar.this.fProgress;
            }
        };
        new TooltipSupport((Control)this.fEstimated, true, false){

            public Object getElement(Control control, int x, int y) {
                return WorkItemProgressBar.this.fProgress;
            }
        };
        this.computeBounds(font);
    }

    private void computeBounds(Font font) {
        TextLayout layout = new TextLayout((Device)this.getDisplay());
        layout.setAscent(-1);
        layout.setDescent(-1);
        layout.setWidth(-1);
        layout.setAlignment(16384);
        layout.setFont(font);
        layout.setText(String.valueOf(MessageFormat.format((String)Messages.GProgressBar_HOURS_LABEL, (Object[])new Object[]{9999, 9999})) + " " + MessageFormat.format((String)Messages.GProgressBar_ESTIMATED_LABEL, (Object[])new Object[]{100}));
        this.fMinWidth = layout.getBounds().width;
        this.fMinHeight = layout.getBounds().height + this.fPainter.computeMinimalHeight();
        layout.dispose();
    }

    public int getMinimalHeight() {
        return this.fMinHeight;
    }

    public int getMinimalWidth() {
        return this.fMinWidth;
    }

    public void setProgress(ProgressInformation progress, boolean computing) {
        Assert.isNotNull((Object)progress);
        this.fProgress = progress;
        this.fComputing = computing;
        ProgressItem item = ProgressItem.create((ProgressInformation)progress, (boolean)computing);
        Long hoursDone = item.getWorkHoursDone(TimeUnit.HOURS);
        Long hoursTotal = item.getWorkHoursTotal(TimeUnit.HOURS);
        this.fHours.setText(MessageFormat.format((String)Messages.GProgressBar_HOURS_LABEL, (Object[])new Object[]{hoursDone, hoursTotal}));
        if (item.getKind() == ProgressItem.Kind.DONE) {
            this.fEstimated.setText(Messages.GProgressBar_ESTIMATED_DONE);
        } else {
            this.fEstimated.setText(MessageFormat.format((String)Messages.GProgressBar_ESTIMATED_LABEL, (Object[])new Object[]{Float.valueOf(item.getQualityOfPlanning())}));
        }
        this.layout(new Control[]{this.fHours, this.fEstimated});
        this.fCanvas.redraw();
        this.fCanvas.update();
    }
}

