/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.parts;

import com.ibm.team.apt.internal.client.DurationSupport;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.resource.IProcessAreaInfo;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningManager;
import com.ibm.team.apt.internal.client.util.WorkItems;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.resource.parts.Messages;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.DurationFormat;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.ide.ui.internal.editor.AbstractRequiredPropertiesUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedFormsText;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedText;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import com.ibm.team.workitem.rcp.ui.UIWorkItemWorkingCopyListener;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class WorkItemEstimateAttributePart
extends AttributePart {
    private static final Status INFO_STATUS = new Status(1, PlanningUIPlugin.getPluginId(), Messages.WorkItemEstimateAttributePart_ESTIMATE_HINT);
    private IAttribute fAttribute = null;
    private Label fCorrectionLabel;
    private ISchedulingRule fCorrectionRule;
    private DecoratedText fCorrectionTextField;
    private DurationSupport fDurationSupport;
    private volatile DurationFormat fDurationFormat = null;
    private RequiredPropertyLabel fEstimateLabel;
    private ISchedulingRule fEstimateRule;
    private DecoratedText fEstimateTextField;
    private final Object fFormatLock = new Object();
    private final Runnable fRequiredPropertiesRunnable = new Runnable(){

        public void run() {
            AbstractRequiredPropertiesUpdater updater = (AbstractRequiredPropertiesUpdater)WorkItemEstimateAttributePart.this.getSite().getAdapter(AbstractRequiredPropertiesUpdater.class);
            if (updater == null) {
                return;
            }
            WorkItemEstimateAttributePart.this.fEstimateLabel.setRequired(updater.isRequiredProperty(WorkItemEstimateAttributePart.this.getEstimateAttribute().getIdentifier()));
        }
    };
    private final AtomicInteger fUpdateToken = new AtomicInteger(0);
    private volatile WorkItemWorkingCopy fWorkingCopy;
    private final WorkItemListener fWorkItemListener = new WorkItemListener();

    private static final Duration getDuration(ResolvedWorkItem item, IAttribute attribute) {
        Long number = (Long)item.getValue(attribute);
        if (number != null) {
            return new Duration(number.longValue());
        }
        return Duration.UNSPECIFIED;
    }

    private static IStatus getIdleStatus(DecoratedText field) {
        Text text = field.getText();
        if (text.isFocusControl() && text.isEnabled()) {
            return INFO_STATUS;
        }
        return Status.OK_STATUS;
    }

    private static long getWorkYearMillis(DurationFormat format) {
        return 3600000L * (long)format.getHoursPerDay() * (long)format.getDaysPerWeek() * 52L;
    }

    private static Duration parseDuration(String text, String name, DurationFormat format) throws ParseException {
        if (text == null || text.length() == 0) {
            return Duration.UNSPECIFIED;
        }
        Duration duration = format.parse(text);
        if (duration.longValue() > WorkItemEstimateAttributePart.getWorkYearMillis(format)) {
            throw new ParseException(MessageFormat.format(Messages.WorkItemEstimateAttributePart_ONE_WORK_YEAR_HINT, name), 0);
        }
        return duration;
    }

    private static void syncExec(DecoratedText field, final Runnable runnable) {
        Display display;
        final Text text = field.getText();
        if (!text.isDisposed() && !(display = text.getDisplay()).isDisposed()) {
            display.syncExec(new Runnable(){

                public void run() {
                    if (!text.isDisposed()) {
                        runnable.run();
                    }
                }
            });
        }
    }

    private static void updateFocusStatus(DecoratedText field, boolean focus) {
        IStatus status = field.getStatus();
        if (!status.matches(4) && !status.matches(2)) {
            Text text = field.getText();
            if (focus && text.isEnabled()) {
                field.setStatus((IStatus)INFO_STATUS);
            } else {
                field.setStatus(Status.OK_STATUS);
            }
        }
    }

    private void addListeners() {
        AbstractRequiredPropertiesUpdater updater;
        UIWorkItemWorkingCopyListener copyListener;
        WorkItemUIWorkingCopy copy = this.getUIWorkingCopy();
        UIWorkItemListener listener = copy.getUIWorkItemListener();
        if (listener != null) {
            listener.addListener((IWorkItemListener)this.fWorkItemListener);
        }
        if ((copyListener = (UIWorkItemWorkingCopyListener)this.getSite().getAdapter(UIWorkItemWorkingCopyListener.class)) != null) {
            copyListener.addListener((IWorkingCopyListener)this.fWorkItemListener);
        }
        if ((updater = (AbstractRequiredPropertiesUpdater)this.getSite().getAdapter(AbstractRequiredPropertiesUpdater.class)) != null) {
            updater.addListener(this.fRequiredPropertiesRunnable);
        }
    }

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        this.fEstimateLabel = new RequiredPropertyLabel(parent, (FormToolkit)toolkit);
        this.fEstimateLabel.setText(MessageFormat.format(Messages.WorkItemEstimateAttributePart_DISPLAY_NAME_PATTERN, this.getEstimateAttribute().getDisplayName()));
        formLayout.add(this.fEstimateLabel.getLayoutControl(), "label");
        int styles = "carbon".equals(SWT.getPlatform()) ? 16384 : 131072;
        this.fEstimateTextField = new DecoratedFormsText(parent, this.getSite(), styles);
        Util.addNarrowWidthHint((Control)this.fEstimateTextField.getLayoutControl());
        formLayout.add(this.fEstimateTextField.getLayoutControl(), "content");
        this.fEstimateTextField.setStatus(WorkItemEstimateAttributePart.getIdleStatus(this.fEstimateTextField));
        this.fEstimateTextField.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                final ResolvedWorkItem resolved = WorkItemEstimateAttributePart.this.getUIWorkingCopy().getResolvedWorkItem();
                final IAttribute estimateAttribute = WorkItemEstimateAttributePart.this.getEstimateAttribute();
                final String estimateValue = WorkItemEstimateAttributePart.this.fEstimateTextField.getText().getText().trim();
                if (!Messages.WorkItemEstimateAttributePart_PENDING_LABEL.equals(estimateValue)) {
                    AttributePartUpdateJob job = new AttributePartUpdateJob(WorkItemEstimateAttributePart.this, Messages.WorkItemEstimateAttributePart_UPDATE_ESTIMATE_JOB_NAME){

                        protected IStatus doRunProtected(IProgressMonitor monitor) {
                            DurationFormat format = WorkItemEstimateAttributePart.this.getCachedDurationFormat();
                            if (format == null) {
                                format = WorkItemEstimateAttributePart.this.getDurationFormat(monitor);
                            }
                            WorkItemEstimateAttributePart.this.updateAttribute(this.getToken(), resolved, estimateAttribute, estimateValue, WorkItemEstimateAttributePart.this.fEstimateTextField, format, true);
                            return Status.OK_STATUS;
                        }
                    };
                    job.setPriority(10);
                    job.setRule(WorkItemEstimateAttributePart.this.fEstimateRule);
                    job.setSystem(true);
                    job.schedule();
                }
            }
        });
        this.fEstimateTextField.getText().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                WorkItemEstimateAttributePart.updateFocusStatus(WorkItemEstimateAttributePart.this.fEstimateTextField, true);
            }

            public void focusLost(FocusEvent event) {
                ResolvedWorkItem resolved = WorkItemEstimateAttributePart.this.getUIWorkingCopy().getResolvedWorkItem();
                IAttribute estimateAttribute = WorkItemEstimateAttributePart.this.getEstimateAttribute();
                String estimateValue = WorkItemEstimateAttributePart.this.fEstimateTextField.getText().getText().trim();
                WorkItemEstimateAttributePart.this.updateAttribute(WorkItemEstimateAttributePart.this.fUpdateToken.get(), resolved, estimateAttribute, estimateValue, WorkItemEstimateAttributePart.this.fEstimateTextField, WorkItemEstimateAttributePart.this.getCachedDurationFormat(), false);
                WorkItemEstimateAttributePart.updateFocusStatus(WorkItemEstimateAttributePart.this.fEstimateTextField, false);
            }
        });
        this.fCorrectionLabel = toolkit.createLabel(parent, MessageFormat.format(Messages.WorkItemEstimateAttributePart_DISPLAY_NAME_PATTERN, Messages.WorkItemEstimateAttributePart_CORRECTION_DISPLAY_NAME));
        formLayout.add((Control)this.fCorrectionLabel, "label2");
        this.fCorrectionTextField = new DecoratedFormsText(parent, this.getSite(), styles);
        Util.addNarrowWidthHint((Control)this.fCorrectionTextField.getLayoutControl());
        formLayout.add(this.fCorrectionTextField.getLayoutControl(), "content2");
        this.fCorrectionTextField.setStatus(WorkItemEstimateAttributePart.getIdleStatus(this.fCorrectionTextField));
        this.fCorrectionTextField.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                final ResolvedWorkItem resolved = WorkItemEstimateAttributePart.this.getUIWorkingCopy().getResolvedWorkItem();
                final IAttribute correctionAttribute = WorkItemEstimateAttributePart.this.getCorrectionAttribute();
                final String correctionValue = WorkItemEstimateAttributePart.this.fCorrectionTextField.getText().getText().trim();
                if (!Messages.WorkItemEstimateAttributePart_PENDING_LABEL.equals(correctionValue)) {
                    AttributePartUpdateJob job = new AttributePartUpdateJob(WorkItemEstimateAttributePart.this, Messages.WorkItemEstimateAttributePart_UPDATE_CORRECTION_JOB_NAME){

                        protected IStatus doRunProtected(IProgressMonitor monitor) {
                            DurationFormat format = WorkItemEstimateAttributePart.this.getCachedDurationFormat();
                            if (format == null) {
                                format = WorkItemEstimateAttributePart.this.getDurationFormat(monitor);
                            }
                            WorkItemEstimateAttributePart.this.updateAttribute(this.getToken(), resolved, correctionAttribute, correctionValue, WorkItemEstimateAttributePart.this.fCorrectionTextField, format, true);
                            this.runWithToken(WorkItemEstimateAttributePart.this.fEstimateTextField, new Runnable(){

                                public void run() {
                                    WorkItemEstimateAttributePart.this.fEstimateTextField.getText().setEnabled("".equals(correctionValue) || Messages.WorkItemEstimateAttributePart_PENDING_LABEL.equals(correctionValue));
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    };
                    job.setPriority(10);
                    job.setRule(WorkItemEstimateAttributePart.this.fCorrectionRule);
                    job.setSystem(true);
                    job.schedule();
                }
            }
        });
        this.fCorrectionTextField.getText().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                WorkItemEstimateAttributePart.updateFocusStatus(WorkItemEstimateAttributePart.this.fCorrectionTextField, true);
            }

            public void focusLost(FocusEvent event) {
                ResolvedWorkItem resolved = WorkItemEstimateAttributePart.this.getUIWorkingCopy().getResolvedWorkItem();
                IAttribute correctionAttribute = WorkItemEstimateAttributePart.this.getCorrectionAttribute();
                String correctionValue = WorkItemEstimateAttributePart.this.fCorrectionTextField.getText().getText().trim();
                WorkItemEstimateAttributePart.this.updateAttribute(WorkItemEstimateAttributePart.this.fUpdateToken.get(), resolved, correctionAttribute, correctionValue, WorkItemEstimateAttributePart.this.fCorrectionTextField, WorkItemEstimateAttributePart.this.getCachedDurationFormat(), false);
                WorkItemEstimateAttributePart.updateFocusStatus(WorkItemEstimateAttributePart.this.fCorrectionTextField, false);
            }
        });
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.getWorkingCopy());
    }

    private DurationFormat getCachedDurationFormat() {
        return this.fDurationFormat;
    }

    private IAttribute getCorrectionAttribute() {
        WorkItemWorkingCopy copy = this.getWorkingCopy();
        if (copy == null || this.fAttribute != null && copy.getWorkItem().getProjectArea().sameItemId((IItemHandle)this.fAttribute.getProjectArea())) {
            return this.fAttribute;
        }
        return this.getUIWorkingCopy().getResolvedWorkItem().findAttribute(WorkItemAttributes.CORRECTED_ESTIMATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DurationFormat getDurationFormat(IProgressMonitor monitor) {
        if (this.fDurationFormat == null) {
            Object object = this.fFormatLock;
            synchronized (object) {
                if (this.fDurationFormat == null) {
                    DurationFormat format = DurationFormat.getInstance((int)2);
                    WorkItemWorkingCopy copy = this.getWorkingCopy();
                    if (copy != null) {
                        try {
                            ResourcePlanningManager manager = PlanningClientPlugin.getResourcePlanningManager((ITeamRepository)copy.getTeamRepository());
                            IProcessAreaInfo info = manager.getProcessAreaInfo((IProcessAreaHandle)copy.getWorkItem().getProjectArea(), false, monitor);
                            if (info != null) {
                                int days = info.getWorkWeekDays();
                                if (days <= 0) {
                                    days = 5;
                                }
                                format.setDaysPerWeek(days);
                                int hours = info.getWorkDayHours();
                                if (hours <= 0) {
                                    hours = 8;
                                }
                                format.setHoursPerDay(hours);
                            }
                        }
                        catch (TeamRepositoryException exception) {
                            PlanningUIPlugin.log(exception);
                        }
                    }
                    this.fDurationFormat = format;
                }
            }
        }
        return this.fDurationFormat;
    }

    private IAttribute getEstimateAttribute() {
        return this.getAttribute();
    }

    private WorkItemUIWorkingCopy getUIWorkingCopy() {
        return (WorkItemUIWorkingCopy)this.getWorkingCopy().getAdapter(IWorkItemUIWorkingCopy.class);
    }

    private WorkItemWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    private boolean isProcessAreaInfoCached() {
        WorkItemWorkingCopy copy = this.getWorkingCopy();
        ResourcePlanningManager manager = PlanningClientPlugin.getResourcePlanningManager((ITeamRepository)copy.getTeamRepository());
        return manager.findCachedProcessAreaInfo((IProcessAreaHandle)copy.getWorkItem().getProjectArea()) != null;
    }

    private void removeListeners() {
        WorkItemUIWorkingCopy uiCopy;
        UIWorkItemListener listener;
        WorkItemWorkingCopy copy = this.getWorkingCopy();
        if (copy != null && (listener = (uiCopy = (WorkItemUIWorkingCopy)copy.getAdapter(IWorkItemUIWorkingCopy.class)).getUIWorkItemListener()) != null) {
            listener.removeListener((IWorkItemListener)this.fWorkItemListener);
        }
        if (this.getSite() != null) {
            AbstractRequiredPropertiesUpdater updater;
            UIWorkItemWorkingCopyListener copyListener = (UIWorkItemWorkingCopyListener)this.getSite().getAdapter(UIWorkItemWorkingCopyListener.class);
            if (copyListener != null) {
                copyListener.removeListener((IWorkingCopyListener)this.fWorkItemListener);
            }
            if ((updater = (AbstractRequiredPropertiesUpdater)this.getSite().getAdapter(AbstractRequiredPropertiesUpdater.class)) != null) {
                updater.removeListener(this.fRequiredPropertiesRunnable);
            }
        }
    }

    public void setFocus() {
        this.fCorrectionTextField.getText().setFocus();
    }

    public void setInput(Object input) {
        this.fUpdateToken.getAndIncrement();
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            WorkItemEditorInput extended = (WorkItemEditorInput)input;
            this.fWorkingCopy = extended.getWorkingCopy();
            this.fEstimateRule = new ExclusiveSchedulingRule(this.getEstimateAttribute());
            this.fCorrectionRule = new ExclusiveSchedulingRule(this.getCorrectionAttribute());
            this.addListeners();
            Text text = this.fEstimateTextField.getText();
            DurationFormat cached = this.getCachedDurationFormat();
            boolean refreshInfo = !this.isProcessAreaInfoCached();
            ResolvedWorkItem resolved = this.getUIWorkingCopy().getResolvedWorkItem();
            if (cached == null && WorkItemEstimateAttributePart.getDuration(resolved, this.getEstimateAttribute()).longValue() >= 0L && refreshInfo) {
                text.setEnabled(false);
                text.setText(Messages.WorkItemEstimateAttributePart_PENDING_LABEL);
            }
            text = this.fCorrectionTextField.getText();
            if (cached == null && WorkItemEstimateAttributePart.getDuration(resolved, this.getCorrectionAttribute()).longValue() >= 0L && refreshInfo) {
                text.setEnabled(false);
                text.setText(Messages.WorkItemEstimateAttributePart_PENDING_LABEL);
            }
            this.updateEstimateField();
            this.updateCorrectionField();
            this.fRequiredPropertiesRunnable.run();
        } else {
            this.fEstimateRule = null;
            this.fCorrectionRule = null;
            this.fWorkingCopy = null;
        }
    }

    private void updateAttribute(final int token, ResolvedWorkItem item, IAttribute attribute, String value, final DecoratedText field, DurationFormat format, final boolean dirtyOnly) {
        block12: {
            Duration duration = Duration.INVALID;
            try {
                try {
                    duration = WorkItemEstimateAttributePart.parseDuration(value, attribute.getDisplayName(), format);
                    long number = duration.longValue();
                    if (number >= 0L && number % 1000L != 0L) {
                        throw new ParseException(MessageFormat.format(Messages.WorkItemEstimateAttributePart_NO_MILLISECONDS_HINT, attribute.getDisplayName()), 0);
                    }
                    Duration finalDuration = duration;
                    DurationFormat finalFormat = format;
                    WorkItemEstimateAttributePart.syncExec(field, new Runnable((Format)finalFormat, finalDuration, value, field){
                        private final /* synthetic */ Format val$finalFormat;
                        private final /* synthetic */ Duration val$finalDuration;
                        private final /* synthetic */ String val$value;
                        private final /* synthetic */ DecoratedText val$field;
                        {
                            this.val$finalFormat = format;
                            this.val$finalDuration = duration;
                            this.val$value = string;
                            this.val$field = decoratedText;
                        }

                        public void run() {
                            if (token == WorkItemEstimateAttributePart.this.fUpdateToken.get()) {
                                String formatted;
                                if (!dirtyOnly && !this.val$value.equals(formatted = this.val$finalFormat.format(this.val$finalDuration))) {
                                    this.val$field.setValue(formatted);
                                }
                                this.val$field.setStatus(WorkItemEstimateAttributePart.getIdleStatus(this.val$field));
                            }
                        }
                    });
                }
                catch (ParseException exception) {
                    WorkItemWorkingCopy copy;
                    Duration predecessor;
                    WorkItemEstimateAttributePart.syncExec(field, new Runnable(){

                        public void run() {
                            if (token == WorkItemEstimateAttributePart.this.fUpdateToken.get()) {
                                field.setStatus((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), exception.getLocalizedMessage()));
                            }
                        }
                    });
                    if (token != this.fUpdateToken.get() || duration.equals((Object)(predecessor = WorkItemEstimateAttributePart.getDuration(item, attribute))) || (copy = this.getWorkingCopy()) == null) break block12;
                    if (dirtyOnly) {
                        if (!Duration.INVALID.equals((Object)predecessor)) {
                            ((WorkItemWorkingCopyImpl)copy).setDirty(true);
                        }
                        break block12;
                    }
                    this.fDurationSupport.setCurrentEstimate(item.getWorkItem(), attribute.sameItemId((IItemHandle)this.getCorrectionAttribute()), WorkItems.isResolved((IWorkItem)item.getWorkItem(), (IWorkflowInfo)item.getWorkflowInfo()), duration.longValue());
                }
            }
            finally {
                WorkItemWorkingCopy copy;
                Duration predecessor;
                if (token == this.fUpdateToken.get() && !duration.equals((Object)(predecessor = WorkItemEstimateAttributePart.getDuration(item, attribute))) && (copy = this.getWorkingCopy()) != null) {
                    if (dirtyOnly) {
                        if (!Duration.INVALID.equals((Object)predecessor)) {
                            ((WorkItemWorkingCopyImpl)copy).setDirty(true);
                        }
                    } else {
                        this.fDurationSupport.setCurrentEstimate(item.getWorkItem(), attribute.sameItemId((IItemHandle)this.getCorrectionAttribute()), WorkItems.isResolved((IWorkItem)item.getWorkItem(), (IWorkflowInfo)item.getWorkflowInfo()), duration.longValue());
                    }
                }
            }
        }
    }

    private void updateCorrectionField() {
        final ResolvedWorkItem resolved = this.getUIWorkingCopy().getResolvedWorkItem();
        final IAttribute correctionAttribute = this.getCorrectionAttribute();
        final String correctionValue = this.fCorrectionTextField.getText().getText().trim();
        AttributePartUpdateJob job = new AttributePartUpdateJob(Messages.WorkItemEstimateAttributePart_UPDATE_CORRECTION_FIELD_JOB_NAME){

            protected IStatus doRunProtected(IProgressMonitor monitor) {
                DurationFormat format = WorkItemEstimateAttributePart.this.getCachedDurationFormat();
                if (format == null) {
                    format = WorkItemEstimateAttributePart.this.getDurationFormat(monitor);
                }
                WorkItemEstimateAttributePart.this.updateTextField(this, resolved, correctionAttribute, correctionValue, WorkItemEstimateAttributePart.this.fCorrectionTextField, format, true);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setRule(this.fCorrectionRule);
        job.setSystem(true);
        job.schedule();
    }

    private void updateEstimateField() {
        final ResolvedWorkItem resolved = this.getUIWorkingCopy().getResolvedWorkItem();
        final IAttribute estimateAttribute = this.getEstimateAttribute();
        final IAttribute correctionAttribute = this.getCorrectionAttribute();
        final String estimateValue = this.fEstimateTextField.getText().getText().trim();
        AttributePartUpdateJob job = new AttributePartUpdateJob(Messages.WorkItemEstimateAttributePart_UPDATE_ESTIMATE_FIELD_JOB_NAME){

            protected IStatus doRunProtected(IProgressMonitor monitor) {
                DurationFormat format = WorkItemEstimateAttributePart.this.getCachedDurationFormat();
                if (format == null) {
                    format = WorkItemEstimateAttributePart.this.getDurationFormat(monitor);
                }
                Duration duration = WorkItemEstimateAttributePart.getDuration(resolved, correctionAttribute);
                WorkItemEstimateAttributePart.this.updateTextField(this, resolved, estimateAttribute, estimateValue, WorkItemEstimateAttributePart.this.fEstimateTextField, format, Duration.UNSPECIFIED.equals((Object)duration));
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setRule(this.fEstimateRule);
        job.setSystem(true);
        job.schedule();
    }

    private void updateTextField(AttributePartUpdateJob job, ResolvedWorkItem item, IAttribute attribute, String value, final DecoratedText field, DurationFormat format, final boolean enabled) {
        block3: {
            Duration duration = WorkItemEstimateAttributePart.getDuration(item, attribute);
            try {
                if (!duration.equals((Object)WorkItemEstimateAttributePart.parseDuration(value, attribute.getDisplayName(), format))) {
                    final String formatted = format.format(duration);
                    job.runWithToken(field, new Runnable(){

                        public void run() {
                            Text text = field.getText();
                            text.setText(formatted);
                            text.setEnabled(enabled);
                        }
                    });
                }
            }
            catch (ParseException parseException) {
                if (!duration.isValid()) break block3;
                final String formatted = format.format(duration);
                job.runWithToken(field, new Runnable(){

                    public void run() {
                        Text text = field.getText();
                        text.setText(formatted);
                        text.setEnabled(enabled);
                    }
                });
            }
        }
    }

    private abstract class AttributePartUpdateJob
    extends FoundationJob {
        private final int fToken;

        AttributePartUpdateJob(String name) {
            super(name);
            this.fToken = WorkItemEstimateAttributePart.this.fUpdateToken.get();
        }

        protected abstract IStatus doRunProtected(IProgressMonitor var1) throws Exception;

        protected final int getToken() {
            return this.fToken;
        }

        protected final IStatus runProtected(IProgressMonitor monitor) throws Exception {
            if (WorkItemEstimateAttributePart.this.fDurationSupport == null) {
                IWorkItem workItem = WorkItemEstimateAttributePart.this.getWorkingCopy().getWorkItem();
                WorkItemEstimateAttributePart.this.fDurationSupport = DurationSupport.FACTORY.getInstance((IProcessAreaHandle)workItem.getProjectArea(), monitor);
            }
            if (WorkItemEstimateAttributePart.this.fDurationSupport == null) {
                return Status.CANCEL_STATUS;
            }
            if (this.fToken == WorkItemEstimateAttributePart.this.fUpdateToken.get()) {
                return this.doRunProtected(monitor);
            }
            return Status.OK_STATUS;
        }

        protected final void runWithToken(DecoratedText field, final Runnable runnable) {
            Assert.isNotNull((Object)runnable);
            WorkItemEstimateAttributePart.syncExec(field, new Runnable(){

                public void run() {
                    if (AttributePartUpdateJob.this.fToken == WorkItemEstimateAttributePart.this.fUpdateToken.get()) {
                        runnable.run();
                    }
                }
            });
        }

        protected final void runWithToken(Runnable runnable) {
            Assert.isNotNull((Object)runnable);
            if (this.fToken == WorkItemEstimateAttributePart.this.fUpdateToken.get()) {
                runnable.run();
            }
        }
    }

    private static final class ExclusiveSchedulingRule
    implements ISchedulingRule {
        private final IAttribute fAttribute;

        ExclusiveSchedulingRule(IAttribute attribute) {
            this.fAttribute = attribute;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof ExclusiveSchedulingRule) {
                ExclusiveSchedulingRule extended = (ExclusiveSchedulingRule)rule;
                return extended.fAttribute.sameItemId((IItemHandle)this.fAttribute);
            }
            return false;
        }
    }

    private final class WorkItemListener
    implements IWorkItemListener,
    IWorkingCopyListener {
        private WorkItemListener() {
        }

        private void updateField(DecoratedText field, IReportInfo info) {
            if (info != null && info.getSeverity() == 4) {
                field.setStatus((IStatus)new Status(info.getSeverity(), "com.ibm.team.workitem.ide.ui", info.getSummary()));
            }
        }

        public void workingCopyEvent(WorkingCopyEvent event) {
            if ((event.hasType("saved") || event.hasType("saveCanceled")) && event.getStatus() != null) {
                Map properties = Util.findMissingProperties((WorkingCopyEvent)event);
                this.updateField(WorkItemEstimateAttributePart.this.fEstimateTextField, (IReportInfo)properties.get(WorkItemEstimateAttributePart.this.getEstimateAttribute().getIdentifier()));
                this.updateField(WorkItemEstimateAttributePart.this.fCorrectionTextField, (IReportInfo)properties.get(WorkItemEstimateAttributePart.this.getCorrectionAttribute().getIdentifier()));
            }
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            WorkItemWorkingCopy copy = WorkItemEstimateAttributePart.this.getWorkingCopy();
            if (copy == null) {
                return;
            }
            if (!event.affects((IWorkItemHandle)copy.getWorkItem())) {
                return;
            }
            if (event.affects(WorkItemEstimateAttributePart.this.getEstimateAttribute().getIdentifier())) {
                WorkItemEstimateAttributePart.this.updateEstimateField();
            } else if (event.affects(WorkItemEstimateAttributePart.this.getCorrectionAttribute().getIdentifier())) {
                WorkItemEstimateAttributePart.this.updateCorrectionField();
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }
}

