/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.parts;

import com.ibm.team.apt.internal.client.DurationSupport;
import com.ibm.team.apt.internal.client.EstimateMode;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.resource.IProcessAreaInfo;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningManager;
import com.ibm.team.apt.internal.client.util.WorkItems;
import com.ibm.team.apt.internal.common.duration.PlanDuration;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.resource.parts.Messages;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.DurationFormat;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedControl;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedFormsText;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedText;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import com.ibm.team.workitem.rcp.ui.UIWorkItemWorkingCopyListener;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public final class WorkItemDurationAttributePart
extends AttributePart {
    private static final ISchedulingRule EXCLUSIVE_SCHEDULING_RULE = new ExclusiveSchedulingRule();
    private static final MessageMutableStatus INFO_STATUS = new MessageMutableStatus(1, PlanningUIPlugin.getPluginId(), Messages.WorkItemDurationAttributePart_DURATION_HINT);
    private static final int STATUS_CODE_PARSE_ERROR = 4;
    private DurationSupport fDurationSupport;
    private volatile DurationFormat fDurationFormat = null;
    private Label fDurationLabel;
    private DecoratedText fDurationTextField;
    private final Object fFormatLock = new Object();
    private final AtomicInteger fUpdateToken = new AtomicInteger(0);
    private volatile WorkItemWorkingCopy fWorkingCopy;
    private final WorkItemListener fWorkItemListener = new WorkItemListener();

    private PlanDuration getPlanDuration() {
        ResolvedWorkItem item = this.getUIWorkingCopy().getResolvedWorkItem();
        WorkItem workItem = (WorkItem)item.getWorkItem();
        IWorkflowInfo info = item.getWorkflowInfo();
        PlanDuration duration = new PlanDuration(workItem.getDuration(), workItem.getCorrectedEstimate(), workItem.getTimeSpent(), WorkItems.isResolved((IWorkItem)workItem, (IWorkflowInfo)info));
        return duration;
    }

    private Duration getDuration() {
        PlanDuration duration = this.getPlanDuration();
        return this.isMode(EstimateMode.TimeRemaining) ? new Duration(duration.getTimeRemaining()) : new Duration(duration.getTimeSpent());
    }

    private IStatus validate() {
        if (!this.isMode(EstimateMode.TimeRemaining)) {
            return Status.OK_STATUS;
        }
        PlanDuration duration = this.getPlanDuration();
        Object status = PlanDuration.isEncodedTimeRemaining((long)duration.getTimeSpent()) ? DurationSupport.TIME_REMAINING_EXCEEDS_ESTIMATE : (duration.getCurrentEstimate() < duration.getTimeSpent() ? new Status(2, DurationSupport.TIME_REMAINING_EXCEEDS_ESTIMATE.getPlugin(), DurationSupport.TIME_REMAINING_EXCEEDS_ESTIMATE.getMessage()) : Status.OK_STATUS);
        return status;
    }

    private static void updateInfoStatus(EstimateMode mode) {
        if (mode == EstimateMode.TimeRemaining) {
            INFO_STATUS.setMessage(Messages.WorkItemDurationAttributePart_DURATION_HINT_TIME_REMAINING);
        } else if (mode == EstimateMode.TimeSpent) {
            INFO_STATUS.setMessage(Messages.WorkItemDurationAttributePart_DURATION_HINT_TIME_SPENT);
        } else {
            INFO_STATUS.setMessage(Messages.WorkItemDurationAttributePart_DURATION_HINT);
        }
    }

    private static IStatus getIdleStatus(DecoratedText field) {
        IStatus status = field.getStatus();
        if (status.matches(6)) {
            return status;
        }
        Text text = field.getText();
        if (text.isFocusControl() && text.isEnabled()) {
            return INFO_STATUS;
        }
        return Status.OK_STATUS;
    }

    private static long getWorkYearMillis(DurationFormat format) {
        return 3600000L * (long)format.getHoursPerDay() * (long)format.getDaysPerWeek() * 52L;
    }

    private static void syncExec(DecoratedText field, final Runnable runnable) {
        Display display;
        final Text text = field.getText();
        if (!text.isDisposed() && !(display = text.getDisplay()).isDisposed()) {
            display.syncExec(new Runnable(){

                public void run() {
                    if (!text.isDisposed()) {
                        runnable.run();
                    }
                }
            });
        }
    }

    private static void updateFocusStatus(DecoratedText field, boolean focus) {
        IStatus status = field.getStatus();
        if (!status.matches(4) && !status.matches(2)) {
            Text text = field.getText();
            if (focus && text.isEnabled()) {
                field.setStatus((IStatus)INFO_STATUS);
            } else {
                field.setStatus(Status.OK_STATUS);
            }
        }
    }

    private void addListeners() {
        UIWorkItemWorkingCopyListener copyListener;
        WorkItemUIWorkingCopy copy = this.getUIWorkingCopy();
        UIWorkItemListener listener = copy.getUIWorkItemListener();
        if (listener != null) {
            listener.addListener((IWorkItemListener)this.fWorkItemListener, this.getAttribute().getIdentifier());
            listener.addListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.DURATION_PROPERTY);
            listener.addListener((IWorkItemListener)this.fWorkItemListener, WorkItem.CORRECTED_ESTIMATE_PROPERTY);
        }
        if ((copyListener = (UIWorkItemWorkingCopyListener)this.getSite().getAdapter(UIWorkItemWorkingCopyListener.class)) != null) {
            copyListener.addListener((IWorkingCopyListener)this.fWorkItemListener);
        }
    }

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemDurationAttributePart.updateInfoStatus(null);
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        this.fDurationLabel = toolkit.createLabel(parent, "");
        if (this.fDurationSupport == null && this.getAttribute() != null) {
            this.fDurationSupport = DurationSupport.FACTORY.getInstance((IProcessAreaHandle)this.getAttribute().getProjectArea());
        }
        String label = Messages.WorkItemDurationAttributePart_LABEL_TIME;
        if (this.fDurationSupport != null) {
            EstimateMode mode = this.fDurationSupport.getEstimateMode();
            label = mode.getDisplayName();
            WorkItemDurationAttributePart.updateInfoStatus(mode);
        } else {
            int maxWidth = 0;
            GC gc = new GC((Drawable)this.fDurationLabel);
            EstimateMode[] estimateModeArray = EstimateMode.values();
            int n = estimateModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                EstimateMode mode = estimateModeArray[n2];
                String name = MessageFormat.format(Messages.WorkItemDurationAttributePart_DISPLAY_NAME_PATTERN, mode.getDisplayName());
                maxWidth = Math.max(maxWidth, gc.stringExtent((String)name).x);
                ++n2;
            }
            gc.dispose();
            ITeamFormData data = TeamFormLayouts.getLayoutData((Control)this.fDurationLabel);
            if (data == null) {
                data = ITeamFormData.LABEL;
            }
            TeamFormLayouts.setLayoutData((Control)this.fDurationLabel, (ITeamFormData)data.setWidthHint(maxWidth));
        }
        this.fDurationLabel.setText(MessageFormat.format(Messages.WorkItemDurationAttributePart_DISPLAY_NAME_PATTERN, label));
        formLayout.add((Control)this.fDurationLabel, "label");
        this.fDurationTextField = new DecoratedFormsText(parent, this.getSite(), "carbon".equals(SWT.getPlatform()) ? 16384 : 131072);
        Util.addWidthHint((Control)this.fDurationTextField.getLayoutControl());
        formLayout.add(this.fDurationTextField.getLayoutControl(), "content");
        this.fDurationTextField.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                WorkItemDurationAttributePart.this.updateAttribute(true);
            }
        });
        this.fDurationTextField.getText().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                WorkItemDurationAttributePart.updateFocusStatus(WorkItemDurationAttributePart.this.fDurationTextField, true);
            }

            public void focusLost(FocusEvent event) {
                WorkItemDurationAttributePart.this.updateAttribute(false);
                WorkItemDurationAttributePart.updateFocusStatus(WorkItemDurationAttributePart.this.fDurationTextField, false);
            }
        });
        this.fDurationTextField.setStatus(WorkItemDurationAttributePart.getIdleStatus(this.fDurationTextField));
    }

    public void dispose() {
        this.fUpdateToken.set(-1);
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.getWorkingCopy());
    }

    private DurationFormat getCachedDurationFormat() {
        return this.fDurationFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DurationFormat getDurationFormat(IProgressMonitor monitor) {
        if (this.fDurationFormat == null) {
            Object object = this.fFormatLock;
            synchronized (object) {
                if (this.fDurationFormat == null) {
                    DurationFormat format = DurationFormat.getInstance((int)2);
                    WorkItemWorkingCopy copy = this.getWorkingCopy();
                    if (copy != null) {
                        try {
                            ResourcePlanningManager manager = PlanningClientPlugin.getResourcePlanningManager((ITeamRepository)copy.getTeamRepository());
                            IProcessAreaInfo info = manager.getProcessAreaInfo((IProcessAreaHandle)copy.getWorkItem().getProjectArea(), false, monitor);
                            if (info != null) {
                                int days = info.getWorkWeekDays();
                                if (days <= 0) {
                                    days = 5;
                                }
                                format.setDaysPerWeek(days);
                                int hours = info.getWorkDayHours();
                                if (hours <= 0) {
                                    hours = 8;
                                }
                                format.setHoursPerDay(hours);
                            }
                        }
                        catch (TeamRepositoryException exception) {
                            PlanningUIPlugin.log(exception);
                        }
                    }
                    this.fDurationFormat = format;
                }
            }
        }
        return this.fDurationFormat;
    }

    private WorkItemUIWorkingCopy getUIWorkingCopy() {
        return (WorkItemUIWorkingCopy)this.getWorkingCopy().getAdapter(IWorkItemUIWorkingCopy.class);
    }

    private WorkItemWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    private boolean isMode(EstimateMode mode) {
        return this.fDurationSupport.getEstimateMode() == mode;
    }

    private boolean isProcessAreaInfoCached() {
        WorkItemWorkingCopy copy = this.getWorkingCopy();
        ResourcePlanningManager manager = PlanningClientPlugin.getResourcePlanningManager((ITeamRepository)copy.getTeamRepository());
        return manager.findCachedProcessAreaInfo((IProcessAreaHandle)copy.getWorkItem().getProjectArea()) != null;
    }

    private Duration parseDuration(String text, DurationFormat format) throws ParseException {
        if (text == null || text.length() == 0) {
            return Duration.UNSPECIFIED;
        }
        Duration duration = format.parse(text);
        if (duration.longValue() > WorkItemDurationAttributePart.getWorkYearMillis(format)) {
            throw new ParseException(MessageFormat.format(Messages.WorkItemDurationAttributePart_ONE_WORK_YEAR_HINT, this.getAttribute().getDisplayName()), 0);
        }
        return duration;
    }

    private void removeListeners() {
        UIWorkItemWorkingCopyListener copyListener;
        WorkItemUIWorkingCopy uiCopy;
        UIWorkItemListener listener;
        WorkItemWorkingCopy copy = this.getWorkingCopy();
        if (copy != null && (listener = (uiCopy = this.getUIWorkingCopy()).getUIWorkItemListener()) != null) {
            listener.removeListener((IWorkItemListener)this.fWorkItemListener, this.getAttribute().getIdentifier());
            listener.removeListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.DURATION_PROPERTY);
            listener.removeListener((IWorkItemListener)this.fWorkItemListener, WorkItem.CORRECTED_ESTIMATE_PROPERTY);
        }
        if (this.getSite() != null && (copyListener = (UIWorkItemWorkingCopyListener)this.getSite().getAdapter(UIWorkItemWorkingCopyListener.class)) != null) {
            copyListener.removeListener((IWorkingCopyListener)this.fWorkItemListener);
        }
    }

    public void setFocus() {
        this.fDurationTextField.getText().setFocus();
    }

    public void setInput(Object input) {
        this.fUpdateToken.getAndIncrement();
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved() && this.getAttribute() != null) {
            WorkItemEditorInput extended = (WorkItemEditorInput)input;
            this.fWorkingCopy = extended.getWorkingCopy();
            this.addListeners();
            Text text = this.fDurationTextField.getText();
            DurationFormat cached = this.getCachedDurationFormat();
            boolean refreshInfo = !this.isProcessAreaInfoCached();
            PlanDuration duration = this.getPlanDuration();
            if (cached == null && (duration.hasTimeSpent() || duration.hasTimeRemaining()) && refreshInfo) {
                text.setEnabled(false);
                text.setText(Messages.WorkItemDurationAttributePart_PENDING_LABEL);
            }
            this.updateTextField();
        } else {
            this.fWorkingCopy = null;
        }
    }

    private void updateAttribute(final boolean dirtyOnly) {
        final ResolvedWorkItem resolved = this.getUIWorkingCopy().getResolvedWorkItem();
        final String trimmed = this.fDurationTextField.getText().getText().trim();
        if (!Messages.WorkItemDurationAttributePart_PENDING_LABEL.equals(trimmed)) {
            AttributePartUpdateJob job = new AttributePartUpdateJob(Messages.WorkItemDurationAttributePart_UPDATE_DURATION_JOB_NAME){

                protected IStatus doRunProtected(IProgressMonitor monitor) {
                    block7: {
                        DurationFormat format = WorkItemDurationAttributePart.this.getCachedDurationFormat();
                        if (format == null) {
                            format = WorkItemDurationAttributePart.this.getDurationFormat(monitor);
                        }
                        Duration duration = Duration.INVALID;
                        try {
                            try {
                                duration = WorkItemDurationAttributePart.this.parseDuration(trimmed, format);
                                long number = duration.longValue();
                                if (number >= 0L && number % 1000L != 0L) {
                                    throw new ParseException(MessageFormat.format(Messages.WorkItemEstimateAttributePart_NO_MILLISECONDS_HINT, WorkItemDurationAttributePart.this.getAttribute().getDisplayName()), 0);
                                }
                                Duration finalDuration = duration;
                                DurationFormat finalFormat = format;
                                this.runWithToken(WorkItemDurationAttributePart.this.fDurationTextField, new Runnable((Format)finalFormat, finalDuration, trimmed){
                                    private final /* synthetic */ Format val$finalFormat;
                                    private final /* synthetic */ Duration val$finalDuration;
                                    private final /* synthetic */ String val$trimmed;
                                    {
                                        this.val$finalFormat = format;
                                        this.val$finalDuration = duration;
                                        this.val$trimmed = string;
                                    }

                                    public void run() {
                                        IStatus currentStatus;
                                        String formatted;
                                        if (!dirtyOnly && !this.val$trimmed.equals(formatted = this.val$finalFormat.format(this.val$finalDuration))) {
                                            WorkItemDurationAttributePart.this.fDurationTextField.setValue(formatted);
                                        }
                                        if ((currentStatus = WorkItemDurationAttributePart.this.fDurationTextField.getStatus()).getCode() == 4) {
                                            WorkItemDurationAttributePart.this.fDurationTextField.setStatus(Status.OK_STATUS);
                                        }
                                    }
                                });
                            }
                            catch (ParseException exception) {
                                this.runWithToken(WorkItemDurationAttributePart.this.fDurationTextField, new Runnable(){

                                    public void run() {
                                        WorkItemDurationAttributePart.this.fDurationTextField.setStatus((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), 4, exception.getLocalizedMessage(), (Throwable)exception));
                                    }
                                });
                                Duration finalDuration = duration;
                                this.runWithToken(new Runnable(finalDuration, dirtyOnly, resolved){
                                    private final /* synthetic */ Duration val$finalDuration;
                                    private final /* synthetic */ boolean val$dirtyOnly;
                                    private final /* synthetic */ ResolvedWorkItem val$resolved;
                                    {
                                        this.val$finalDuration = duration;
                                        this.val$dirtyOnly = bl;
                                        this.val$resolved = resolvedWorkItem;
                                    }

                                    public void run() {
                                        WorkItemWorkingCopy copy;
                                        Duration predecessor = WorkItemDurationAttributePart.this.getDuration();
                                        if (!this.val$finalDuration.equals((Object)predecessor) && (copy = WorkItemDurationAttributePart.this.getWorkingCopy()) != null) {
                                            if (this.val$dirtyOnly) {
                                                if (!Duration.INVALID.equals((Object)predecessor)) {
                                                    ((WorkItemWorkingCopyImpl)copy).setDirty(true);
                                                }
                                            } else {
                                                final IStatus status = WorkItemDurationAttributePart.this.fDurationSupport.setCurrentDuration(this.val$resolved.getWorkItem(), WorkItems.isResolved((IWorkItem)this.val$resolved.getWorkItem(), (IWorkflowInfo)this.val$resolved.getWorkflowInfo()), this.val$finalDuration.longValue());
                                                this.runWithToken(WorkItemDurationAttributePart.this.fDurationTextField, new Runnable(){

                                                    public void run() {
                                                        IStatus currentStatus = WorkItemDurationAttributePart.this.fDurationTextField.getStatus();
                                                        if (currentStatus.getCode() != 4) {
                                                            WorkItemDurationAttributePart.this.fDurationTextField.setStatus(status);
                                                        }
                                                    }
                                                });
                                            }
                                        }
                                    }
                                });
                                break block7;
                            }
                        }
                        catch (Throwable throwable) {
                            Duration finalDuration = duration;
                            this.runWithToken(new /* invalid duplicate definition of identical inner class */);
                            throw throwable;
                        }
                        Duration finalDuration = duration;
                        this.runWithToken(new /* invalid duplicate definition of identical inner class */);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(10);
            job.setRule(EXCLUSIVE_SCHEDULING_RULE);
            job.setSystem(true);
            job.schedule();
        }
    }

    private void updateTextField() {
        final String trimmed = this.fDurationTextField.getText().getText().trim();
        AttributePartUpdateJob job = new AttributePartUpdateJob(Messages.WorkItemDurationAttributePart_UPDATE_DURATION_JOB_NAME){

            protected IStatus doRunProtected(IProgressMonitor monitor) {
                block9: {
                    DurationFormat format = WorkItemDurationAttributePart.this.getCachedDurationFormat();
                    if (format == null) {
                        format = WorkItemDurationAttributePart.this.getDurationFormat(monitor);
                    }
                    PlanDuration planDuration = WorkItemDurationAttributePart.this.getPlanDuration();
                    Duration duration = WorkItemDurationAttributePart.this.isMode(EstimateMode.TimeRemaining) ? new Duration(planDuration.getTimeRemaining()) : new Duration(planDuration.getTimeSpent());
                    try {
                        try {
                            boolean invalidTimeSpent;
                            boolean bl = invalidTimeSpent = WorkItemDurationAttributePart.this.isMode(EstimateMode.TimeRemaining) && !duration.isValid() && planDuration.getCurrentEstimate() < planDuration.getTimeSpent();
                            if (invalidTimeSpent) {
                                duration = new Duration(planDuration.getTimeSpent());
                            }
                            if (!duration.equals((Object)WorkItemDurationAttributePart.this.parseDuration(trimmed, format))) {
                                final String formatted = format.format(duration);
                                this.runWithToken(WorkItemDurationAttributePart.this.fDurationTextField, new Runnable(){

                                    public void run() {
                                        Text text = WorkItemDurationAttributePart.this.fDurationTextField.getText();
                                        text.setText(formatted);
                                        text.setEnabled(true);
                                    }
                                });
                            }
                        }
                        catch (ParseException parseException) {
                            if (duration.isValid()) {
                                final String formatted = format.format(duration);
                                this.runWithToken(WorkItemDurationAttributePart.this.fDurationTextField, new Runnable(){

                                    public void run() {
                                        Text text = WorkItemDurationAttributePart.this.fDurationTextField.getText();
                                        text.setText(formatted);
                                        text.setEnabled(true);
                                    }
                                });
                            }
                            this.runWithToken(WorkItemDurationAttributePart.this.fDurationTextField, new Runnable(){

                                public void run() {
                                    IStatus currentStatus = WorkItemDurationAttributePart.this.fDurationTextField.getStatus();
                                    if (currentStatus.isOK()) {
                                        IStatus status = WorkItemDurationAttributePart.this.validate();
                                        WorkItemDurationAttributePart.this.fDurationTextField.setStatus(status);
                                    }
                                }
                            });
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        this.runWithToken(WorkItemDurationAttributePart.this.fDurationTextField, new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    this.runWithToken(WorkItemDurationAttributePart.this.fDurationTextField, new /* invalid duplicate definition of identical inner class */);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setRule(EXCLUSIVE_SCHEDULING_RULE);
        job.setSystem(true);
        job.schedule();
    }

    private abstract class AttributePartUpdateJob
    extends FoundationJob {
        private final int fToken;

        AttributePartUpdateJob(String name) {
            super(name);
            this.fToken = WorkItemDurationAttributePart.this.fUpdateToken.get();
        }

        protected abstract IStatus doRunProtected(IProgressMonitor var1) throws Exception;

        protected final IStatus runProtected(IProgressMonitor monitor) throws Exception {
            if (WorkItemDurationAttributePart.this.fDurationSupport == null) {
                IWorkItem workItem = WorkItemDurationAttributePart.this.getWorkingCopy().getWorkItem();
                WorkItemDurationAttributePart.this.fDurationSupport = DurationSupport.FACTORY.getInstance((IProcessAreaHandle)workItem.getProjectArea(), monitor);
                if (WorkItemDurationAttributePart.this.fDurationSupport != null) {
                    this.runWithToken(WorkItemDurationAttributePart.this.fDurationTextField, new Runnable(){

                        public void run() {
                            EstimateMode mode = WorkItemDurationAttributePart.this.fDurationSupport.getEstimateMode();
                            WorkItemDurationAttributePart.this.fDurationLabel.setText(MessageFormat.format(Messages.WorkItemDurationAttributePart_DISPLAY_NAME_PATTERN, mode.getDisplayName()));
                            WorkItemDurationAttributePart.updateInfoStatus(mode);
                        }
                    });
                } else {
                    return Status.CANCEL_STATUS;
                }
            }
            if (this.fToken == WorkItemDurationAttributePart.this.fUpdateToken.get()) {
                return this.doRunProtected(monitor);
            }
            return Status.OK_STATUS;
        }

        protected final void runWithToken(DecoratedText field, final Runnable runnable) {
            Assert.isNotNull((Object)runnable);
            WorkItemDurationAttributePart.syncExec(field, new Runnable(){

                public void run() {
                    if (AttributePartUpdateJob.this.fToken == WorkItemDurationAttributePart.this.fUpdateToken.get()) {
                        runnable.run();
                    }
                }
            });
        }

        protected final void runWithToken(Runnable runnable) {
            Assert.isNotNull((Object)runnable);
            if (this.fToken == WorkItemDurationAttributePart.this.fUpdateToken.get()) {
                runnable.run();
            }
        }
    }

    private static final class ExclusiveSchedulingRule
    implements ISchedulingRule {
        private ExclusiveSchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof ExclusiveSchedulingRule;
        }
    }

    private static final class MessageMutableStatus
    extends Status {
        public MessageMutableStatus(int severity, String pluginId, String message) {
            super(severity, pluginId, message);
        }

        public void setMessage(String message) {
            super.setMessage(message);
        }
    }

    private final class WorkItemListener
    implements IWorkItemListener,
    IWorkingCopyListener {
        private WorkItemListener() {
        }

        private void updateField(DecoratedControl field, IReportInfo info) {
            if (info != null && info.getSeverity() == 4) {
                field.setStatus((IStatus)new Status(info.getSeverity(), "com.ibm.team.workitem.ide.ui", info.getSummary()));
            }
        }

        public void workingCopyEvent(WorkingCopyEvent event) {
            if ((event.hasType("saved") || event.hasType("saveCanceled")) && event.getStatus() != null) {
                this.updateField((DecoratedControl)WorkItemDurationAttributePart.this.fDurationTextField, (IReportInfo)Util.findMissingProperties((WorkingCopyEvent)event).get(WorkItemDurationAttributePart.this.getAttribute().getIdentifier()));
            }
        }

        public synchronized void workItemAttributeChanged(WorkItemChangeEvent event) {
            WorkItemWorkingCopy copy = WorkItemDurationAttributePart.this.getWorkingCopy();
            if (copy == null) {
                return;
            }
            if (!event.affects((IWorkItemHandle)copy.getWorkItem())) {
                return;
            }
            if (event.affects(WorkItemDurationAttributePart.this.getAttribute().getIdentifier())) {
                WorkItemDurationAttributePart.this.updateTextField();
            }
            if (event.affects(IWorkItem.DURATION_PROPERTY) || event.affects(WorkItem.CORRECTED_ESTIMATE_PROPERTY)) {
                final IStatus status = WorkItemDurationAttributePart.this.validate();
                WorkItemDurationAttributePart.syncExec(WorkItemDurationAttributePart.this.fDurationTextField, new Runnable(){

                    public void run() {
                        WorkItemDurationAttributePart.this.fDurationTextField.setStatus(status);
                    }
                });
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }
}

