/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource;

import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.common.resource.IContributorAbsenceHandle;
import com.ibm.team.apt.common.resource.IContributorResourceDetails;
import com.ibm.team.apt.common.resource.IWorkLocationDefinition;
import com.ibm.team.apt.common.resource.IWorkResourceDetails;
import com.ibm.team.apt.common.resource.IWorkResourceDetailsHandle;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.resource.IContributorInfo;
import com.ibm.team.apt.internal.client.resource.OperationStatus;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningManager;
import com.ibm.team.apt.internal.common.resource.model.ContributorResourceDetails;
import com.ibm.team.apt.internal.common.resource.model.WorkLocationDefinition;
import com.ibm.team.apt.internal.common.resource.model.WorkResourceDetails;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.ide.ui.resource.AbstractContributorResourceInput;
import com.ibm.team.apt.internal.ide.ui.resource.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContributorResourceEditorInput
extends AbstractContributorResourceInput {
    private boolean fCheckedWritePermission = false;
    private final IContributor fContributor;
    private final ResourcePlanningManager fManager;
    private boolean fRefreshInfo = true;
    private IContributorResourceDetails fResourceDetailsWorkingCopy;
    private boolean fWritePermission = false;

    public ContributorResourceEditorInput(IContributor contributor) {
        Assert.isNotNull((Object)contributor);
        Assert.isLegal((boolean)(contributor.getOrigin() instanceof ITeamRepository), (String)Messages.ContributorResourceEditorInput_ORIGIN_MUST_BE_REPOSITORY);
        this.fContributor = contributor;
        this.fManager = PlanningClientPlugin.getResourcePlanningManager((IItemHandle)contributor);
    }

    @Override
    public synchronized boolean checkWritePermissions(IProgressMonitor monitor) {
        if (!this.fCheckedWritePermission) {
            this.fWritePermission = this.fManager.getResourcePlanningClient().checkWritePermissions((IContributorHandle)this.fContributor, monitor);
            this.fCheckedWritePermission = true;
        }
        return this.fWritePermission;
    }

    @Override
    public synchronized OperationStatus<IContributorAbsenceHandle> deleteAbsences(IContributorAbsenceHandle[] handles, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)handles);
        try {
            OperationStatus operationStatus = this.fManager.getResourcePlanningClient().deleteAbsences(handles, monitor);
            return operationStatus;
        }
        finally {
            this.fRefreshInfo = true;
        }
    }

    @Override
    public synchronized OperationStatus<IWorkResourceDetailsHandle> deleteWorkDetails(IWorkResourceDetailsHandle[] handles, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)handles);
        try {
            OperationStatus operationStatus = this.fManager.getResourcePlanningClient().deleteWorkDetails(handles, monitor);
            return operationStatus;
        }
        finally {
            this.fRefreshInfo = true;
        }
    }

    @Override
    public synchronized OperationStatus<IContributorAbsence> getAbsences(IProgressMonitor monitor) throws TeamRepositoryException {
        ItemCollection absences = this.fManager.getContributorInfo((IContributorHandle)this.fContributor, this.fRefreshInfo, monitor).getAbsences((IContributorHandle)this.fContributor);
        this.fRefreshInfo = false;
        return new OperationStatus((Object[])((IContributorAbsence[])absences.toArray((Object[])new IContributorAbsence[absences.size()])));
    }

    @Override
    public IContributor getContributor() {
        return this.fContributor;
    }

    public String getName() {
        return this.fContributor.getName();
    }

    public String getToolTipText() {
        return this.fContributor.getName();
    }

    @Override
    public synchronized OperationStatus<IWorkResourceDetails> getWorkDetails(IProgressMonitor monitor) throws TeamRepositoryException {
        ItemCollection details = this.fManager.getContributorInfo((IContributorHandle)this.fContributor, this.fRefreshInfo, monitor).getWorkDetails((IContributorHandle)this.fContributor);
        this.fRefreshInfo = false;
        return new OperationStatus((Object[])((IWorkResourceDetails[])details.toArray((Object[])new IWorkResourceDetails[details.size()])));
    }

    @Override
    public synchronized OperationStatus<IWorkLocationDefinition> getWorkLocation(IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkLocationDefinition definition = this.fManager.getContributorInfo((IContributorHandle)this.fContributor, this.fRefreshInfo, monitor).getWorkLocation((IContributorHandle)this.fContributor);
        this.fRefreshInfo = false;
        return new OperationStatus((Object[])new IWorkLocationDefinition[]{definition});
    }

    @Override
    public synchronized IWorkLocationDefinition getWorkLocationWorkingCopy(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fResourceDetailsWorkingCopy == null) {
            IContributorInfo info = this.fManager.getContributorInfo((IContributorHandle)this.fContributor, this.fRefreshInfo, monitor);
            this.fRefreshInfo = false;
            ContributorResourceDetails workingCopy = null;
            IContributorResourceDetails details = info.getContributorDetails((IContributorHandle)this.fContributor);
            if (details != null) {
                workingCopy = (ContributorResourceDetails)details.getWorkingCopy();
            } else {
                workingCopy = (ContributorResourceDetails)IContributorResourceDetails.ITEM_TYPE.createItem();
                workingCopy.setOwner((IContributorHandle)this.fContributor.getItemHandle());
                workingCopy.setWorkLocation(info.getWorkLocation((IContributorHandle)this.fContributor));
            }
            this.fResourceDetailsWorkingCopy = workingCopy;
        }
        return this.fResourceDetailsWorkingCopy.getWorkLocation();
    }

    @Override
    public synchronized OperationStatus<IContributorAbsence> saveAbsences(IContributorAbsence[] workingCopies, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)workingCopies);
        try {
            OperationStatus operationStatus = this.fManager.getResourcePlanningClient().saveAbsences(workingCopies, monitor);
            return operationStatus;
        }
        finally {
            this.fRefreshInfo = true;
        }
    }

    @Override
    public synchronized OperationStatus<IContributorResourceDetails> saveContributorDetails(IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)this.fResourceDetailsWorkingCopy);
        try {
            IContributorResourceDetails workingCopy = this.fResourceDetailsWorkingCopy;
            IWorkLocationDefinition location = workingCopy.getWorkLocation();
            if (location instanceof WorkLocationDefinition) {
                WorkLocationDefinition extended = (WorkLocationDefinition)location;
                extended.setCustomized(true);
                extended.setUniversal(false);
            }
            this.fResourceDetailsWorkingCopy = null;
            OperationStatus operationStatus = this.fManager.getResourcePlanningClient().saveContributorDetails(workingCopy, monitor);
            return operationStatus;
        }
        finally {
            this.fRefreshInfo = true;
        }
    }

    @Override
    public synchronized OperationStatus<IWorkResourceDetails> saveWorkDetails(IWorkResourceDetails[] workingCopies, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)workingCopies);
        try {
            IWorkResourceDetails[] iWorkResourceDetailsArray = workingCopies;
            int n = workingCopies.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkResourceDetails workingCopy = iWorkResourceDetailsArray[n2];
                if (workingCopy instanceof WorkResourceDetails) {
                    WorkResourceDetails details = (WorkResourceDetails)workingCopy;
                    details.setCustomized(true);
                }
                ++n2;
            }
            OperationStatus operationStatus = this.fManager.getResourcePlanningClient().saveWorkDetails(workingCopies, monitor);
            return operationStatus;
        }
        finally {
            this.fRefreshInfo = true;
        }
    }
}

