/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.quickquery.workitem;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryParameter;
import com.ibm.team.apt.ide.ui.quickquery.QuickQueryOperator;
import com.ibm.team.apt.internal.ide.ui.quickquery.AbstractQuickQueryAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.SimpleQuickQueryParameter;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeAttribute
extends AbstractQuickQueryAttribute {
    public TypeAttribute(IQuickQueryContext context) {
        super("type", Messages.TypeAttribute_DESCRIPTION, context);
    }

    @Override
    public Collection<IQuickQueryParameter> getParameterProposals(boolean importantOnly, QuickQueryOperator operator, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IWorkItemType> workItemTypes = this.getWorkItemTypes(monitor);
        ArrayList<IQuickQueryParameter> result = new ArrayList<IQuickQueryParameter>(workItemTypes.size());
        for (IWorkItemType workItemType : workItemTypes) {
            String label = workItemType.getDisplayName();
            String description = NLS.bind((String)Messages.TypeAttribute_DESCRIPTION_PROPOSAL, (Object[])new Object[]{label});
            result.add(new SimpleQuickQueryParameter(label, description, WorkItemUI.getImageDescriptor((URL)workItemType.getIconURL())));
        }
        return result;
    }

    @Override
    public Expression buildExpression(QuickQueryOperator operator, String parameter, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.TypeAttribute_MONITOR_BUILD_EXPRESSION, 2);
        try {
            IQueryableAttribute priorityAttribute = this.findWorkItemQueryableAttribute(IWorkItem.TYPE_PROPERTY, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            List<IWorkItemType> workItemTypes = this.getWorkItemTypes(monitor);
            for (IWorkItemType workItemType : workItemTypes) {
                if (!workItemType.getDisplayName().equals(parameter)) continue;
                AttributeExpression attributeExpression = new AttributeExpression(priorityAttribute, AttributeOperation.EQUALS, (Object)workItemType.getIdentifier());
                return attributeExpression;
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    private List<IWorkItemType> getWorkItemTypes(IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemClient workItemClient = this.getWorkItemClient();
        return workItemClient.findWorkItemTypes(this.getContext().getProjectArea(), monitor);
    }
}

