/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.quickquery.workitem;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryParameter;
import com.ibm.team.apt.ide.ui.quickquery.QuickQueryOperator;
import com.ibm.team.apt.internal.ide.ui.quickquery.AbstractQuickQueryAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.SimpleQuickQueryParameter;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ISeverity;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeverityAttribute
extends AbstractQuickQueryAttribute {
    private static final String ATTRIBUTE_IDENTIFIER = IWorkItem.SEVERITY_PROPERTY;

    public SeverityAttribute(IQuickQueryContext context) {
        super("severity", Messages.SeverityAttribute_DESCRIPTION, context);
    }

    @Override
    public Collection<IQuickQueryParameter> getParameterProposals(boolean importantOnly, QuickQueryOperator operator, IProgressMonitor monitor) throws TeamRepositoryException {
        List<ISeverity> severities = this.getSeverities(monitor);
        ArrayList<IQuickQueryParameter> result = new ArrayList<IQuickQueryParameter>(severities.size());
        for (ISeverity severity : severities) {
            String label = severity.getName();
            String description = MessageFormat.format(Messages.SeverityAttribute_DESCRIPTION_PROPSAL, label);
            result.add(new SimpleQuickQueryParameter(label, description, WorkItemUI.getImageDescriptor((URL)severity.getIconURL())));
        }
        return result;
    }

    @Override
    public Expression buildExpression(QuickQueryOperator operator, String parameter, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.SeverityAttribute_MONITOR_BUILD_EXPRESSION, 2);
        try {
            IQueryableAttribute severityAttribute = this.findWorkItemQueryableAttribute(ATTRIBUTE_IDENTIFIER, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            List<ISeverity> severities = this.getSeverities((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ISeverity referenceSeverity = null;
            for (ISeverity severity : severities) {
                if (!severity.getName().equalsIgnoreCase(parameter)) continue;
                referenceSeverity = severity;
                break;
            }
            if (referenceSeverity != null) {
                if (operator.is(QuickQueryOperator.DEFAULT, QuickQueryOperator.EQ)) {
                    AttributeExpression attributeExpression = new AttributeExpression(severityAttribute, AttributeOperation.EQUALS, (Object)referenceSeverity.getIdentifier2());
                    return attributeExpression;
                }
                if (operator.is(QuickQueryOperator.GT, QuickQueryOperator.LT)) {
                    Term result = new Term(1, null);
                    for (ISeverity priority : severities) {
                        int relation = referenceSeverity.compareTo(priority);
                        if ((QuickQueryOperator.GT != operator || relation >= 0) && (QuickQueryOperator.LT != operator || relation <= 0)) continue;
                        result.add((Expression)new AttributeExpression(severityAttribute, AttributeOperation.EQUALS, (Object)priority.getIdentifier2()));
                    }
                    Term term = result;
                    return term;
                }
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    private List<ISeverity> getSeverities(IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            monitor.beginTask(Messages.SeverityAttribute_MONITOR_RESOLVE_ITEMS, 2);
            IAttribute attribute = this.getWorkItemClient().findAttribute(this.getContext().getProjectArea(), ATTRIBUTE_IDENTIFIER, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            List<ISeverity> list = this.getValues(attribute, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            return list;
        }
        finally {
            monitor.done();
        }
    }
}

