/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.quickquery.workitem;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryAttribute;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryAttributeFactory;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryDefinition;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryWordConsumer;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.expression.Expression;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickQueryDefinition
implements IQuickQueryDefinition {
    private final IQuickQueryWordConsumer fDefaultWordConsumer;
    private final List<IQuickQueryWordConsumer> fWordConsumers;
    private final List<IQuickQueryAttributeFactory> fAttributeFactories;

    public QuickQueryDefinition(IQuickQueryWordConsumer defaultWordConsumer, List<IQuickQueryWordConsumer> wordConsumers, List<IQuickQueryAttributeFactory> attributeFactories) {
        this.fDefaultWordConsumer = defaultWordConsumer;
        this.fWordConsumers = wordConsumers;
        this.fAttributeFactories = attributeFactories;
    }

    @Override
    public Collection<String> getWordProposals(IQuickQueryContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.QuickQueryDefinition_MONITOR_RESOLVE_ITEMS, this.fWordConsumers.size());
        try {
            HashSet<String> wordProposals = new HashSet<String>();
            for (IQuickQueryWordConsumer wordConsumer : this.fWordConsumers) {
                wordProposals.addAll(wordConsumer.getWordProposals(context, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            }
            wordProposals.addAll(this.fDefaultWordConsumer.getWordProposals(context, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            HashSet<String> hashSet = wordProposals;
            return hashSet;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public Expression buildWordExpression(IQuickQueryContext context, String word, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.QuickQueryDefinition_MONITOR_BUILD_EPRESSION, this.fWordConsumers.size());
        try {
            for (IQuickQueryWordConsumer wordConsumer : this.fWordConsumers) {
                if (!wordConsumer.isWordHandled(context, word)) continue;
                Expression expression = wordConsumer.buildExpression(context, word, monitor);
                return expression;
            }
            Expression expression = this.fDefaultWordConsumer.buildExpression(context, word, monitor);
            return expression;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public Collection<IQuickQueryAttribute> findAllAttributes(IQuickQueryContext context) throws TeamRepositoryException {
        HashMap<String, IQuickQueryAttribute> allAttributes = new HashMap<String, IQuickQueryAttribute>();
        for (IQuickQueryAttributeFactory factory : this.fAttributeFactories) {
            for (IQuickQueryAttribute attribute : factory.findAllAttributes(context)) {
                if (allAttributes.containsKey(attribute.getKeyword())) continue;
                allAttributes.put(attribute.getKeyword(), attribute);
            }
        }
        return allAttributes.values();
    }

    @Override
    public IQuickQueryAttribute findAttribute(IQuickQueryContext context, String keyword) throws TeamRepositoryException {
        for (IQuickQueryAttributeFactory factory : this.fAttributeFactories) {
            IQuickQueryAttribute result = factory.findAttribute(context, keyword);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

