/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.quickquery.workitem;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryParameter;
import com.ibm.team.apt.ide.ui.quickquery.QuickQueryOperator;
import com.ibm.team.apt.internal.ide.ui.quickquery.AbstractQuickQueryAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.SimpleQuickQueryParameter;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IPriority;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityAttribute
extends AbstractQuickQueryAttribute {
    private static final String ATTRIBUTE_IDENTIFIER = IWorkItem.PRIORITY_PROPERTY;

    public PriorityAttribute(IQuickQueryContext context) {
        super("priority", Messages.PriorityAttribute_DESCRIPTION, context);
    }

    @Override
    public Collection<IQuickQueryParameter> getParameterProposals(boolean importantOnly, QuickQueryOperator operator, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IPriority> priorities = this.getPriorities(monitor);
        ArrayList<IQuickQueryParameter> result = new ArrayList<IQuickQueryParameter>(priorities.size());
        for (IPriority priority : priorities) {
            String label = priority.getName();
            String description = MessageFormat.format(Messages.PriorityAttribute_DESCRIPTION_PROPOSAL, label);
            result.add(new SimpleQuickQueryParameter(label, description, WorkItemUI.getImageDescriptor((URL)priority.getIconURL())));
        }
        return result;
    }

    @Override
    public Expression buildExpression(QuickQueryOperator operator, String parameter, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.PriorityAttribute_MONITOR_BUILD_EXPRESSION, 2);
        try {
            IQueryableAttribute priorityAttribute = this.findWorkItemQueryableAttribute(ATTRIBUTE_IDENTIFIER, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            List<IPriority> priorities = this.getPriorities((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IPriority referencePriority = null;
            for (IPriority priority : priorities) {
                if (!priority.getName().equalsIgnoreCase(parameter)) continue;
                referencePriority = priority;
                break;
            }
            if (referencePriority != null) {
                if (operator.is(QuickQueryOperator.DEFAULT, QuickQueryOperator.EQ)) {
                    AttributeExpression attributeExpression = new AttributeExpression(priorityAttribute, AttributeOperation.EQUALS, (Object)referencePriority.getIdentifier2());
                    return attributeExpression;
                }
                if (operator.is(QuickQueryOperator.GT, QuickQueryOperator.LT)) {
                    Term result = new Term(1, null);
                    for (IPriority priority : priorities) {
                        int relation = referencePriority.compareTo(priority);
                        if ((QuickQueryOperator.GT != operator || relation >= 0) && (QuickQueryOperator.LT != operator || relation <= 0)) continue;
                        result.add((Expression)new AttributeExpression(priorityAttribute, AttributeOperation.EQUALS, (Object)priority.getIdentifier2()));
                    }
                    Term term = result;
                    return term;
                }
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    private List<IPriority> getPriorities(IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            monitor.beginTask(Messages.PriorityAttribute_MONITOR_RESOLVE_ITEMS, 2);
            IAttribute attribute = this.getWorkItemClient().findAttribute(this.getContext().getProjectArea(), ATTRIBUTE_IDENTIFIER, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            List<IPriority> list = this.getValues(attribute, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            return list;
        }
        finally {
            monitor.done();
        }
    }
}

