/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.quickquery.workitem;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryParameter;
import com.ibm.team.apt.ide.ui.quickquery.QuickQueryOperator;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.quickquery.AbstractQuickQueryAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.SimpleQuickQueryParameter;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.DurationFormat;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EstimateAttribute
extends AbstractQuickQueryAttribute {
    private static final String PARAMETER_SET = "set";
    private static final String PARAMETER_UNSET = "unset";

    public EstimateAttribute(IQuickQueryContext context) {
        super("estimate", Messages.EstimateAttribute_DESCRIPTION, context);
    }

    @Override
    public Collection<IQuickQueryParameter> getParameterProposals(boolean importantOnly, QuickQueryOperator operator, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IQuickQueryParameter> result = new ArrayList<IQuickQueryParameter>(2);
        if (!importantOnly && QuickQueryOperator.DEFAULT == operator) {
            result.add(new SimpleQuickQueryParameter(PARAMETER_SET, Messages.EstimateAttribute_DESCRIPTION_PROPOSAL_SET, ImagePool.DURATION));
            result.add(new SimpleQuickQueryParameter(PARAMETER_UNSET, Messages.EstimateAttribute_DESCRIPTION_PROPOSAL_UNSET, ImagePool.DURATION));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Expression buildExpression(QuickQueryOperator operator, String parameter, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.EstimateAttribute_MONITOR_BUILD_EXPRESSION, 2);
        try {
            if (parameter == null) return null;
            if (parameter.length() == 0) {
                return null;
            }
            IQueryableAttribute estimateAttribute = this.findWorkItemQueryableAttribute(IWorkItem.DURATION_PROPERTY, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (QuickQueryOperator.DEFAULT == operator) {
                if (PARAMETER_SET.equalsIgnoreCase(parameter)) {
                    AttributeExpression attributeExpression = new AttributeExpression(estimateAttribute, AttributeOperation.NOT_EQUALS, (Object)-1L);
                    return attributeExpression;
                }
                if (!PARAMETER_UNSET.equalsIgnoreCase(parameter)) return null;
                AttributeExpression attributeExpression = new AttributeExpression(estimateAttribute, AttributeOperation.EQUALS, (Object)-1L);
                return attributeExpression;
            }
            Duration duration = DurationFormat.getInstance().parse(parameter);
            if (QuickQueryOperator.EQ == operator) {
                AttributeExpression attributeExpression = new AttributeExpression(estimateAttribute, AttributeOperation.EQUALS, (Object)duration.longValue());
                return attributeExpression;
            }
            if (QuickQueryOperator.LT == operator) {
                AttributeExpression attributeExpression = new AttributeExpression(estimateAttribute, AttributeOperation.SMALLER_OR_EQUALS, (Object)duration.longValue());
                return attributeExpression;
            }
            if (QuickQueryOperator.GT != operator) return null;
            AttributeExpression attributeExpression = new AttributeExpression(estimateAttribute, AttributeOperation.GREATER_OR_EQUALS, (Object)duration.longValue());
            return attributeExpression;
        }
        finally {
            monitor.done();
        }
    }
}

