/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.quickquery.workitem;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryWordConsumer;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWordConsumer
implements IQuickQueryWordConsumer {
    private static final Pattern fWorkItemIdPattern = Pattern.compile("\\d+");

    @Override
    public boolean isWordHandled(IQuickQueryContext context, String word) throws TeamRepositoryException {
        return true;
    }

    @Override
    public Collection<String> getWordProposals(IQuickQueryContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        return Collections.EMPTY_SET;
    }

    @Override
    public Expression buildExpression(IQuickQueryContext context, String word, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle projectArea = context.getProjectArea();
        IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)projectArea);
        IQueryableAttributeFactory factory = QueryableAttributes.getFactory((IItemType)IWorkItem.ITEM_TYPE);
        IQueryableAttribute summaryAttribute = factory.findAttribute(projectArea, IWorkItem.SUMMARY_PROPERTY, (IAuditableCommon)auditableClient, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IQueryableAttribute descriptionAttribute = factory.findAttribute(projectArea, IWorkItem.DESCRIPTION_PROPERTY, (IAuditableCommon)auditableClient, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ArrayList<AttributeExpression> expressions = new ArrayList<AttributeExpression>();
        expressions.add(new AttributeExpression(summaryAttribute, AttributeOperation.CONTAINS, (Object)word));
        expressions.add(new AttributeExpression(descriptionAttribute, AttributeOperation.CONTAINS, (Object)word));
        if (fWorkItemIdPattern.matcher(word).matches()) {
            try {
                IQueryableAttribute idAttribute = factory.findAttribute(projectArea, IWorkItem.ID_PROPERTY, (IAuditableCommon)auditableClient, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                expressions.add(new AttributeExpression(idAttribute, AttributeOperation.EQUALS, (Object)Integer.parseInt(word)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new Term(1, expressions.toArray(new Expression[expressions.size()]));
    }
}

