/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.quickquery.workitem;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryParameter;
import com.ibm.team.apt.ide.ui.quickquery.QuickQueryOperator;
import com.ibm.team.apt.internal.client.util.Categories;
import com.ibm.team.apt.internal.ide.ui.quickquery.AbstractQuickQueryAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.SimpleQuickQueryParameter;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryAttribute
extends AbstractQuickQueryAttribute {
    public CategoryAttribute(IQuickQueryContext context) {
        super("category", Messages.CategoryAttribute_DESCRIPTION, context);
    }

    @Override
    public Collection<IQuickQueryParameter> getParameterProposals(boolean importantOnly, QuickQueryOperator operator, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.CategoryAttribute_MONITOR_RESOLVE_ITEMS, -1);
        try {
            List<ICategory> categories = this.getCategories(monitor);
            ArrayList<IQuickQueryParameter> result = new ArrayList<IQuickQueryParameter>(categories.size());
            for (ICategory category : categories) {
                String label = this.getWorkItemClient().resolveHierarchicalName((ICategoryHandle)category, monitor);
                String description = MessageFormat.format(Messages.CategoryAttribute_DESCRIPTION_PROPOSAL, category.getName());
                result.add(new SimpleQuickQueryParameter(label, description));
            }
            ArrayList<IQuickQueryParameter> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    public Collection<String> getParameterProposals(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.CategoryAttribute_MONITOR_RESOLVE_ITEMS, -1);
        try {
            List<ICategory> categories = this.getCategories(monitor);
            ArrayList<String> result = new ArrayList<String>(categories.size());
            for (ICategory category : categories) {
                result.add(this.getWorkItemClient().resolveHierarchicalName((ICategoryHandle)category, monitor));
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public Expression buildExpression(QuickQueryOperator operator, String parameter, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.CategoryAttribute_MONITOR_BUILD_EXPRESSION, 2);
        try {
            if (parameter != null && parameter.trim().length() > 0) {
                List<ICategory> categories = this.getCategories(monitor);
                IQueryableAttribute categoryAttribute = this.findWorkItemQueryableAttribute(IWorkItem.CATEGORY_PROPERTY, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (QuickQueryOperator.DEFAULT == operator || QuickQueryOperator.EQ == operator) {
                    for (ICategory category : categories) {
                        String hierarchicalName = this.getWorkItemClient().resolveHierarchicalName((ICategoryHandle)category, monitor);
                        if (!hierarchicalName.equalsIgnoreCase(parameter)) continue;
                        AttributeExpression attributeExpression = new AttributeExpression(categoryAttribute, AttributeOperation.EQUALS, (Object)category.getItemHandle());
                        return attributeExpression;
                    }
                } else if (QuickQueryOperator.SUBTREE == operator) {
                    Term result = new Term(1, null);
                    for (ICategory category : categories) {
                        String hierarchicalName = this.getWorkItemClient().resolveHierarchicalName((ICategoryHandle)category, monitor);
                        if (!hierarchicalName.startsWith(parameter)) continue;
                        result.add((Expression)new AttributeExpression(categoryAttribute, AttributeOperation.EQUALS, (Object)category.getItemHandle()));
                    }
                    Term term = result;
                    return term;
                }
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    private List<ICategory> getCategories(IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            IWorkItemClient workItemClient = this.getWorkItemClient();
            IProjectAreaHandle projectArea = this.getContext().getProjectArea();
            List categories = workItemClient.findCategories(projectArea, ICategory.SMALL_PROFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            Categories.sort((List)categories);
            List list = categories;
            return list;
        }
        finally {
            monitor.done();
        }
    }
}

