/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.quickquery;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryAttribute;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryAttributeFactory;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.quickquery.PlanAwareDevLineAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.PlanAwareTagsAttribute;
import com.ibm.team.apt.internal.ide.ui.quickquery.ViewAttributes;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanItemAttributeFactory
implements IQuickQueryAttributeFactory {
    private Map<String, IQuickQueryAttribute> fAttributes;

    @Override
    public IQuickQueryAttribute findAttribute(IQuickQueryContext context, String keyword) throws TeamRepositoryException {
        this.initialize(context);
        return this.fAttributes.get(keyword);
    }

    public List<IQuickQueryAttribute> findAllAttributes(IQuickQueryContext context) throws TeamRepositoryException {
        this.initialize(context);
        return new ArrayList<IQuickQueryAttribute>(this.fAttributes.values());
    }

    private synchronized void initialize(IQuickQueryContext context) {
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, IQuickQueryAttribute>();
            ViewAttributes viewAttributes = new ViewAttributes();
            this.fAttributes.put(viewAttributes.getKeyword(), viewAttributes);
            PlanAwareTagsAttribute tagAttribute = new PlanAwareTagsAttribute(context);
            this.fAttributes.put(tagAttribute.getKeyword(), tagAttribute);
            PlanAwareDevLineAttribute devLineAttribute = new PlanAwareDevLineAttribute(context);
            this.fAttributes.put(devLineAttribute.getKeyword(), devLineAttribute);
        }
    }

    private ResolvedPlan getPlanContext(IQuickQueryContext context) {
        ResolvedPlan result = (ResolvedPlan)context.getAdapter(ResolvedPlan.class);
        if (result == null) {
            throw new IllegalArgumentException("IQuickQueryContext not compatible with PlanItemAttributeFactory");
        }
        return result;
    }
}

