/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.quickquery;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryParameter;
import com.ibm.team.apt.ide.ui.quickquery.QuickQueryOperator;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.quickquery.Messages;
import com.ibm.team.apt.internal.ide.ui.quickquery.SimpleQuickQueryParameter;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.TagsAttribute;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanAwareTagsAttribute
extends TagsAttribute {
    public PlanAwareTagsAttribute(IQuickQueryContext context) {
        super(context);
    }

    @Override
    public Collection<IQuickQueryParameter> getParameterProposals(boolean importantOnly, QuickQueryOperator operator, IProgressMonitor monitor) throws TeamRepositoryException {
        if (importantOnly) {
            return Collections.EMPTY_SET;
        }
        HashMap<String, SimpleQuickQueryParameter> resultMap = new HashMap<String, SimpleQuickQueryParameter>();
        for (PlanItem planItem : this.getPlanContext().getAllPlanItems()) {
            Collection tags = planItem.getTags();
            for (String tag : tags) {
                if (resultMap.containsKey(tag)) continue;
                resultMap.put(tag, new SimpleQuickQueryParameter(tag, MessageFormat.format(Messages.PlanAwareTagsAttribute_DESCRIPTION_PROPOSAL, tag)));
            }
        }
        return resultMap.values();
    }

    private ResolvedPlan getPlanContext() {
        ResolvedPlan result = (ResolvedPlan)this.getContext().getAdapter(ResolvedPlan.class);
        if (result == null) {
            throw new IllegalArgumentException("IQuickQueryContext not compatible with PlanAwareTagsAttribute");
        }
        return result;
    }
}

