/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.navigator;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.navigator.AbstractIterationFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.DevelopmentLineFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.Messages;
import com.ibm.team.apt.internal.ide.ui.navigator.PlanningDomain;
import com.ibm.team.apt.internal.ide.ui.navigator.PlanningDomainFolder;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IIteration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class PlanningLabelProvider
extends LabelProvider
implements ITreePathLabelProvider {
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());

    public void dispose() {
        this.fResourceManager.dispose();
        this.fStandardLabelProvider.dispose();
    }

    public String getText(Object element) {
        ViewerLabel label = new ViewerLabel("", null);
        this.updateLabel(label, new TreePath(new Object[]{element}));
        return label.getText();
    }

    public Image getImage(Object element) {
        ViewerLabel label = new ViewerLabel("", null);
        this.updateLabel(label, new TreePath(new Object[]{element}));
        return label.getImage();
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (element instanceof PlanningDomain) {
            label.setText(Messages.PlanningLabelProvider_LABEL_PLANS);
            label.setImage(super.getImage(element));
        } else if (element instanceof IIterationPlanRecord) {
            label.setText(((IIterationPlanRecord)element).getName());
            label.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.ITERATION_PLAN_OBJ));
        } else if (element instanceof PlanningDomainFolder) {
            label.setText(((PlanningDomainFolder)element).getName());
            if (element instanceof DevelopmentLineFolder) {
                label.setImage(this.fStandardLabelProvider.getImage((Object)((DevelopmentLineFolder)element).getDevelopmentLine()));
            } else if (element instanceof AbstractIterationFolder) {
                IIteration iteration = ((AbstractIterationFolder)element).getIteration();
                if (iteration.isArchived()) {
                    label.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.ITERATION_PLAN_FOLDER_OBJ_ARCHIVED));
                } else {
                    label.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.ITERATION_PLAN_FOLDER_OBJ));
                }
            } else {
                label.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.ITERATION_PLAN_FOLDER_OBJ));
            }
        } else if (element instanceof PendingUpdateAdapter) {
            label.setText(((PendingUpdateAdapter)element).getLabel(element));
            label.setImage(null);
        } else {
            label.setText(super.getText(element));
            label.setImage(super.getImage(element));
        }
    }
}

