/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.navigator;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.util.IterationStructure;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.apt.internal.common.util.SortMode;
import com.ibm.team.apt.internal.ide.core.IPlanElementChangedListener;
import com.ibm.team.apt.internal.ide.core.PlanAddedEvent;
import com.ibm.team.apt.internal.ide.core.PlanChangedEvent;
import com.ibm.team.apt.internal.ide.core.PlanDeletedEvent;
import com.ibm.team.apt.internal.ide.core.PlanEvent;
import com.ibm.team.apt.internal.ide.core.PlanModel;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.navigator.AbstractIterationFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.CurrentIterationFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.DevelopmentLineFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.IterationFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.Messages;
import com.ibm.team.apt.internal.ide.ui.navigator.PlanningDomain;
import com.ibm.team.apt.internal.ide.ui.navigator.PlanningDomainFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.RootFolder;
import com.ibm.team.apt.internal.ide.ui.util.DevelopmentLineUIComparator;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.ProcessRCPUI;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQueryPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanningContentProvider
implements ITreeContentProvider,
ITreePathContentProvider,
IDeferredWorkbenchAdapter {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final TreePath[] EMPTY_TREEPATH_ARRAY = new TreePath[0];
    private PlanningDomain fDomain;
    private PlanListener fPlanListener;
    private PreferenceListener fPreferenceListener;
    private AbstractTreeViewer fViewer;
    private RootFolder fRootFolder;
    private ItemMap<IProjectAreaHandle, IterationStructure> fIterationStructures;
    private IIteration fInlinedIteration;
    private DeferredTreeContentManager fManager;

    public PlanningContentProvider(PlanningDomain domain) {
        Assert.isLegal((domain != null ? 1 : 0) != 0);
        this.fDomain = domain;
        this.addListeners();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fRootFolder = null;
        this.fIterationStructures = new ItemHashMap();
        this.fInlinedIteration = null;
        this.fViewer = (AbstractTreeViewer)viewer;
        if (this.fManager == null) {
            this.fManager = new DeferredTreeContentManager(this, (AbstractTreeViewer)viewer, this.fDomain.getWorkbenchPart().getSite()){

                protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                    if (PlanningContentProvider.this.hasChildren(element)) {
                        return PlanningContentProvider.this;
                    }
                    return super.getAdapter(element);
                }
            };
        }
    }

    public void dispose() {
        this.fManager = null;
        this.removeListeners();
    }

    public Object getParent(Object element) {
        if (element instanceof PlanningDomainFolder) {
            ((PlanningDomainFolder)element).getParent();
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreePath) {
            return this.hasChildren((TreePath)element);
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreePath) {
            return this.getChildren((TreePath)parentElement);
        }
        return null;
    }

    public Object[] getChildren(TreePath parentPath) {
        Object parentElement = parentPath.getLastSegment();
        if (parentElement instanceof DomainSubtreeRoot || parentElement instanceof PlanningDomainFolder) {
            return this.fManager.getChildren((Object)parentPath);
        }
        return EMPTY_ARRAY;
    }

    public TreePath[] getParents(Object element) {
        return EMPTY_TREEPATH_ARRAY;
    }

    public boolean hasChildren(TreePath path) {
        Object element = path.getLastSegment();
        return element instanceof DomainSubtreeRoot || element instanceof PlanningDomainFolder;
    }

    public boolean isContainer() {
        return true;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        block29: {
            path = (TreePath)object;
            element = path.getLastSegment();
            if (!(element instanceof DomainSubtreeRoot) && !(element instanceof PlanningDomainFolder) || monitor.isCanceled()) {
                return;
            }
            try {
                showArchived = ProcessRCPUI.getPreferenceStore().getBoolean("teamArtifactsNavigator.showArchived");
                if (!(element instanceof DomainSubtreeRoot)) ** GOTO lbl91
                monitor.beginTask("", 6);
                root = (DomainSubtreeRoot)element;
                this.fRootFolder = new RootFolder(root);
                this.fIterationStructures.clear();
                this.fInlinedIteration = null;
                projectAreaHandle = null;
                teamArea = null;
                categoryElement = root.getCategoryElement();
                if (categoryElement instanceof IProjectAreaHandle) {
                    projectAreaHandle = (IProjectAreaHandle)categoryElement;
                } else if (categoryElement instanceof ITeamArea) {
                    teamArea = (ITeamArea)categoryElement;
                    projectAreaHandle = teamArea.getProjectArea();
                }
                if (projectAreaHandle == null && teamArea == null) lbl-1000:
                // 7 sources

                {
                    return;
                }
                try {
                    block31: {
                        block30: {
                            teamAreas = this.fDomain.getConnectedProjectAreaRegistry().getSelectedTeamAreas(projectAreaHandle);
                            if (teamAreas.isEmpty()) ** GOTO lbl-1000
                            repository = (ITeamRepository)projectAreaHandle.getOrigin();
                            auditableCommon = PlanningClientPlugin.getAuditableClient((ITeamRepository)repository);
                            pis = PlanningClientPlugin.getProcessItemService((ITeamRepository)repository);
                            iterationStructure = this.fetchIterationStructure(projectAreaHandle, monitor);
                            if (teamArea != null) {
                                devLines = new ItemArrayList(1);
                                line = pis.getDevelopmentLine(teamArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                if (showArchived || !line.isArchived()) {
                                    devLines.add((Object)line);
                                }
                            } else {
                                devLines = iterationStructure.getDevelopmentLines(showArchived);
                                monitor.worked(1);
                            }
                            ItemCollections.sort((ItemList)devLines, (Comparator)new DevelopmentLineUIComparator(SortMode.ASC, auditableCommon.findDefaultDevelopmentLine(projectAreaHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1))));
                            currentIterations = new ArrayList<ItemArrayList>();
                            sub = new SubProgressMonitor(monitor, 1);
                            sub.beginTask("", devLines.size());
                            for (IDevelopmentLine developmentLine : devLines) {
                                ci = iterationStructure.getCurrentIterations((IDevelopmentLineHandle)developmentLine);
                                toUse = new ArrayList<IIteration>();
                                var24_45 = ci.iterator();
                                while (var24_45.hasNext()) {
                                    iteration = (IIteration)var24_45.next();
                                    if (!this.showIteration(iterationStructure, iteration, showArchived)) continue;
                                    toUse.add(iteration);
                                }
                                Collections.reverse(toUse);
                                iterations = new ItemArrayList(toUse);
                                currentIterations.add(iterations);
                            }
                            sub.done();
                            if (currentIterations.size() == 1 && ((ItemList)currentIterations.get(0)).size() == 1) {
                                this.fInlinedIteration = (IIteration)((ItemList)currentIterations.get(0)).get(0);
                                this.fetchPlanRecords(repository, this.fInlinedIteration, teamAreas, collector, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            } else {
                                devLineMap = new ItemHashMap();
                                for (IDevelopmentLine line : devLines) {
                                    devLineMap.put(line.getItemHandle(), (Object)line);
                                }
                                folders = new ArrayList<AbstractIterationFolder>();
                                for (ItemList iterations : currentIterations) {
                                    for (IIteration iteration : iterations) {
                                        line = (IDevelopmentLine)devLineMap.get((IItemHandle)iteration.getDevelopmentLine());
                                        if (line != null) {
                                            folders.add(new CurrentIterationFolder(this.fRootFolder, iteration, line));
                                            continue;
                                        }
                                        folders.add(new IterationFolder(this.fRootFolder, iteration));
                                    }
                                }
                                collector.add(folders.toArray(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                            if (monitor.isCanceled()) ** GOTO lbl-1000
                            devLineFolders = new ArrayList<DevelopmentLineFolder>(devLines.size());
                            for (IDevelopmentLine devLine : devLines) {
                                devLineFolders.add(new DevelopmentLineFolder(this.fRootFolder, devLine));
                            }
                            collector.add(devLineFolders.toArray(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            break block29;
lbl91:
                            // 1 sources

                            if (!(element instanceof DevelopmentLineFolder)) break block30;
                            monitor.beginTask("", 5);
                            folder = (DevelopmentLineFolder)element;
                            folder.clearChildren();
                            projectAreaHandle = this.getProjectAreaHandle(folder);
                            teamAreas = this.fDomain.getConnectedProjectAreaRegistry().getSelectedTeamAreas(projectAreaHandle);
                            if (teamAreas.isEmpty()) ** GOTO lbl-1000
                            iterationStructure = this.fetchIterationStructure(projectAreaHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            projectPhases = iterationStructure.getIterations(folder.getDevelopmentLine().getIterations());
                            if (projectPhases.size() > 0) {
                                folders = new ArrayList<IterationFolder>(projectPhases.size());
                                for (IIteration iteration : projectPhases) {
                                    if (iteration == null || !this.showIteration(iterationStructure, iteration, showArchived)) continue;
                                    folders.add(new IterationFolder(folder, iteration));
                                }
                                collector.add(folders.toArray(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                            break block29;
                        }
                        if (!(element instanceof IterationFolder)) break block31;
                        monitor.beginTask("", 4);
                        folder = (IterationFolder)element;
                        folder.clearChildren();
                        projectAreaHandle = this.getProjectAreaHandle(folder);
                        teamAreas = this.fDomain.getConnectedProjectAreaRegistry().getSelectedTeamAreas(projectAreaHandle);
                        if (teamAreas.isEmpty()) ** GOTO lbl-1000
                        repository = PlanningClientPlugin.getTeamRepository((IItemHandle)projectAreaHandle);
                        this.fetchPlanRecords(repository, folder.getIteration(), teamAreas, collector, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        iterationStructure = this.fetchIterationStructure(projectAreaHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        iterations = iterationStructure.getIterations(folder.getIteration().getChildren());
                        if (iterations.isEmpty()) ** GOTO lbl-1000
                        folders = new ArrayList<IterationFolder>(iterations.size());
                        i = iterations.size() - 1;
                        while (i >= 0) {
                            iteration = (IIteration)iterations.get(i);
                            if (iteration != null && this.showIteration(iterationStructure, iteration, showArchived)) {
                                folders.add(new IterationFolder(folder, iteration));
                            }
                            --i;
                        }
                        collector.add(folders.toArray(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        break block29;
                    }
                    if (element instanceof CurrentIterationFolder) {
                        monitor.beginTask("", -1);
                        folder = (AbstractIterationFolder)element;
                        folder.clearChildren();
                        projectAreaHandle = this.getProjectAreaHandle(folder);
                        teamAreas = this.fDomain.getConnectedProjectAreaRegistry().getSelectedTeamAreas(projectAreaHandle);
                        if (!teamAreas.isEmpty()) ** break;
                        ** continue;
                        this.fetchPlanRecords(PlanningClientPlugin.getTeamRepository((IItemHandle)projectAreaHandle), folder.getIteration(), teamAreas, collector, monitor);
                    }
                }
                catch (TeamRepositoryException e) {
                    PlanningUIPlugin.log(e);
                }
            }
            finally {
                collector.done();
                monitor.done();
            }
        }
    }

    private IterationStructure fetchIterationStructure(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IterationStructure iterationStructure = (IterationStructure)this.fIterationStructures.get((IItemHandle)projectAreaHandle);
        if (iterationStructure == null) {
            iterationStructure = IterationStructure.create((IProjectAreaHandle)projectAreaHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fIterationStructures.put((IItemHandle)projectAreaHandle, (Object)iterationStructure);
        }
        return iterationStructure;
    }

    private boolean showIteration(IterationStructure iterationStructure, IIteration iteration, boolean showArchived) {
        return iterationStructure.showIteration((IIterationHandle)iteration) && (!iteration.isArchived() || showArchived);
    }

    private void fetchPlanRecords(ITeamRepository repository, IIteration iteration, List<ITeamAreaHandle> teamAreas, IElementCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemManager manager = repository.itemManager();
        IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((ITeamRepository)repository);
        IItemQueryPage page = client.fetchIterationPlanRecords(teamAreas, (IIterationHandle)iteration, 10);
        if (monitor.isCanceled()) {
            return;
        }
        collector.add(manager.fetchCompleteItems(page.getItemHandles(), 0, monitor).toArray(), monitor);
        while (page.hasNext()) {
            page = client.fetchNextQueryPage(page, 10);
            if (monitor.isCanceled()) {
                return;
            }
            collector.add(manager.fetchCompleteItems(page.getItemHandles(), 0, monitor).toArray(), monitor);
        }
    }

    private IProjectAreaHandle getProjectAreaHandle(PlanningDomainFolder folder) {
        DomainSubtreeRoot parent = folder.getRoot().getDomainSubtreeRoot();
        Object categoryElement = parent.getCategoryElement();
        if (categoryElement instanceof IProjectAreaHandle) {
            return (IProjectAreaHandle)categoryElement;
        }
        if (categoryElement instanceof ITeamArea) {
            return ((ITeamArea)categoryElement).getProjectArea();
        }
        Assert.isTrue((boolean)false, (String)("Shouldn't happen. Category element is: " + categoryElement.getClass().getName()));
        return null;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        if (o instanceof ITeamRepository) {
            return ((ITeamRepository)o).getRepositoryURI();
        }
        if (o instanceof IIterationPlanRecord) {
            return ((IIterationPlanRecord)o).getName();
        }
        if (o instanceof TreePath) {
            TreePath path = (TreePath)o;
            Object lastSegement = path.getLastSegment();
            if (lastSegement instanceof DomainSubtreeRoot) {
                return Messages.PlanningContentProvider_LABEL_PLANNING_DOMAIN;
            }
            if (lastSegement instanceof PlanningDomainFolder) {
                return ((PlanningDomainFolder)lastSegement).getName();
            }
            return o.toString();
        }
        return o.toString();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    private void addListeners() {
        if (this.fPlanListener == null) {
            this.fPlanListener = new PlanListener();
            PlanModel.INSTANCE.addListener((IPlanElementChangedListener)this.fPlanListener);
        }
        if (this.fPreferenceListener == null) {
            this.fPreferenceListener = new PreferenceListener();
            ProcessRCPUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        }
    }

    private void removeListeners() {
        if (this.fPlanListener != null) {
            PlanModel.INSTANCE.removeListener((IPlanElementChangedListener)this.fPlanListener);
            this.fPlanListener = null;
        }
        if (this.fPreferenceListener != null) {
            ProcessRCPUI.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        }
    }

    private void refreshViewer() {
        if (this.fViewer == null || this.fRootFolder == null) {
            return;
        }
        UI.syncExec(this.fViewer.getControl(), new Runnable(){

            public void run() {
                PlanningContentProvider.this.fViewer.refresh((Object)PlanningContentProvider.this.fRootFolder.getDomainSubtreeRoot());
            }
        });
    }

    private void handlePlanAdded(final PlanAddedEvent event) {
        this.postUpdate(new Runnable(){

            public void run() {
                if (PlanningContentProvider.this.fRootFolder == null) {
                    return;
                }
                IIterationPlanRecord record = event.getPlan();
                IProjectArea connectedProjectArea = PlanningContentProvider.this.fDomain.getConnectedProjectAreaRegistry().getConnectedProjectArea(record.getTeamArea());
                if (connectedProjectArea != null) {
                    IIterationHandle iteration = record.getIteration();
                    if (PlanningContentProvider.this.fInlinedIteration != null && PlanningContentProvider.this.fInlinedIteration.sameItemId((IItemHandle)iteration)) {
                        PlanningContentProvider.this.fViewer.refresh((Object)PlanningContentProvider.this.fRootFolder.getDomainSubtreeRoot());
                    } else {
                        List<PlanningDomainFolder> folders = PlanningContentProvider.this.fRootFolder.getFolders((IItemHandle)iteration);
                        if (folders != null) {
                            for (PlanningDomainFolder folder : folders) {
                                PlanningContentProvider.this.fViewer.refresh((Object)folder);
                            }
                        }
                    }
                }
            }
        });
    }

    private void handlePlanChanged(final PlanChangedEvent event) {
        this.postUpdate(new Runnable(){

            public void run() {
                if (event.isIntervalChanged()) {
                    if (PlanningContentProvider.this.fRootFolder != null) {
                        PlanningContentProvider.this.fViewer.refresh((Object)PlanningContentProvider.this.fRootFolder.getDomainSubtreeRoot());
                    }
                } else {
                    PlanningContentProvider.this.fViewer.update((Object)event.getPlan(), null);
                }
            }
        });
    }

    private void handlePlanDeleted(final PlanDeletedEvent event) {
        UI.syncExec(this.fViewer.getControl(), new Runnable(){

            public void run() {
                PlanningContentProvider.this.fViewer.remove((Object)event.getPlan());
            }
        });
    }

    private void postUpdate(Runnable runnable) {
        if (this.fViewer == null) {
            return;
        }
        Control tree = this.fViewer.getControl();
        if (!tree.isDisposed()) {
            tree.getDisplay().syncExec(runnable);
        }
    }

    private class PlanListener
    implements IPlanElementChangedListener {
        private PlanListener() {
        }

        public void changed(PlanEvent event) {
            if (!(event.getPlan() instanceof IIterationPlanRecord)) {
                return;
            }
            if (event instanceof PlanAddedEvent) {
                PlanningContentProvider.this.handlePlanAdded((PlanAddedEvent)event);
            }
            if (event instanceof PlanChangedEvent) {
                PlanningContentProvider.this.handlePlanChanged((PlanChangedEvent)event);
            }
            if (event instanceof PlanDeletedEvent) {
                PlanningContentProvider.this.handlePlanDeleted((PlanDeletedEvent)event);
            }
        }
    }

    private class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("teamArtifactsNavigator.showDeletedIterations".equals(event.getProperty())) {
                PlanningContentProvider.this.refreshViewer();
            }
        }
    }
}

