/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryDefinition;
import com.ibm.team.apt.ide.ui.quickquery.QuickQueryTypeRegistry;
import com.ibm.team.apt.internal.client.IItemResolveService;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementDeltaVisitor;
import com.ibm.team.apt.internal.client.IPlanElementListener;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.problems.PlanProblemReport;
import com.ibm.team.apt.internal.client.problems.Problem;
import com.ibm.team.apt.internal.client.util.IDeferredResolveListener;
import com.ibm.team.apt.internal.client.util.IDeferredResolver;
import com.ibm.team.apt.internal.common.util.IEventCondition;
import com.ibm.team.apt.internal.common.util.IterationHierarchy;
import com.ibm.team.apt.internal.common.util.SimpleEventCondition;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorizeConfiguration;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorizeDialog;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorizerEvent;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.IColorizerConfigListener;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.IQuickQueryEntryFinder;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryBar;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryHelper;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryMode;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupByDescription;
import com.ibm.team.apt.internal.ide.ui.mywork.AbstractPlanItemViewerSection;
import com.ibm.team.apt.internal.ide.ui.mywork.AbstractPlanSection;
import com.ibm.team.apt.internal.ide.ui.mywork.AbstractSaveStrategy;
import com.ibm.team.apt.internal.ide.ui.mywork.AutoSaveStrategy;
import com.ibm.team.apt.internal.ide.ui.mywork.IMyWorkSettings;
import com.ibm.team.apt.internal.ide.ui.mywork.ISelectionMediator;
import com.ibm.team.apt.internal.ide.ui.mywork.ManualSaveStrategy;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkActionContributor;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkCanvas;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkPreferencesDialog;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkSettings;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkViewListener;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkViewModel;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkViewer;
import com.ibm.team.apt.internal.ide.ui.mywork.SectionCurrentWork;
import com.ibm.team.apt.internal.ide.ui.testing.IMyWorkViewTestAccess;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.AnimatedLoadingLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.InformationViewer;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.jface.dashboard.ISection;
import com.ibm.team.jface.internal.dashboard.ColorRegistry;
import com.ibm.team.jface.internal.dashboard.views.PerspectiveSectionSlot;
import com.ibm.team.jface.internal.dashboard.views.SectionPart;
import com.ibm.team.jface.internal.dashboard.views.SectionsManager;
import com.ibm.team.jface.internal.dashboard.views.TeamCentralView;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.ide.ui.ConnectProjectAreasAction;
import com.ibm.team.process.internal.ide.ui.EditorUtilities;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.rcp.ui.internal.ConnectedProjectAreas;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyWorkView
extends TeamCentralView
implements ISaveablePart2,
IItemResolveService,
IAdaptable {
    public static final String ID = "com.ibm.team.apt.internal.ui.myWorkView";
    private static final String PREF_SHOW_QUICKSTARTAFFORDANCE = "showQuickstartAffordance";
    private static final int CODE_NO_TEAMAREA = 1000;
    private static final int CODE_NO_DEVLINE = 1001;
    private static final int CODE_NO_CURRENTITERATION = 1002;
    private static final String STATE_PROJECT_AREA = "projectAreaId";
    private static final String STATE_AUTOSAVE = "autosave";
    private static final String STATE_SETTINGS = "settings";
    private static final String SETTINGS_MEMENTO_ROOT = "settings";
    private static final String SETTINGS_MEMENTO_COLORIZE = "quickColorize";
    private static final String SETTINGS_MEMENTO_COLORIZECONFIG = "config";
    private final MyWorkSettings fSettings = new MyWorkSettings();
    private ListenerList fStateListener = new ListenerList(1);
    private ListenerList fViewListeners = new ListenerList(1);
    private ListenerList fSelectionListeners = new ListenerList(1);
    private List<AbstractPlanItemViewerSection> fViewers = new ArrayList<AbstractPlanItemViewerSection>();
    private State fCurrentState = State.NotConfigured;
    private IStatus fErrorStatus;
    private AtomicInteger fIsLoading = new AtomicInteger();
    private AbstractSaveStrategy fSaveStrategy;
    private ITeamRepository fTeamRepository;
    private IProjectAreaHandle fProjectArea;
    private ResolvedPersonalPlan fPlan;
    private boolean fIsPlanConnected;
    private Object fInitializationLock = new Object();
    private IPlanElementListener fPlanListener;
    private ShowCurrentAction fShowCurrentAction = new ShowCurrentAction();
    private SaveAction fSaveAction = new SaveAction();
    private SelectProjectAreaAction fSelectProjectAreaAction = new SelectProjectAreaAction();
    private EditWorkLocationAction fEditWorkLocationAction = new EditWorkLocationAction();
    private PreferencesAction fConfigureAction = new PreferencesAction();
    private ToggleAutosaveAction fToggleAutosaveAction = new ToggleAutosaveAction();
    private QuickColorizeAction fColorizeAction = new QuickColorizeAction();
    private MarkAllReadAction fMarkAllReadAction = new MarkAllReadAction();
    private StateAwareAction[] fActions = new StateAwareAction[]{this.fShowCurrentAction, this.fToggleAutosaveAction, this.fSaveAction, this.fSelectProjectAreaAction, this.fEditWorkLocationAction, this.fMarkAllReadAction, this.fConfigureAction, this.fColorizeAction};
    private MyWorkActionContributor fActionContributor;
    private Composite fContainer;
    private AnimatedLoadingLabel fLoadingControl;
    private Composite fTextControl;
    private Link fMessageLink;
    private Label fTextImage;
    private InformationViewer fSaveMessageViewer;
    private Composite fTeamCentralControl;
    private Composite fSectionHolder;
    private QuickQueryBar fQuickQueryBar;
    private IQuickQueryDefinition fQuickQueryDefinition;
    private IQuickQueryContext fQuickQueryContext = new IQuickQueryContext(){

        public Object getAdapter(Class adapter) {
            if (ResolvedPlan.class.equals((Object)adapter)) {
                return MyWorkView.this.getInput();
            }
            if (IProjectAreaHandle.class.equals((Object)adapter)) {
                return MyWorkView.this.getProjectArea();
            }
            return Platform.getAdapterManager().getAdapter((Object)this, adapter);
        }

        public IProjectAreaHandle getProjectArea() {
            return MyWorkView.this.getProjectArea();
        }
    };
    private List<ColorizeConfiguration> fQuickQueryColorConfigs = new ArrayList<ColorizeConfiguration>();
    private ListenerList fColorizeConfigListeners = new ListenerList();
    private ResourceManager fResourceManager;
    private ConnectedProjectAreaRegistry fProjectAreaRegistry;
    private ProjectAreaListener fProjectAreaListener = new ProjectAreaListener();
    private ITeamRepository.ILoginParticipant fLoginParticipant = new PersonalPlanViewLoginParticipant();
    private boolean fIsDisposed;
    private OverlayIcon fTitleImageWithWarning;
    private OverlayIcon fTitleImageWithError;
    private OverlayIcon fTitleImageWithFatalError;
    private final ISelectionMediator fSelectionMediator = new SelectionMediator();
    private boolean fShowQuickstartAffordance = true;
    private final IMyWorkViewTestAccess fTestAccess = new IMyWorkViewTestAccess(){

        public IEventCondition getConnectedCondition() {
            return new StateCondition(State.Connected);
        }

        public void discardInput() {
            MyWorkView.this.setInput(null);
            MyWorkView.this.fErrorStatus = Status.CANCEL_STATUS;
            MyWorkView.this.doStateChange(State.Error);
        }

        public MyWorkCanvas canvas() {
            SectionCurrentWork timeline = MyWorkView.this.getTimeline();
            return timeline != null ? timeline.getCanvas() : null;
        }

        public MyWorkViewer viewer() {
            SectionCurrentWork timeline = MyWorkView.this.getTimeline();
            return (MyWorkViewer)(timeline != null ? timeline.getViewModel().getViewer() : null);
        }

        public MyWorkViewModel viewModel() {
            SectionCurrentWork timeline = MyWorkView.this.getTimeline();
            return timeline != null ? timeline.getViewModel() : null;
        }

        public GroupByDescription grouping() {
            SectionCurrentWork timeline = MyWorkView.this.getTimeline();
            return timeline != null ? timeline.getGroupMode() : null;
        }

        public void setReferenceTime(final Date time) {
            if (MyWorkView.this.fPlan != null) {
                MyWorkView.this.fPlan.runWithDeltaBuilder(new Runnable(){

                    public void run() {
                        MyWorkView.this.fPlan.setReferenceTime(time);
                    }
                });
                SectionCurrentWork timeline = MyWorkView.this.getTimeline();
                if (timeline != null) {
                    timeline.getViewModel().refresh();
                    timeline.getViewModel().getViewer().expandAll();
                }
            }
        }

        class StateCondition
        extends SimpleEventCondition
        implements UIStateListener {
            List<State> fStates;

            public StateCondition(State ... states) {
                this.fStates = Arrays.asList(states);
                MyWorkView.this.addStateListener(this);
                if (this.fStates.contains((Object)MyWorkView.this.fCurrentState)) {
                    this.setEventTriggered();
                }
            }

            public void notifyStateChange(State newState) {
                if (this.fStates.contains((Object)newState)) {
                    MyWorkView.this.removeStateListener(this);
                    this.setEventTriggered();
                }
            }
        }
    };

    public MyWorkView() {
        this.setViewId(ID);
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
        imageDescriptorArray[1] = ImagePool.WARNING_OVR;
        this.fTitleImageWithWarning = new OverlayIcon(ImagePool.ITERATION_PLAN_PERSONAL, imageDescriptorArray, 17408);
        ImageDescriptor[] imageDescriptorArray2 = new ImageDescriptor[2];
        imageDescriptorArray2[1] = ImagePool.ERROR_OVR;
        this.fTitleImageWithError = new OverlayIcon(ImagePool.ITERATION_PLAN_PERSONAL, imageDescriptorArray2, 17408);
        ImageDescriptor[] imageDescriptorArray3 = new ImageDescriptor[2];
        imageDescriptorArray3[1] = ImagePool.FATALERROR_OVR;
        this.fTitleImageWithFatalError = new OverlayIcon(ImagePool.ITERATION_PLAN_PERSONAL, imageDescriptorArray3, 17408);
        this.fPlanListener = new PlanListener();
        this.fProjectAreaRegistry = ConnectedProjectAreaRegistry.getDefault();
        this.fQuickQueryDefinition = QuickQueryTypeRegistry.getQuickQueryDefinition("com.ibm.team.apt.ide.ui.mywork.quickfilter");
        this.enableAutosave(true);
    }

    public IProjectAreaHandle getProjectArea() {
        return this.fProjectArea;
    }

    public void setProjectArea(IProjectAreaHandle projectAreaHandle) {
        if (projectAreaHandle != null && !projectAreaHandle.sameItemId((IItemHandle)this.fProjectArea)) {
            this.setInput(null);
            this.handleProjectAreaChange(projectAreaHandle);
        }
    }

    public Control getControl() {
        return this.fContainer;
    }

    public ResolvedPersonalPlan getInput() {
        return this.fPlan;
    }

    public void addSelectionListener(ISelectionListener selectionListener) {
        this.fSelectionListeners.add((Object)selectionListener);
    }

    public void removeSelectionListener(ISelectionListener selectionListener) {
        this.fSelectionListeners.remove((Object)selectionListener);
    }

    public void registerPlanViewer(AbstractPlanItemViewerSection planViewer) {
        this.fViewers.add(planViewer);
    }

    public void unregisterPlanViewer(AbstractPlanItemViewerSection planViewer) {
        this.fViewers.remove(planViewer);
    }

    public void notifyPlanSectionActivated(AbstractPlanSection section) {
        if (this.fActionContributor != null) {
            this.fActionContributor.setActiveSection(section);
            this.fActionContributor.refresh(section);
        }
    }

    public void notifyPlanSectionDeactivated(AbstractPlanSection section) {
    }

    public QuickQueryBar getQuickQueryBar() {
        return this.fQuickQueryBar;
    }

    public ISelectionMediator getSelectionMediator() {
        return this.fSelectionMediator;
    }

    public List<ColorizeConfiguration> getColorizeConfigurations() {
        return Collections.unmodifiableList(this.fQuickQueryColorConfigs);
    }

    public void addColorizeConfigListener(IColorizerConfigListener listener) {
        this.fColorizeConfigListeners.add((Object)listener);
    }

    public void removeColorizeConfigListener(IColorizerConfigListener listener) {
        this.fColorizeConfigListeners.remove((Object)listener);
    }

    public AbstractPlanItemViewerSection getCurrentSection() {
        ISection section;
        SectionPart lastSelectedSection = this.getSectionsManager().getLastSelectedSection();
        if (lastSelectedSection != null && (section = lastSelectedSection.getSectionImpl()) instanceof AbstractPlanItemViewerSection) {
            return (AbstractPlanItemViewerSection)section;
        }
        return null;
    }

    public boolean shouldShowQuickStartAffordance() {
        return this.fShowQuickstartAffordance;
    }

    public void disableQuickStartAffordance() {
        this.fShowQuickstartAffordance = false;
    }

    void updateSaveMessages() {
        this.fSaveMessageViewer.refresh();
    }

    void ensureLoggedIn() {
        try {
            TeamRunnable login = new TeamRunnable(){

                protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                    MyWorkView.this.fTeamRepository.login(monitor);
                }
            };
            new ProgressMonitorDialog(this.fContainer.getShell()).run(true, true, (IRunnableWithProgress)login);
        }
        catch (InvocationTargetException e) {
            PlanningUIPlugin.log(Messages.MyWorkView_FAILURE_LOG_IN, e);
        }
        catch (InterruptedException interruptedException) {}
    }

    void dirtyStateChanged() {
        this.firePropertyChange(257);
    }

    void enableAutosave(boolean isAutosave) {
        if (this.fSaveStrategy != null) {
            if (isAutosave == "com.ibm.team.apt.mywork.autosave".equals(this.fSaveStrategy.getId())) {
                return;
            }
            if (this.fSaveMessageViewer != null) {
                this.fSaveMessageViewer.removeInformationMessageListener(this.fSaveStrategy.getMessageListener());
                this.fSaveMessageViewer.setInput(null);
            }
            this.fSaveStrategy.inputChanged(this.fPlan, null);
            this.fSaveStrategy = null;
        }
        this.fSaveStrategy = isAutosave ? new AutoSaveStrategy(this) : new ManualSaveStrategy(this);
        this.fSaveStrategy.inputChanged(null, this.fPlan);
        this.fSaveStrategy.setLoggedIn(this.fCurrentState == State.Connected);
        if (this.fSaveMessageViewer != null) {
            this.fSaveMessageViewer.setInput(this.fSaveStrategy);
            this.fSaveMessageViewer.addInformationMessageListener(this.fSaveStrategy.getMessageListener());
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fProjectAreaRegistry.addListener((IConnectedProjectAreaRegistryListener)this.fProjectAreaListener);
        this.loadPreferences();
    }

    public void createPartControl(Composite parent) {
        this.fContainer = new Composite(parent, 0);
        this.fContainer.setLayout((Layout)new StackLayout());
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fContainer);
        ColorRegistry colorreg = ColorRegistry.getDefault();
        Color background = JazzResources.getColor((ResourceManager)this.fResourceManager, (ColorDescriptor)colorreg.getColorDescriptor((Object)"TEAM_CENTRAL_BACKGROUND"));
        this.fContainer.setBackground(background);
        this.createLoadingContainer(this.fContainer);
        this.createTextContainer(this.fContainer);
        this.createTeamCentralContainer(this.fContainer);
        this.contributeToActionBars();
        this.showPage(this.fTextControl);
        this.updateUIState(null, this.fCurrentState);
        this.initializeView();
    }

    public IMyWorkSettings getSettings() {
        return this.fSettings;
    }

    public void dispose() {
        this.savePreferences();
        this.fIsDisposed = true;
        this.setInput(null);
        if (this.fTeamRepository != null) {
            this.fTeamRepository.removeLoginParticipant(this.fLoginParticipant);
        }
        this.fProjectAreaRegistry.removeListener((IConnectedProjectAreaRegistryListener)this.fProjectAreaListener);
        StateAwareAction[] stateAwareActionArray = this.fActions;
        int n = this.fActions.length;
        int n2 = 0;
        while (n2 < n) {
            StateAwareAction action = stateAwareActionArray[n2];
            action.dispose();
            ++n2;
        }
        if (this.fQuickQueryBar != null) {
            this.fQuickQueryBar.dispose();
        }
        super.dispose();
    }

    private void createLoadingContainer(Composite parent) {
        this.fLoadingControl = new AnimatedLoadingLabel(parent, 0);
        this.fLoadingControl.setFont(JFaceResources.getBannerFont());
    }

    private void createTextContainer(Composite parent) {
        this.fTextControl = new Composite(parent, 0);
        this.fTextControl.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().margins(4, 3).numColumns(2).applyTo(this.fTextControl);
        this.fTextImage = new Label(this.fTextControl, 0);
        GridDataFactory.fillDefaults().align(16384, 128).hint(16, 16).applyTo((Control)this.fTextImage);
        this.fTextImage.setBackground(this.fTextControl.getBackground());
        this.fMessageLink = new Link(this.fTextControl, 64);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.fMessageLink);
        this.fMessageLink.setBackground(this.fTextControl.getBackground());
        this.fMessageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if ("teamarea".equals(event.text)) {
                    IWorkbenchPage page = MyWorkView.this.getSite().getPage();
                    try {
                        IShowInTarget target;
                        IViewPart teamOrganizationView = page.showView("com.ibm.team.process.projectAreaExplorer");
                        if (teamOrganizationView != null && (target = (IShowInTarget)teamOrganizationView.getAdapter(IShowInTarget.class)) != null) {
                            target.show(new ShowInContext(null, (ISelection)new StructuredSelection((Object)MyWorkView.this.fProjectArea)));
                        }
                    }
                    catch (PartInitException e) {
                        MessageDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)Messages.MyWorkView_FAILURE_OPEN_TEAM_ORGANIZATION, (String)e.getMessage());
                    }
                } else if ("projectarea".equals(event.text)) {
                    IWorkbenchPage page = MyWorkView.this.getSite().getPage();
                    EditorUtilities.openProjectAreaEditor((IWorkbenchPage)page, (IProjectAreaHandle)MyWorkView.this.fProjectArea, (String)"processAreaOverview");
                } else if ("refresh".equals(event.text)) {
                    MyWorkView.this.refreshViewer();
                } else if (event.text.equals("login")) {
                    MyWorkView.this.ensureLoggedIn();
                } else if (event.text.equals("setupProjectArea")) {
                    new ConnectProjectAreasAction().run();
                } else if (event.text.equals("selectProjectArea")) {
                    MyWorkView.this.fSelectProjectAreaAction.run();
                }
            }
        });
    }

    private void createTeamCentralContainer(Composite parent) {
        this.fTeamCentralControl = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(1).applyTo(this.fTeamCentralControl);
        this.fSaveMessageViewer = new InformationViewer(this.fTeamCentralControl, 2048);
        this.fSaveMessageViewer.getControl().setLayoutData((Object)new GridData(4, 128, true, false));
        this.fSaveMessageViewer.setComparator(new InformationViewer.MessageComparator());
        this.fSaveMessageViewer.setLabelProvider(new InformationViewer.MessageLabelProvider());
        this.fSaveMessageViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private final Object[] NO_ELEMENTS = new Object[0];

            public Object[] getElements(Object inputElement) {
                return ((AbstractSaveStrategy)inputElement).getMessages().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        if (this.fSaveStrategy != null) {
            this.fSaveMessageViewer.setInput(this.fSaveStrategy);
            this.fSaveMessageViewer.addInformationMessageListener(this.fSaveStrategy.getMessageListener());
        }
        this.fSectionHolder = new Composite(this.fTeamCentralControl, 0);
        this.fSectionHolder.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().grab(true, true).minSize(0, 0).applyTo((Control)this.fSectionHolder);
        this.createQuickFilter(this.fTeamCentralControl);
        super.createPartControl(this.fSectionHolder);
    }

    private void createQuickFilter(Composite parent) {
        this.fQuickQueryBar = new QuickQueryBar(parent, this.fQuickQueryDefinition, this.fQuickQueryContext);
        this.fQuickQueryBar.registerParticipant(new IQuickQueryEntryFinder(){

            @Override
            public QuickQueryMode getMode() {
                return QuickQueryMode.Find;
            }

            @Override
            public boolean isInstalled() {
                for (AbstractPlanItemViewerSection planSection : MyWorkView.this.fViewers) {
                    if (!planSection.getEntryFinder().isInstalled()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void setEnabled(boolean enabled) {
                for (AbstractPlanItemViewerSection planSection : MyWorkView.this.fViewers) {
                    planSection.getEntryFinder().setEnabled(enabled);
                }
            }

            @Override
            public void setExpression(Expression expression) {
                for (AbstractPlanItemViewerSection planSection : MyWorkView.this.fViewers) {
                    planSection.getEntryFinder().setExpression(expression);
                }
                if (expression != null && !MyWorkView.this.fContainer.isDisposed()) {
                    MyWorkView.this.fContainer.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!MyWorkView.this.fContainer.isDisposed()) {
                                this.find(true);
                            }
                        }
                    });
                }
            }

            @Override
            public boolean find(boolean searchAll) {
                AbstractPlanItemViewerSection currentSection = this.getCurrentSection();
                this.clearOtherSectionsSelection(currentSection);
                return currentSection != null && currentSection.getEntryFinder().find(false) || this.findNext(true);
            }

            @Override
            public boolean findNext(boolean searchAll) {
                List<AbstractPlanItemViewerSection> allSections = this.getAllSections();
                AbstractPlanItemViewerSection currentSection = this.getCurrentSection();
                boolean canRestart = searchAll;
                while (true) {
                    if (currentSection == null && canRestart) {
                        if (allSections.size() > 0) {
                            currentSection = allSections.get(0);
                        }
                        canRestart = false;
                        this.beep();
                    }
                    if (currentSection == null) {
                        return false;
                    }
                    this.clearOtherSectionsSelection(currentSection);
                    if (currentSection.getEntryFinder().findNext(false)) {
                        if (this.setCurrentSection(currentSection)) {
                            currentSection.getEntryFinder().findNext(false);
                        }
                        return true;
                    }
                    int currentSectionIndex = allSections.indexOf(currentSection);
                    if (currentSectionIndex >= 0 && currentSectionIndex < allSections.size() - 1) {
                        currentSection = allSections.get(currentSectionIndex + 1);
                        continue;
                    }
                    currentSection = null;
                }
            }

            @Override
            public boolean findPrevious(boolean searchAll) {
                List<AbstractPlanItemViewerSection> allSections = this.getAllSections();
                AbstractPlanItemViewerSection currentSection = this.getCurrentSection();
                boolean canRestart = searchAll;
                while (true) {
                    if (currentSection == null && canRestart) {
                        if (allSections.size() > 0) {
                            currentSection = allSections.get(allSections.size() - 1);
                        }
                        canRestart = false;
                        this.beep();
                    }
                    if (currentSection == null) {
                        return false;
                    }
                    this.clearOtherSectionsSelection(currentSection);
                    if (currentSection.getEntryFinder().findPrevious(false)) {
                        if (this.setCurrentSection(currentSection)) {
                            currentSection.getEntryFinder().findPrevious(false);
                        }
                        return true;
                    }
                    int currentSectionIndex = allSections.indexOf(currentSection);
                    if (currentSectionIndex > 0) {
                        currentSection = allSections.get(currentSectionIndex - 1);
                        continue;
                    }
                    currentSection = null;
                }
            }

            private boolean setCurrentSection(AbstractPlanItemViewerSection currentSection) {
                SectionsManager sectionsManager = MyWorkView.this.getSectionsManager();
                for (Object sectionSlot : sectionsManager.getPerspectivesManager().getCurrentPerspective().getSectionSlots()) {
                    ISection sectionImpl;
                    String sectionId = ((PerspectiveSectionSlot)sectionSlot).getSectionId();
                    SectionPart sectionPart = sectionsManager.getSection(sectionId);
                    if (sectionPart == null || (sectionImpl = sectionPart.getSectionImpl()) != currentSection) continue;
                    sectionsManager.setLastSelectedSection(sectionPart);
                    if (sectionPart.isExpanded()) continue;
                    sectionPart.setSectionExpanded(true, false, true);
                    return true;
                }
                return false;
            }

            private List<AbstractPlanItemViewerSection> getAllSections() {
                ArrayList<AbstractPlanItemViewerSection> result = new ArrayList<AbstractPlanItemViewerSection>();
                SectionsManager sectionsManager = MyWorkView.this.getSectionsManager();
                for (Object sectionSlot : sectionsManager.getPerspectivesManager().getCurrentPerspective().getSectionSlots()) {
                    ISection sectionImpl;
                    String sectionId = ((PerspectiveSectionSlot)sectionSlot).getSectionId();
                    SectionPart sectionPart = sectionsManager.getSection(sectionId);
                    if (sectionPart == null || !((sectionImpl = sectionPart.getSectionImpl()) instanceof AbstractPlanItemViewerSection)) continue;
                    result.add((AbstractPlanItemViewerSection)sectionImpl);
                }
                return result;
            }

            private AbstractPlanItemViewerSection getCurrentSection() {
                AbstractPlanItemViewerSection currentSection = MyWorkView.this.getCurrentSection();
                if (currentSection != null) {
                    return currentSection;
                }
                List<AbstractPlanItemViewerSection> allSections = this.getAllSections();
                return allSections.size() > 0 ? allSections.get(0) : null;
            }

            private void clearOtherSectionsSelection(AbstractPlanItemViewerSection currentSection) {
                Collection<OutlineEntry<?>> selectedEntries = currentSection.getViewModel().getSelectedEntries();
                currentSection.getViewModel().setSelectedEntries(Collections.EMPTY_LIST);
                currentSection.getViewModel().setSelectedEntries(selectedEntries);
            }

            private void beep() {
                final Display display = Display.getDefault();
                display.asyncExec(new Runnable(){

                    public void run() {
                        display.beep();
                    }
                });
            }
        });
    }

    private void contributeToActionBars() {
        this.fActionContributor = new MyWorkActionContributor(this.getViewSite(), this.fQuickQueryBar);
        this.fActionContributor.contributeToActionBar();
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
        this.addPreferences(bars.getMenuManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fShowCurrentAction);
        manager.add((IAction)this.fSaveAction);
    }

    private void addPreferences(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new ContributionItem(){

            public void fill(Menu menu, int index) {
                new MenuItem(menu, 2);
                new ActionContributionItem((IAction)MyWorkView.this.fSelectProjectAreaAction).fill(menu, -1);
                new ActionContributionItem((IAction)MyWorkView.this.fToggleAutosaveAction).fill(menu, -1);
                new ActionContributionItem((IAction)MyWorkView.this.fColorizeAction).fill(menu, -1);
                new MenuItem(menu, 2);
                new ActionContributionItem((IAction)MyWorkView.this.fEditWorkLocationAction).fill(menu, -1);
            }

            public boolean isDynamic() {
                return true;
            }
        });
    }

    protected void addSettingsToMenu(Menu settingsSubMenu) {
        new ActionContributionItem((IAction)this.fConfigureAction).fill(settingsSubMenu, -1);
        new MenuItem(settingsSubMenu, 2);
        super.addSettingsToMenu(settingsSubMenu);
    }

    private void addStateListener(UIStateListener listener) {
        this.fStateListener.add((Object)listener);
    }

    private void removeStateListener(UIStateListener listener) {
        this.fStateListener.remove((Object)listener);
    }

    public void addViewListener(MyWorkViewListener listener) {
        this.fViewListeners.add((Object)listener);
    }

    public void removeViewListener(MyWorkViewListener listener) {
        this.fViewListeners.remove((Object)listener);
    }

    private void updateUIState(State oldState, final State newState) {
        if (this.fContainer == null || this.fContainer.isDisposed()) {
            return;
        }
        UI.asyncExec((Control)this.fContainer, new Runnable(){

            public void run() {
                newState.setUiState(MyWorkView.this);
                Object[] objectArray = MyWorkView.this.fStateListener.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((UIStateListener)listener).notifyStateChange(newState);
                    ++n2;
                }
            }
        });
    }

    private void setUiStateNotConfigured() {
        this.showPage(this.fTextControl);
        this.fTextImage.setImage(this.fResourceManager.createImage(ImagePool.INFO_OBJ));
        this.fTextImage.setEnabled(true);
        boolean hasUninitializedProjectAreas = false;
        ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        ArrayList projectAreas = new ArrayList(registry.getConnectedProjectAreas(null));
        Iterator iterator = projectAreas.iterator();
        while (iterator.hasNext()) {
            if (!this.isUninitializedProjectArea((IProjectAreaHandle)iterator.next())) continue;
            iterator.remove();
            hasUninitializedProjectAreas = true;
        }
        if (projectAreas.isEmpty() && !hasUninitializedProjectAreas) {
            this.fMessageLink.setText(NLS.bind((String)Messages.MyWorkView_HINT_NO_PROJECT_AREA, (Object[])new Object[]{"setupProjectArea"}));
        } else if (projectAreas.size() == 1) {
            this.setProjectArea((IProjectAreaHandle)projectAreas.get(0));
        } else {
            this.fMessageLink.setText(NLS.bind((String)Messages.MyWorkView_HINT_SELECT_PROJECT_AREA, (Object[])new Object[]{"selectProjectArea"}));
        }
    }

    private void setUiStateNotLoggedIn() {
        if (this.fPlan == null || ((StackLayout)this.fContainer.getLayout()).topControl != this.fTeamCentralControl) {
            this.showPage(this.fTextControl);
            ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
            String name = registry.getProjectAreaName(this.fProjectArea);
            this.fMessageLink.setText(NLS.bind((String)Messages.MyWorkView_HINT_NOT_LOGGED_IN, (Object[])new Object[]{name, "login", "selectProjectArea"}));
            this.fTextImage.setImage(this.fResourceManager.createImage(ImagePool.INFO_OBJ));
            this.fTextImage.setEnabled(true);
        }
    }

    private void setUiStateLoading() {
        if (((StackLayout)this.fContainer.getLayout()).topControl != this.fTeamCentralControl) {
            this.showPage(this.fLoadingControl);
            this.fLoadingControl.start(0);
        }
    }

    private void setUiStateConnected() {
        this.showPage(this.fTeamCentralControl);
        if (this.fSaveStrategy != null) {
            this.fSaveStrategy.setLoggedIn(true);
        }
    }

    private void setUiStateError() {
        String message = "";
        Image image = null;
        if (this.fErrorStatus != null) {
            message = this.fErrorStatus.getMessage();
            switch (this.fErrorStatus.getSeverity()) {
                case 1: {
                    image = this.fResourceManager.createImage(ImagePool.INFO_OBJ);
                    break;
                }
                case 2: {
                    image = this.fResourceManager.createImage(ImagePool.WARNING_OBJ);
                    break;
                }
                case 4: {
                    image = this.fResourceManager.createImage(ImagePool.ERROR_OBJ);
                    break;
                }
                case 8: {
                    message = Messages.MyWorkView_FAILURE_LOAD_DATA_CANCELD;
                }
            }
        }
        this.showPage(this.fTextControl);
        this.fTextImage.setImage(image);
        this.fTextImage.setEnabled(true);
        if (this.fErrorStatus != null && this.fErrorStatus.getCode() == 1000) {
            ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
            String name = registry.getProjectAreaName(this.fProjectArea);
            message = MessageFormat.format(Messages.MyWorkView_HINT_NOT_MEMBER, name, "teamarea", "refresh");
        } else if (this.fErrorStatus != null && this.fErrorStatus.getCode() == 1001) {
            message = NLS.bind((String)Messages.MyWorkView_HINT_NO_DEVELOPMENT_LINES, (Object[])new Object[]{"projectarea", "refresh"});
        } else if (this.fErrorStatus != null && this.fErrorStatus.getCode() == 1002) {
            message = NLS.bind((String)Messages.MyWorkView_HINT_NO_DELIVERABLES, (Object[])new Object[]{"projectarea", "refresh"});
        }
        this.fMessageLink.setText(message);
    }

    private void showPage(Composite page) {
        StackLayout stackLayout = (StackLayout)this.fContainer.getLayout();
        if (stackLayout.topControl == page) {
            return;
        }
        if (stackLayout.topControl == this.fLoadingControl) {
            this.fLoadingControl.stop();
        }
        stackLayout.topControl = page;
        this.fContainer.layout(true, true);
    }

    private SectionCurrentWork getTimeline() {
        SectionPart sectionPart = this.getSectionsManager().getSection("com.ibm.team.apt.internal.ui.mywork.SectionMyCurrentWork");
        return (SectionCurrentWork)sectionPart.getSectionImpl();
    }

    /*
     * WARNING - void declaration
     */
    private void setInput(ResolvedPersonalPlan resolvedPlan) {
        void var6_8;
        ResolvedPersonalPlan oldInput = this.fPlan;
        if (oldInput != null) {
            if (this.fIsPlanConnected) {
                this.fPlan.disconnect();
            }
            this.fPlan.removeListener(this.fPlanListener);
            this.fPlan.setItemResolveService(null);
        }
        Status cancelSetInput = null;
        if (resolvedPlan != null) {
            if (!resolvedPlan.isMemberOfProjectArea()) {
                cancelSetInput = new Status(1, PlanningUIPlugin.getPluginId(), 1000, "Logged-in contributor not member of a team area or no development lines configured.", null);
            } else if (resolvedPlan.getDevelopmentLines().size() == 0) {
                cancelSetInput = new Status(1, PlanningUIPlugin.getPluginId(), 1001, "No development lines configured.", null);
            } else {
                boolean foundCurrentIteration = false;
                for (IDevelopmentLine developmentLine : resolvedPlan.getDevelopmentLines()) {
                    IterationHierarchy iterationHierarchy = resolvedPlan.getDevelopmentLineIterationHierarchy((IDevelopmentLineHandle)developmentLine);
                    if (iterationHierarchy == null || iterationHierarchy.getCurrentIteration() == null) continue;
                    foundCurrentIteration = true;
                    break;
                }
                if (!foundCurrentIteration) {
                    cancelSetInput = new Status(1, PlanningUIPlugin.getPluginId(), 1002, Messages.MyWorkView_MSG_NO_DELIVERABLES, null);
                }
            }
        }
        if (cancelSetInput != null) {
            resolvedPlan.disconnect();
            resolvedPlan = null;
        }
        this.fPlan = resolvedPlan;
        this.fErrorStatus = cancelSetInput;
        State newState = State.Connected;
        if (this.fPlan != null) {
            this.fIsPlanConnected = true;
            this.fPlan.addListener(this.fPlanListener);
            this.fPlan.setItemResolveService((IItemResolveService)this);
            this.initializeView();
            this.fPlan.triggerProblemCalculation();
        } else {
            newState = State.Error;
        }
        this.fSaveStrategy.inputChanged(oldInput, this.fPlan);
        Object[] listeners = this.fViewListeners.getListeners();
        boolean bl = false;
        while (var6_8 < listeners.length) {
            ((MyWorkViewListener)listeners[var6_8]).inputChanged(oldInput, this.fPlan);
            ++var6_8;
        }
        for (AbstractPlanSection abstractPlanSection : this.fViewers) {
            this.fActionContributor.refresh(abstractPlanSection);
        }
        if (this.fPlan != null) {
            new Job(Messages.MyWorkView_JOB_INIT_QUICK_COLOR){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    ArrayList configs = new ArrayList(MyWorkView.this.fQuickQueryColorConfigs);
                    monitor.beginTask(Messages.MyWorkView_MONITOR_BUILD_EXPRESSION, configs.size());
                    try {
                        for (ColorizeConfiguration config : configs) {
                            if (monitor.isCanceled()) {
                                break;
                            }
                            Expression expression = QuickQueryHelper.buildExpression(config.getQuery(), MyWorkView.this.fQuickQueryDefinition, MyWorkView.this.fQuickQueryContext, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            List list = MyWorkView.this.fQuickQueryColorConfigs;
                            synchronized (list) {
                                if (MyWorkView.this.fQuickQueryColorConfigs.contains(config)) {
                                    config.setCachedExpression(expression);
                                }
                            }
                            MyWorkView.this.fireColorizeChanged(config);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        this.doStateChange(newState);
    }

    private void fireColorizeChanged(final ColorizeConfiguration changedConfiguration) {
        if (!this.fSectionHolder.isDisposed()) {
            this.fSectionHolder.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!MyWorkView.this.fSectionHolder.isDisposed()) {
                        ColorizerEvent event = new ColorizerEvent(ColorizerEvent.Type.Changed, changedConfiguration);
                        Object[] objectArray = MyWorkView.this.fColorizeConfigListeners.getListeners();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object listener = objectArray[n2];
                            ((IColorizerConfigListener)listener).configChanged(event);
                            ++n2;
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeView() {
        Object object = this.fInitializationLock;
        synchronized (object) {
            if (this.fContainer != null && this.fPlan != null) {
                this.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        MyWorkView.this.firePropertyChange(257);
                    }
                });
            }
        }
    }

    private void doStateChange(State newState) {
        this.updateUIState(this.fCurrentState, newState);
        this.fCurrentState = newState;
    }

    public <T> void deferredResolve(final IDeferredResolver<T> resolver, final IDeferredResolveListener<T> resolveListener, final boolean disableUI) {
        final Job resolveJob = new Job(Messages.MyWorkView_JOB_LOADING_DATA){

            protected IStatus run(IProgressMonitor monitor) {
                Status result = null;
                State oldState = MyWorkView.this.fCurrentState;
                if (disableUI) {
                    MyWorkView.this.doStateChange(State.Loading);
                }
                try {
                    try {
                        Object resolved = resolver.resolve(monitor);
                        resolveListener.resolved(resolved);
                    }
                    catch (TeamRepositoryException e) {
                        result = new Status(4, PlanningUIPlugin.getPluginId(), NLS.bind((String)Messages.MyWorkView_FAILURE_LOAD_DATA, (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                    }
                    if (result != null) {
                        Status finalResult = result;
                        MyWorkView.this.getDisplay().syncExec(new Runnable((IStatus)finalResult){
                            private final /* synthetic */ IStatus val$finalResult;
                            {
                                this.val$finalResult = iStatus;
                            }

                            public void run() {
                                resolveListener.failed(this.val$finalResult);
                            }
                        });
                    }
                }
                finally {
                    if (disableUI && MyWorkView.this.fCurrentState == State.Loading) {
                        MyWorkView.this.doStateChange(oldState);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                MyWorkView.this.getProgressService().schedule(resolveJob, 0L, true);
            }
        });
    }

    public <T> T blockingResolve(final IDeferredResolver<T> resolver) throws TeamRepositoryException {
        final Object[] result = new Object[1];
        final TeamRepositoryException[] resolveException = new TeamRepositoryException[1];
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    MyWorkView.this.getProgressService().run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(Messages.MyWorkView_MONITOR_LOADING_ADDITIONAL_DATA, 1);
                            try {
                                State oldState = MyWorkView.this.fCurrentState;
                                MyWorkView.this.doStateChange(State.Loading);
                                try {
                                    try {
                                        result[0] = resolver.resolve((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    }
                                    catch (TeamRepositoryException e) {
                                        resolveException[0] = e;
                                        if (MyWorkView.this.fCurrentState == State.Loading) {
                                            MyWorkView.this.doStateChange(oldState);
                                        }
                                    }
                                }
                                finally {
                                    if (MyWorkView.this.fCurrentState == State.Loading) {
                                        MyWorkView.this.doStateChange(oldState);
                                    }
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    resolveException[0] = new TeamRepositoryException((Throwable)e);
                }
                catch (InterruptedException e) {
                    resolveException[0] = new TeamRepositoryException((Throwable)e);
                }
            }
        });
        if (resolveException[0] != null) {
            throw resolveException[0];
        }
        return (T)result[0];
    }

    public int promptToSaveOnClose() {
        if (this.fPlan == null) {
            return 1;
        }
        if (this.fPlan.isDirty()) {
            return 3;
        }
        if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.MyWorkView_ITEM_UPDATES, (String)Messages.MyWorkView_ITEM_UPDATES_DETAILS)) {
            return 0;
        }
        return 1;
    }

    public void doSave(IProgressMonitor monitor) {
        this.fSaveStrategy.doSave(monitor);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        if (this.fPlan == null) {
            return false;
        }
        return this.fPlan.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        if (this.fPlan == null) {
            return false;
        }
        return this.fPlan.isDirty();
    }

    private IWorkbenchSiteProgressService getProgressService() {
        return (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
    }

    private Display getDisplay() {
        return this.getSite().getShell().getDisplay();
    }

    private void handleProjectAreaChange(IProjectAreaHandle projectArea) {
        if (this.fTeamRepository != null) {
            this.fTeamRepository.removeLoginParticipant(this.fLoginParticipant);
        }
        this.fProjectArea = projectArea;
        this.doStateChange(State.NotLoggedIn);
        this.fTeamRepository = (ITeamRepository)this.fProjectArea.getOrigin();
        this.fTeamRepository.addLoginParticipant(this.fLoginParticipant);
        if (this.fTeamRepository.loggedIn()) {
            this.fLoginParticipant.handleLogin(this.fTeamRepository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPreferences() {
        String projectAreaString;
        IPreferenceStore preferences;
        block15: {
            preferences = PlanningUIPlugin.getDefault().getPreferenceStore();
            String serializedSettings = preferences.getString("settings");
            if (serializedSettings != null && serializedSettings.length() > 0) {
                try {
                    XMLMemento settingsMemento = XMLMemento.createReadRoot((Reader)new StringReader(serializedSettings));
                    this.fSettings.loadState((IMemento)settingsMemento);
                    IMemento colorizeMemento = settingsMemento.getChild(SETTINGS_MEMENTO_COLORIZE);
                    if (colorizeMemento == null) break block15;
                    IMemento[] children = colorizeMemento.getChildren(SETTINGS_MEMENTO_COLORIZECONFIG);
                    List<ColorizeConfiguration> list = this.fQuickQueryColorConfigs;
                    synchronized (list) {
                        IMemento[] iMementoArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMemento configurationMemento = iMementoArray[n2];
                            ColorizeConfiguration configuration = new ColorizeConfiguration();
                            configuration.readState(configurationMemento);
                            this.fQuickQueryColorConfigs.add(configuration);
                            ++n2;
                        }
                        Collections.sort(this.fQuickQueryColorConfigs, new Comparator<ColorizeConfiguration>(){

                            @Override
                            public int compare(ColorizeConfiguration o1, ColorizeConfiguration o2) {
                                return o1.getPriority() - o2.getPriority();
                            }
                        });
                        int i = 0;
                        while (i < this.fQuickQueryColorConfigs.size()) {
                            this.fQuickQueryColorConfigs.get(i).setPriority(i);
                            ++i;
                        }
                    }
                }
                catch (WorkbenchException e) {
                    PlanningUIPlugin.log(e);
                }
            }
        }
        if ((projectAreaString = preferences.getString(STATE_PROJECT_AREA)) != null && projectAreaString.length() > 0) {
            try {
                UUID projectAreaId = UUID.valueOf((String)projectAreaString);
                for (IProjectAreaHandle projectArea : this.fProjectAreaRegistry.getConnectedProjectAreas(null, true)) {
                    if (!projectArea.getItemId().equals((Object)projectAreaId)) continue;
                    this.fProjectArea = projectArea;
                    break;
                }
            }
            catch (IllegalArgumentException e) {
                PlanningUIPlugin.log(e);
            }
        }
        this.enableAutosave(!preferences.contains(STATE_AUTOSAVE) || Boolean.valueOf(preferences.getString(STATE_AUTOSAVE)) != false);
        if (this.fProjectArea == null) {
            this.fProjectArea = ConnectedProjectAreas.getInstance().getDefaultProjectArea(true);
            if (this.fProjectArea != null && this.isUninitializedProjectArea(this.fProjectArea)) {
                this.fProjectArea = null;
            }
        }
        if (this.fProjectArea != null) {
            this.handleProjectAreaChange(this.fProjectArea);
        }
    }

    private boolean isUninitializedProjectArea(IProjectAreaHandle projectAreaHandle) {
        IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)projectAreaHandle).itemManager();
        IProjectArea projectArea = (IProjectArea)itemManager.getSharedItemIfKnown((IItemHandle)projectAreaHandle);
        return projectArea != null && !projectArea.isInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePreferences() {
        IPreferenceStore preferences = PlanningUIPlugin.getDefault().getPreferenceStore();
        if (this.fProjectArea != null) {
            preferences.putValue(STATE_PROJECT_AREA, this.fProjectArea.getItemId().getUuidValue());
        }
        preferences.putValue(STATE_AUTOSAVE, Boolean.valueOf("com.ibm.team.apt.mywork.autosave".equals(this.fSaveStrategy.getId())).toString());
        XMLMemento settingsMemento = XMLMemento.createWriteRoot((String)"settings");
        this.fSettings.saveState((IMemento)settingsMemento);
        IMemento colorizeMemento = settingsMemento.createChild(SETTINGS_MEMENTO_COLORIZE);
        List<ColorizeConfiguration> list = this.fQuickQueryColorConfigs;
        synchronized (list) {
            for (ColorizeConfiguration configuration : this.fQuickQueryColorConfigs) {
                configuration.saveState(colorizeMemento.createChild(SETTINGS_MEMENTO_COLORIZECONFIG));
            }
        }
        this.fSettings.saveState((IMemento)settingsMemento);
        try {
            StringWriter writer = new StringWriter();
            settingsMemento.save((Writer)writer);
            preferences.setValue("settings", writer.toString());
        }
        catch (IOException e) {
            PlanningUIPlugin.log(e);
        }
    }

    protected void initFromMemento(IMemento memento) {
        super.initFromMemento(memento);
        if (memento.getString(PREF_SHOW_QUICKSTARTAFFORDANCE) != null) {
            this.fShowQuickstartAffordance = Boolean.valueOf(memento.getString(PREF_SHOW_QUICKSTARTAFFORDANCE));
        }
    }

    protected void saveStateToMemento(IMemento memento) {
        super.saveStateToMemento(memento);
        memento.putString(PREF_SHOW_QUICKSTARTAFFORDANCE, String.valueOf(this.fShowQuickstartAffordance));
    }

    protected ImageDescriptor getTitleImageDescriptor() {
        PlanProblemReport report;
        ImageDescriptor result = ImagePool.ITERATION_PLAN_PERSONAL;
        if (this.fCurrentState == State.Connected && this.fPlan != null && (report = this.fPlan.getProblemReport()) != null) {
            if (report.isSeverity(Problem.Severity.FATAL_ERROR)) {
                result = this.fTitleImageWithFatalError;
            } else if (report.isSeverity(Problem.Severity.ERROR)) {
                result = this.fTitleImageWithError;
            } else if (report.isSeverity(Problem.Severity.WARNING)) {
                result = this.fTitleImageWithWarning;
            }
        }
        return result;
    }

    private boolean refreshViewer() {
        if (this.isDirty() && !MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.MyWorkView_TITLE_REFRESH, (String)Messages.MyWorkView_REFREH_CONFIRMATION)) {
            return false;
        }
        Object resolver = null;
        resolver = this.fCurrentState == State.Connected ? new RefreshResolver() : new LoadResolver();
        this.deferredResolve((IDeferredResolver)resolver, new PlanLoadListener(), true);
        return true;
    }

    protected void refreshAll() {
        boolean doRefresh = true;
        if (this.fCurrentState == State.Connected || this.fCurrentState == State.Error) {
            doRefresh = this.refreshViewer();
        }
        if (doRefresh) {
            super.refreshAll();
        }
    }

    public IMyWorkViewTestAccess testAccess() {
        return this.fTestAccess;
    }

    private class EditWorkLocationAction
    extends StateAwareAction {
        public EditWorkLocationAction() {
            super(Messages.MyWorkView_EDIT_WORK_LOCATION_ACTION_LABEL, State.Connected);
        }

        public void run() {
            EditorUtilities.openContributorEditor((IWorkbenchPage)MyWorkView.this.getSite().getPage(), (IContributorHandle)MyWorkView.this.fPlan.getPlanOwner(), (String)"com.ibm.team.apt.resource.work.location.page");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoadResolver
    implements IDeferredResolver<ResolvedPersonalPlan> {
        private LoadResolver() {
        }

        public ResolvedPersonalPlan resolve(IProgressMonitor monitor) throws TeamRepositoryException {
            try {
                ResolvedPersonalPlan resolvedPlan = null;
                int loadCount = MyWorkView.this.fIsLoading.getAndIncrement();
                if (loadCount == 0) {
                    monitor.beginTask(Messages.MyWorkView_MONITOR_LOADING_DATA, 2);
                    Assert.isTrue((MyWorkView.this.fTeamRepository != null && MyWorkView.this.fProjectArea != null ? 1 : 0) != 0);
                    IIterationPlanClient client = (IIterationPlanClient)MyWorkView.this.fTeamRepository.getClientLibrary(IIterationPlanClient.class);
                    resolvedPlan = client.fetchPersonalPlan(MyWorkView.this.fProjectArea, (IContributorHandle)MyWorkView.this.fTeamRepository.loggedInContributor(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    resolvedPlan.connect((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                ResolvedPersonalPlan resolvedPersonalPlan = resolvedPlan;
                return resolvedPersonalPlan;
            }
            finally {
                MyWorkView.this.fIsLoading.decrementAndGet();
                monitor.done();
            }
        }
    }

    private class MarkAllReadAction
    extends StateAwareAction {
        public MarkAllReadAction() {
            super(Messages.MyWorkView_MARK_ALL_READ_ACTION_LABEL, State.Connected);
        }

        public void run() {
            for (PlanItem planItem : MyWorkView.this.fPlan.getAllPlanItems()) {
                planItem.markRead();
            }
        }
    }

    private class PersonalPlanViewLoginParticipant
    implements ITeamRepository.ILoginParticipant {
        private PersonalPlanViewLoginParticipant() {
        }

        public void handleLogin(ITeamRepository repository) {
            if (MyWorkView.this.fPlan == null) {
                MyWorkView.this.deferredResolve(new LoadResolver(), new PlanLoadListener(), true);
            } else if (!MyWorkView.this.fPlan.getPlanOwner().sameItemId((IItemHandle)repository.loggedInContributor())) {
                MyWorkView.this.setInput(null);
                MyWorkView.this.deferredResolve(new LoadResolver(), new PlanLoadListener(), true);
            } else {
                MyWorkView.this.doStateChange(State.Connected);
            }
            if (MyWorkView.this.fSaveStrategy != null) {
                MyWorkView.this.fSaveStrategy.setLoggedIn(true);
            }
        }

        public void handleLogout(ITeamRepository repository) {
            MyWorkView.this.doStateChange(State.NotLoggedIn);
            if (MyWorkView.this.fSaveStrategy != null) {
                MyWorkView.this.fSaveStrategy.setLoggedIn(false);
            }
        }
    }

    private class PlanListener
    implements IPlanElementListener {
        private PlanListener() {
        }

        public void planElementChanged(IPlanElementChangeEvent event) {
            ResolvedPersonalPlan plan = MyWorkView.this.fPlan;
            IPlanElementDelta delta = event.getDelta();
            delta.accept(new IPlanElementDeltaVisitor((ResolvedPlan)plan){
                private final /* synthetic */ ResolvedPlan val$plan;
                {
                    this.val$plan = resolvedPlan;
                }

                public boolean visit(IPlanElementDelta delta) {
                    PlanElement element = delta.getPlanElement();
                    if (this.val$plan == element) {
                        UIJob job;
                        if (delta.getAttributeDelta(ResolvedPlan.DIRTY) != null) {
                            job = new UIJob(MyWorkView.this.getSite().getShell().getDisplay(), Messages.MyWorkView_JOB_UPDATE_EDITOR_STATE){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    MyWorkView.this.firePropertyChange(257);
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setSystem(true);
                            job.schedule();
                        }
                        if (delta.affectsAttribute(PlanElement.PROBLEM_REPORT)) {
                            job = new UIJob(MyWorkView.this.getSite().getShell().getDisplay(), Messages.MyWorkView_JOB_UPDATE_EDITOR_ICON){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    if (!MyWorkView.this.fIsDisposed) {
                                        MyWorkView.this.updateTitleImage();
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setSystem(true);
                            job.schedule();
                        }
                    }
                    return true;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlanLoadListener
    implements IDeferredResolveListener<ResolvedPersonalPlan> {
        private PlanLoadListener() {
        }

        public void resolved(ResolvedPersonalPlan result) {
            if (result != null) {
                MyWorkView.this.setInput(result);
            }
        }

        public void canceled() {
            MyWorkView.this.setInput(null);
            MyWorkView.this.fErrorStatus = Status.CANCEL_STATUS;
            MyWorkView.this.doStateChange(State.Error);
        }

        public void failed(IStatus state) {
            MyWorkView.this.setInput(null);
            MyWorkView.this.fErrorStatus = state;
            MyWorkView.this.doStateChange(State.Error);
        }
    }

    private class PreferencesAction
    extends StateAwareAction {
        public PreferencesAction() {
            super(Messages.MyWorkView_PREFERENCES_ACTION_LABEL, State.Connected);
        }

        public void run() {
            new MyWorkPreferencesDialog(MyWorkView.this.fContainer.getShell(), MyWorkView.this.fSettings).open();
        }
    }

    private class ProjectAreaListener
    implements IConnectedProjectAreaRegistryListener {
        private ProjectAreaListener() {
        }

        public void connectedProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
            if (MyWorkView.this.fCurrentState == State.NotConfigured) {
                MyWorkView.this.updateUIState(MyWorkView.this.fCurrentState, MyWorkView.this.fCurrentState);
            } else if (changeEvent.getRemovedProjectArea() != null && changeEvent.getRemovedProjectArea().sameItemId((IItemHandle)MyWorkView.this.fProjectArea)) {
                MyWorkView.this.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        if (MyWorkView.this.fTeamRepository != null) {
                            MyWorkView.this.fTeamRepository.removeLoginParticipant(MyWorkView.this.fLoginParticipant);
                        }
                        MyWorkView.this.fTeamRepository = null;
                        MyWorkView.this.fProjectArea = null;
                        MyWorkView.this.setInput(null);
                        MyWorkView.this.doStateChange(State.NotConfigured);
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QuickColorizeAction
    extends StateAwareAction {
        public QuickColorizeAction() {
            super(Messages.MyWorkView_QUICK_COLORIZE_ACTION_LABEL, State.Connected);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList<ColorizeConfiguration> colorConfigs;
            List list = MyWorkView.this.fQuickQueryColorConfigs;
            synchronized (list) {
                colorConfigs = new ArrayList<ColorizeConfiguration>(MyWorkView.this.fQuickQueryColorConfigs);
            }
            ColorizeDialog colorizeDialog = new ColorizeDialog(MyWorkView.this.fContainer.getShell(), MyWorkView.this.fQuickQueryDefinition, (ResolvedPlan)MyWorkView.this.fPlan, colorConfigs);
            if (colorizeDialog.open() == 0) {
                List list2 = MyWorkView.this.fQuickQueryColorConfigs;
                synchronized (list2) {
                    MyWorkView.this.fQuickQueryColorConfigs.clear();
                    MyWorkView.this.fQuickQueryColorConfigs.addAll(colorizeDialog.getConfigurations());
                }
                this.fireColorizeEvent(ColorizerEvent.Type.Added, colorizeDialog.getAddedConfigurations());
                this.fireColorizeEvent(ColorizerEvent.Type.Changed, colorizeDialog.getChangedConfigurations());
                this.fireColorizeEvent(ColorizerEvent.Type.Removed, colorizeDialog.getRemovedConfigurations());
            }
        }

        private void fireColorizeEvent(ColorizerEvent.Type type, Collection<ColorizeConfiguration> appliesTo) {
            Object[] listeners = MyWorkView.this.fColorizeConfigListeners.getListeners();
            for (ColorizeConfiguration configuration : appliesTo) {
                ColorizerEvent event = new ColorizerEvent(type, configuration);
                Object[] objectArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IColorizerConfigListener)listener).configChanged(event);
                    ++n2;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RefreshResolver
    implements IDeferredResolver<ResolvedPersonalPlan> {
        private RefreshResolver() {
        }

        public ResolvedPersonalPlan resolve(IProgressMonitor monitor) throws TeamRepositoryException {
            monitor.beginTask(Messages.MyWorkView_MONITOR_LOADING_DATA, 3);
            try {
                ResolvedPersonalPlan oldPlan = MyWorkView.this.fPlan;
                IIterationPlanClient client = PlanningClientPlugin.getIterationPlanClient((ITeamRepository)oldPlan.getTeamRepository());
                ResolvedPersonalPlan newPlan = client.fetchPersonalPlan((IProjectAreaHandle)oldPlan.getProjectArea(), (IContributorHandle)oldPlan.getPlanOwner(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                oldPlan.disconnect();
                oldPlan.waitForDisconnect((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                MyWorkView.this.fIsPlanConnected = false;
                if (newPlan != null) {
                    newPlan.connect((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                ResolvedPersonalPlan resolvedPersonalPlan = newPlan;
                return resolvedPersonalPlan;
            }
            finally {
                monitor.done();
            }
        }
    }

    private class SaveAction
    extends StateAwareAction {
        public SaveAction() {
            super(Messages.MyWorkView_SAVE_ACTION_LABEL, ImagePool.SAVE_ENABLED, State.Connected, State.NotLoggedIn);
            this.setDisabledImageDescriptor(ImagePool.SAVE_DISABLED);
            this.setEnabled(false);
            MyWorkView.this.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (257 == propId && !MyWorkView.this.fIsDisposed) {
                        SaveAction.this.setEnabled(MyWorkView.this.isDirty());
                    }
                }
            });
        }

        public void notifyStateChange(State newState) {
            this.setEnabled((newState == State.Connected || newState == State.NotLoggedIn) && MyWorkView.this.fPlan != null && MyWorkView.this.fPlan.isDirty());
        }

        public void run() {
            MyWorkView.this.fSaveStrategy.doSave(null);
        }
    }

    private class SelectProjectAreaAction
    extends StateAwareAction {
        public SelectProjectAreaAction() {
            super(Messages.MyWorkView_SELECT_PROJECT_AREA_ACTION_LABEL, State.values());
        }

        public void run() {
            MyWorkView.this.setProjectArea(this.showDialog());
        }

        private IProjectAreaHandle showDialog() {
            List projectAreas = ProjectAreaPicker.getAllConnectedProjectAreas((boolean)true);
            Collections.sort(projectAreas, ProjectAreaPicker.fgProjectAreaComparator);
            ProjectAreaPicker.ProjectAreaLabelProvider labelProvider = new ProjectAreaPicker.ProjectAreaLabelProvider(projectAreas);
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(MyWorkView.this.fContainer.getShell(), (ILabelProvider)labelProvider);
            dialog.setTitle(Messages.MyWorkView_TITLE_SELECT_PROJECT_AREA);
            dialog.setMessage(Messages.MyWorkView_MSG_SELECT_PROJECT_AREA);
            dialog.setElements(projectAreas.toArray());
            dialog.open();
            IProjectAreaHandle result = (IProjectAreaHandle)dialog.getFirstResult();
            labelProvider.dispose();
            return result;
        }
    }

    private class SelectionMediator
    implements ISelectionMediator {
        private SelectionMediator() {
        }

        public void setSelection(ISelection selection, boolean reveal) {
            for (AbstractPlanItemViewerSection section : MyWorkView.this.fViewers) {
                MyWorkViewer viewer = (MyWorkViewer)section.getViewModel().getViewer();
                if (viewer == null) continue;
                viewer.internalSetSelection(selection, reveal);
            }
        }
    }

    private class ShowCurrentAction
    extends StateAwareAction {
        public ShowCurrentAction() {
            super(Messages.MyWorkView_SHOW_CURRENT_ACTION_LABEL, ImagePool.SHOW_TODAY, State.Connected);
        }

        public void run() {
            SectionCurrentWork timeline = MyWorkView.this.getTimeline();
            if (timeline != null) {
                timeline.showCurrent();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NotConfigured{

            public void setUiState(MyWorkView view) {
                view.setUiStateNotConfigured();
            }
        }
        ,
        NotLoggedIn{

            public void setUiState(MyWorkView view) {
                view.setUiStateNotLoggedIn();
            }
        }
        ,
        Loading{

            public void setUiState(MyWorkView view) {
                view.setUiStateLoading();
            }
        }
        ,
        Connected{

            public void setUiState(MyWorkView view) {
                view.setUiStateConnected();
            }
        }
        ,
        Error{

            public void setUiState(MyWorkView view) {
                view.setUiStateError();
            }
        };


        public abstract void setUiState(MyWorkView var1);
    }

    private abstract class StateAwareAction
    extends Action
    implements UIStateListener {
        private final State[] fActiveStates;

        public StateAwareAction(String text, State ... activeStates) {
            super(text);
            this.fActiveStates = activeStates;
            MyWorkView.this.addStateListener(this);
        }

        public StateAwareAction(String text, ImageDescriptor image, State ... activeStates) {
            super(text, image);
            this.fActiveStates = activeStates;
            MyWorkView.this.addStateListener(this);
        }

        public StateAwareAction(String text, int style, State ... activeStates) {
            super(text, style);
            this.fActiveStates = activeStates;
            MyWorkView.this.addStateListener(this);
        }

        public void notifyStateChange(State newState) {
            boolean enabled = false;
            State[] stateArray = this.fActiveStates;
            int n = this.fActiveStates.length;
            int n2 = 0;
            while (n2 < n) {
                State state = stateArray[n2];
                if (state == newState) {
                    enabled = true;
                    break;
                }
                ++n2;
            }
            this.setEnabled(enabled);
        }

        public void dispose() {
            MyWorkView.this.removeStateListener(this);
        }
    }

    private class ToggleAutosaveAction
    extends StateAwareAction {
        public ToggleAutosaveAction() {
            super(Messages.MyWorkView_AUTOSAVE_CHANGES, 2, State.Connected);
        }

        public boolean isChecked() {
            return "com.ibm.team.apt.mywork.autosave".equals(MyWorkView.this.fSaveStrategy.getId());
        }

        public void run() {
            MyWorkView.this.enableAutosave(!this.isChecked());
        }
    }

    private static interface UIStateListener {
        public void notifyStateChange(State var1);
    }
}

