/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.OutOfOfficeItem;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GFadeableTreeNodeContent;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IColumnBasedGadget;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkOutOfOfficeGadget;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GHTMLText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GImage;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.TextFonts;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;

public class MyWorkOutOfOfficeNodeContent
extends GFadeableTreeNodeContent
implements IColumnBasedGadget {
    private OutOfOfficeItem fAbsence;
    private GImage fTypeImage;
    private GText fSummary;
    private GText fDetails;

    public MyWorkOutOfOfficeNodeContent(MyWorkOutOfOfficeGadget parent, OutOfOfficeItem absence) {
        super(parent);
        this.fAbsence = absence;
        MyWorkResources resources = this.getTimelineResources();
        this.fTypeImage = new GImage(this, resources.getOutOfOfficeImage());
        TextFonts fonts = resources.getTextFonts();
        Font summaryFont = fonts.getNormalFont();
        this.fSummary = new GText(this, 0);
        this.fSummary.setFont(summaryFont);
        this.fSummary.setColor(resources.getSummaryColor());
        String summary = absence.getHTMLSummary().getPlainText();
        if (summary.trim().length() == 0) {
            summary = Messages.MyWorkOutOfOfficeNodeContent_LABEL;
        }
        this.fSummary.setText(summary);
        String absenceDetails = MessageFormat.format(Messages.MyWorkOutOfOfficeNodeContent_DESCRIPTION, this.fAbsence.getStart(), this.fAbsence.getEnd());
        this.fDetails = new GHTMLText(this);
        this.fDetails.setText(absenceDetails);
    }

    public Object getElement() {
        return this.fAbsence;
    }

    public int getColumnCount() {
        return 1;
    }

    public int getColumnWidth(int index) {
        Assert.isLegal((index == 0 ? 1 : 0) != 0);
        return Math.max(this.fSummary.computeMaximumWidth(), this.fDetails.computeMaximumWidth());
    }

    public int computeMinimalWidth() {
        MyWorkResources resources = this.getTimelineResources();
        int image = this.fTypeImage.computeMinimalWidth();
        int summary = this.fSummary.computeMinimalWidth();
        int details = this.showDetails() ? this.fDetails.computeMinimalWidth() : 0;
        return this.max(image + resources.getIconSummarySpacing() + summary, details);
    }

    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        int detailsWidth = 0;
        int startY = y;
        MyWorkResources resources = this.getTimelineResources();
        this.fTypeImage.layout(x, y, -1, -1);
        int tx = x + this.fTypeImage.getWidth() + resources.getIconSummarySpacing();
        int maxSummaryWidth = wHint - tx;
        if (this.fSummary.computeMaximumWidth() > maxSummaryWidth) {
            this.fSummary.layout(tx, y, maxSummaryWidth, -1);
        } else {
            this.fSummary.layout(tx, y, -1, -1);
        }
        this.fSummary.setMaximumWidth(maxSummaryWidth);
        boolean showDetails = this.showDetails();
        this.fDetails.setExclude(!showDetails);
        y += this.max(this.fTypeImage.getHeight(), this.fSummary.getHeight());
        if (showDetails) {
            this.fDetails.layout(x + this.getImageWhiteSpace(), y += resources.getDescriptionSpacing(), wHint, -1);
            y += this.fDetails.getHeight();
            detailsWidth = this.fDetails.getWidth();
        }
        int width = this.max(wHint, this.fTypeImage.getWidth() + resources.getIconSummarySpacing() + this.fSummary.getWidth(), detailsWidth + this.getImageWhiteSpace());
        return new Point(width, y - startY);
    }

    private MyWorkResources getTimelineResources() {
        return (MyWorkResources)this.getOutlineResources();
    }

    private int getImageWhiteSpace() {
        return 2;
    }

    protected int getAlphaValue() {
        return this.fAbsence.isResolved() ? 120 : 255;
    }

    protected Color getBackgroundColor() {
        return this.getOutline().getBackground();
    }

    private boolean isExpanded() {
        return ((MyWorkOutOfOfficeGadget)this.getParent()).isShowDetails();
    }

    private boolean showDetails() {
        return this.isExpanded();
    }
}

