/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.Attribute;
import com.ibm.team.apt.internal.client.EstimateMode;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.DurationAttribute;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GFadeableTreeNodeContent;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.PriorityDropDownAction;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IColumnBasedGadget;
import com.ibm.team.apt.internal.ide.ui.mywork.GColumnBox;
import com.ibm.team.apt.internal.ide.ui.mywork.GExpandableTreeNode;
import com.ibm.team.apt.internal.ide.ui.mywork.GMyWorkDuration;
import com.ibm.team.apt.internal.ide.ui.mywork.IMyWorkSettings;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkCanvas;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkItemGadget;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GButton;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GImage;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Gadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.TextFonts;
import com.ibm.team.workitem.common.model.IPriority;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class MyWorkItemNodeContent
extends GFadeableTreeNodeContent
implements IColumnBasedGadget {
    private static final String[] LABEL_PROPERTIES = new String[]{PlanItem.DIRTY.getName(), PlanItem.ITEM_TYPE.getName(), PlanItem.PRIORITY.getName(), PlanItem.SUMMARY.getName(), PlanItem.ID.getName(), PlanItem.ESTIMATE.getName(), PlanItem.DURATION.getName(), PlanItem.ORIGINAL_ESTIMATE.getName(), PlanItem.CORRECTED_ESTIMATE.getName(), PlanItem.TIMESPENT.getName(), PlanItem.FIXEDSTARTDATE.getName(), PlanItem.DUE_DATE.getName(), PlanItem.MARKED_READ.getName(), PlanItem.DRAFT_ITEM.getName(), PlanItem.STATE.getName(), PlanItem.PROBLEM_REPORT.getName()};
    private PlanItem fPlanItem;
    private GImage fTypeImage;
    private GButton fImportanceGadget;
    private GText fSummary;
    private GMyWorkDuration fEstimateControl;
    private GColumnBox fPlanningControls;

    static {
        Arrays.sort(LABEL_PROPERTIES);
    }

    public MyWorkItemNodeContent(MyWorkItemGadget parent, PlanItem planItem) {
        super(parent);
        this.fPlanItem = planItem;
        MyWorkResources resources = this.getTimelineResources();
        HashSet<Attribute> handled = new HashSet<Attribute>();
        handled.add(PlanItem.SUMMARY);
        Image workItemImage = resources.getWorkItemLabelProvider().getImage((Object)planItem.getWorkItem(false));
        this.fTypeImage = new GImage(this, workItemImage);
        Image importanceImage = this.getImportanceImage();
        this.fImportanceGadget = new GButton(this, importanceImage, 1024);
        this.fImportanceGadget.setAction((IAction)this.getImportanceAction());
        this.fEstimateControl = new GMyWorkDuration((CompositeGadget)this, planItem, DurationAttribute.ESTIMATE);
        this.fEstimateControl.setLabelWidth(resources.getDurationLabelWidth());
        TextFonts fonts = resources.getTextFonts();
        Font summaryFont = planItem.isMarkedRead() ? fonts.getNormalFont() : fonts.getBoldFont();
        this.fSummary = new GText(this, resources.isSingleClickMode() ? 2048 : 0);
        this.fSummary.setFont(summaryFont);
        this.fSummary.setColor(resources.getSummaryColor());
        this.fSummary.setText(planItem.getHTMLSummary().getPlainText());
        this.fPlanningControls = new GColumnBox(this);
        this.fPlanningControls.setHorizontalSpacing(15);
        this.contributeToPlanningControls(this.fPlanningControls);
    }

    public Object getElement() {
        return this.fPlanItem;
    }

    public GText getSummary() {
        return this.fSummary;
    }

    public int getColumnCount() {
        return 1;
    }

    public int getColumnWidth(int index) {
        Assert.isLegal((index == 0 ? 1 : 0) != 0);
        return this.computeMinimalWidth();
    }

    public int computeMinimalWidth() {
        MyWorkResources resources = this.getTimelineResources();
        int image = this.fTypeImage.computeMinimalWidth();
        int priority = this.fImportanceGadget.computeMinimalWidth();
        int summary = this.fSummary.computeMinimalWidth();
        int estimate = resources.getSummaryDurationSpacing() + this.fEstimateControl.computeMinimalWidth();
        int summaryIndent = image + resources.getTypePrioSpacing() + priority + resources.getIconSummarySpacing();
        int planningControls = 0;
        if (this.showPlanningDetails()) {
            planningControls = summaryIndent + this.fPlanningControls.computeMinimalWidth();
        }
        return this.max(summaryIndent + summary + estimate, summaryIndent + planningControls);
    }

    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        int planningControlsWidth = 0;
        int startY = y;
        MyWorkResources resources = this.getTimelineResources();
        boolean showPlanningDetails = this.showPlanningDetails();
        this.fTypeImage.layout(x, y, -1, -1);
        int tx = x + this.fTypeImage.getWidth() + resources.getTypePrioSpacing();
        this.fImportanceGadget.layout(tx, y, -1, -1);
        int tWidth = wHint;
        this.fEstimateControl.layout(x, y, -1, -1);
        int estimateWidth = this.fEstimateControl.getWidth() + resources.getSummaryDurationSpacing();
        this.fEstimateControl.move(wHint - this.fEstimateControl.getWidth(), 0);
        int maxSummaryWidth = tWidth - ((tx += this.fImportanceGadget.getWidth() + resources.getIconSummarySpacing()) - x) - estimateWidth;
        if (this.fSummary.computeMaximumWidth() > maxSummaryWidth) {
            this.fSummary.layout(tx, y, maxSummaryWidth, -1);
        } else {
            this.fSummary.layout(tx, y, -1, -1);
        }
        this.fSummary.setMaximumWidth(maxSummaryWidth);
        tWidth -= this.getImageWhiteSpace();
        x += this.getImageWhiteSpace();
        int summaryIndent = this.fTypeImage.getWidth() + resources.getTypePrioSpacing() + this.fImportanceGadget.getWidth() + resources.getIconSummarySpacing();
        y += this.max(this.fTypeImage.getHeight(), this.fSummary.getHeight());
        this.fPlanningControls.setExclude(!showPlanningDetails);
        if (showPlanningDetails) {
            this.fPlanningControls.layout(tx, y += resources.getDescriptionSpacing(), tWidth - summaryIndent, -1);
            y += this.fPlanningControls.getHeight();
            planningControlsWidth = this.fPlanningControls.getWidth();
            y += resources.getStatusSpacing();
        }
        int width = this.max(wHint, summaryIndent + this.fSummary.getWidth() + estimateWidth, summaryIndent + planningControlsWidth);
        return new Point(width, y - startY);
    }

    protected Point relayout(int x, int y, int deltaWidth, int deltaHeight, Gadget changedChild) {
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        if (changedChild == this.fSummary) {
            height += deltaHeight;
            if (!this.fPlanningControls.isExcluded()) {
                this.fPlanningControls.move(0, deltaHeight);
            }
        }
        return new Point(width, height);
    }

    private MyWorkResources getTimelineResources() {
        return (MyWorkResources)this.getOutlineResources();
    }

    private IMyWorkSettings getMyWorkSettings() {
        return ((MyWorkCanvas)this.getOutline()).getSettings();
    }

    private int getImageWhiteSpace() {
        return 2;
    }

    protected int getAlphaValue() {
        return this.fPlanItem.isResolved() ? 120 : 255;
    }

    protected Color getBackgroundColor() {
        return this.getOutline().getBackground();
    }

    public boolean isLabelProperty(String property) {
        return Arrays.binarySearch(LABEL_PROPERTIES, property) >= 0;
    }

    protected Image getImportanceImage() {
        return this.getOutlineResources().getImage(WorkItemUI.getImageDescriptor((IPriority)this.fPlanItem.getPriority()));
    }

    protected Action getImportanceAction() {
        return new PriorityDropDownAction(this.fPlanItem, this.getOutlineResources());
    }

    protected void contributeToPlanningControls(GColumnBox planningBox) {
        if (this.fPlanItem.isEstimateCorrected()) {
            new GLabel(this.fPlanningControls, Messages.MyWorkItemNodeContent_LABEL_ESTIMATE_ORIGINAL, 0);
            GMyWorkDuration originalEstimate = new GMyWorkDuration((CompositeGadget)this.fPlanningControls, this.fPlanItem, DurationAttribute.ORIGINAL_ESTIMATE);
            originalEstimate.setAction(null);
        } else {
            new GLabel(this.fPlanningControls, Messages.MyWorkItemNodeContent_LABEL_ESTIMATE_CORRECTED, 0);
            new GMyWorkDuration((CompositeGadget)this.fPlanningControls, this.fPlanItem, DurationAttribute.CORRECTED_ESTIMATE);
        }
        ResolvedPersonalPlan plan = (ResolvedPersonalPlan)this.fPlanItem.getPlan();
        EstimateMode mode = plan.getDurationSupport().getEstimateMode();
        DurationAttribute durationAttribute = mode == EstimateMode.TimeRemaining ? DurationAttribute.TIME_REMAINING : DurationAttribute.TIME_SPENT;
        new GLabel(this.fPlanningControls, mode.getDisplayName(), 0);
        new GMyWorkDuration((CompositeGadget)this.fPlanningControls, this.fPlanItem, durationAttribute);
    }

    protected boolean isExpanded() {
        return ((GExpandableTreeNode)this.getParent()).isShowDetails();
    }

    protected boolean showPlanningDetails() {
        return this.isExpanded();
    }

    protected boolean isEditable() {
        return ((GExpandableTreeNode)this.getParent()).isSelected();
    }
}

