/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GMarkerGadget;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorizeTag;
import com.ibm.team.apt.internal.ide.ui.mywork.GExpandableTreeNode;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkItemNodeContent;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ContentOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLink;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Insets;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyWorkItemGadget
extends GExpandableTreeNode<PlanItem, MyWorkItemNodeContent> {
    private GMarkerGadget fMarker;
    private GLink fId;

    public MyWorkItemGadget(ContentOutlineItem item, final PlanItem planItem, final IWorkbenchSite site, List<ColorizeTag> colorTags) {
        super(item, planItem, colorTags);
        boolean markResolved = this.markAsResolved(planItem);
        this.fMarker = new GMarkerGadget(this, planItem, null);
        this.fId = new GLink(this, planItem.isDraftItem() ? "--" : WorkItemTextUtilities.getWorkItemId((IWorkItem)planItem.getWorkItem(false)), 0);
        this.fId.setReturnParentElement(true);
        this.fId.setAction((IAction)new Action(){

            public void run() {
                WorkItemUI.open((IWorkbenchPage)site.getPage(), (Object)planItem.getWorkItemHandle());
            }
        });
        if (markResolved) {
            this.fId.setStrikeOut(true);
            this.fId.setColor(this.getPlanOutlineResources().getItemCompletedColor());
        }
    }

    protected boolean markAsResolved(PlanItem planItem) {
        return planItem.isAuxiliaryPlanItem() || planItem.isResolved();
    }

    public PlanItem getPlanItem() {
        return (PlanItem)((MyWorkItemNodeContent)this.getContent()).getElement();
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        PlanOutlineResources resources = this.getPlanOutlineResources();
        Insets insets = ((MyWorkItemNodeContent)this.getContent()).getInsets();
        int contentY = y + insets.top();
        this.fMarker.layout(x, contentY, wHint, hHint);
        int markerWidth = this.fMarker.getWidth();
        this.fMarker.move((this.getMarkerColumnWidth() - markerWidth) / 2, 0);
        Point parentSize = super.arrangeContent(x, y, wHint, hHint);
        this.fId.layout(x + parentSize.x + resources.getIdSpacing() - this.getIdColumnWidth(), contentY, this.getIdColumnWidth(), hHint);
        return parentSize;
    }

    @Override
    public int computeMinimalWidth() {
        return this.getMarkerColumnWidth() + super.computeMinimalWidth() + this.getIdColumnWidth();
    }

    @Override
    public GLink getLink() {
        return this.fId;
    }

    @Override
    public GMarkerGadget getMarkerGadget() {
        return this.fMarker;
    }
}

