/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.common.MessageElement;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelUpdater;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelUpdateRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupByDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.PartialViewerSorter;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.SortMode;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupByMyWorkChangesDescription
extends GroupByDescription {
    private static final List<SortMode> DEFAULT_SORT_MODES = Collections.unmodifiableList(Arrays.asList(SortMode.PRIORITY, SortMode.MODIFIED_DATE));
    public static final String ID = "MYWORK_NEWLYASSIGNED";

    public GroupByMyWorkChangesDescription() {
        super(ID, Messages.GroupByMyWorkChangesDescription_LABEL);
    }

    @Override
    public PlanModelTransformer createModelTransformer(IAdaptable options) {
        return new NewlyAssignedTransformer();
    }

    @Override
    protected ItemMovePolicy createItemMovePolicy() {
        return new ItemMovePolicy(){};
    }

    @Override
    public PartialViewerSorter createSorter() {
        return new PartialViewerSorter(true);
    }

    @Override
    public List<SortMode> getSortModes() {
        return DEFAULT_SORT_MODES;
    }

    @Override
    public SortMode getDefaultSortMode() {
        return SortMode.PRIORITY;
    }

    private static class NewlyAssignedTransformer
    extends PlanModelTransformer {
        private final MessageElement fNoNewWorkMessage = new MessageElement(Messages.GroupByMyWorkChangesDescription_MSG_NO_WORK);
        private final NoNewWorkMessageManager fNoNewWorkMessageManager = new NoNewWorkMessageManager();

        public NewlyAssignedTransformer() {
            super(Collections.EMPTY_LIST);
        }

        public void inputChanged(PlanViewModel newModel, ResolvedPlan newInput) {
            PlanViewModel oldModel = this.getViewModel();
            if (oldModel != null) {
                oldModel.removePostUpdateRunnable(this.fNoNewWorkMessageManager, true);
            }
            if (newModel != null) {
                newModel.addPostUpdateRunnable(this.fNoNewWorkMessageManager, true);
            }
            super.inputChanged(newModel, newInput);
        }

        protected boolean isElementIncluded(PlanElement element) {
            return super.isElementIncluded(element) && element instanceof PlanItem && ((PlanItem)element).isNewItem() && !((PlanItem)element).isAuxiliaryPlanItem();
        }

        static /* synthetic */ Object[] access$1() {
            return PlanModelTransformer.EMPTY_PATH;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class NoNewWorkMessageManager
        implements ModelUpdateRunnable<Void, RuntimeException> {
            private NoNewWorkMessageManager() {
            }

            @Override
            public Void run(IOutlineModelUpdater updateAccessor) {
                OutlineEntry<?> rootEntry = updateAccessor.getRootEntry();
                if (rootEntry != null) {
                    OutlineEntry messageEntry = this.getFirstEntry(updateAccessor.getElementEntries(NewlyAssignedTransformer.this.fNoNewWorkMessage));
                    List<OutlineEntry<?>> entries = updateAccessor.getChildren(rootEntry);
                    if (entries.size() > 1 && messageEntry != null) {
                        updateAccessor.removeEntry(messageEntry);
                    } else if (entries.size() == 0) {
                        updateAccessor.addEntry(NewlyAssignedTransformer.access$1(), NewlyAssignedTransformer.this.fNoNewWorkMessage);
                    }
                }
                return null;
            }

            private <T> OutlineEntry<T> getFirstEntry(Collection<OutlineEntry<T>> entries) {
                Iterator<OutlineEntry<T>> iterator = entries.iterator();
                return iterator.hasNext() ? iterator.next() : null;
            }
        }
    }
}

