/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.IPersonalPlanSaveAccessor;
import com.ibm.team.apt.internal.client.IPersonalPlanSaveManager;
import com.ibm.team.apt.internal.client.PersonalPlanItem;
import com.ibm.team.apt.internal.client.PlanDeltaBuilder;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanSaveResult;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.client.problems.PlanProblemReport;
import com.ibm.team.apt.internal.client.problems.Problem;
import com.ibm.team.apt.internal.client.util.Items;
import com.ibm.team.apt.internal.common.Message;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.SaveConflictDialog;
import com.ibm.team.apt.internal.ide.ui.common.SaveConflictItem;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkView;
import com.ibm.team.apt.internal.ide.ui.util.ExceptionHandler;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.InformationViewer;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IReconcileReport;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.MultiStaleDataException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSaveStrategy {
    protected final MyWorkView fMyWorkView;
    protected boolean fIsLoggedIn;
    protected boolean fContentChanged;
    protected ResolvedPersonalPlan fPlan;
    protected IPersonalPlanSaveAccessor fPlanSaveAccessor;
    protected Map<PlanItem, SaveConflictItem> fSaveConflicts = Collections.synchronizedMap(new HashMap());
    private final Set<PlanItem> fInSaveItems = new HashSet<PlanItem>();
    private List<Message> fMessages = new ArrayList<Message>();
    private final InformationViewer.IInformationMessageListener fMessageListener = new InformationViewer.IInformationMessageListener(){

        public void clicked(Object element, String text) {
            if (element instanceof ActionMessage) {
                ((ActionMessage)((Object)element)).clicked(text);
            }
        }

        public void closed(Object element) {
            if (element instanceof ActionMessage) {
                ((ActionMessage)((Object)element)).closed();
            }
        }
    };

    public AbstractSaveStrategy(MyWorkView myWorkView) {
        this.fMyWorkView = myWorkView;
    }

    public abstract String getId();

    public void inputChanged(ResolvedPersonalPlan oldInput, ResolvedPersonalPlan newInput) {
        this.setInput(newInput);
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.fIsLoggedIn) {
            if (!MessageDialog.openQuestion((Shell)this.fMyWorkView.getSite().getShell(), (String)Messages.AbstractSaveStrategy_TITLE_SAVE, (String)Messages.AbstractSaveStrategy_LOGIN_DETAILS)) {
                return;
            }
            this.fMyWorkView.ensureLoggedIn();
        }
        if (!this.fIsLoggedIn) {
            return;
        }
        PlanProblemReport problemReport = this.fPlan.getProblemReport();
        if (problemReport != null && problemReport.isSeverity(Problem.Severity.FATAL_ERROR) && !MessageDialog.openQuestion((Shell)this.fMyWorkView.getSite().getShell(), (String)Messages.AbstractSaveStrategy_TITLE_SAVE, (String)Messages.MyWorkView_FAILURE_SAVE_DETAILS)) {
            return;
        }
        try {
            List<PlanItem> planItemToSave;
            PlanSaveResult[] saveResult;
            block19: {
                saveResult = new PlanSaveResult[1];
                planItemToSave = this.beginSave(this.fPlanSaveAccessor.getDirtyPlanItems());
                try {
                    this.fMyWorkView.getSite().getWorkbenchWindow().getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                saveResult[0] = AbstractSaveStrategy.this.fPlanSaveAccessor.save(planItemToSave, monitor);
                            }
                            catch (TeamRepositoryException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t instanceof TeamRepositoryException) {
                        throw (TeamRepositoryException)t;
                    }
                    ExceptionHandler.handle(e, this.fMyWorkView.getSite().getShell(), Messages.AbstractSaveStrategy_TITLE_SAVE, Messages.AbstractSaveStrategy_FAILURE_SAVE_UNEXPECTED);
                    this.endSave(planItemToSave);
                    break block19;
                }
                catch (InterruptedException interruptedException) {
                    try {
                        return;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.endSave(planItemToSave);
                    }
                }
                this.endSave(planItemToSave);
            }
            if (saveResult[0].getStatus().isOK()) {
                this.successfullySaved(planItemToSave);
            } else {
                ErrorDialog.openError((Shell)this.fMyWorkView.getSite().getShell(), (String)Messages.AbstractSaveStrategy_TITLE_SAVE, (String)Messages.AbstractSaveStrategy_FAILURE_SAVE, (IStatus)saveResult[0].getStatus());
            }
        }
        catch (MultiStaleDataException e) {
            this.resolveSaveConflicts(this.getSaveConflictItems(e));
        }
        catch (TeamOperationCanceledException teamOperationCanceledException) {
            MessageDialog.openInformation((Shell)this.fMyWorkView.getSite().getShell(), (String)Messages.AbstractSaveStrategy_TITLE_SAVE, (String)Messages.AbstractSaveStrategy_FAILURE_SAVE_PROCESS);
        }
        catch (ConnectionException e) {
            Status status = new Status(4, PlanningUIPlugin.getPluginId(), Messages.AbstractSaveStrategy_FAILURE_SAVE_CONNECTION, (Throwable)e);
            ErrorDialog.openError((Shell)this.fMyWorkView.getSite().getShell(), (String)Messages.AbstractSaveStrategy_TITLE_SAVE, (String)Messages.AbstractSaveStrategy_FAILURE_SAVE, (IStatus)status);
        }
        catch (TeamRepositoryException e) {
            ExceptionHandler.handle(e, this.fMyWorkView.getSite().getShell(), Messages.AbstractSaveStrategy_TITLE_SAVE, Messages.AbstractSaveStrategy_FAILURE_SAVE_UNEXPECTED);
        }
        this.updateDirtyState();
    }

    private boolean resolveSaveConflicts(Collection<SaveConflictItem> saveConflicts) {
        SaveConflictDialog dialog = new SaveConflictDialog(this.fMyWorkView.getSite().getShell(), saveConflicts.toArray(new SaveConflictItem[0]));
        switch (dialog.open()) {
            case 1025: {
                this.fPlan.autoMerge(this.getReconcileReports(saveConflicts));
                return true;
            }
            case 1027: {
                this.fPlan.revert(this.getReconcileReports(saveConflicts));
                return true;
            }
            case 1026: {
                this.fPlan.refresh(this.getReconcileReports(saveConflicts));
                return true;
            }
        }
        return false;
    }

    private IReconcileReport[] getReconcileReports(Collection<SaveConflictItem> saveConflicts) {
        IReconcileReport[] result = new IReconcileReport[saveConflicts.size()];
        int index = 0;
        for (SaveConflictItem saveConflict : saveConflicts) {
            result[index++] = saveConflict.getReconcileReport();
        }
        return result;
    }

    public void setLoggedIn(boolean loggedIn) {
        this.fIsLoggedIn = loggedIn;
    }

    public List<Message> getMessages() {
        return new ArrayList<Message>(this.fMessages);
    }

    public InformationViewer.IInformationMessageListener getMessageListener() {
        return this.fMessageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PlanItem> beginSave(Collection<PlanItem> saveRequest) {
        Set<PlanItem> set = this.fInSaveItems;
        synchronized (set) {
            ArrayList<PlanItem> result = new ArrayList<PlanItem>(saveRequest);
            result.removeAll(this.fInSaveItems);
            this.fInSaveItems.addAll(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endSave(Collection<PlanItem> items) {
        Set<PlanItem> set = this.fInSaveItems;
        synchronized (set) {
            Assert.isTrue((boolean)this.fInSaveItems.containsAll(items));
            this.fInSaveItems.removeAll(items);
        }
    }

    protected void successfullySaved(List<PlanItem> savedPlanItem) {
        this.fMessages.clear();
        this.updateMessages();
    }

    protected void updateMessages() {
        if (this.fMyWorkView != null && this.fMyWorkView.getControl() != null) {
            UI.asyncExec(this.fMyWorkView.getControl(), new Runnable(){

                public void run() {
                    AbstractSaveStrategy.this.fMyWorkView.updateSaveMessages();
                }
            });
        }
    }

    protected void addMessage(Message message) {
        this.fMessages.add(message);
    }

    protected void removeMessageKind(Class<? extends Message> clazz) {
        List<Message> messages = this.fMessages;
        Iterator<Message> messageIterator = messages.iterator();
        while (messageIterator.hasNext()) {
            Message message = messageIterator.next();
            if (!clazz.isAssignableFrom(message.getClass())) continue;
            messageIterator.remove();
        }
    }

    protected void handleSaveException(TeamRepositoryException e) {
        this.addMessage(new SaveExceptionMessage(e));
        this.updateMessages();
    }

    protected void handleStaleDataException(MultiStaleDataException e) {
        this.addSaveConflicts(this.getSaveConflictItems(e));
        this.updateStaleDataMessage();
    }

    private void updateStaleDataMessage() {
        this.removeMessageKind(StaleDataMessage.class);
        int saveConflictCount = this.fSaveConflicts.size();
        if (saveConflictCount > 0) {
            this.addMessage(new StaleDataMessage(saveConflictCount));
        }
        this.updateMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSaveConflicts(List<SaveConflictItem> saveConflicts) {
        Map<PlanItem, SaveConflictItem> map = this.fSaveConflicts;
        synchronized (map) {
            for (SaveConflictItem saveConflict : saveConflicts) {
                PersonalPlanItem planItem = this.fPlan.getPlanItem((IWorkItemHandle)saveConflict.getBase());
                if (planItem == null) continue;
                this.fSaveConflicts.put((PlanItem)planItem, saveConflict);
            }
        }
    }

    private List<SaveConflictItem> getSaveConflictItems(MultiStaleDataException e) {
        IReconcileReport[] reports = e.getReconcileReports();
        ArrayList<SaveConflictItem> result = new ArrayList<SaveConflictItem>(reports.length);
        int i = 0;
        while (i < reports.length) {
            IReconcileReport report = reports[i];
            ITeamRepository origin = (ITeamRepository)e.getOrigin();
            Items.setOrigin((IItem)report.getBase(), (ITeamRepository)origin);
            Items.setOrigin((IItem)report.getOutgoing(), (ITeamRepository)origin);
            Items.setOrigin((IItem)report.getIncoming(), (ITeamRepository)origin);
            Items.setOrigin((IItem)report.getMergeResult(), (ITeamRepository)origin);
            result.add(new SaveConflictItem(report));
            ++i;
        }
        return result;
    }

    private void setInput(ResolvedPersonalPlan resolvedPlan) {
        this.fPlanSaveAccessor = null;
        this.fContentChanged = false;
        if (this.fPlan != null) {
            this.fPlan.setSaveManager(null);
        }
        this.fPlan = resolvedPlan;
        if (this.fPlan != null) {
            this.fPlanSaveAccessor = this.fPlan.setSaveManager((IPersonalPlanSaveManager)new SaveManager());
            this.fContentChanged = this.fPlanSaveAccessor.hasDirtyPlanItems();
            this.fSaveConflicts.clear();
            this.onConnectNewInput(this.fPlan);
        }
        if (this.fMyWorkView.getControl() != null) {
            UI.asyncExec(this.fMyWorkView.getControl(), new Runnable(){

                public void run() {
                    AbstractSaveStrategy.this.fMyWorkView.dirtyStateChanged();
                    AbstractSaveStrategy.this.fMessages.clear();
                    AbstractSaveStrategy.this.fMyWorkView.updateSaveMessages();
                }
            });
        }
    }

    protected void onConnectNewInput(ResolvedPersonalPlan plan) {
    }

    protected boolean getDirtyState() {
        return this.fContentChanged;
    }

    protected void updateDirtyState() {
        this.internalSetDirtyState(this.fPlanSaveAccessor.hasDirtyPlanItems());
    }

    protected void markAsDirty(boolean dirty) {
        this.internalSetDirtyState(dirty || this.fPlanSaveAccessor.hasDirtyPlanItems());
    }

    protected abstract void handleDisconnect();

    protected abstract void handleWriteableStateChange(PlanItem var1, boolean var2);

    protected abstract void handleDirtyStateChange(PlanItem var1, boolean var2);

    protected abstract void handleWorkItemChange(PlanItem var1, WorkItemChangeEvent var2);

    private void internalSetDirtyState(boolean dirty) {
        if (this.getDirtyState() == dirty) {
            return;
        }
        this.fContentChanged = dirty;
        PlanDeltaBuilder builder = this.fPlan.connectDeltaBuilder();
        try {
            builder.changed((PlanElement)this.fPlan, PlanItem.DIRTY, (Object)(!this.fContentChanged ? 1 : 0), (Object)this.fContentChanged);
        }
        finally {
            this.fPlan.disconnectDeltaBuilder();
        }
    }

    protected abstract class ActionMessage
    extends Message {
        public ActionMessage(String message, Message.Severity severity) {
            super(message, severity);
        }

        public void clicked(String ref) {
        }

        public void closed() {
            AbstractSaveStrategy.this.fMessages.remove((Object)this);
        }
    }

    private class SaveExceptionMessage
    extends ActionMessage {
        public SaveExceptionMessage(TeamRepositoryException exception) {
            super(Messages.AbstractSaveStrategy_SAVE_FAILED, Message.Severity.Error);
        }

        public void clicked(String ref) {
            AbstractSaveStrategy.this.doSave(null);
        }
    }

    private class SaveManager
    implements IPersonalPlanSaveManager {
        private SaveManager() {
        }

        public boolean isDirty() {
            return AbstractSaveStrategy.this.getDirtyState();
        }

        public void markAsDirty(boolean dirty) {
            AbstractSaveStrategy.this.markAsDirty(dirty);
        }

        public void updateDirtyState() {
            AbstractSaveStrategy.this.updateDirtyState();
        }

        public void onDisconnect() {
            AbstractSaveStrategy.this.handleDisconnect();
        }

        public void onDirtyStateChange(PlanItem planItem, boolean isDirty) {
            if (planItem != null) {
                AbstractSaveStrategy.this.handleDirtyStateChange(planItem, isDirty);
            }
        }

        public void onWriteableStateChange(PlanItem planItem, boolean isWritable) {
            if (planItem != null) {
                AbstractSaveStrategy.this.handleWriteableStateChange(planItem, isWritable);
            }
        }

        public void onWorkItemChange(PlanItem planItem, WorkItemChangeEvent event) {
            if (planItem != null) {
                AbstractSaveStrategy.this.handleWorkItemChange(planItem, event);
            }
        }
    }

    private class StaleDataMessage
    extends ActionMessage {
        public StaleDataMessage(int conflictCount) {
            super(NLS.bind((String)Messages.AbstractSaveStrategy_RESOLVE, (Object[])new Object[]{conflictCount}), Message.Severity.Warning);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clicked(String ref) {
            ArrayList<SaveConflictItem> conflictsToResolve = new ArrayList<SaveConflictItem>();
            Map<PlanItem, SaveConflictItem> map = AbstractSaveStrategy.this.fSaveConflicts;
            synchronized (map) {
                conflictsToResolve.addAll(AbstractSaveStrategy.this.fSaveConflicts.values());
                AbstractSaveStrategy.this.fSaveConflicts.clear();
            }
            if (!AbstractSaveStrategy.this.resolveSaveConflicts(conflictsToResolve)) {
                AbstractSaveStrategy.this.addSaveConflicts(conflictsToResolve);
            } else {
                for (SaveConflictItem saveConflict : conflictsToResolve) {
                    PersonalPlanItem planItem = AbstractSaveStrategy.this.fPlan.getPlanItem((IWorkItemHandle)saveConflict.getBase());
                    if (planItem == null) continue;
                    AbstractSaveStrategy.this.handleDirtyStateChange((PlanItem)planItem, true);
                }
            }
            AbstractSaveStrategy.this.updateStaleDataMessage();
        }
    }
}

