/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.PersonalPlanItem;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.GadgetFactory;
import com.ibm.team.apt.internal.ide.ui.common.IMarker;
import com.ibm.team.apt.internal.ide.ui.common.PlanOpenListener;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModelContentProvider;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModelViewerSorter;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorizeConfiguration;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorizerEvent;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.IColorizerConfigListener;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.IQuickQueryEntryFinder;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryBar;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryColorizer;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryEntryFilter;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryEntryFinder;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupByDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.PartialViewerSorter;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.SortMode;
import com.ibm.team.apt.internal.ide.ui.mywork.AbstractPlanSection;
import com.ibm.team.apt.internal.ide.ui.mywork.ColorTagComparer;
import com.ibm.team.apt.internal.ide.ui.mywork.IMyWorkSettings;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkActionGroup;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkCanvas;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkGadgetFactory;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkResources;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkSettingsProxy;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkViewModel;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkViewer;
import com.ibm.team.apt.internal.ide.ui.mywork.TimeSpansMode;
import com.ibm.team.apt.internal.ide.ui.widgets.InformationBar;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLink;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGObject;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineColumn;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import com.ibm.team.feed.core.NewsContextProvider;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.dashboard.ISectionSite;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.jface.tooltip.INavigatorContent;
import com.ibm.team.jface.tooltip.NavigatorContentAdapter;
import com.ibm.team.jface.tooltip.SlideoutSupport;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public abstract class AbstractPlanItemViewerSection
extends AbstractPlanSection
implements IAdaptable {
    private static final String SORT_MODE_KEY = "sortMode";
    private static final String GROUP_BY_COLOR_KEY = "groupByColor";
    private boolean fGroupByColor;
    private MyWorkCanvas fCanvas;
    private MyWorkViewer fViewer;
    private MyWorkViewModel fViewModel;
    private String fCurrentMessage;
    private int fCurrentMessageType;
    private InformationBar.IInformationBarListener fCurrentInformationBarLinkHandler;
    private InformationBar fInformationBar;
    private GroupByDescription fGroupMode;
    private IMyWorkSettings fSettings;
    private String fLastSortMode;
    private QuickQueryEntryFilter fQuickQueryFilter;
    private QuickQueryColorizer fQuickQueryColorizer;
    private QuickQueryEntryFinder fQuickQueryEntryFinder;
    private PartialViewerSorter fViewerSorter;
    private PlanModelTransformer fPlanModelTransformer;
    private MyWorkActionGroup fActionGroup;
    private Map<ColorizeConfiguration, QuickQueryColorizer> fColorizers = new HashMap<ColorizeConfiguration, QuickQueryColorizer>();
    private IColorizerConfigListener fColorizerListener = new IColorizerConfigListener(){

        public void configChanged(ColorizerEvent event) {
            ColorizeConfiguration config = event.getConfig();
            switch (event.getEventType()) {
                case Added: {
                    AbstractPlanItemViewerSection.this.addColorizer(config);
                    break;
                }
                case Changed: {
                    AbstractPlanItemViewerSection.this.updateColorizer(config);
                    break;
                }
                case Removed: {
                    AbstractPlanItemViewerSection.this.removeColorizer(config);
                }
            }
        }
    };
    private SlideoutSupport fSlideout;
    private SlideoutMode fSlideoutMode = SlideoutMode.None;
    private MyWorkCanvas.InterceptingKeyListener fNavigationInterceptionListener;
    private WorkItemSelectionProvider fWorkItemSelectionProvider = new WorkItemSelectionProvider();

    public AbstractPlanItemViewerSection(String contextId) {
        super(contextId);
    }

    public IQuickQueryEntryFinder getEntryFinder() {
        return this.fQuickQueryEntryFinder;
    }

    public void showDetails(boolean showDetails) {
        this.updateSlideout(showDetails ? SlideoutMode.Details : SlideoutMode.None);
    }

    public boolean isShowDetails() {
        return this.fSlideoutMode == SlideoutMode.Details;
    }

    public void showRecentNews(boolean showRecentNews) {
        this.updateSlideout(showRecentNews ? SlideoutMode.News : SlideoutMode.None);
    }

    public boolean isShowRecentNews() {
        return this.fSlideoutMode == SlideoutMode.News;
    }

    protected IMyWorkSettings getSettings() {
        return this.fSettings;
    }

    protected GroupByDescription getGroupMode() {
        return this.fGroupMode;
    }

    public MyWorkViewModel getViewModel() {
        return this.fViewModel;
    }

    protected MyWorkCanvas getCanvas() {
        return this.fCanvas;
    }

    protected MyWorkViewer getViewer() {
        return this.fViewer;
    }

    protected PlanModelTransformer getPlanModelTransformer() {
        return this.fPlanModelTransformer;
    }

    protected void setPlanModeTransformer(PlanModelTransformer transformer) {
        this.fPlanModelTransformer = transformer;
        if (this.fViewModel != null) {
            this.fViewModel.setModelTransformer(this.fPlanModelTransformer);
        }
    }

    protected boolean isQuickFilterActive() {
        return this.fQuickQueryFilter.isInstalled();
    }

    protected void setInformationMessage(String message, int type, InformationBar.IInformationBarListener linkListener) {
        if (this.fCurrentInformationBarLinkHandler != null) {
            if (this.fInformationBar != null) {
                this.fInformationBar.removeLinkListener(this.fCurrentInformationBarLinkHandler);
            }
            this.fCurrentInformationBarLinkHandler = null;
        }
        if (linkListener != null) {
            this.fCurrentInformationBarLinkHandler = linkListener;
            if (this.fInformationBar != null) {
                this.fInformationBar.addLinkListener(linkListener);
            }
        }
        this.fCurrentMessage = message;
        this.fCurrentMessageType = type;
        if (this.fInformationBar != null) {
            this.fInformationBar.setMessage(message, type);
        }
    }

    protected void clearInformationMessage() {
        if (this.fCurrentInformationBarLinkHandler != null) {
            if (this.fInformationBar != null) {
                this.fInformationBar.removeLinkListener(this.fCurrentInformationBarLinkHandler);
            }
            this.fCurrentInformationBarLinkHandler = null;
        }
        this.fCurrentMessage = null;
        this.fCurrentMessageType = 0;
        if (this.fInformationBar != null) {
            this.fInformationBar.setMessage(null, 0);
        }
    }

    protected abstract GroupByDescription createGroupByDescription();

    protected abstract void onInitializePlan();

    protected GadgetFactory getGadgetFactory() {
        return new MyWorkGadgetFactory((IWorkbenchPartSite)this.getSectionSite().getViewSite());
    }

    protected void doSetPostFilterState() {
    }

    public Object getAdapter(Class adapter) {
        if (TimeSpansMode.class.equals((Object)adapter)) {
            return this.getSettings().getTimeSpansMode();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public Action getAction(String id) {
        return this.fActionGroup.getAction(id);
    }

    protected void onInit(IMemento memento) {
        if (memento != null) {
            this.fLastSortMode = memento.getString(SORT_MODE_KEY);
            this.fGroupByColor = Boolean.valueOf(memento.getString(GROUP_BY_COLOR_KEY));
        }
        this.fGroupMode = this.createGroupByDescription();
        this.fSettings = new MyWorkSettingsProxy(this.getPersonalPlanService().getSettings(), this.fGroupMode);
        this.setPlanModeTransformer(this.fGroupMode.createModelTransformer(this));
        this.fViewerSorter = this.fGroupMode.createSorter();
        this.fViewerSorter.setItemComparator(this.getSortMode().getComparator());
        this.fViewerSorter.setTagComparator(this.fGroupByColor ? new ColorTagComparer() : null);
        this.getPersonalPlanService().registerPlanViewer(this);
        this.fViewModel = new MyWorkViewModel(this.fSettings);
        this.fViewModel.setModelTransformer(this.fPlanModelTransformer);
        this.fViewModel.setSorter(this.fViewerSorter);
        this.fActionGroup = new MyWorkActionGroup((IWorkbenchSite)this.getSectionSite().getViewSite(), this.getViewModel(), this);
        this.fWorkItemSelectionProvider.sourceChanged(null, this.fViewModel.getSelectionProvider());
        QuickQueryBar quickQueryBar = this.getPersonalPlanService().getQuickQueryBar();
        this.fQuickQueryEntryFinder = new QuickQueryEntryFinder(this.fViewModel);
        this.fQuickQueryEntryFinder.setEnabled(true);
        this.fQuickQueryFilter = new QuickQueryEntryFilter((PlanViewModel)this.fViewModel){

            protected void updateFilterCounts() {
                AbstractPlanItemViewerSection.this.updateSectionHeader();
                AbstractPlanItemViewerSection.this.doSetPostFilterState();
            }
        };
        quickQueryBar.registerParticipant(this.fQuickQueryFilter);
        this.fQuickQueryColorizer = new QuickQueryColorizer(this.fViewModel);
        this.fQuickQueryColorizer.setPriority(-1);
        this.fQuickQueryColorizer.setLabel(Messages.AbstractPlanItemViewerSection_LABEL_QUICK_COLORIZE);
        this.fQuickQueryColorizer.setEnabled(true);
        this.fQuickQueryColorizer.setColor(new RGB(255, 255, 0));
        quickQueryBar.registerParticipant(this.fQuickQueryColorizer);
        List<ColorizeConfiguration> colorizeConfigurations = this.getPersonalPlanService().getColorizeConfigurations();
        for (ColorizeConfiguration configuration : colorizeConfigurations) {
            this.addColorizer(configuration);
        }
        this.getPersonalPlanService().addColorizeConfigListener(this.fColorizerListener);
    }

    protected void onInputChanged(ResolvedPersonalPlan oldInput, ResolvedPersonalPlan newInput) {
        if (newInput != null) {
            this.initializeView();
        } else if (oldInput != null && !this.isDisposed()) {
            this.fViewModel.setInput(null);
        }
        if (this.fActionGroup != null) {
            this.fActionGroup.inputChanged(oldInput, newInput);
        }
        this.updateSectionHeader();
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString(SORT_MODE_KEY, this.fLastSortMode);
        memento.putString(GROUP_BY_COLOR_KEY, Boolean.toString(this.fGroupByColor));
    }

    protected void onDispose() {
        this.fWorkItemSelectionProvider.sourceChanged(this.fViewModel.getSelectionProvider(), null);
        this.getPersonalPlanService().removeColorizeConfigListener(this.fColorizerListener);
        for (ColorizeConfiguration configuration : new ArrayList(this.fColorizers.keySet())) {
            this.removeColorizer(configuration);
        }
        this.getPersonalPlanService().unregisterPlanViewer(this);
        QuickQueryBar quickQueryBar = this.getPersonalPlanService().getQuickQueryBar();
        quickQueryBar.unregisterParticipant(this.fQuickQueryFilter);
        quickQueryBar.unregisterParticipant(this.fQuickQueryColorizer);
        if (this.fSlideout != null) {
            this.fSlideout.dispose();
            this.fSlideout = null;
        }
        if (this.fNavigationInterceptionListener != null) {
            this.fCanvas.removeInterceptingKeyListener(this.fNavigationInterceptionListener);
        }
        if (this.fViewer != null) {
            this.fViewer.dispose();
            this.fViewer = null;
        }
        if (this.fActionGroup != null) {
            this.fActionGroup.dispose();
            this.fActionGroup = null;
        }
    }

    public void createContent(Composite parent) {
        GridLayoutFactory.swtDefaults().margins(0, 0).spacing(0, 0).applyTo(parent);
        this.fInformationBar = new InformationBar(parent, 2048);
        this.fInformationBar.setLayoutData(new GridData(4, 128, true, false));
        if (this.fCurrentMessage != null) {
            this.fInformationBar.setMessage(this.fCurrentMessage, this.fCurrentMessageType);
        }
        if (this.fCurrentInformationBarLinkHandler != null) {
            this.fInformationBar.addLinkListener(this.fCurrentInformationBarLinkHandler);
        }
        this.fCanvas = new MyWorkCanvas(parent, 0, this.fSettings);
        OutlineColumn c = new OutlineColumn(this.fCanvas);
        MyWorkResources resources = this.fCanvas.getTimelineResources();
        c.setWidth(resources.getMarkerColumnWidth());
        c = new OutlineColumn(this.fCanvas);
        c.setWidth(4);
        int numberWidth = 0;
        Font normalFont = resources.getTextFonts().getNormalFont();
        GC gc = new GC((Drawable)normalFont.getDevice());
        try {
            gc.setFont(normalFont);
            int i = 0;
            while (i < 10) {
                numberWidth = Math.max(numberWidth, gc.textExtent((String)Integer.toString((int)i)).x);
                ++i;
            }
        }
        finally {
            gc.dispose();
        }
        c = new OutlineColumn(this.fCanvas);
        c.setWidth(numberWidth * 2);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fCanvas);
        this.fViewer = new MyWorkViewer(this.getGadgetFactory(), this.fCanvas, this.getPersonalPlanService().getSelectionMediator(), this.getPersonalPlanService().getSite());
        this.fViewer.setContentProvider((IContentProvider)new OutlineModelContentProvider());
        this.fViewer.setComparator(new OutlineModelViewerSorter());
        this.fViewer.addOpenListener(new PlanOpenListener(this.getSectionSite().getViewSite().getPage()));
        this.getSectionSite().addSelectionProvider((ISelectionProvider)this.fWorkItemSelectionProvider);
        this.fViewModel.setViewer(this.fViewer);
        this.hookContextMenu();
        this.hookSlideoutSupport(this.getSectionSite());
        new TooltipSupport((Control)this.fCanvas, true, false){

            public Object getElement(Control control, int x, int y) {
                IGObject graphicalObject = AbstractPlanItemViewerSection.this.fCanvas.getGObjectUnder(x, y);
                if (graphicalObject == null) {
                    return null;
                }
                Object element = graphicalObject.getElement();
                if (element instanceof PlanItem && graphicalObject instanceof GLink) {
                    return ((PlanItem)element).getWorkItemHandle();
                }
                if (element instanceof IMarker) {
                    return element;
                }
                return null;
            }

            public Rectangle getElementBounds(Control control, int x, int y) {
                IGObject graphicalObject = AbstractPlanItemViewerSection.this.fCanvas.getGObjectUnder(x, y);
                if (graphicalObject == null) {
                    return new Rectangle(0, 0, 0, 0);
                }
                return Rectangles.create(AbstractPlanItemViewerSection.this.fCanvas.getTransformation().toViewPort(graphicalObject.getBounds()));
            }
        };
    }

    public void createTeaser(Composite parent) {
        super.createTeaser(parent);
        Menu sectionMenu = this.getSectionSite().getSectionMenu();
        SortMode currentSortMode = this.getSortMode();
        List<SortMode> sortModes = this.fGroupMode.getSortModes();
        if (sortModes.size() > 0) {
            MenuItem sortMenuItem = new MenuItem(sectionMenu, 64);
            sortMenuItem.setText(this.getSortMenuLabel());
            Menu sortMenu = new Menu(sortMenuItem);
            sortMenuItem.setMenu(sortMenu);
            for (final SortMode sortMode : sortModes) {
                MenuItem showFilterMenu = new MenuItem(sortMenu, 16);
                showFilterMenu.setSelection(sortMode.equals((Object)currentSortMode));
                showFilterMenu.setText(sortMode.getLabel());
                showFilterMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AbstractPlanItemViewerSection.this.fLastSortMode = sortMode.getKey();
                        AbstractPlanItemViewerSection.this.fViewerSorter.setItemComparator(sortMode.getComparator());
                        AbstractPlanItemViewerSection.this.fViewModel.refreshSortOrder();
                    }
                });
            }
        }
        final MenuItem groupByColorMenuItem = new MenuItem(sectionMenu, 32);
        groupByColorMenuItem.setText(Messages.AbstractPlanItemViewerSection_LABEL_GROUP_BY_COLOR);
        groupByColorMenuItem.setSelection(this.fGroupByColor);
        groupByColorMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPlanItemViewerSection.this.fGroupByColor = groupByColorMenuItem.getSelection();
                AbstractPlanItemViewerSection.this.fViewerSorter.setTagComparator(AbstractPlanItemViewerSection.this.fGroupByColor ? new ColorTagComparer() : null);
                AbstractPlanItemViewerSection.this.fViewModel.refreshSortOrder();
            }
        });
    }

    protected String getSortMenuLabel() {
        return Messages.AbstractPlanItemViewerSection_LABEL_SORT_BY;
    }

    protected SortMode getSortMode() {
        SortMode result = null;
        if (this.fLastSortMode != null) {
            result = SortMode.getSortMode(this.fLastSortMode);
        }
        if (result == null) {
            result = this.fGroupMode.getDefaultSortMode();
        }
        return result;
    }

    public void setFocus() {
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.setFocus();
        }
    }

    public void hookSlideoutSupport(final ISectionSite sectionSite) {
        this.fSlideout = new SlideoutSupport((Control)this.fCanvas, (ISelectionProvider)this.fViewer, MyWorkViewer.class.getName(), true){
            private final String EMPTY_MESSAGE_TEMPLATE_START;
            private final String EMPTY_MESSAGE_TEMPLATE_END = "</div>\n</body></html>\n";
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3);
                this.EMPTY_MESSAGE_TEMPLATE_START = "<html><head>\n" + "<style type=\"text/css\"> .{ " + MarkupUtil.getFont() + " } </style>" + "\n</head><body>\n" + "<div>";
                this.EMPTY_MESSAGE_TEMPLATE_END = "</div>\n</body></html>\n";
            }

            protected INavigatorContent convertSelectionToNavigatorContent(ISelection selection) {
                if (AbstractPlanItemViewerSection.this.fSlideoutMode == SlideoutMode.None) {
                    return null;
                }
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (structuredSelection.size() != 1) {
                    return null;
                }
                Object node = structuredSelection.getFirstElement();
                if (node instanceof OutlineEntry && EntryUtils.isType((OutlineEntry)node, PlanItem.class)) {
                    switch (AbstractPlanItemViewerSection.this.fSlideoutMode) {
                        case Details: {
                            return new NavigatorContentAdapter(Arrays.asList(((PlanItem)((OutlineEntry)node).getElement()).getWorkItemHandle()));
                        }
                        case News: {
                            ArrayList newsItems = new ArrayList(((PlanItem)((OutlineEntry)node).getElement()).getNewsItems());
                            if (newsItems.isEmpty()) break;
                            NewsItem firstToDisplay = (NewsItem)newsItems.get(newsItems.size() - 1);
                            for (NewsItem newsItem : newsItems) {
                                if (newsItem.isIsRead()) continue;
                                firstToDisplay = newsItem;
                                break;
                            }
                            return new NavigatorContentAdapter(newsItems, (Object)firstToDisplay);
                        }
                    }
                }
                String message = Messages.AbstractPlanItemViewerSection_MSG_NO_CONTENT;
                switch (AbstractPlanItemViewerSection.this.fSlideoutMode) {
                    case News: {
                        message = Messages.AbstractPlanItemViewerSection_MSG_NO_NEWS;
                        break;
                    }
                    case Details: {
                        message = Messages.AbstractPlanItemViewerSection_MSG_NO_DETAILS;
                    }
                }
                return new NavigatorContentAdapter(Arrays.asList(String.valueOf(this.EMPTY_MESSAGE_TEMPLATE_START) + message + "</div>\n</body></html>\n"));
            }

            protected void openRequested(Object element) {
                if (element instanceof NewsItem) {
                    NewsItem newsItem = (NewsItem)element;
                    String link = newsItem.getLink();
                    if (link == null || link.length() == 0) {
                        return;
                    }
                    IDomainAdapter adapter = DomainAdapterUtils.getDomainAdapter((Object)newsItem);
                    if (adapter != null) {
                        adapter.markAsRead((Object)newsItem, 0);
                    }
                    try {
                        Hyperlinks.openHyperlink((URI)new URI(link), (ContextProvider)new NewsContextProvider(newsItem, (Object)sectionSite.getViewSite().getPage()), (String)newsItem.getTitle());
                    }
                    catch (URISyntaxException e) {
                        IViewSite viewSite = sectionSite.getViewSite();
                        Shell shell = viewSite != null ? viewSite.getShell() : null;
                        String msg = Messages.AbstractPlanItemViewerSection_FAILURE_NEWS_DETAILS;
                        ErrorDialog.openError((Shell)shell, (String)Messages.AbstractPlanItemViewerSection_FAILURE_NEWS, (String)msg, (IStatus)new Status(4, PlanningUIPlugin.getPluginId(), -1, msg, (Throwable)e));
                    }
                } else if (element instanceof IWorkItem) {
                    WorkItemUI.open((IWorkbenchPage)AbstractPlanItemViewerSection.this.getSectionSite().getViewSite().getPage(), (Object)element);
                }
            }

            protected void slideoutCloseRequested() {
                AbstractPlanItemViewerSection.this.fSlideoutMode = SlideoutMode.None;
                super.slideoutCloseRequested();
            }
        };
        this.fNavigationInterceptionListener = new MyWorkCanvas.InterceptingKeyListener(){

            public boolean keyPressed(KeyEvent e) {
                if (AbstractPlanItemViewerSection.this.fSlideoutMode == SlideoutMode.News) {
                    if (e.stateMask == 0 && e.keyCode == 32) {
                        Collection<?> elements = AbstractPlanItemViewerSection.this.fViewModel.getSelectedElements();
                        boolean continsUnread = false;
                        for (Object element : elements) {
                            continsUnread |= element instanceof PlanItem && !((PlanItem)element).isMarkedRead();
                        }
                        for (Object element : elements) {
                            if (!(element instanceof PlanItem)) continue;
                            if (continsUnread) {
                                ((PlanItem)element).markRead();
                                continue;
                            }
                            ((PlanItem)element).markUnread();
                        }
                        return true;
                    }
                    if (e.keyCode == 0x1000003 || e.keyCode == 0x1000004) {
                        return true;
                    }
                }
                return false;
            }
        };
        this.fCanvas.addInterceptingKeyListener(this.fNavigationInterceptionListener);
    }

    protected void addColorizer(ColorizeConfiguration config) {
        QuickQueryColorizer colorizer = new QuickQueryColorizer(this.fViewModel);
        this.fColorizers.put(config, colorizer);
        this.updateColorizer(config);
    }

    protected void updateColorizer(ColorizeConfiguration config) {
        QuickQueryColorizer colorizer = this.fColorizers.get(config);
        colorizer.allowUpdates(false);
        try {
            colorizer.setExpression(config.getCachedExpression());
            colorizer.setColor(config.getColor());
            colorizer.setEnabled(config.isEnabled());
            colorizer.setPriority(config.getPriority());
        }
        finally {
            colorizer.allowUpdates(true);
        }
    }

    protected void removeColorizer(ColorizeConfiguration config) {
        QuickQueryColorizer colorizer = this.fColorizers.remove(config);
        colorizer.setEnabled(false);
    }

    private void initializeView() {
        if (this.fViewModel != null && this.getPlan() != null) {
            this.fViewModel.setInput(this.getPlan());
            this.getSectionSite().getViewSite().getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    AbstractPlanItemViewerSection.this.onInitializePlan();
                }
            });
        }
    }

    private void updateSlideout(SlideoutMode mode) {
        SlideoutMode oldMode = this.fSlideoutMode;
        this.fSlideoutMode = mode;
        if (this.fSlideout != null) {
            if (this.fSlideoutMode == SlideoutMode.None || oldMode != SlideoutMode.None && oldMode != this.fSlideoutMode) {
                this.fSlideout.closeSlideout();
            }
            if (this.fSlideoutMode != SlideoutMode.None) {
                this.fSlideout.showSlideout();
            }
        }
    }

    private void hookContextMenu() {
        IViewSite viewSite = this.getSectionSite().getViewSite();
        MenuManager contextMenuMgr = new MenuManager("#PopupMenu");
        contextMenuMgr.setRemoveAllWhenShown(true);
        contextMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("group.open"));
                manager.add((IContributionItem)new Separator("group.schedule"));
                manager.add((IContributionItem)new Separator("group.edit"));
                AbstractPlanItemViewerSection.this.fActionGroup.fillContextMenu(manager);
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        viewSite.registerContextMenu(contextMenuMgr, (ISelectionProvider)this.fWorkItemSelectionProvider);
        final Menu menu = contextMenuMgr.createContextMenu((Control)this.fCanvas);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                menu.setDefaultItem(this.findItemForAction(menu, "com.ibm.team.apt.actions.myWork.openWorkItem"));
            }

            private MenuItem findItemForAction(Menu menu2, String id) {
                MenuItem[] items;
                MenuItem[] menuItemArray = items = menu2.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    ActionContributionItem contributionItem;
                    MenuItem item = menuItemArray[n2];
                    if (item.getData() instanceof ActionContributionItem && id.equals((contributionItem = (ActionContributionItem)item.getData()).getId())) {
                        return item;
                    }
                    ++n2;
                }
                return null;
            }
        });
        this.fCanvas.setMenu(menu);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SlideoutMode {
        None,
        Details,
        News;

    }

    private class WorkItemSelectionProvider
    implements ISelectionProvider,
    ISelectionChangedListener {
        private IStructuredSelection fCachedSelection = null;
        private final ListenerList fSelectionListeners = new ListenerList();

        private WorkItemSelectionProvider() {
        }

        public void sourceChanged(ISelectionProvider oldProvider, ISelectionProvider newProvider) {
            if (oldProvider != null) {
                oldProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            if (newProvider != null) {
                newProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fSelectionListeners.add((Object)listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fSelectionListeners.remove((Object)listener);
        }

        public ISelection getSelection() {
            if (this.fCachedSelection == null) {
                this.fCachedSelection = this.getWorkItemSelection();
            }
            return this.fCachedSelection;
        }

        public void setSelection(ISelection selection) {
            if (AbstractPlanItemViewerSection.this.fViewModel == null) {
                return;
            }
            this.fCachedSelection = null;
            if (selection instanceof IStructuredSelection) {
                ResolvedPersonalPlan plan = AbstractPlanItemViewerSection.this.getPlan();
                Object[] selectedObjects = ((IStructuredSelection)selection).toArray();
                ArrayList<PersonalPlanItem> toSelect = new ArrayList<PersonalPlanItem>();
                Object[] objectArray = selectedObjects;
                int n = selectedObjects.length;
                int n2 = 0;
                while (n2 < n) {
                    PersonalPlanItem planItem;
                    Object selectedObject = objectArray[n2];
                    if (selectedObject instanceof IWorkItemHandle && (planItem = plan.getPlanItem((IWorkItemHandle)selectedObject)) != null) {
                        toSelect.add(planItem);
                    }
                    ++n2;
                }
                AbstractPlanItemViewerSection.this.fViewModel.setSelectedElements(toSelect);
            }
        }

        public void selectionChanged(SelectionChangedEvent viewerEvent) {
            this.fCachedSelection = null;
            Object[] listeners = this.fSelectionListeners.getListeners();
            if (listeners.length > 0) {
                IStructuredSelection newSelection = this.getWorkItemSelection();
                final SelectionChangedEvent modelEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)newSelection);
                Object[] objectArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    final Object listener = objectArray[n2];
                    SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            ((ISelectionChangedListener)listener).selectionChanged(modelEvent);
                        }

                        public void handleException(Throwable exception) {
                            PlanningUIPlugin.log(exception);
                        }
                    });
                    ++n2;
                }
            }
        }

        private IStructuredSelection getWorkItemSelection() {
            if (AbstractPlanItemViewerSection.this.fViewModel == null) {
                return StructuredSelection.EMPTY;
            }
            Collection<OutlineEntry<?>> selectedEntries = AbstractPlanItemViewerSection.this.fViewModel.getSelectedEntries();
            ArrayList<IWorkItemHandle> workItems = new ArrayList<IWorkItemHandle>(selectedEntries.size());
            for (OutlineEntry<?> entry : selectedEntries) {
                if (!(entry.getElement() instanceof PlanItem)) continue;
                workItems.add(((PlanItem)entry.getElement()).getWorkItemHandle());
            }
            return new StructuredSelection(workItems.toArray());
        }
    }
}

