/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.jface;

import com.ibm.team.apt.internal.ide.ui.jface.CheckboxLabelAdapter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CheckboxListViewer
extends ContentViewer
implements ICheckable {
    private final Composite fContainer;
    private final Composite fPackParent;
    private final List<Button> fButtons = new ArrayList<Button>();
    private ListenerList fCheckStateListeners = new ListenerList();

    public CheckboxListViewer(Composite parent, int style, Composite packParent) {
        this.fPackParent = packParent;
        this.fContainer = new Composite(parent, style);
        this.fContainer.setLayout((Layout)new ListLayout());
        if (packParent != null) {
            boolean parentIsChildOfPackParent = false;
            while (parent != null) {
                if (parent == packParent) {
                    parentIsChildOfPackParent = true;
                    break;
                }
                parent = parent.getParent();
            }
            Assert.isLegal((boolean)parentIsChildOfPackParent);
        }
    }

    public Control getControl() {
        return this.fContainer;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isLegal((boolean)(labelProvider instanceof CheckboxLabelAdapter));
        super.setLabelProvider(labelProvider);
    }

    public void setContentProvider(IContentProvider contentProvider) {
        Assert.isLegal((boolean)(contentProvider instanceof IStructuredContentProvider));
        super.setContentProvider(contentProvider);
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.fCheckStateListeners.add((Object)listener);
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.fCheckStateListeners.remove((Object)listener);
    }

    public boolean getChecked(Object element) {
        Button button = this.findElement(element);
        return button != null ? button.getSelection() : false;
    }

    public boolean setChecked(Object element, boolean state) {
        Button button = this.findElement(element);
        if (button == null) {
            return false;
        }
        button.setSelection(state);
        return true;
    }

    public void setAllChecked(boolean state) {
        for (Button button : this.fButtons) {
            button.setSelection(state);
        }
    }

    public void setInput(Object input) {
        super.setInput(input);
        this.refresh();
    }

    public void refresh() {
        this.removeAll();
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.getContentProvider();
        CheckboxLabelAdapter labelProvider = (CheckboxLabelAdapter)this.getLabelProvider();
        if (contentProvider != null && labelProvider != null) {
            Object[] elements;
            Object[] objectArray = elements = contentProvider.getElements(this.getInput());
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.createButton(element, labelProvider.getText(element), labelProvider.isChecked(element));
                ++n2;
            }
        }
        if (this.fPackParent != null) {
            this.fPackParent.layout(true, true);
        } else {
            this.fContainer.layout(true, true);
        }
    }

    public ISelection getSelection() {
        return new StructuredSelection();
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    private Button findElement(Object element) {
        Assert.isLegal((element != null ? 1 : 0) != 0);
        for (Button button : this.fButtons) {
            if (element != button.getData()) continue;
            return button;
        }
        return null;
    }

    private void removeAll() {
        for (Button button : this.fButtons) {
            button.dispose();
        }
        this.fButtons.clear();
    }

    private void fireEvent(Object element, boolean newState) {
        Object[] listeners = this.fCheckStateListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ICheckStateListener listener = (ICheckStateListener)listeners[i];
            CheckStateChangedEvent event = new CheckStateChangedEvent((ICheckable)this, element, newState);
            listener.checkStateChanged(event);
            ++i;
        }
    }

    private Button createButton(final Object element, String text, boolean selected) {
        final Button result = new Button(this.fContainer, 32);
        result.setText(text);
        result.setSelection(selected);
        result.setData(element);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckboxListViewer.this.fireEvent(element, result.getSelection());
            }
        });
        this.fButtons.add(result);
        return result;
    }

    private class ListLayout
    extends Layout {
        private final int HORIZONTAL_INDENT = 5;
        private final int VERTICAL_SPACING = 5;

        private ListLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Assert.isLegal((composite == CheckboxListViewer.this.fContainer ? 1 : 0) != 0);
            int preferredWidth = 0;
            int preferredHeight = 0;
            for (Button button : CheckboxListViewer.this.fButtons) {
                Point preferredSize = button.computeSize(wHint, hHint);
                preferredWidth = Math.max(preferredSize.x, preferredWidth);
                preferredHeight += preferredSize.y + 5;
            }
            return new Point(preferredWidth, preferredHeight);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Assert.isLegal((composite == CheckboxListViewer.this.fContainer ? 1 : 0) != 0);
            Rectangle clientArea = CheckboxListViewer.this.fContainer.getClientArea();
            int left = clientArea.x + 5;
            int top = clientArea.y;
            int width = clientArea.width - 5;
            for (Button button : CheckboxListViewer.this.fButtons) {
                Point preferredSize = button.computeSize(width, -1);
                button.setBounds(left, top, width, preferredSize.y);
                top += preferredSize.y + 5;
            }
        }
    }
}

