/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki.actions;

import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiPartitionScanner;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiViewer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.TextNavigationAction;

public class SmartTableNavigation
extends TextNavigationAction {
    private final WikiViewer fViewer;

    public SmartTableNavigation(WikiViewer viewer) {
        super(viewer.getTextWidget(), 0x1040004);
        this.fViewer = viewer;
    }

    public void run() {
        StyledText st;
        boolean isMatchingPartition = false;
        boolean isSmartHomeEndEnabled = false;
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        if (store != null) {
            isSmartHomeEndEnabled = store.getBoolean("AbstractTextEditor.Navigation.SmartHomeEnd");
        }
        if ((st = this.fViewer.getTextWidget()) == null || st.isDisposed()) {
            return;
        }
        IDocument document = this.fViewer.getDocument();
        if (document == null) {
            return;
        }
        int caretOffset = st.getCaretOffset();
        int lineNumber = st.getLineAtOffset(caretOffset);
        int lineOffset = st.getOffsetAtLine(lineNumber);
        int newCaretOffset = -1;
        try {
            String type = ((IDocumentExtension3)document).getPartition(WikiPartitionScanner.Partitions.WIKI_PARTITING, caretOffset, true).getType();
            if (WikiPartitionScanner.Partitions.TABLE.id.equals(type)) {
                String line;
                int skip;
                isMatchingPartition = true;
                IRegion region = document.getLineInformation(lineNumber);
                int lineLength = region.getLength();
                if (lineLength > 0 && (skip = this.getCellStartPosition(line = st.getText(region.getOffset(), region.getOffset() + lineLength), caretOffset - lineOffset, line.length())) != -1) {
                    newCaretOffset = caretOffset + skip;
                }
            }
        }
        catch (BadLocationException e) {
            PlanningUIPlugin.log(e);
        }
        catch (BadPartitioningException e) {
            PlanningUIPlugin.log(e);
        }
        if (isMatchingPartition && isSmartHomeEndEnabled && newCaretOffset != -1) {
            st.setCaretOffset(newCaretOffset);
        } else {
            super.run();
        }
    }

    protected int getCellStartPosition(String line, int offset, int length) {
        int index = offset;
        while (line.charAt(index) != '|') {
            if (++index < length) continue;
            return -1;
        }
        if (index <= length - 1) {
            ++index;
        }
        return index - offset;
    }
}

