/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki.actions;

import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiPartitionScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.TextNavigationAction;

public class SmartHomeAction
extends TextNavigationAction {
    private static final char BEGIN_HEADING = '=';
    private static final char BEGIN_BULLET = '*';
    private static final char BEGIN_NUMBERED = '#';
    private final ISourceViewer fViewer;

    public SmartHomeAction(ISourceViewer viewer) {
        super(viewer.getTextWidget(), 0x1000007);
        this.fViewer = viewer;
    }

    protected int getLineStartPosition(String line, int length, char ch) {
        int index = 0;
        while (index < length && line.charAt(index) == ch) {
            ++index;
        }
        if (index < length && Character.isWhitespace(line.charAt(index))) {
            ++index;
        }
        return index;
    }

    public void run() {
        int index;
        StyledText st;
        boolean isMatchingPartition = false;
        boolean isSmartHomeEndEnabled = false;
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        if (store != null) {
            isSmartHomeEndEnabled = store.getBoolean("AbstractTextEditor.Navigation.SmartHomeEnd");
        }
        if ((st = this.fViewer.getTextWidget()) == null || st.isDisposed()) {
            return;
        }
        IDocument document = this.fViewer.getDocument();
        int caretOffset = st.getCaretOffset();
        int lineNumber = st.getLineAtOffset(caretOffset);
        int lineOffset = st.getOffsetAtLine(lineNumber);
        int offsetInLine = caretOffset - lineOffset;
        int lineLength = -1;
        int ch = 0;
        try {
            String type = ((IDocumentExtension3)document).getPartition(WikiPartitionScanner.Partitions.WIKI_PARTITING, caretOffset, true).getType();
            if (WikiPartitionScanner.Partitions.HEADING.id.equals(type)) {
                isMatchingPartition = true;
                ch = 61;
            } else if (WikiPartitionScanner.Partitions.BULLET_LIST.id.equals(type)) {
                isMatchingPartition = true;
                ch = 42;
            } else if (WikiPartitionScanner.Partitions.NUMBERED_LIST.id.equals(type)) {
                isMatchingPartition = true;
                ch = 35;
            }
            IRegion line = document.getLineInformation(lineNumber);
            lineLength = line.getLength();
        }
        catch (BadLocationException e) {
            PlanningUIPlugin.log(e);
        }
        catch (BadPartitioningException e) {
            PlanningUIPlugin.log(e);
        }
        String line = "";
        if (lineLength > 0) {
            int end = lineOffset + lineLength - 1;
            end = Math.min(end, st.getCharCount() - 1);
            line = st.getText(lineOffset, end);
        }
        int newCaretOffset = -1;
        newCaretOffset = isSmartHomeEndEnabled && isMatchingPartition ? ((index = this.getLineStartPosition(line, lineLength, (char)ch)) < offsetInLine ? lineOffset + index : lineOffset) : lineOffset;
        st.setCaretOffset(newCaretOffset);
    }
}

