/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki.actions;

import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPage;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPageAttachment;
import com.ibm.team.apt.internal.client.wiki.WikiClient;
import com.ibm.team.apt.internal.client.wiki.WikiManager;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.editor.WikiFormPage2;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.util.ExceptionHandler;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.texteditor.IUpdate;

public class RemoveAttachmentAction
extends Action
implements IUpdate {
    private static final String MSG_ONE_ATTACHMENT = Messages.RemoveAttachmentAction_CONFIRM_REMOVE_ATTACHEMENT_MESSAGE_SINGULAR;
    private static final String MSG_MANY_ATTACHMENTS = Messages.RemoveAttachmentAction_CONFIRM_REMOVE_ATTACHEMENT_MESSAGE_PLURAL;
    private WikiFormPage2 fPage;
    private TableViewer fViewer;
    private final Section fSection;

    public RemoveAttachmentAction(WikiFormPage2 page, Section section) {
        super(Messages.RemoveAttachmentAction_LABEL, ImagePool.REMOVE);
        Assert.isNotNull((Object)page);
        Assert.isNotNull((Object)section);
        this.fPage = page;
        this.fViewer = page.getAttachmentsViewer();
        this.fSection = section;
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RemoveAttachmentAction.this.update();
            }
        });
        this.fSection.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                RemoveAttachmentAction.this.update();
            }

            public void expansionStateChanging(ExpansionEvent e) {
                RemoveAttachmentAction.this.update();
            }
        });
        this.update();
    }

    public void update() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        Iterator iter = selection.iterator();
        boolean enabled = true;
        enabled &= this.fSection.isExpanded();
        enabled &= !selection.isEmpty();
        while (iter.hasNext() && enabled) {
            Object next = iter.next();
            if (!(next instanceof ResolvedWikiPageAttachment)) continue;
            enabled &= !((ResolvedWikiPageAttachment)next).isPredefined();
        }
        this.setEnabled(enabled);
    }

    public void run() {
        final ResolvedWikiPage input = this.fPage.getInput();
        final WikiManager manager = WikiClient.getWikiManager((IItem)input.getWikiPage());
        final Object[] objects = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        IProgressService service = this.fPage.getEditorSite().getWorkbenchWindow().getWorkbench().getProgressService();
        String msg = objects.length > 1 ? NLS.bind((String)MSG_MANY_ATTACHMENTS, (Object[])new Object[]{objects.length}) : NLS.bind((String)MSG_ONE_ATTACHMENT, (Object[])new Object[]{((ResolvedWikiPageAttachment)objects[0]).getAttachment().getName()});
        boolean proceed = MessageDialog.openConfirm((Shell)this.fPage.getSite().getShell(), (String)Messages.RemoveAttachmentAction_CONFIRM_REMOVE_ATTACHEMENT_TITLE, (String)msg);
        if (!proceed) {
            return;
        }
        try {
            service.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Object[] objectArray = objects;
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        if (object instanceof ResolvedWikiPageAttachment) {
                            try {
                                final ResolvedWikiPageAttachment attachment = (ResolvedWikiPageAttachment)object;
                                manager.deleteAttachment(attachment.getAttachment(), monitor);
                                UI.syncExec((Control)RemoveAttachmentAction.this.fPage.getSite().getShell(), new Runnable(){

                                    public void run() {
                                        input.removeAttachment(attachment);
                                    }
                                });
                            }
                            catch (TeamRepositoryException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        ++n2;
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.fPage.getEditorSite().getShell(), Messages.RemoveAttachmentAction_FAILED_DIALOG_TITLE, Messages.RemoveAttachmentAction_FAILED_DIALOG_MESSAGE);
        }
        catch (InterruptedException interruptedException) {}
    }
}

