/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki.actions;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.wiki.Attachments;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPage;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPageAttachment;
import com.ibm.team.apt.internal.common.wiki.IWikiPageAttachment;
import com.ibm.team.apt.internal.ide.ui.editor.WikiFormPage2;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadAttachmentAction
extends Action {
    private final WikiFormPage2 fPage;
    private TableViewer fViewer;

    public DownloadAttachmentAction(WikiFormPage2 page) {
        super(Messages.DownloadAttachmentAction_LABEL);
        this.fPage = page;
        this.fViewer = page.getAttachmentsViewer();
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DownloadAttachmentAction.this.update();
            }
        });
        this.update();
    }

    protected void update() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.isEmpty()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    private String openFileDialog(List<IWikiPageAttachment> attachments) {
        int size = attachments.size();
        if (size == 1) {
            String path;
            FileDialog dialog = new FileDialog(this.fPage.getSite().getShell(), 8192);
            Preferences preferences = PlanningClientPlugin.getDefault().getPluginPreferences();
            if (preferences != null && (path = preferences.getString("LAST_ATTACHMENT_LOC")) != null) {
                dialog.setFilterPath(new File(path).getParent());
            }
            dialog.setFileName(attachments.get(0).getName());
            return dialog.open();
        }
        DirectoryDialog dialog = new DirectoryDialog(this.fPage.getSite().getShell());
        dialog.setText(Messages.DownloadAttachmentAction_CHOOSE_DIR_TITLE);
        dialog.setMessage(Messages.DownloadAttachmentAction_CHOOSE_DIR_DETAIL);
        return dialog.open();
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        List list = selection.toList();
        String path = this.openFileDialog(Attachments.getAttachments((List)list));
        if (path == null) {
            return;
        }
        for (Object next : selection) {
            if (!(next instanceof ResolvedWikiPageAttachment)) continue;
            ResolvedWikiPageAttachment resolvedAttachment = (ResolvedWikiPageAttachment)next;
            IWikiPageAttachment attachment = resolvedAttachment.getAttachment();
            DownloadAttachmentJob job = new DownloadAttachmentJob(attachment, path);
            job.schedule();
        }
    }

    public boolean runFromUUID(String uuidValue) {
        UUID uuid;
        try {
            uuid = UUID.valueOf((String)uuidValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        ResolvedWikiPage page = this.fPage.getInput();
        List attachments = Attachments.getAttachments((List)page.getAttachments());
        Iterator iter = attachments.iterator();
        IWikiPageAttachment attachment = null;
        while (iter.hasNext() && attachment == null) {
            IWikiPageAttachment next = (IWikiPageAttachment)iter.next();
            if (!next.getItemId().equals((Object)uuid)) continue;
            attachment = next;
        }
        if (attachment == null) {
            return false;
        }
        String open = this.openFileDialog(Arrays.asList(attachment));
        if (open == null) {
            return false;
        }
        DownloadAttachmentJob job = new DownloadAttachmentJob(attachment, open);
        job.schedule();
        return true;
    }

    private class DownloadAttachmentJob
    extends FoundationJob {
        private final String fTarget;
        private final IWikiPageAttachment fAttachment;

        public DownloadAttachmentJob(IWikiPageAttachment attachment, String target) {
            super(NLS.bind((String)Messages.DownloadAttachmentAction_JOB_DOWNLOAD_ATTACHMENT, (Object)attachment.getName()));
            this.fAttachment = attachment;
            this.fTarget = target;
            this.setPriority(20);
            this.setSystem(false);
            this.setUser(true);
            this.setRule(new ExclusiveSchedulingRule());
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            IContentManager contentManager = PlanningClientPlugin.getTeamRepository((IItemHandle)this.fAttachment).contentManager();
            File file = new File(this.fTarget);
            if (file.isDirectory()) {
                file.mkdirs();
                file = new File(file.getAbsoluteFile() + File.separator + this.fAttachment.getName());
            }
            if (file.exists()) {
                final File finalFile = file;
                final boolean[] confirm = new boolean[]{true};
                UI.syncExec(DownloadAttachmentAction.this.fViewer.getControl(), new Runnable(){

                    public void run() {
                        confirm[0] = MessageDialog.openConfirm((Shell)DownloadAttachmentAction.this.fViewer.getControl().getShell(), (String)Messages.DownloadAttachmentAction_REPLACE_CONFIRM_TITLE, (String)NLS.bind((String)Messages.DownloadAttachmentAction_REPLACE_CONFIRM_DETAIL, (Object)finalFile.getPath()));
                    }
                });
                if (!confirm[0]) {
                    return Status.CANCEL_STATUS;
                }
            }
            FileOutputStream outStream = new FileOutputStream(file);
            contentManager.retrieveContent(this.fAttachment.getContent(), (OutputStream)outStream, monitor);
            this.close(outStream);
            return Status.OK_STATUS;
        }

        private void close(Closeable closable) {
            try {
                closable.close();
            }
            catch (IOException iOException) {}
        }
    }

    private final class ExclusiveSchedulingRule
    implements ISchedulingRule {
        private ExclusiveSchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof ExclusiveSchedulingRule;
        }
    }
}

