/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki.actions;

import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPage;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPageAttachment;
import com.ibm.team.apt.internal.client.wiki.WikiClient;
import com.ibm.team.apt.internal.client.wiki.WikiManager;
import com.ibm.team.apt.internal.common.wiki.IWikiPageAttachment;
import com.ibm.team.apt.internal.common.wiki.IWikiPageHandle;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.editor.IterationPlanEditor;
import com.ibm.team.apt.internal.ide.ui.editor.WikiFormPage2;
import com.ibm.team.apt.internal.ide.ui.editor.WikiPageAttachmentStore;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.util.ExceptionHandler;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.rcp.core.internal.ContentTypeUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddAttachmentAction
extends Action {
    public static final String LAST_ATTACHMENT_LOC = "LAST_ATTACHMENT_LOC";
    private final WikiFormPage2 fPage;
    private LocalResourceManager fResources;
    private final Section fSection;

    public AddAttachmentAction(WikiFormPage2 page, Section section) {
        super(Messages.AddAttachmentAction_LABEL, ImagePool.ADD_ATTACHMENT);
        Assert.isNotNull((Object)page);
        Assert.isNotNull((Object)section);
        this.fPage = page;
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), this.fPage.getPartControl());
        this.fSection = section;
    }

    public boolean isEnabled() {
        IterationPlanData data = ((IterationPlanEditor)this.fPage.getEditor()).getIterationPlanData();
        return data != null && data.canSavePages();
    }

    public void run() {
        String result;
        ResolvedWikiPage page = this.fPage.getInput();
        if (page == null) {
            return;
        }
        if (!this.fSection.isExpanded()) {
            this.fSection.setExpanded(true);
        }
        String path = null;
        Preferences preferences = PlanningClientPlugin.getDefault().getPluginPreferences();
        if (preferences != null) {
            path = preferences.getString(LAST_ATTACHMENT_LOC);
        }
        FileDialog dialog = new FileDialog(this.fPage.getEditorSite().getShell(), 4098);
        if (path != null && path.length() > 0) {
            dialog.setFileName(path);
        }
        if ((result = dialog.open()) != null) {
            if (preferences != null) {
                preferences.setValue(LAST_ATTACHMENT_LOC, result);
                PlanningClientPlugin.getDefault().savePluginPreferences();
            }
            String dir = dialog.getFilterPath();
            String[] names = dialog.getFileNames();
            ArrayList<String> fileNames = new ArrayList<String>(names.length);
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                fileNames.add(String.valueOf(dir) + File.separator + name);
                ++n2;
            }
            this.createAttachments(page, fileNames);
        }
    }

    protected void createAttachments(final ResolvedWikiPage page, final List<String> fileNames) {
        Assert.isNotNull((Object)page);
        Assert.isNotNull(fileNames);
        final IContributor creator = PlanningClientPlugin.getTeamRepository((IItemHandle)page.getOwner()).loggedInContributor();
        final IContentManager contentManager = PlanningClientPlugin.getTeamRepository((IItemHandle)page.getWikiPage()).contentManager();
        IProgressService progressService = this.fPage.getSite().getWorkbenchWindow().getWorkbench().getProgressService();
        try {
            progressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IWorkItemClient client = PlanningClientPlugin.getWorkItemClient((IItemHandle)AddAttachmentAction.this.fPage.getInput().getWikiPage());
                        final long maxAttachmentSize = client.fetchMaxAttachmentSize(monitor);
                        ArrayList<File> files = new ArrayList<File>(fileNames.size());
                        final ArrayList<String> filesTooBig = new ArrayList<String>();
                        for (String fileName : fileNames) {
                            File file = new File(fileName);
                            if (!file.exists()) continue;
                            long length = file.length();
                            if (length <= maxAttachmentSize) {
                                files.add(file);
                                continue;
                            }
                            filesTooBig.add(fileName);
                        }
                        if (!filesTooBig.isEmpty()) {
                            UI.syncExec((Control)AddAttachmentAction.this.fPage.getSite().getShell(), new Runnable(){

                                public void run() {
                                    AddAttachmentAction.this.handleAttchmentsToBig(filesTooBig, maxAttachmentSize);
                                }
                            });
                            return;
                        }
                        for (File file : files) {
                            IWikiPageAttachment attachment = null;
                            attachment = AddAttachmentAction.createAttachmentFromFile(file, contentManager, monitor);
                            attachment.setDescription(null);
                            attachment.setCreator((IContributorHandle)creator);
                            attachment.setOwner((IWikiPageHandle)page.getWikiPage());
                            WikiManager manager = WikiClient.getWikiManager((IItem)page.getWikiPage());
                            attachment = manager.saveAttachment(attachment, monitor);
                            WikiPageAttachmentStore.getInstance().registerWikiPageAttachment(attachment);
                            final ResolvedWikiPageAttachment attachment2 = new ResolvedWikiPageAttachment(attachment, creator, false);
                            UI.syncExec((Control)AddAttachmentAction.this.fPage.getSite().getShell(), new Runnable(){

                                public void run() {
                                    page.addAttachment(attachment2);
                                }
                            });
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.fPage.getEditorSite().getShell(), Messages.AddAttachmentAction_FAILED_TITLE, Messages.AddAttachmentAction_FAILED_MESSAGE);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static IWikiPageAttachment createAttachmentFromFile(File file, IContentManager contentManager, IProgressMonitor monitor) throws InvocationTargetException, CoreException, TeamRepositoryException {
        IFileStore fileStore = EFS.getStore((URI)file.toURI());
        IContentDescription contentDescription = ContentTypeUtils.getContentDescription((IFileStore)fileStore);
        String mime = ContentTypeUtils.getMIMEType((String)fileStore.getName(), (IContentDescription)contentDescription);
        String charset = ContentTypeUtils.getCharSet((IContentDescription)contentDescription, (String)mime);
        IWikiPageAttachment attachment = null;
        InputStream inStream = fileStore.openInputStream(0, monitor);
        try {
            attachment = AddAttachmentAction.createAttachmentFromStream(contentManager, inStream, mime, charset, monitor);
        }
        finally {
            AddAttachmentAction.close(inStream);
        }
        if (attachment != null) {
            attachment.setName(file.getName());
        }
        return attachment;
    }

    public static IWikiPageAttachment createAttachmentFromStream(IContentManager contentManager, InputStream inStream, String mimeType, String charset, IProgressMonitor monitor) throws TeamRepositoryException {
        IContent content = contentManager.storeContent(mimeType, charset, inStream, monitor);
        IWikiPageAttachment attachment = (IWikiPageAttachment)IWikiPageAttachment.ITEM_TYPE.createItem();
        attachment.setContent(content);
        return attachment;
    }

    private static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {}
    }

    private void handleAttchmentsToBig(final List<String> attachments, long maxAttachmentSize) {
        Shell shell = this.fPage.getSite().getShell();
        String title = Messages.AddAttachmentAction_ATTACHMENTS_TOO_BIG_TITLE;
        long maxValueInMB = maxAttachmentSize / 1024L / 1024L;
        if (attachments.size() == 1) {
            String message = NLS.bind((String)Messages.AddAttachmentAction_ATTACHMENTS_TOO_BIG_MESSAGE_SINGULAR, (Object)attachments.get(0), (Object)maxValueInMB);
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        } else {
            String message = NLS.bind((String)Messages.AddAttachmentAction_ATTACHMENTS_TOO_BIG_MESSAGE_PLURAL, (Object)attachments.size(), (Object)maxValueInMB);
            ListDialog dialog = new ListDialog(shell);
            dialog.setTitle(title);
            dialog.setMessage(message);
            dialog.setContentProvider(new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return attachments.toArray();
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }
            });
            dialog.setLabelProvider(new ILabelProvider(){
                private final Image fImgAttachment;
                {
                    this.fImgAttachment = AddAttachmentAction.this.fResources.createImage(ImagePool.ADD_ATTACHMENT);
                }

                public Image getImage(Object element) {
                    if (element instanceof String) {
                        return this.fImgAttachment;
                    }
                    return null;
                }

                public String getText(Object element) {
                    if (element instanceof String) {
                        return (String)element;
                    }
                    return null;
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void dispose() {
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            dialog.setInput(attachments);
            dialog.open();
        }
    }
}

