/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiSourceViewerConfiguration;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.xxx.DeleteLineTarget;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.PatchedStyledText;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class WikiViewer
extends SourceViewer {
    private final ITextEditor fTextEditor = new ITextEditor(){
        private static final String CLASS_INCREMENTAL_FIND = "org.eclipse.ui.texteditor.IncrementalFindTarget";
        private IEditorSite fSite;
        private IEditorInput fInput;

        public ISelectionProvider getSelectionProvider() {
            return WikiViewer.this.getSelectionProvider();
        }

        public void selectAndReveal(int offset, int length) {
            WikiViewer.this.setSelectedRange(offset, length);
            WikiViewer.this.revealRange(offset, length);
        }

        public boolean isEditable() {
            return true;
        }

        public void init(IEditorSite site, IEditorInput input) throws PartInitException {
            Assert.isTrue((site == null || this.fSite == null ? 1 : 0) != 0);
            Assert.isTrue((input == null || this.fInput == null ? 1 : 0) != 0);
            this.fSite = site;
            this.fInput = input;
        }

        public IEditorInput getEditorInput() {
            return this.fInput;
        }

        public IEditorSite getEditorSite() {
            return this.fSite;
        }

        public IWorkbenchPartSite getSite() {
            return this.fSite;
        }

        public void setFocus() {
            WikiViewer.this.getTextWidget().setFocus();
        }

        public Object getAdapter(Class adapter) {
            if (ITextOperationTarget.class.equals((Object)adapter)) {
                return WikiViewer.this;
            }
            if (CLASS_INCREMENTAL_FIND.equals(adapter.getName())) {
                return WikiViewer.this.getFindReplaceTarget();
            }
            if (IFindReplaceTarget.class.equals((Object)adapter)) {
                return WikiViewer.this.getFindReplaceTarget();
            }
            if (DeleteLineTarget.class.equals((Object)adapter)) {
                return new DeleteLineTarget((ITextViewer)WikiViewer.this);
            }
            return null;
        }

        public IAction getAction(String actionId) {
            throw new UnsupportedOperationException();
        }

        public IDocumentProvider getDocumentProvider() {
            throw new UnsupportedOperationException();
        }

        public IRegion getHighlightRange() {
            throw new UnsupportedOperationException();
        }

        public String getTitle() {
            throw new UnsupportedOperationException();
        }

        public Image getTitleImage() {
            throw new UnsupportedOperationException();
        }

        public String getTitleToolTip() {
            throw new UnsupportedOperationException();
        }

        public void addPropertyListener(IPropertyListener listener) {
            throw new UnsupportedOperationException();
        }

        public void removePropertyListener(IPropertyListener listener) {
            throw new UnsupportedOperationException();
        }

        public void setAction(String actionID, IAction action) {
            throw new UnsupportedOperationException();
        }

        public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
            throw new UnsupportedOperationException();
        }

        public void removeActionActivationCode(String actionId) {
            throw new UnsupportedOperationException();
        }

        public void createPartControl(Composite parent) {
            throw new UnsupportedOperationException();
        }

        public void dispose() {
            throw new UnsupportedOperationException();
        }

        public void close(boolean save) {
            throw new UnsupportedOperationException();
        }

        public void doRevertToSaved() {
            throw new UnsupportedOperationException();
        }

        public void doSave(IProgressMonitor monitor) {
            throw new UnsupportedOperationException();
        }

        public void doSaveAs() {
            throw new UnsupportedOperationException();
        }

        public boolean isDirty() {
            throw new UnsupportedOperationException();
        }

        public boolean isSaveAsAllowed() {
            throw new UnsupportedOperationException();
        }

        public boolean isSaveOnCloseNeeded() {
            throw new UnsupportedOperationException();
        }

        public void setHighlightRange(int offset, int length, boolean moveCursor) {
            throw new UnsupportedOperationException();
        }

        public void resetHighlightRange() {
            throw new UnsupportedOperationException();
        }

        public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
            throw new UnsupportedOperationException();
        }

        public boolean showsHighlightRangeOnly() {
            throw new UnsupportedOperationException();
        }
    };
    private final ISharedTextColors fSharedColors = new ISharedTextColors(){

        public Color getColor(RGB rgb) {
            return WikiViewer.this.fResources.createColor(rgb);
        }

        public void dispose() {
        }
    };
    private LocalResourceManager fResources;
    private static MarkerAnnotationPreferences fgAnnotationPreferences;

    public WikiViewer(Composite parent, IVerticalRuler ruler, int styles) {
        super(parent, ruler, styles);
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.configure((SourceViewerConfiguration)new WikiSourceViewerConfiguration((ResourceManager)this.fResources));
        this.configureSourceViewerDecorationSupport(new SourceViewerDecorationSupport((ISourceViewer)this, null, null, this.fSharedColors));
    }

    public LocalResourceManager getResources() {
        return this.fResources;
    }

    protected StyledText createTextWidget(Composite parent, int styles) {
        return new PatchedStyledText(parent, styles);
    }

    protected void configureSourceViewerDecorationSupport(final SourceViewerDecorationSupport support) {
        Iterator iter = WikiViewer.getAnnotationPreferences().getAnnotationPreferences().iterator();
        while (iter.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)iter.next());
        }
        support.install(EditorsUI.getPreferenceStore());
        support.setCursorLinePainterPreferenceKeys("currentLine", "currentLineColor");
        support.setMarginPainterPreferenceKeys("printMargin", "printMarginColor", "printMarginColumn");
        this.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                support.dispose();
            }
        });
    }

    public static MarkerAnnotationPreferences getAnnotationPreferences() {
        if (fgAnnotationPreferences == null) {
            fgAnnotationPreferences = new MarkerAnnotationPreferences();
        }
        return fgAnnotationPreferences;
    }

    public ISharedTextColors getSharedColors() {
        return this.fSharedColors;
    }

    public ITextEditor getTextEditor() {
        return this.fTextEditor;
    }
}

