/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.ide.ui.common.IOutlineSettingsListener;
import com.ibm.team.apt.internal.ide.ui.common.OutlineSettingChangeEvent;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupByDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.SortMode;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.OutlineFilterDescriptor;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanOutlineSettingChangeEvent;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.ProgressMode;

public class PlanOutlineSettingsListener
implements IOutlineSettingsListener {
    private final IPlanOutlineSettings fSettings;

    public PlanOutlineSettingsListener() {
        this(null);
    }

    public PlanOutlineSettingsListener(IPlanOutlineSettings settings) {
        this.fSettings = settings;
    }

    public void refresh() {
        if (this.fSettings != null) {
            this.showDetailsChanged(this.fSettings.getShowDetails());
            this.groupModeChanged(this.fSettings.getGroupMode());
            this.sortModeChanged(this.fSettings.getSortMode());
        }
    }

    public void showDetailsChanged(boolean show) {
    }

    public void groupModeChanged(GroupByDescription mode) {
    }

    public void sortModeChanged(SortMode mode) {
    }

    public void filterChanged(OutlineFilterDescriptor filter, boolean active) {
    }

    public void ownerProgressModeChanged(ProgressMode newValue) {
    }

    public void settingChanged(OutlineSettingChangeEvent event) {
        switch ((PlanOutlineSettingChangeEvent.Property)event.getChangedProperty()) {
            case REFRESH: {
                this.refresh();
                break;
            }
            case SHOW_DETAILS: {
                this.showDetailsChanged((Boolean)event.getNewValue());
                break;
            }
            case GROUP_MODE: {
                this.groupModeChanged((GroupByDescription)event.getNewValue());
                break;
            }
            case SORT_MODE: {
                this.sortModeChanged((SortMode)((Object)event.getNewValue()));
                break;
            }
            case FILTER: {
                this.filterChanged((OutlineFilterDescriptor)event.getNewValue(), (Boolean)event.getParameters()[0]);
                break;
            }
            case OWNER_PROGRESS_MODE: {
                this.ownerProgressModeChanged((ProgressMode)((Object)event.getNewValue()));
            }
        }
    }
}

