/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.ide.ui.common.GadgetFactory;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewer;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewerDragAdapter;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewerDropAdapter;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.OwnerElement;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanEditorGadgetFactory;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutline;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.PlanElementSelectionTransfer;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.AbstractTextEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GShell;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.foundation.rcp.ui.dnd.URIReferenceTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanItemOutlineViewer
extends PlanViewer {
    private final IWorkbenchPartSite fSite;
    private boolean fIsFiringSelectionEvent = false;

    public PlanItemOutlineViewer(PlanItemOutline control, IWorkbenchPartSite site) {
        super((GadgetFactory)new PlanEditorGadgetFactory(site), control);
        this.setUseHashlookup(true);
        this.fSite = site;
        this.hookDragAndDrop();
    }

    @Override
    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        if (input instanceof ResolvedIterationPlan && this.getControl() instanceof PlanItemOutline) {
            ((PlanItemOutline)this.getControl()).setInput((ResolvedIterationPlan)input);
        }
    }

    @Override
    public void resort(OutlineEntry<?> entry) {
        this.storeEditor();
        super.resort(entry);
        this.adjustEditor();
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        this.storeEditor();
        super.internalRefresh(element, updateLabels);
        this.adjustEditor();
    }

    private void storeEditor() {
        PlanItemOutline planOutline = this.getPlanOutline();
        AbstractTextEditor editor = planOutline.getCurrentTextEditor();
        if (editor != null && editor.isActive()) {
            editor.storeData();
        }
    }

    private void adjustEditor() {
        ITreeContentProvider cp;
        PlanItemOutline planOutline = this.getPlanOutline();
        AbstractTextEditor editor = planOutline.getCurrentTextEditor();
        if (editor != null && editor.isActive()) {
            OutlineEntry<?> entry = editor.getEntry();
            Widget widget = this.findItem(entry);
            if (widget != null) {
                if (widget instanceof PlanItemOutlineItem) {
                    planOutline.adjustTextEditor((PlanItemOutlineItem)widget);
                } else {
                    planOutline.cancelEditSession();
                }
            } else {
                planOutline.stopEditSession();
            }
        }
        if ((cp = (ITreeContentProvider)this.getContentProvider()) != null && cp.getElements(this.getInput()).length == 0) {
            this.getControl().redraw();
        }
    }

    protected void internalRemove(Object parent, Object[] elements) {
        this.stopEditSession(elements);
        super.internalRemove(parent, elements);
    }

    @Override
    protected void internalRemove(Object[] elementsOrPaths) {
        this.stopEditSession(elementsOrPaths);
        super.internalRemove(elementsOrPaths);
    }

    private PlanItemOutline getPlanOutline() {
        return (PlanItemOutline)this.getOutline();
    }

    protected Item newItem(Widget parent, int style, int index) {
        PlanItemOutlineItem result;
        if (parent instanceof Outline) {
            result = new PlanItemOutlineItem((PlanItemOutline)parent, style, index);
        } else {
            OutlineItem parentItem = (OutlineItem)parent;
            result = new PlanItemOutlineItem(parentItem, style, index);
            if (parentItem.isLayouted() && parentItem.getItemCount() == 1) {
                parentItem.getOutline().redraw(parentItem, false);
            }
        }
        return result;
    }

    protected void internalUpdate(Widget widget, Object element, String[] properties) {
        if (widget instanceof PlanItemOutlineItem) {
            boolean inEditMode = false;
            PlanItemOutline planOutline = this.getPlanOutline();
            PlanItemOutlineItem outlineItem = (PlanItemOutlineItem)widget;
            AbstractTextEditor editor = planOutline.getCurrentTextEditor();
            if (editor != null && editor.isActive()) {
                GShell content = outlineItem.getContent();
                inEditMode = content instanceof PlanItemGadget && editor.isOwner((PlanItemGadget)content);
            }
            super.internalUpdate(widget, element, properties);
            GShell newContent = outlineItem.getContent();
            if (inEditMode && newContent instanceof PlanItemGadget) {
                editor.transferOwnership((PlanItemGadget)newContent);
            }
        } else {
            super.internalUpdate(widget, element, properties);
        }
    }

    public boolean isExpandable(Object elementOrTreePath) {
        if (!super.isExpandable(elementOrTreePath)) {
            return false;
        }
        Object[] filteredChildren = this.getFilteredChildren(elementOrTreePath);
        return filteredChildren.length > 0;
    }

    private void hookDragAndDrop() {
        DragSource dragSource = new DragSource((Control)this.getOutline(), 6);
        dragSource.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance(), URIReferenceTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)new PlanViewerDragAdapter(this){

            protected Object convertToExternal(Object in) {
                if (in instanceof PlanItem && !((PlanItem)in).isProgressPlanItem()) {
                    return ((PlanItem)in).getWorkItemHandle();
                }
                if (in instanceof OwnerElement) {
                    return ((OwnerElement)in).getOwner();
                }
                return null;
            }
        });
        DropTarget dropTarget = new DropTarget((Control)this.getOutline(), 6);
        dropTarget.setTransfer(new Transfer[]{PlanElementSelectionTransfer.getTransfer(), LocalSelectionTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new PlanViewerDropAdapter(this, this.fSite));
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        try {
            this.fIsFiringSelectionEvent = true;
            super.fireSelectionChanged(event);
        }
        finally {
            this.fIsFiringSelectionEvent = false;
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (!this.fIsFiringSelectionEvent) {
            super.setSelection(selection, reveal);
        }
    }

    public boolean startEditSession(OutlineEntry<? extends PlanElement> element) {
        this.setSelection((ISelection)new StructuredSelection(element), true);
        OutlineItem item = this.getOutline().getLastSelectedItem();
        if (!this.equals(element, item.getData())) {
            return false;
        }
        GShell content = item.getContent();
        if (!(content instanceof PlanItemGadget)) {
            return false;
        }
        this.getOutline().startEditSession(((PlanItemGadget)content).getSummary());
        return true;
    }

    public void setTextEditorFullSelection() {
        this.getOutline().setTextEditorFullSelection();
    }

    public void stopEditSession() {
        PlanItemOutline planOutline = this.getPlanOutline();
        AbstractTextEditor editor = planOutline.getCurrentTextEditor();
        if (editor != null && editor.isActive()) {
            planOutline.stopEditSession();
        }
    }

    private void stopEditSession(Object[] elementsOrPaths) {
        PlanItemOutline planOutline = this.getPlanOutline();
        AbstractTextEditor editor = planOutline.getCurrentTextEditor();
        if (editor != null && editor.isActive() && this.contains(elementsOrPaths, editor.getEntry())) {
            planOutline.stopEditSession();
        }
    }

    private boolean contains(Object[] elementsOrPaths, OutlineEntry<?> entry) {
        Object[] objectArray = elementsOrPaths;
        int n = elementsOrPaths.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object == entry) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void cutText() {
        StyledText textWidget = this.getTextWidget();
        if (textWidget == null) {
            return;
        }
        textWidget.cut();
    }

    public void copyText() {
        StyledText textWidget = this.getTextWidget();
        if (textWidget == null) {
            return;
        }
        textWidget.copy();
    }

    public void pasteText() {
        StyledText textWidget = this.getTextWidget();
        if (textWidget == null) {
            return;
        }
        textWidget.paste();
    }

    private StyledText getTextWidget() {
        AbstractTextEditor editor = this.getOutline().getCurrentTextEditor();
        if (editor == null || !editor.isActive()) {
            return null;
        }
        StyledText textWidget = editor.getControl();
        return textWidget != null && !textWidget.isDisposed() ? textWidget : null;
    }
}

