/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.ide.ui.common.IOutlineSettingsListener;
import com.ibm.team.apt.internal.ide.ui.common.PlanCanvas;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.DescriptionEditor;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.SummaryEditor;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutlineItem;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanOutlineSettingsListener;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.AbstractTextEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ITextEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ITextEditorListener;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PlanItemOutline
extends PlanCanvas {
    private SummaryEditor fSummaryEditor;
    private DescriptionEditor fDescriptionEditor;
    private ResolvedIterationPlan fPlan;
    private final IOutlineSettingsListener fSettingsListener;
    private int fLastCaretOffset = Integer.MIN_VALUE;

    public PlanItemOutline(Composite parent, int style, IPlanOutlineSettings settings) {
        super(parent, style | 0x200 | 0x100, settings);
        this.fSettingsListener = new PlanOutlineSettingsListener(settings){

            public void showDetailsChanged(boolean show) {
                PlanItemOutline.this.handleShowDetailsChanged(show);
            }
        };
        Font font = this.getFont();
        PlanOutlineResources resources = this.getPlanOutlineResources();
        this.fSummaryEditor = new SummaryEditor((Composite)this, 64);
        this.fSummaryEditor.stopEditSession();
        StyledText summaryControl = this.fSummaryEditor.getControl();
        summaryControl.setBackground(resources.getTextFieldColor());
        summaryControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                PlanItemOutline.this.doTextEditKeyPressed(e);
            }
        });
        summaryControl.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                boolean ctrl = (e.stateMask & 0x40000) != 0;
                switch (e.detail) {
                    case 8: {
                        if (ctrl) {
                            PlanItemOutline.this.stopEditSession();
                            PlanItemGadget gadget = PlanItemOutline.this.getPreviousPlanItemGadget();
                            if (gadget == null) break;
                            if (gadget.getPlanItem().isDraftItem()) {
                                PlanItemOutline.this.activateDescriptionEditorFor(gadget, false);
                            } else {
                                PlanItemOutline.this.activateSummaryEditorFor(gadget, false);
                            }
                            e.detail = 0;
                            break;
                        }
                        e.doit = false;
                        break;
                    }
                    case 16: {
                        if (ctrl) {
                            PlanItemOutline.this.stopEditSession();
                            PlanItemGadget gadget = (PlanItemGadget)PlanItemOutline.this.getLastSelectedItem().getContent();
                            if (gadget.getPlanItem().isDraftItem()) {
                                PlanItemOutline.this.activateDescriptionEditorFor(gadget, false);
                                e.detail = 0;
                                break;
                            }
                            gadget = PlanItemOutline.this.getNextPlanItemGadget();
                            if (gadget == null) break;
                            PlanItemOutline.this.activateSummaryEditorFor(gadget, false);
                            e.detail = 0;
                            break;
                        }
                        e.doit = false;
                    }
                }
            }
        });
        this.fSummaryEditor.addListener(new ITextEditorListener(){

            public void contentChanged(ITextEditor editor) {
                if (PlanItemOutline.this.fPlan != null) {
                    PlanItemOutline.this.fPlan.markAsDirty();
                }
            }
        });
        this.fDescriptionEditor = new DescriptionEditor((Composite)this, 64);
        this.fDescriptionEditor.stopEditSession();
        StyledText descriptionControl = this.fDescriptionEditor.getControl();
        descriptionControl.setFont(font);
        descriptionControl.setBackground(null);
        descriptionControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                PlanItemOutline.this.doTextEditKeyPressed(e);
            }
        });
        descriptionControl.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                boolean ctrl = (e.stateMask & 0x40000) != 0;
                switch (e.detail) {
                    case 8: {
                        if (ctrl) {
                            PlanItemOutline.this.stopEditSession();
                            PlanItemGadget gadget = (PlanItemGadget)PlanItemOutline.this.getLastSelectedItem().getContent();
                            PlanItemOutline.this.activateSummaryEditorFor(gadget, true);
                            e.detail = 0;
                            break;
                        }
                        e.doit = false;
                        break;
                    }
                    case 16: {
                        if (ctrl) {
                            PlanItemOutline.this.stopEditSession();
                            PlanItemGadget gadget = PlanItemOutline.this.getNextPlanItemGadget();
                            if (gadget == null) break;
                            PlanItemOutline.this.activateSummaryEditorFor(gadget, false);
                            e.detail = 0;
                            break;
                        }
                        e.doit = false;
                    }
                }
            }
        });
        this.fDescriptionEditor.addListener(new ITextEditorListener(){

            public void contentChanged(ITextEditor editor) {
                if (PlanItemOutline.this.fPlan != null) {
                    PlanItemOutline.this.fPlan.markAsDirty();
                }
            }
        });
        TextLayout textLayout = resources.getTextLayout();
        int ascent = summaryControl.getBaseline();
        int descent = summaryControl.getLineHeight() - ascent;
        textLayout.setAscent(ascent);
        textLayout.setDescent(descent);
        int tabs = summaryControl.getTabs();
        StringBuffer tabBuffer = new StringBuffer(tabs);
        int i = 0;
        while (i < tabs) {
            tabBuffer.append(' ');
            ++i;
        }
        textLayout.setText(tabBuffer.toString());
        textLayout.setTabs(new int[]{textLayout.getBounds().width});
        textLayout.setText("");
        this.getSettings().addSettingsChangeListener(this.fSettingsListener);
    }

    public void setInput(ResolvedIterationPlan plan) {
        this.fPlan = plan;
    }

    protected OutlineResources createOutlineResource() {
        return new PlanOutlineResources((Control)this);
    }

    public PlanOutlineResources getPlanOutlineResources() {
        return (PlanOutlineResources)this.getOutlineResources();
    }

    public IPlanOutlineSettings getSettings() {
        return (IPlanOutlineSettings)super.getSettings();
    }

    protected void handleDisposed(DisposeEvent e) {
        this.getSettings().removeSettingsChangeListener(this.fSettingsListener);
        this.fSummaryEditor.dispose();
        this.fDescriptionEditor.dispose();
        super.handleDisposed(e);
    }

    public void adjustTextEditor(PlanItemOutlineItem item) {
        AbstractTextEditor currentTextEditor = this.getCurrentTextEditor();
        if (currentTextEditor != null && currentTextEditor.isActive() && item.getData() != null && item.getData().equals(currentTextEditor.getEntry())) {
            currentTextEditor.transferOwnership(item.getPlanItemGadget());
            currentTextEditor.adjustBounds(this.getTransformation());
            currentTextEditor.setFocus();
        }
    }

    public void stopEditSession() {
        this.fLastCaretOffset = Integer.MIN_VALUE;
        super.stopEditSession();
    }

    protected AbstractTextEditor doStartEditSession(GText owner) {
        PlanItem item;
        String id = owner.getId();
        OutlineEntry entry = (OutlineEntry)owner.getOutlineItem().getData();
        if (entry.getElement() instanceof PlanItem && !((ResolvedIterationPlan)(item = (PlanItem)entry.getElement()).getPlan()).isEditingSupported(item)) {
            this.fLastCaretOffset = Integer.MIN_VALUE;
            return null;
        }
        if ("summary".equals(id)) {
            this.fSummaryEditor.startEditSession(owner, entry, this.getTransformation());
            this.fLastCaretOffset = this.fSummaryEditor.getControl().getCaretOffset();
            return this.fSummaryEditor;
        }
        if ("description".equals(id)) {
            this.fDescriptionEditor.startEditSession(owner, entry, this.getTransformation());
            this.fLastCaretOffset = this.fDescriptionEditor.getControl().getCaretOffset();
            return this.fDescriptionEditor;
        }
        this.fLastCaretOffset = Integer.MIN_VALUE;
        return null;
    }

    public void setTextEditorFullSelection() {
        super.setTextEditorFullSelection();
        this.fLastCaretOffset = this.getCurrentTextEditor().getControl().getCaretOffset();
    }

    public void hookContextMenu(IMenuListener listener) {
        this.fSummaryEditor.addMenuListener(listener);
        this.fDescriptionEditor.addMenuListener(listener);
    }

    private void doTextEditKeyPressed(KeyEvent event) {
        StyledText text = (StyledText)event.widget;
        if (this.checkCursorVisible(text) || event.stateMask != 0) {
            return;
        }
        switch (event.keyCode) {
            case 0x1000002: 
            case 0x1000004: {
                PlanItemGadget gadget = (PlanItemGadget)this.getLastSelectedItem().getContent();
                if (this.getCurrentTextEditor() != this.fSummaryEditor || !gadget.getPlanItem().isDraftItem()) break;
                this.stopEditSession();
                gadget = (PlanItemGadget)this.getLastSelectedItem().getContent();
                this.startEditSession(gadget.getDescription());
                this.checkCursorVisible(this.fDescriptionEditor.getControl());
                break;
            }
            case 0x1000001: 
            case 0x1000003: {
                if (this.getCurrentTextEditor() != this.fDescriptionEditor) break;
                this.stopEditSession();
                PlanItemGadget gadget = (PlanItemGadget)this.getLastSelectedItem().getContent();
                this.startEditSession(gadget.getSummary());
                StyledText control = this.fSummaryEditor.getControl();
                if (event.keyCode == 0x1000003) {
                    control.setSelection(control.getCharCount());
                    this.fLastCaretOffset = control.getCaretOffset();
                }
                this.checkCursorVisible(control);
            }
        }
    }

    private boolean checkCursorVisible(StyledText text) {
        int offset = text.getCaretOffset();
        if (this.fLastCaretOffset == offset) {
            return false;
        }
        return this.forceCursorVisible(text, offset);
    }

    private boolean forceCursorVisible(StyledText text) {
        return this.forceCursorVisible(text, text.getCaretOffset());
    }

    private boolean forceCursorVisible(StyledText text, int offset) {
        int caretWidth;
        this.fLastCaretOffset = offset;
        Point caretLocation = this.toControl(text.toDisplay(text.getLocationAtOffset(offset)));
        Rectangle clientArea = this.getClientArea();
        int lineHeight = text.getLineHeight();
        if (caretLocation.y < 0 ? clientArea.contains(caretLocation) : clientArea.contains(caretLocation.x, caretLocation.y + lineHeight)) {
            return true;
        }
        int deltaX = 0;
        int deltaY = 0;
        if (caretLocation.y < 0) {
            deltaY = caretLocation.y;
        } else if (caretLocation.y + lineHeight > clientArea.y + clientArea.height) {
            deltaY = caretLocation.y + lineHeight - (clientArea.y + clientArea.height);
        }
        Caret textCaret = text.getCaret();
        int n = caretWidth = textCaret != null ? textCaret.getSize().x : 0;
        if (caretLocation.x < 0) {
            deltaX = caretLocation.x;
        } else if (caretLocation.x + caretWidth >= clientArea.x + clientArea.width) {
            deltaX = caretLocation.x + caretWidth + 1 - (clientArea.x + clientArea.width);
        }
        this.scroll(deltaX, deltaY);
        return true;
    }

    private PlanItemGadget getPreviousPlanItemGadget() {
        OutlineItem result = this.getPreviousVisibleItem(this.getLastSelectedItem());
        while (this.isPlanItemGadget(result)) {
            result = this.getPreviousVisibleItem(result);
        }
        if (result == null) {
            return null;
        }
        return (PlanItemGadget)result.getContent();
    }

    private PlanItemGadget getNextPlanItemGadget() {
        OutlineItem result = this.getNextVisibleItem(this.getLastSelectedItem());
        while (this.isPlanItemGadget(result)) {
            result = this.getNextVisibleItem(result);
        }
        if (result == null) {
            return null;
        }
        return (PlanItemGadget)result.getContent();
    }

    private boolean isPlanItemGadget(OutlineItem result) {
        return result != null && !(result.getContent() instanceof PlanItemGadget);
    }

    private void activateSummaryEditorFor(PlanItemGadget gadget, boolean caretAtEnd) {
        this.activateEditorFor(this.fSummaryEditor, gadget.getSummary(), caretAtEnd);
    }

    private void activateDescriptionEditorFor(PlanItemGadget gadget, boolean caretAtEnd) {
        this.activateEditorFor(this.fDescriptionEditor, gadget.getDescription(), caretAtEnd);
    }

    private void activateEditorFor(AbstractTextEditor editor, GText owner, boolean caretAtEnd) {
        if (this.getLastSelectedItem() != owner.getOutlineItem()) {
            this.setSelection(owner.getOutlineItem(), true);
        }
        this.startEditSession(owner);
        StyledText control = editor.getControl();
        if (caretAtEnd) {
            control.setCaretOffset(control.getCharCount());
            this.fLastCaretOffset = control.getCaretOffset();
        }
        this.forceCursorVisible(control);
    }

    private void handleShowDetailsChanged(boolean show) {
        this.relayout();
    }
}

