/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.common.ProgressInformation;
import com.ibm.team.apt.internal.common.ProgressItem;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarPainters;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ProgressBarPainter;
import com.ibm.team.jface.DoubleBufferPainter;
import com.ibm.team.jface.tooltip.TooltipSupport;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class IterationPlanProgressBar
extends Canvas {
    private ProgressInformation fProgress = new ProgressInformation();
    private int fCount = 0;
    private boolean fComputing = true;
    private final BarResources fResources = new BarResources((Control)this);
    private final ProgressBarPainter fPainter = new ProgressBarPainter(this.fResources);
    private final TextLayout fTextLayout;
    private final int fXPadding;

    public void setProgress(ProgressInformation progress) {
        Assert.isNotNull((Object)progress);
        this.fProgress = progress;
        ++this.fCount;
        if (this.fCount > 1) {
            this.fComputing = false;
        }
    }

    public IterationPlanProgressBar(Composite parent, int style, final int horizontalAlignment) {
        super(parent, style | 0x40000);
        this.fTextLayout = new TextLayout((Device)parent.getDisplay());
        this.fXPadding = UI.height(this.getFont()) / 4;
        new DoubleBufferPainter(this){

            public void doPaint(PaintEvent e) {
                e.gc.setAdvanced(true);
                Rectangle clientArea = IterationPlanProgressBar.this.getClientArea();
                ProgressItem input = ProgressItem.create((ProgressInformation)IterationPlanProgressBar.this.fProgress, (boolean)IterationPlanProgressBar.this.fComputing);
                IterationPlanProgressBar.this.fTextLayout.setAscent(-1);
                IterationPlanProgressBar.this.fTextLayout.setDescent(-1);
                IterationPlanProgressBar.this.fTextLayout.setWidth(-1);
                IterationPlanProgressBar.this.fTextLayout.setText("");
                IterationPlanProgressBar.this.fTextLayout.setAlignment(16384);
                IterationPlanProgressBar.this.fTextLayout.setFont(e.gc.getFont());
                String hourLabel = input.getTextHours();
                IterationPlanProgressBar.this.fTextLayout.setText(hourLabel);
                Rectangle extentHourLabel = IterationPlanProgressBar.this.fTextLayout.getBounds();
                String qualityLabel = input.getTextQualityOfPlanning();
                IterationPlanProgressBar.this.fTextLayout.setText(qualityLabel);
                Rectangle extentQualityLabel = IterationPlanProgressBar.this.fTextLayout.getBounds();
                int barWidth = 0;
                if ((horizontalAlignment & 0x20000) != 0) {
                    int xOffset = 0;
                    int totalXPadding = 0;
                    switch (input.getKind()) {
                        case MESSAGE: 
                        case LOADING: {
                            totalXPadding = 2 * IterationPlanProgressBar.this.fXPadding;
                            barWidth = xOffset = e.gc.stringExtent((String)input.getMessage().getMessage()).x * 2;
                            break;
                        }
                        case BAR_WITH_PROJECTION: 
                        case BAR: 
                        case DONE: {
                            totalXPadding = 6 * IterationPlanProgressBar.this.fXPadding;
                            barWidth = extentHourLabel.width + extentQualityLabel.width;
                            xOffset = extentHourLabel.width * 2 + extentQualityLabel.width * 2;
                        }
                    }
                    xOffset += totalXPadding;
                    xOffset = clientArea.width - xOffset;
                    xOffset = Math.max(0, xOffset);
                    clientArea.x += xOffset;
                    clientArea.width -= xOffset;
                }
                switch (input.getKind()) {
                    case MESSAGE: 
                    case LOADING: {
                        Rectangle bounds = this.divide(clientArea, new int[]{-1}, IterationPlanProgressBar.this.fXPadding)[0];
                        if (clientArea.width > barWidth) {
                            int delta = clientArea.width - barWidth;
                            clientArea.x += delta;
                            clientArea.width -= delta;
                        }
                        IterationPlanProgressBar.this.fPainter.paint(e.gc, bounds, input);
                        break;
                    }
                    case BAR_WITH_PROJECTION: 
                    case BAR: 
                    case DONE: {
                        if ((float)(extentQualityLabel.width + extentHourLabel.width) > (float)(clientArea.width - 6 * IterationPlanProgressBar.this.fXPadding) * 0.5f) {
                            if (clientArea.width > barWidth) {
                                int delta = clientArea.width - barWidth;
                                clientArea.x += delta;
                                clientArea.width -= delta;
                            }
                            IterationPlanProgressBar.this.fPainter.paint(e.gc, clientArea, input);
                            break;
                        }
                        Rectangle[] rectangles = this.divide(clientArea, new int[]{extentHourLabel.width, -1, extentQualityLabel.width}, IterationPlanProgressBar.this.fXPadding);
                        IterationPlanProgressBar.this.fTextLayout.setText(hourLabel);
                        if (input.getKind() == ProgressItem.Kind.BAR_WITH_PROJECTION) {
                            Color color = input.isAhead() ? IterationPlanProgressBar.this.fResources.getGreen() : IterationPlanProgressBar.this.fResources.getRed();
                            int index1 = hourLabel.lastIndexOf(124);
                            int index2 = hourLabel.lastIndexOf(104);
                            if (index2 == -1) {
                                index2 = hourLabel.length();
                            }
                            IterationPlanProgressBar.this.fTextLayout.setStyle(new TextStyle(null, e.gc.getForeground(), null), 0, hourLabel.length());
                            if (index1 != -1 && index2 != -1) {
                                IterationPlanProgressBar.this.fTextLayout.setStyle(new TextStyle(null, color, null), index1 + 1, Math.max(index1 + 1, index2 - 1));
                            }
                        }
                        Point point = BarPainters.align(rectangles[0], extentHourLabel.width, extentHourLabel.height, BarPainters.Alignment.Center, new BarPainters.Alignment[0]);
                        IterationPlanProgressBar.this.fTextLayout.draw(e.gc, point.x, point.y);
                        IterationPlanProgressBar.this.fPainter.paint(e.gc, rectangles[1], input);
                        point = BarPainters.align(rectangles[2], extentQualityLabel.width, extentQualityLabel.height, BarPainters.Alignment.Center, new BarPainters.Alignment[0]);
                        e.gc.drawString(qualityLabel, point.x, point.y, true);
                    }
                }
            }

            private Rectangle[] divide(Rectangle bounds, int[] widths, int xPadding) {
                int n;
                int width;
                Rectangle[] result = new Rectangle[widths.length];
                int remainingWidth = bounds.width;
                int nDefaultWidth = 0;
                int i = 0;
                while (i < widths.length) {
                    width = widths[i];
                    remainingWidth -= 2 * xPadding;
                    if (width != -1) {
                        remainingWidth -= Math.max(0, width);
                    } else {
                        ++nDefaultWidth;
                    }
                    result[i] = new Rectangle(-1, bounds.y, width, bounds.height);
                    ++i;
                }
                if (nDefaultWidth > 0) {
                    Rectangle[] rectangleArray = result;
                    n = result.length;
                    width = 0;
                    while (width < n) {
                        Rectangle rect = rectangleArray[width];
                        if (rect.width == -1) {
                            rect.width = remainingWidth / nDefaultWidth;
                        }
                        ++width;
                    }
                }
                int currentX = bounds.x;
                Rectangle[] rectangleArray = result;
                int n2 = result.length;
                n = 0;
                while (n < n2) {
                    Rectangle rect = rectangleArray[n];
                    rect.x = currentX += xPadding;
                    currentX += rect.width + xPadding;
                    ++n;
                }
                return result;
            }
        };
        new TooltipSupport((Control)this, true, false){

            public Object getElement(Control control, int x, int y) {
                return IterationPlanProgressBar.this.fProgress;
            }
        };
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IterationPlanProgressBar.this.fTextLayout.dispose();
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        ProgressItem item = ProgressItem.create((ProgressInformation)this.fProgress, (boolean)this.fComputing);
        int width = 0;
        int height = this.computeMinimalHeight();
        switch (item.getKind()) {
            case MESSAGE: 
            case LOADING: {
                this.fTextLayout.setText(item.getMessage().getMessage());
                width = Math.max(this.fTextLayout.getBounds().width, height * 12);
                break;
            }
            case BAR: {
                this.fTextLayout.setText(item.getTextQualityOfPlanning());
                width += this.fTextLayout.getBounds().width;
                width *= 2;
                width += 4 * this.fXPadding;
                break;
            }
            case BAR_WITH_PROJECTION: {
                this.fTextLayout.setText(item.getTextHours());
                width += this.fTextLayout.getBounds().width;
                this.fTextLayout.setText(item.getTextQualityOfPlanning());
                width += this.fTextLayout.getBounds().width;
                width *= 2;
                width += 6 * this.fXPadding;
            }
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    public int computeMinimalHeight() {
        return this.fPainter.computeMinimalHeight();
    }

    public int computeTrimHeight(int height) {
        return this.fPainter.computeTrimHeight(height);
    }
}

