/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.Attribute;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.util.Tags;
import com.ibm.team.apt.internal.ide.ui.common.LocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.SecondaryLocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryNavigator;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryTag;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupByDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.HierarchicalItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.PrimaryLocationTag;
import com.ibm.team.apt.internal.ide.ui.common.structure.TagElement;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.ProgressAwarePlanModelTransformer;
import com.ibm.team.repository.common.util.NLS;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;

public class GroupByTagDescription
extends GroupByDescription {
    public static final String ID = "TAGS";

    public GroupByTagDescription() {
        super(ID, Messages.GroupByTagDescription_LABEL);
    }

    public PlanModelTransformer createModelTransformer(IAdaptable options) {
        return new TagGroupingTransformer();
    }

    protected ItemMovePolicy createItemMovePolicy() {
        return new TagGroupingItemMovePolicy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TagGroupingItemMovePolicy
    extends HierarchicalItemMovePolicy {
        private TagGroupingItemMovePolicy() {
        }

        @Override
        public boolean canMoveUp(final OutlineEntry<?> entry) {
            if (!this.isPlanItemInPrimaryGroup(entry)) {
                return false;
            }
            if (super.canMoveUp(entry)) {
                return true;
            }
            return entry.getModel().readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

                @Override
                public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                    EntryNavigator n = readAccessor.getEntryNavigator(true);
                    return !n.isFirst(n.parentEntry(entry));
                }
            });
        }

        @Override
        public boolean canMoveDown(final OutlineEntry<?> entry) {
            if (!this.isPlanItemInPrimaryGroup(entry)) {
                return false;
            }
            if (super.canMoveDown(entry)) {
                return true;
            }
            return entry.getModel().readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

                @Override
                public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                    EntryNavigator n = readAccessor.getEntryNavigator(true);
                    if (EntryUtils.isType(n.parentEntry(entry), PlanItem.class)) {
                        return false;
                    }
                    return !n.isLast(n.parentEntry(entry));
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TagGroupingTransformer
    extends ProgressAwarePlanModelTransformer<TagElement> {
        public TagGroupingTransformer() {
            super((Collection<Attribute>)Arrays.asList(PlanItem.PRIMARY_TAG, PlanItem.PRIMARY_ITEM), TagElement.class);
        }

        @Override
        protected Collection<GroupElement[]> getDefaultGroups() {
            return Collections.singleton(new GroupElement[]{new TagElement(Tags.NO_TAGS)});
        }

        @Override
        protected Collection<GroupElement[]> getGroups(List<PlanModelTransformer.ElementInfo> elementInfoPath) {
            Assert.isTrue((elementInfoPath.size() >= 1 ? 1 : 0) != 0);
            HashMap<String, GroupElement[]> resultMap = new HashMap<String, GroupElement[]>();
            for (PlanModelTransformer.ElementInfo elementInfo : elementInfoPath) {
                String tag;
                if (!this.isPrimaryItem(elementInfo) || resultMap.containsKey(tag = this.getPrimaryTag(elementInfo))) continue;
                resultMap.put(tag, this.getGroupElements(tag));
            }
            return resultMap.values();
        }

        @Override
        protected EntryTag[] doCalculateTags(GroupElement[] groupPath, List<PlanModelTransformer.ElementInfo> elementInfoPath) {
            Assert.isTrue((elementInfoPath.size() >= 1 ? 1 : 0) != 0);
            PlanModelTransformer.ElementInfo elementInfo = elementInfoPath.get(0);
            return this.isPrimaryItem(elementInfo) && Arrays.equals(groupPath, this.getGroupElements(this.getPrimaryTag(elementInfo))) ? DEFAULT_TAGS : NO_TAGS;
        }

        @Override
        public LocationMarker calculateLocationMarker(OutlineEntry<?> entry) {
            LocationMarker result = super.calculateLocationMarker(entry);
            if (result == null && EntryUtils.isType(entry, PlanItem.class) && !entry.hasTag(PrimaryLocationTag.INSTANCE)) {
                PlanItem planItem = (PlanItem)entry.getElement();
                String message = null;
                message = Tags.NO_TAGS.equals(planItem.getPrimaryTag()) ? Messages.GroupByTagDescription_WORKITEM_IS_NOT_TAGGED : NLS.bind((String)Messages.GroupByTagDescription_BELONGS_TO_OTHER_TAG, (Object[])new Object[]{planItem.getPrimaryTag()});
                result = new SecondaryLocationMarker(message);
            }
            return result;
        }

        private String getPrimaryTag(PlanModelTransformer.ElementInfo elementInfo) {
            Object[] structureValues = elementInfo.getStructureValues();
            Assert.isLegal((structureValues.length == 2 && structureValues[0] instanceof String ? 1 : 0) != 0);
            return (String)structureValues[0];
        }

        private GroupElement[] getGroupElements(String tag) {
            return new GroupElement[]{new TagElement(tag)};
        }

        private boolean isPrimaryItem(PlanModelTransformer.ElementInfo elementInfo) {
            Object[] structureValues = elementInfo.getStructureValues();
            Assert.isLegal((structureValues.length == 2 && structureValues[1] instanceof Boolean ? 1 : 0) != 0);
            return (Boolean)structureValues[1];
        }
    }
}

