/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.Attribute;
import com.ibm.team.apt.internal.client.IPlanElementVisitor;
import com.ibm.team.apt.internal.client.IterationPlanItem;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.common.LocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.SecondaryLocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryNavigator;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryTag;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.IEntryVisitor;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelUpdater;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelUpdateRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModel;
import com.ibm.team.apt.internal.ide.ui.common.structure.DefaultRootElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupByDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupFolderElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupFolderElementManager;
import com.ibm.team.apt.internal.ide.ui.common.structure.HierarchicalItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.PartialViewerSorter;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.PrimaryLocationTag;
import com.ibm.team.apt.internal.ide.ui.common.structure.SortMode;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.ProgressAwarePlanModelTransformer;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupByNoneDescription
extends GroupByDescription {
    private static final List<SortMode> SORT_MODES;
    public static final String ID = "NONE";
    private static final char FOLDER_PATH_SEPARATOR = '/';
    private MyFolderTransformer fTransformer;
    private GroupFolderElementManager fFolderManager;
    private ItemSortOrder fItemSortOrder;

    static {
        ArrayList<SortMode> sortModes = new ArrayList<SortMode>();
        sortModes.add(SortMode.MY_SORT_ORDER);
        sortModes.addAll(DEFAULT_SORT_MODES);
        SORT_MODES = Collections.unmodifiableList(sortModes);
    }

    public GroupByNoneDescription() {
        super(ID, Messages.GroupByNoneDescription_LABEL);
    }

    @Override
    public void aboutToSave() {
        if (this.fTransformer != null) {
            this.fTransformer.storeData();
        }
        super.aboutToSave();
    }

    @Override
    public SortMode getDefaultSortMode() {
        return SortMode.MY_SORT_ORDER;
    }

    @Override
    public List<SortMode> getSortModes() {
        return SORT_MODES;
    }

    @Override
    public PlanModelTransformer createModelTransformer(IAdaptable options) {
        this.fTransformer = new MyFolderTransformer(this.getFolderManager(), this.getItemSortOrder());
        return this.fTransformer;
    }

    @Override
    protected ItemMovePolicy createItemMovePolicy() {
        return new MyFolderItemMovePolicy(this.getFolderManager());
    }

    @Override
    public PartialViewerSorter createSorter() {
        return new MyFolderViewerSorter(this.getItemSortOrder());
    }

    private GroupFolderElementManager getFolderManager() {
        if (this.fFolderManager == null) {
            this.fFolderManager = new GroupFolderElementManager();
        }
        return this.fFolderManager;
    }

    private ItemSortOrder getItemSortOrder() {
        if (this.fItemSortOrder == null) {
            this.fItemSortOrder = new ItemSortOrder();
        }
        return this.fItemSortOrder;
    }

    private static String createPath(OutlineEntry<?> e1, EntryNavigator n) {
        StringBuilder buffer = new StringBuilder();
        GroupByNoneDescription.createPath(buffer, e1, n);
        if (buffer.length() == 0) {
            buffer.append('/');
        }
        return buffer.toString();
    }

    private static void createPath(StringBuilder buffer, OutlineEntry<?> entry, EntryNavigator n) {
        Object element;
        OutlineEntry<?> parent = n.parentEntry(entry);
        if (parent != null) {
            GroupByNoneDescription.createPath(buffer, parent, n);
        }
        if (!((element = entry.getElement()) instanceof DefaultRootElement)) {
            if (element instanceof GroupFolderElement) {
                buffer.append('/').append(((GroupFolderElement)element).getId().getUuidValue());
            } else if (element instanceof PlanItem) {
                buffer.append('/').append(((PlanItem)element).getWorkItemId().getUuidValue());
            } else {
                Assert.isTrue((boolean)false, (String)("Unknown element type: " + element.getClass()));
            }
        }
    }

    private static interface ISortOrderStore {
        public void storeData();
    }

    private static class ItemSortOrder {
        private int fIndex;
        private Map<String, Integer> fMapping = new HashMap<String, Integer>();
        private ISortOrderStore fStore;

        public void setStore(ISortOrderStore store) {
            this.fStore = store;
        }

        public void storeOrder() {
            if (this.fStore != null) {
                this.fStore.storeData();
            }
        }

        public void clear() {
            this.fMapping.clear();
            this.fIndex = 0;
        }

        public void put(String path) {
            this.fMapping.put(path, this.fIndex);
            ++this.fIndex;
        }

        public void incrementIndexBy(int delta) {
            this.fIndex += delta;
        }

        public int get(String path) {
            Integer result = this.fMapping.get(path);
            if (result == null) {
                return -1;
            }
            return result;
        }

        public int getIndex() {
            return this.fIndex;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyFolderItemMovePolicy
    extends HierarchicalItemMovePolicy {
        private final GroupFolderElementManager fFolderManager;

        public MyFolderItemMovePolicy(GroupFolderElementManager folderManager) {
            this.fFolderManager = folderManager;
        }

        @Override
        public void addItemAbove(OutlineEntry<?> entry, String workItemType, IRunnableContext context) throws TeamRepositoryException {
            super.addItemAbove(entry, workItemType, context);
            if (entry != null) {
                ((ResolvedIterationPlan)this.getPlan(entry)).setAuxiliaryDataChanged();
            }
        }

        @Override
        public void addItemBelow(OutlineEntry<?> entry, String workItemType, IRunnableContext context) throws TeamRepositoryException {
            super.addItemBelow(entry, workItemType, context);
            if (entry != null) {
                ((ResolvedIterationPlan)this.getPlan(entry)).setAuxiliaryDataChanged();
            }
        }

        public void addFolderBelow(final OutlineEntry<GroupFolderElement> siblingEntry, final String name) {
            final OutlineModel<?> model = siblingEntry.getModel();
            model.updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){

                @Override
                public Void run(IOutlineModelUpdater updateAccessor) throws RuntimeException {
                    GroupFolderElement gfe = (GroupFolderElement)siblingEntry.getElement();
                    GroupFolderElement parent = gfe.getParent();
                    GroupFolderElement newFolder = MyFolderItemMovePolicy.this.fFolderManager.create(parent, name, -1);
                    final OutlineEntry<GroupFolderElement> newEntry = updateAccessor.addEntry(parent == null ? GroupFolderElement.EMPTY_PATH : parent.getPath(), newFolder);
                    EntryNavigator n = updateAccessor.getEntryNavigator(false);
                    List<OutlineEntry<?>> siblingEntries = n.siblingEntries(siblingEntry);
                    updateAccessor.move(newEntry, siblingEntries.indexOf(siblingEntry) + 1);
                    updateAccessor.executeAfterUpdate(new Runnable(){

                        public void run() {
                            model.revealEntry(newEntry);
                            model.setSelectedEntry(newEntry);
                        }
                    });
                    ((ResolvedIterationPlan)MyFolderItemMovePolicy.this.getPlan(siblingEntry)).setAuxiliaryDataChanged();
                    return null;
                }
            });
        }

        public void deleteFolder(final OutlineEntry<GroupFolderElement> entry, GroupFolderElement bugsFolder) {
            final HashSet removed = new HashSet();
            final OutlineModel<?> model = entry.getModel();
            final OutlineEntry toSelect = (OutlineEntry)model.readModel(new ModelReadRunnable<OutlineEntry<?>, RuntimeException>(){

                @Override
                public OutlineEntry<?> run(IOutlineModelReader readAccessor) throws RuntimeException {
                    readAccessor.accept(entry, new IEntryVisitor(){

                        @Override
                        public boolean visit(OutlineEntry<?> entry) {
                            if (entry.getElement() instanceof GroupFolderElement) {
                                removed.add(((GroupFolderElement)entry.getElement()).getId());
                                return true;
                            }
                            return false;
                        }
                    });
                    EntryNavigator n = readAccessor.getEntryNavigator(true);
                    OutlineEntry<?> result = n.successorEntry(entry);
                    if (result == null) {
                        result = n.predecessorEntry(entry);
                    }
                    if (result == null && (result = n.parentEntry(entry)) != null && !EntryUtils.isType(result, GroupFolderElement.class)) {
                        result = null;
                    }
                    return result;
                }
            });
            ResolvedIterationPlan plan = (ResolvedIterationPlan)this.getPlan(entry);
            final UUID bugFolderId = bugsFolder.getId();
            try {
                plan.connectDeltaBuilder();
                plan.accept(new IPlanElementVisitor(){

                    public boolean visit(PlanElement element) {
                        IterationPlanItem item;
                        if (element instanceof IterationPlanItem && removed.contains((item = (IterationPlanItem)element).getFolderId())) {
                            item.setFolderId(bugFolderId);
                        }
                        return true;
                    }
                });
                plan.setAuxiliaryDataChanged();
            }
            finally {
                plan.disconnectDeltaBuilder();
            }
            model.updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){

                @Override
                public Void run(IOutlineModelUpdater updateAccessor) throws RuntimeException {
                    updateAccessor.removeEntry(entry);
                    if (toSelect != null) {
                        updateAccessor.executeAfterUpdate(new Runnable(){

                            public void run() {
                                model.revealEntry(toSelect);
                                model.setSelectedEntry(toSelect);
                            }
                        });
                    }
                    return null;
                }
            });
            ((ResolvedIterationPlan)this.getPlan(entry)).setAuxiliaryDataChanged();
        }

        public void renameFolder(final OutlineEntry<GroupFolderElement> toRename, String newName) {
            toRename.getElement().setLabel(newName);
            toRename.getModel().updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){

                @Override
                public Void run(IOutlineModelUpdater updateAccessor) throws RuntimeException {
                    updateAccessor.update(toRename, new String[]{"label"});
                    return null;
                }
            });
            ((ResolvedIterationPlan)this.getPlan(toRename)).setAuxiliaryDataChanged();
        }

        public void adopt(final OutlineEntry<GroupFolderElement> folder, final Collection<OutlineEntry<IterationPlanItem>> entries) {
            final GroupFolderElement gfe = folder.getElement();
            ResolvedPlan plan = this.getPlan(folder);
            try {
                plan.connectDeltaBuilder();
                for (OutlineEntry<IterationPlanItem> outlineEntry : entries) {
                    IterationPlanItem toChange = outlineEntry.getElement();
                    final UUID currentFolder = toChange.getFolderId();
                    toChange.accept(new IPlanElementVisitor(){

                        public boolean visit(PlanElement element) {
                            if (element instanceof IterationPlanItem && currentFolder.equals((Object)((IterationPlanItem)element).getFolderId())) {
                                gfe.adopt(element, folder, (IProgressMonitor)new NullProgressMonitor());
                            }
                            return true;
                        }
                    });
                }
            }
            finally {
                plan.disconnectDeltaBuilder();
            }
            final OutlineModel<?> model = folder.getModel();
            model.updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){

                @Override
                public Void run(IOutlineModelUpdater updateAccessor) throws RuntimeException {
                    EntryNavigator n = updateAccessor.getEntryNavigator(true);
                    List<OutlineEntry<?>> children = n.childEntries(folder);
                    if (children.size() == entries.size()) {
                        return null;
                    }
                    int folderIndex = children.size();
                    int i = 0;
                    for (OutlineEntry<?> child : children) {
                        if (child.getElement() instanceof GroupFolderElement) {
                            folderIndex = i;
                            break;
                        }
                        ++i;
                    }
                    final ArrayList toSelect = new ArrayList();
                    for (OutlineEntry adpoted : entries) {
                        for (OutlineEntry<?> child : children) {
                            if (adpoted.getElement() != child.getElement()) continue;
                            updateAccessor.move(child, folderIndex);
                            toSelect.add(child);
                            ++folderIndex;
                        }
                    }
                    if (!toSelect.isEmpty()) {
                        updateAccessor.executeAfterUpdate(new Runnable(){

                            public void run() {
                                model.revealEntry((OutlineEntry)toSelect.get(0));
                                model.setSelectedEntries(toSelect);
                            }
                        });
                    }
                    return null;
                }
            });
            ((ResolvedIterationPlan)plan).setAuxiliaryDataChanged();
        }

        @Override
        public boolean canMoveUp(final OutlineEntry<?> entry) {
            if (!(entry.getElement() instanceof PlanItem) && !(entry.getElement() instanceof GroupElement)) {
                return false;
            }
            if (entry.getElement() instanceof PlanItem && !this.isPlanItemInPrimaryGroup(entry)) {
                return false;
            }
            if (super.canMoveUp(entry)) {
                return true;
            }
            return entry.getModel().readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

                @Override
                public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                    EntryNavigator n = readAccessor.getEntryNavigator(true);
                    if (EntryUtils.isType(entry, GroupFolderElement.class)) {
                        if (!n.isFirst(n.parentEntry(entry)) && EntryUtils.isType(n.predecessorEntry(entry), GroupFolderElement.class)) {
                            return true;
                        }
                        return false;
                    }
                    if (EntryUtils.isType(entry, PlanItem.class)) {
                        if (EntryUtils.isType(n.parentEntry(entry), GroupFolderElement.class) && (EntryUtils.isType(n.predecessorEntry(n.parentEntry(entry)), GroupFolderElement.class) || EntryUtils.isType(n.parentEntry(n.parentEntry(entry)), GroupFolderElement.class))) {
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
            });
        }

        @Override
        public void moveUp(final OutlineEntry<?> entry) {
            if (entry.getElement() instanceof PlanItem) {
                super.moveUp(entry);
                IPlanOutlineSettings settings = (IPlanOutlineSettings)this.getViewModel(entry).getOutlineSettings();
                if (settings.getSortMode() == SortMode.MY_SORT_ORDER) {
                    ((ResolvedIterationPlan)this.getPlan(entry)).setAuxiliaryDataChanged();
                }
                return;
            }
            if (!(entry.getElement() instanceof GroupFolderElement)) {
                return;
            }
            final OutlineModel<?> model = entry.getModel();
            model.updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){

                @Override
                public Void run(IOutlineModelUpdater updateAccessor) throws RuntimeException {
                    EntryNavigator n = updateAccessor.getEntryNavigator(false);
                    OutlineEntry<?> predecessorEntry = n.predecessorEntry(entry);
                    if (predecessorEntry != null) {
                        updateAccessor.move(entry, n.index(predecessorEntry));
                    }
                    updateAccessor.executeAfterUpdate(new Runnable(){

                        public void run() {
                            model.revealEntry(entry);
                            model.setSelectedEntry(entry);
                        }
                    });
                    ((ResolvedIterationPlan)MyFolderItemMovePolicy.this.getPlan(entry)).setAuxiliaryDataChanged();
                    return null;
                }
            });
        }

        @Override
        public boolean canMoveDown(final OutlineEntry<?> entry) {
            if (!(entry.getElement() instanceof PlanItem) && !(entry.getElement() instanceof GroupElement)) {
                return false;
            }
            if (entry.getElement() instanceof PlanItem && !this.isPlanItemInPrimaryGroup(entry)) {
                return false;
            }
            if (super.canMoveDown(entry)) {
                return true;
            }
            return entry.getModel().readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

                @Override
                public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                    EntryNavigator n = readAccessor.getEntryNavigator(true);
                    if (entry.getElement() instanceof PlanItem) {
                        if (EntryUtils.isType(n.parentEntry(entry), PlanItem.class)) {
                            return false;
                        }
                        OutlineEntry<?> parentEntry = n.parentEntry(entry);
                        while (parentEntry != null) {
                            OutlineEntry<?> successorEntry = n.successorEntry(parentEntry);
                            if (EntryUtils.isType(successorEntry, PlanItem.class)) {
                                return false;
                            }
                            if (EntryUtils.isType(successorEntry, GroupFolderElement.class)) {
                                return true;
                            }
                            parentEntry = n.parentEntry(parentEntry);
                        }
                        return false;
                    }
                    if (entry.getElement() instanceof GroupFolderElement) {
                        return !n.isLast(entry);
                    }
                    return false;
                }
            });
        }

        @Override
        public void moveDown(final OutlineEntry<?> entry) {
            if (entry.getElement() instanceof PlanItem) {
                super.moveDown(entry);
                IPlanOutlineSettings settings = (IPlanOutlineSettings)this.getViewModel(entry).getOutlineSettings();
                if (settings.getSortMode() == SortMode.MY_SORT_ORDER) {
                    ((ResolvedIterationPlan)this.getPlan(entry)).setAuxiliaryDataChanged();
                }
                return;
            }
            if (!(entry.getElement() instanceof GroupFolderElement)) {
                return;
            }
            final OutlineModel<?> model = entry.getModel();
            model.updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){

                @Override
                public Void run(IOutlineModelUpdater updateAccessor) throws RuntimeException {
                    EntryNavigator n = updateAccessor.getEntryNavigator(false);
                    OutlineEntry<?> successorEntry = n.successorEntry(entry);
                    if (successorEntry != null) {
                        updateAccessor.move(entry, n.index(successorEntry) + 1);
                    }
                    updateAccessor.executeAfterUpdate(new Runnable(){

                        public void run() {
                            model.revealEntry(entry);
                            model.setSelectedEntry(entry);
                        }
                    });
                    ((ResolvedIterationPlan)MyFolderItemMovePolicy.this.getPlan(entry)).setAuxiliaryDataChanged();
                    return null;
                }
            });
        }

        @Override
        public boolean canIncreaseIndent(final OutlineEntry<?> entry) {
            if (!this.isPlanItemInPrimaryGroup(entry) && !this.isFolder(entry)) {
                return false;
            }
            final Object element = entry.getElement();
            if (element instanceof PlanItem && super.canIncreaseIndent(entry)) {
                return true;
            }
            if (!(element instanceof GroupFolderElement)) {
                return false;
            }
            return entry.getModel().readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

                @Override
                public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                    Object previous = readAccessor.getEntryNavigator(true).predecessor(entry);
                    if (element instanceof PlanItem) {
                        return previous instanceof GroupFolderElement;
                    }
                    if (element instanceof GroupFolderElement) {
                        GroupFolderElement folder = (GroupFolderElement)element;
                        if (previous instanceof GroupFolderElement && !folder.isTopItemFolder() && !folder.isBugFolder()) {
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
            });
        }

        @Override
        public void increaseIndent(final OutlineEntry<?> entry) {
            final Object element = entry.getElement();
            final OutlineModel<?> model = entry.getModel();
            model.updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){

                @Override
                public Void run(IOutlineModelUpdater updateAccessor) throws RuntimeException {
                    EntryNavigator n = updateAccessor.getEntryNavigator(true);
                    Object previous = n.predecessor(entry);
                    if (element instanceof PlanItem && previous instanceof PlanItem) {
                        MyFolderItemMovePolicy.super.increaseIndent(entry);
                    } else if (element instanceof PlanItem && previous instanceof GroupFolderElement) {
                        ((GroupFolderElement)previous).adopt((PlanElement)((PlanItem)element), n.predecessorEntry(entry), (IProgressMonitor)new NullProgressMonitor());
                    } else if (element instanceof GroupFolderElement && previous instanceof GroupFolderElement) {
                        final OutlineModel.ExpansionHull expansionHull = entry.getModel().getExpansionHull(entry);
                        GroupFolderElement toMove = (GroupFolderElement)element;
                        GroupFolderElement newParent = (GroupFolderElement)previous;
                        toMove.reparent(newParent);
                        final OutlineEntry newEntry = updateAccessor.reparentEntry(entry, newParent.getPath());
                        updateAccessor.executeAfterUpdate(new Runnable(){

                            public void run() {
                                if (newEntry != null) {
                                    model.setExpansionHull(newEntry, expansionHull);
                                    model.revealEntry(newEntry);
                                    model.setSelectedEntry(newEntry);
                                }
                            }
                        });
                        ((ResolvedIterationPlan)MyFolderItemMovePolicy.this.getPlan(entry)).setAuxiliaryDataChanged();
                    }
                    return null;
                }
            });
        }

        @Override
        public boolean canDecreaseIndent(final OutlineEntry<?> entry) {
            if (!this.isPlanItemInPrimaryGroup(entry) && !this.isFolder(entry)) {
                return false;
            }
            final Object element = entry.getElement();
            return entry.getModel().readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

                @Override
                public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                    EntryNavigator n = readAccessor.getEntryNavigator(true);
                    OutlineEntry<?> parentEntry = n.parentEntry(entry);
                    if (parentEntry == null) {
                        return false;
                    }
                    OutlineEntry<?> grantParentEntry = n.parentEntry(parentEntry);
                    Object grantParent = grantParentEntry != null ? grantParentEntry.getElement() : null;
                    ElementType rest = MyFolderItemMovePolicy.this.getEntryType(n, n.successorEntry(entry));
                    if (element instanceof PlanItem) {
                        if ((rest == null || rest == ElementType.Items) && EntryUtils.isType(parentEntry, PlanItem.class) && (grantParent == null || grantParent instanceof PlanItem || grantParent instanceof GroupFolderElement)) {
                            return true;
                        }
                        return false;
                    }
                    if (element instanceof GroupFolderElement) {
                        GroupFolderElement folder = (GroupFolderElement)element;
                        if (!(!(grantParent instanceof DefaultRootElement) && !(grantParent instanceof GroupFolderElement) || rest != null && rest != ElementType.Folders || folder.isTopItemFolder() || folder.isBugFolder())) {
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
            });
        }

        @Override
        public void decreaseIndent(final OutlineEntry<?> entry) {
            final Object element = entry.getElement();
            final OutlineModel<?> model = entry.getModel();
            model.updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){

                @Override
                public Void run(IOutlineModelUpdater updateAccessor) throws RuntimeException {
                    EntryNavigator n = updateAccessor.getEntryNavigator(true);
                    OutlineEntry<?> parentEntry = n.parentEntry(entry);
                    if (parentEntry == null) {
                        return null;
                    }
                    OutlineEntry<?> grantParentEntry = n.parentEntry(parentEntry);
                    Object grantParent = grantParentEntry != null ? grantParentEntry.getElement() : null;
                    ElementType rest = MyFolderItemMovePolicy.this.getEntryType(n, n.successorEntry(entry));
                    if (element instanceof PlanItem) {
                        if ((rest == null || rest == ElementType.Items) && EntryUtils.isType(parentEntry, PlanItem.class) && (grantParent == null || grantParent instanceof PlanItem || grantParent instanceof GroupFolderElement)) {
                            MyFolderItemMovePolicy.super.decreaseIndent(entry);
                            return null;
                        }
                    } else if (element instanceof GroupFolderElement && (grantParent instanceof DefaultRootElement || grantParent instanceof GroupFolderElement) && (rest == null || rest == ElementType.Folders)) {
                        final OutlineModel.ExpansionHull expansionHull = entry.getModel().getExpansionHull(entry);
                        GroupFolderElement toMove = (GroupFolderElement)element;
                        OutlineEntry entryToMove = entry;
                        GroupFolderElement newParent = grantParent instanceof DefaultRootElement ? null : (GroupFolderElement)grantParent;
                        ArrayList siblingsToMove = new ArrayList();
                        OutlineEntry<?> next = n.successorEntry(entryToMove);
                        while (next != null && EntryUtils.isType(next, GroupFolderElement.class)) {
                            siblingsToMove.add(next);
                            next = n.successorEntry(next);
                        }
                        toMove.reparent(newParent);
                        final OutlineEntry newEntry = updateAccessor.reparentEntry(entryToMove, newParent != null ? newParent.getPath() : new Object[]{});
                        for (OutlineEntry outlineEntry : siblingsToMove) {
                            ((GroupFolderElement)outlineEntry.getElement()).reparent((GroupFolderElement)newEntry.getElement());
                            updateAccessor.reparentEntry(outlineEntry, ((GroupFolderElement)newEntry.getElement()).getPath());
                        }
                        updateAccessor.move(newEntry, n.index(parentEntry) + 1);
                        updateAccessor.executeAfterUpdate(new Runnable(){

                            public void run() {
                                if (newEntry != null) {
                                    model.setExpansionHull(newEntry, expansionHull);
                                    model.revealEntry(newEntry);
                                    model.setSelectedEntry(newEntry);
                                }
                            }
                        });
                        ((ResolvedIterationPlan)MyFolderItemMovePolicy.this.getPlan(entry)).setAuxiliaryDataChanged();
                    }
                    return null;
                }
            });
        }

        @Override
        public ItemMovePolicy.DropLocation validateDrop(final IStructuredSelection sourceSelection, final OutlineEntry<?> targetEntry, final ItemMovePolicy.DropLocation location, final DropTargetEvent event) {
            return targetEntry.getModel().readModel(new ModelReadRunnable<ItemMovePolicy.DropLocation, RuntimeException>(){

                @Override
                public ItemMovePolicy.DropLocation run(IOutlineModelReader readAccessor) throws RuntimeException {
                    ResolvedPlan plan = MyFolderItemMovePolicy.this.getPlan(targetEntry);
                    boolean isTopLevelItem = false;
                    for (Object sourceElement : sourceSelection) {
                        PlanItem item;
                        if (!(sourceElement instanceof IWorkItemHandle) || (item = plan.getPlanItem((IWorkItemHandle)sourceElement)) == null || !item.isTopLevelPlanItem()) continue;
                        isTopLevelItem = true;
                        break;
                    }
                    Object target = targetEntry.getElement();
                    if (isTopLevelItem && target instanceof PlanItem && !((PlanItem)target).isTopLevelPlanItem()) {
                        return ItemMovePolicy.DropLocation.None;
                    }
                    return MyFolderItemMovePolicy.super.validateDrop(sourceSelection, targetEntry, location, event);
                }
            });
        }

        @Override
        public boolean drop(IStructuredSelection sourceSelection, OutlineEntry<?> targetEntry, ItemMovePolicy.DropLocation location, DropTargetEvent event, IProgressService progressService) {
            if (super.drop(sourceSelection, targetEntry, location, event, progressService)) {
                IPlanOutlineSettings settings = (IPlanOutlineSettings)this.getViewModel(targetEntry).getOutlineSettings();
                if (settings.getSortMode() == SortMode.MY_SORT_ORDER) {
                    ((ResolvedIterationPlan)this.getPlan(targetEntry)).setAuxiliaryDataChanged();
                }
                return true;
            }
            return false;
        }

        private ElementType getEntryType(EntryNavigator n, OutlineEntry<?> entry) {
            ElementType result = null;
            while (entry != null) {
                if (entry.getElement() instanceof PlanItem) {
                    if (result == null) {
                        result = ElementType.Items;
                    } else if (result == ElementType.Folders) {
                        result = ElementType.Mixed;
                    }
                } else if (entry.getElement() instanceof GroupFolderElement) {
                    if (result == null) {
                        result = ElementType.Folders;
                    } else if (result == ElementType.Items) {
                        result = ElementType.Mixed;
                    }
                }
                if (result == ElementType.Mixed) {
                    return result;
                }
                entry = n.successorEntry(entry);
            }
            return result;
        }

        private boolean isFolder(OutlineEntry<?> entry) {
            return EntryUtils.isType(entry, GroupFolderElement.class);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ElementType {
            Items,
            Folders,
            Mixed;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyFolderTransformer
    extends ProgressAwarePlanModelTransformer<GroupFolderElement>
    implements ISortOrderStore {
        private GroupFolderElementManager fFolderManager;
        private ItemSortOrder fItemSortOrder;
        private Collection<GroupElement[]> fDefaultGroup;

        public MyFolderTransformer(GroupFolderElementManager folderManager, ItemSortOrder itemSortOrder) {
            super((Collection<Attribute>)Arrays.asList(IterationPlanItem.FOLDER_ID, IterationPlanItem.PRIMARY_ITEM), GroupFolderElement.class);
            this.fFolderManager = folderManager;
            this.fItemSortOrder = itemSortOrder;
            this.fItemSortOrder.setStore(this);
        }

        public GroupFolderElement getBugsFolder() {
            return this.fFolderManager.getBugsFolder();
        }

        @Override
        public void inputChanged(PlanViewModel model, ResolvedPlan newInput) {
            if (newInput == null && this.getPlan() instanceof ResolvedIterationPlan) {
                this.getViewModel().readModel(new ModelReadRunnable<Void, RuntimeException>(){

                    @Override
                    public Void run(IOutlineModelReader readAccessor) throws RuntimeException {
                        MyFolderTransformer.this.storeData(readAccessor);
                        return null;
                    }
                });
            }
            super.inputChanged(model, newInput);
        }

        @Override
        public void aboutToRefreshModel(IOutlineModelReader readAccessor) {
            this.storeData(readAccessor);
        }

        @Override
        public void storeData() {
            if (this.getViewModel() == null || this.getPlan() == null) {
                return;
            }
            this.getViewModel().readModel(new ModelReadRunnable<Void, RuntimeException>(){

                @Override
                public Void run(IOutlineModelReader readAccessor) throws RuntimeException {
                    MyFolderTransformer.this.storeData(readAccessor);
                    return null;
                }
            });
        }

        private void storeData(IOutlineModelReader readAccessor) {
            ResolvedIterationPlan plan = (ResolvedIterationPlan)this.getPlan();
            XMLMemento root = plan.getAuxiliaryData();
            root.removeChildren("myFolderData");
            IMemento overview = root.createChild("myFolderData");
            this.fItemSortOrder.clear();
            this.storeStructure(overview, readAccessor.getEntryNavigator(false), readAccessor.getRootEntry());
            this.storeMapping(overview, (ResolvedPlan)plan);
        }

        private void storeStructure(IMemento memento, EntryNavigator n, OutlineEntry<?> entry) {
            IMemento next = memento;
            if (entry.getElement() instanceof DefaultRootElement) {
                next = memento.createChild("structure");
            } else if (entry.getElement() instanceof GroupFolderElement) {
                GroupFolderElement element = (GroupFolderElement)entry.getElement();
                next = memento.createChild("folder");
                next.putString("itemId", element.getId().getUuidValue());
                next.putString("label", element.getLabel());
            } else if (entry.getElement() instanceof IterationPlanItem) {
                IterationPlanItem planItem = (IterationPlanItem)entry.getElement();
                next = memento.createChild("item");
                next.putString("itemId", planItem.getWorkItemId().getUuidValue());
            }
            this.fItemSortOrder.put(GroupByNoneDescription.createPath(entry, n));
            List<OutlineEntry<?>> childEntries = n.childEntries(entry);
            for (OutlineEntry<?> child : childEntries) {
                this.storeStructure(next, n, child);
            }
        }

        private void storeMapping(IMemento memento, ResolvedPlan plan) {
            final IMemento items = memento.createChild("mapping");
            plan.accept(new IPlanElementVisitor(){

                public boolean visit(PlanElement element) {
                    if (element instanceof IterationPlanItem) {
                        IMemento item = items.createChild("item");
                        IterationPlanItem planItem = (IterationPlanItem)element;
                        UUID folderId = planItem.getFolderId();
                        if (folderId != null) {
                            item.putString("itemId", planItem.getWorkItemId().getUuidValue());
                            item.putString("folderId", folderId.getUuidValue());
                        }
                    }
                    return true;
                }
            });
        }

        @Override
        protected void onBeginRefresh() {
            ResolvedIterationPlan plan = (ResolvedIterationPlan)this.getPlan();
            XMLMemento auxiliaryData = plan.getAuxiliaryData();
            IMemento structure = null;
            if (auxiliaryData.getChild("myFolderData") != null) {
                structure = auxiliaryData.getChild("myFolderData").getChild("structure");
            }
            ArrayList<GroupElement[]> groupElements = new ArrayList<GroupElement[]>();
            this.fFolderManager.clear();
            this.fItemSortOrder.clear();
            this.fItemSortOrder.put(String.valueOf('/'));
            if (structure == null) {
                GroupFolderElement folder = this.fFolderManager.createTopFolder(1);
                groupElements.add(new GroupElement[]{folder});
                folder = this.fFolderManager.createBugFolder(2);
                groupElements.add(new GroupElement[]{folder});
            } else {
                GroupFolderElement folder;
                this.fItemSortOrder.incrementIndexBy(2);
                this.readStructure(structure, groupElements, null, "");
                if (this.fFolderManager.getTopFolder() == null) {
                    folder = this.fFolderManager.createTopFolder(1);
                    groupElements.add(0, new GroupElement[]{folder});
                }
                if (this.fFolderManager.getBugsFolder() == null) {
                    folder = this.fFolderManager.createBugFolder(0x7FFFFFFE);
                    groupElements.add(new GroupElement[]{folder});
                }
            }
            this.fDefaultGroup = groupElements;
            super.onBeginRefresh();
        }

        private void readStructure(IMemento memento, List<GroupElement[]> groupElements, GroupFolderElement parent, String parentPath) {
            IMemento[] children;
            IMemento[] iMementoArray = children = memento.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                if ("folder".equals(child.getType())) {
                    this.fItemSortOrder.incrementIndexBy(1);
                    GroupFolderElement folder = this.fFolderManager.create(parent, UUID.valueOf((String)child.getString("itemId")), child.getString("label"), this.fItemSortOrder.getIndex());
                    groupElements.add(folder.getPath());
                    String folderPath = String.valueOf(parentPath) + '/' + child.getString("itemId");
                    this.fItemSortOrder.put(folderPath);
                    this.readStructure(child, groupElements, folder, folderPath);
                } else if ("item".equals(child.getType())) {
                    String itemPath = String.valueOf(parentPath) + '/' + child.getString("itemId");
                    this.fItemSortOrder.put(itemPath);
                    this.readStructure(child, groupElements, parent, itemPath);
                }
                ++n2;
            }
        }

        @Override
        protected Collection<GroupElement[]> getDefaultGroups() {
            return this.fDefaultGroup;
        }

        @Override
        protected Collection<GroupElement[]> getGroups(List<PlanModelTransformer.ElementInfo> elementInfoPath) {
            ArrayList<GroupElement[]> result = new ArrayList<GroupElement[]>();
            Collection<UUID> uuids = this.getFolderIds(elementInfoPath);
            for (UUID uuid : uuids) {
                result.add(this.getGroupElements(uuid));
            }
            return result;
        }

        @Override
        protected EntryTag[] doCalculateTags(GroupElement[] groupPath, List<PlanModelTransformer.ElementInfo> elementInfoPath) {
            Assert.isTrue((elementInfoPath.size() >= 1 ? 1 : 0) != 0);
            PlanModelTransformer.ElementInfo elementInfo = elementInfoPath.get(0);
            return this.isPrimaryItem(elementInfo) && Arrays.equals(groupPath, this.getGroupElements(this.getFolderId(elementInfo))) ? DEFAULT_TAGS : NO_TAGS;
        }

        @Override
        public LocationMarker calculateLocationMarker(OutlineEntry<?> entry) {
            LocationMarker result = super.calculateLocationMarker(entry);
            if (result == null && EntryUtils.isType(entry, IterationPlanItem.class) && !entry.hasTag(PrimaryLocationTag.INSTANCE)) {
                IterationPlanItem planItem = (IterationPlanItem)entry.getElement();
                GroupFolderElement folder = this.getGroupFolderElement(planItem.getFolderId());
                result = new SecondaryLocationMarker(NLS.bind((String)Messages.GroupByNoneDescription_BELONGS_TO_OTHER_FOLDER, (Object[])new Object[]{folder.getLabel()}));
            }
            return result;
        }

        private UUID getFolderId(PlanModelTransformer.ElementInfo elementInfo) {
            Object[] structureValues = elementInfo.getStructureValues();
            Assert.isLegal((structureValues.length == 2 && structureValues[0] instanceof UUID ? 1 : 0) != 0);
            return (UUID)structureValues[0];
        }

        private GroupFolderElement getGroupFolderElement(UUID folderId) {
            GroupFolderElement element = null;
            if (folderId != null) {
                element = this.fFolderManager.get(folderId);
            }
            if (element == null) {
                element = this.fFolderManager.getBugsFolder();
            }
            return element;
        }

        private GroupElement[] getGroupElements(UUID folderId) {
            return this.getGroupFolderElement(folderId).getPath();
        }

        private boolean isPrimaryItem(PlanModelTransformer.ElementInfo elementInfo) {
            Object[] structureValues = elementInfo.getStructureValues();
            Assert.isLegal((structureValues.length == 2 && structureValues[1] instanceof Boolean ? 1 : 0) != 0);
            return (Boolean)structureValues[1];
        }

        @Override
        protected boolean isElementInitiallyIncluded(PlanElement element) {
            if (super.isElementInitiallyIncluded(element)) {
                return true;
            }
            if (!(element instanceof PlanItem)) {
                return false;
            }
            PlanItem item = (PlanItem)element;
            if (!item.isProgressPlanItem()) {
                return false;
            }
            if (item.getParent() == null || !(item.getParent() instanceof PlanItem)) {
                return false;
            }
            return ((PlanItem)item.getParent()).isTopLevelPlanItem();
        }

        private Collection<UUID> getFolderIds(List<PlanModelTransformer.ElementInfo> elementInfoPath) {
            HashSet<UUID> result = new HashSet<UUID>();
            for (PlanModelTransformer.ElementInfo elementInfo : elementInfoPath) {
                UUID folderId = (UUID)elementInfo.getStructureValues()[0];
                if (folderId == null) continue;
                result.add(folderId);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyFolderViewerSorter
    extends PartialViewerSorter {
        private final ItemSortOrder fItemSortOrder;

        public MyFolderViewerSorter(ItemSortOrder itemSortOrder) {
            super(false);
            this.fItemSortOrder = itemSortOrder;
        }

        @Override
        public void setItemComparator(PartialViewerSorter.ElementComparer<?> comparator) {
            PartialViewerSorter.ElementComparer<?> oldComparator = this.getItemComparator();
            if (SortMode.MY_SORT_ORDER.getComparator().getClass().isInstance(oldComparator) && !SortMode.MY_SORT_ORDER.getComparator().getClass().isInstance(comparator)) {
                this.fItemSortOrder.storeOrder();
            }
            super.setItemComparator(comparator);
        }

        @Override
        public <T> int compare(int category, OutlineEntry<T> e1, OutlineEntry<T> e2, IOutlineModelReader readAccessor) {
            PartialViewerSorter.ElementComparer<?> comparator = this.getItemComparator();
            if (SortMode.MY_SORT_ORDER.getComparator().getClass().isInstance(comparator)) {
                EntryNavigator n = readAccessor.getEntryNavigator(false);
                int i1 = this.fItemSortOrder.get(GroupByNoneDescription.createPath(e1, n));
                int i2 = this.fItemSortOrder.get(GroupByNoneDescription.createPath(e2, n));
                if (i1 == -1 && i2 == -1) {
                    return 0;
                }
                if (i1 == -1) {
                    return 1;
                }
                if (i2 == -1) {
                    return -1;
                }
                return i1 - i2;
            }
            return super.compare(category, e1, e2, readAccessor);
        }
    }
}

