/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.IOutlineSettingsListener;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupByDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.SortMode;
import com.ibm.team.apt.internal.ide.ui.editor.OutlinePage;
import com.ibm.team.apt.internal.ide.ui.editor.PlanModeDescription;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.OutlineFilterDescriptor;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanOutlineSettingChangeEvent;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.ProgressMode;
import com.ibm.team.foundation.common.util.IMemento;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;

class PlanModeState
implements IPlanOutlineSettings {
    private static final String OUTLINE_VIEWER = "outlineViewer";
    private final String GROUP_MODE = "groupMode";
    private final String SORT_MODE = "sortMode";
    private final String ACTIVE_FILTERS = "activeFilters";
    private final String DEFAULT_WORK_ITEM_TYPE = "defaultWorkItemType";
    private final String OWNER_PROGRESS_MODE = "ownerProgressMode";
    private final OutlinePage fOutlinePage;
    private final PlanModeDescription fDescription;
    private final ListenerList fSettingListeners = new ListenerList(1);
    private boolean fShowDetails = true;
    private String fGroupModeId;
    private String fSortModeId;
    private Set<String> fActiveFilterIds = new HashSet<String>();
    private ProgressMode fOwnerProgressMode = ProgressMode.PROGRESS;
    private String fDefaultWorkItemType;

    public PlanModeState(OutlinePage outlinePage, PlanModeDescription description) {
        this.fOutlinePage = outlinePage;
        this.fDescription = description;
    }

    public PlanModeDescription getPlanMode() {
        return this.fDescription;
    }

    public void setShowDetails(boolean showDetails) {
        if (showDetails != this.fShowDetails) {
            this.fShowDetails = showDetails;
            this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.SHOW_DETAILS, (Object)showDetails, new Object[0]));
        }
    }

    public void setGroupMode(GroupByDescription mode) {
        if (!mode.getId().equals(this.fGroupModeId)) {
            this.fGroupModeId = mode.getId();
            this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.GROUP_MODE, (Object)mode, new Object[0]));
            if (!mode.getSortModes().contains((Object)this.getSortMode()) || "NONE".equals(this.fGroupModeId)) {
                this.setSortMode(mode.getDefaultSortMode());
            }
        }
    }

    public void setSortMode(SortMode mode) {
        if (!mode.getKey().equals(this.fSortModeId)) {
            this.fSortModeId = mode.getKey();
            this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.SORT_MODE, (Object)mode, new Object[0]));
        }
    }

    public String getDefaultWorkItemType() {
        return this.fDefaultWorkItemType;
    }

    public void setDefaultWorkItemType(String workItemType) {
        if (this.fDefaultWorkItemType == null && workItemType == null) {
            return;
        }
        if (this.fDefaultWorkItemType == null && workItemType != null || this.fDefaultWorkItemType != null && workItemType == null || !this.fDefaultWorkItemType.equals(workItemType)) {
            this.fDefaultWorkItemType = workItemType;
            this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.DEFAULT_WORK_ITEM_TYPE, (Object)this.fDefaultWorkItemType, new Object[0]));
        }
    }

    public void setOwnerProgressMode(ProgressMode mode) {
        if (this.fOwnerProgressMode != mode) {
            this.fOwnerProgressMode = mode;
            this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.OWNER_PROGRESS_MODE, (Object)this.fOwnerProgressMode, new Object[0]));
        }
    }

    public void addFilter(OutlineFilterDescriptor filter) {
        if (this.fActiveFilterIds.add(filter.getId())) {
            PlanningUIPlugin.getDefault().getFilterUsageStatistics().registerFilterActivated(filter.getId());
            this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.FILTER, (Object)filter, Boolean.TRUE));
        }
    }

    public void removeFilter(OutlineFilterDescriptor filter) {
        if (this.fActiveFilterIds.remove(filter.getId())) {
            this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.FILTER, (Object)filter, Boolean.FALSE));
        }
    }

    public void clearFilters(OutlineFilterDescriptor.FilterType filterType) {
        Iterator<String> filterIdIterator = this.fActiveFilterIds.iterator();
        while (filterIdIterator.hasNext()) {
            OutlineFilterDescriptor filter = this.getFilterFromId(filterIdIterator.next());
            if (filter == null || !OutlineFilterDescriptor.FilterType.ALL.equals((Object)filterType) && !filter.isFilterType(filterType)) continue;
            filterIdIterator.remove();
            this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.FILTER, (Object)filter, Boolean.FALSE));
        }
    }

    public void setFilters(OutlineFilterDescriptor[] filters, OutlineFilterDescriptor.FilterType filterType) {
        HashSet newFilters = new HashSet(Arrays.asList(filters));
        Iterator<String> filterIdIterator = this.fActiveFilterIds.iterator();
        while (filterIdIterator.hasNext()) {
            OutlineFilterDescriptor filter = this.getFilterFromId(filterIdIterator.next());
            if (filter == null || !OutlineFilterDescriptor.FilterType.ALL.equals((Object)filterType) && !filter.isFilterType(filterType) || newFilters.remove(filter)) continue;
            filterIdIterator.remove();
            this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.FILTER, (Object)filter, Boolean.FALSE));
        }
        for (OutlineFilterDescriptor filter : newFilters) {
            this.addFilter(filter);
        }
    }

    public boolean hasActiveFilters(OutlineFilterDescriptor.FilterType filterType) {
        Iterator<String> filterIdIterator = this.fActiveFilterIds.iterator();
        while (filterIdIterator.hasNext()) {
            OutlineFilterDescriptor filter = this.getFilterFromId(filterIdIterator.next());
            if (filter == null || !OutlineFilterDescriptor.FilterType.ALL.equals((Object)filterType) && !filter.isFilterType(filterType)) continue;
            return true;
        }
        return false;
    }

    public boolean isFilterActive(OutlineFilterDescriptor filter) {
        return this.fActiveFilterIds.contains(filter.getId());
    }

    public void saveState(IMemento memento) {
        IMemento modeState = memento.createChild(this.fDescription.getId());
        modeState.putString("groupMode", this.fGroupModeId);
        modeState.putString("sortMode", this.fSortModeId);
        if (this.fDefaultWorkItemType != null) {
            modeState.putString("defaultWorkItemType", this.fDefaultWorkItemType);
        }
        modeState.putString("ownerProgressMode", this.fOwnerProgressMode.name());
        StringBuilder filterString = new StringBuilder();
        for (String filterId : this.fActiveFilterIds) {
            OutlineFilterDescriptor filterDescriptor = this.getFilterFromId(filterId);
            if (filterDescriptor != null && filterDescriptor.isFilterType(OutlineFilterDescriptor.FilterType.TRANSIENT)) continue;
            if (filterString.length() > 0) {
                filterString.append(',');
            }
            filterString.append(filterId);
        }
        modeState.putString("activeFilters", filterString.toString());
    }

    public void loadState(IMemento uiState) {
        IMemento modeState = uiState.getChild(this.fDescription.getId());
        if (modeState == null && "com.ibm.team.apt.ide.planmode.TeamMode".equals(this.fDescription.getId())) {
            modeState = uiState.getChild(OUTLINE_VIEWER);
        }
        if (modeState == null) {
            return;
        }
        this.fGroupModeId = modeState.getString("groupMode");
        this.fSortModeId = modeState.getString("sortMode");
        this.fDefaultWorkItemType = modeState.getString("defaultWorkItemType");
        String name = modeState.getString("ownerProgressMode");
        if (name != null) {
            try {
                this.fOwnerProgressMode = Enum.valueOf(ProgressMode.class, name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.fOwnerProgressMode = ProgressMode.LOAD;
            }
        }
        this.fActiveFilterIds.clear();
        String filterString = modeState.getString("activeFilters");
        if (filterString != null) {
            String[] filterIds;
            String[] stringArray = filterIds = filterString.split(",");
            int n = filterIds.length;
            int n2 = 0;
            while (n2 < n) {
                String filterId = stringArray[n2];
                if ((filterId = filterId.trim()).length() > 0) {
                    this.fActiveFilterIds.add(filterId);
                }
                ++n2;
            }
        }
    }

    public ItemMovePolicy getItemMovePolicy() {
        return this.getGroupMode().getItemMovePolicy();
    }

    public boolean getShowDetails() {
        return this.fShowDetails;
    }

    public GroupByDescription getGroupMode() {
        if (this.fGroupModeId == null) {
            return this.fDescription.getDefaultGroupMode();
        }
        GroupByDescription[] groupByDescriptionArray = this.fDescription.getGroupModes();
        int n = groupByDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            GroupByDescription groupMode = groupByDescriptionArray[n2];
            if (this.fGroupModeId.equals(groupMode.getId())) {
                return groupMode;
            }
            ++n2;
        }
        return this.fDescription.getDefaultGroupMode();
    }

    public SortMode getSortMode() {
        SortMode result;
        SortMode sortMode = result = this.fSortModeId != null ? SortMode.getSortMode(this.fSortModeId) : null;
        if (result == null) {
            result = this.getGroupMode().getDefaultSortMode();
        }
        return result;
    }

    public ProgressMode getOwnerProgressMode() {
        return this.fOwnerProgressMode;
    }

    public OutlineFilterDescriptor[] getActiveFilters(OutlineFilterDescriptor.FilterType filterType) {
        ArrayList<OutlineFilterDescriptor> result = new ArrayList<OutlineFilterDescriptor>();
        for (String filterId : this.fActiveFilterIds) {
            OutlineFilterDescriptor filter = this.getFilterFromId(filterId);
            if (filter == null || !OutlineFilterDescriptor.FilterType.ALL.equals((Object)filterType) && !filter.isFilterType(filterType)) continue;
            result.add(filter);
        }
        return result.toArray(new OutlineFilterDescriptor[result.size()]);
    }

    public void addSettingsChangeListener(IOutlineSettingsListener listener) {
        this.fSettingListeners.add((Object)listener);
    }

    public void removeSettingsChangeListener(IOutlineSettingsListener listener) {
        this.fSettingListeners.remove((Object)listener);
    }

    private boolean readBoolean(IMemento memento, String key, boolean defaultValue) {
        Boolean value = memento.getBoolean(key);
        return value != null ? value : defaultValue;
    }

    private void fireChangeEvent(PlanOutlineSettingChangeEvent event) {
        Object[] listeners = this.fSettingListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IOutlineSettingsListener listener = (IOutlineSettingsListener)listeners[i];
            listener.settingChanged(event);
            ++i;
        }
    }

    private OutlineFilterDescriptor getFilterFromId(String filterId) {
        return this.fOutlinePage != null && this.fOutlinePage.getViewModel() != null ? this.fOutlinePage.getFilterFromId(filterId) : null;
    }
}

